/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.tool;

import cc.ceofax.controller.Main;
import cc.ceofax.controller.portal;
import com.google.gson.Gson;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttClient {
    private static final String BROKER_URL = "tcp://165.154.227.65:1883";
    private static final String CLIENT_TOPIC_PREFIX = "ceofax/client/";
    private static final String SERVER_TOPIC_PREFIX = "ceofax/server/";
    private static final String BROADCAST_TOPIC = "ceofax/broadcast";
    private String clientId;
    private String publishTopic;
    private String subscribeTopic;
    private boolean isConnected = false;
    private volatile boolean isResubscribing = false;
    private ScheduledExecutorService reconnectExecutor;
    private Gson gson = new Gson();
    private String username;
    private String password;
    private org.eclipse.paho.client.mqttv3.MqttClient mqttClient;

    public MqttClient(String accountId) {
        this.clientId = accountId + "_" + System.currentTimeMillis();
        this.publishTopic = CLIENT_TOPIC_PREFIX + accountId;
        this.subscribeTopic = SERVER_TOPIC_PREFIX + accountId;
        this.reconnectExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void connect() {
        block4: {
            try {
                System.out.println("MQTT Client connecting to broker: tcp://165.154.227.65:1883");
                System.out.println("Client ID: " + this.clientId);
                System.out.println("Publish Topic: " + this.publishTopic);
                System.out.println("Subscribe Topic: " + this.subscribeTopic);
                MemoryPersistence persistence = new MemoryPersistence();
                this.mqttClient = new org.eclipse.paho.client.mqttv3.MqttClient(BROKER_URL, this.clientId, (MqttClientPersistence)persistence);
                MqttConnectOptions connOpts = new MqttConnectOptions();
                connOpts.setCleanSession(true);
                connOpts.setKeepAliveInterval(60);
                connOpts.setAutomaticReconnect(true);
                connOpts.setConnectionTimeout(30);
                connOpts.setMaxInflight(10);
                if (this.username != null && this.password != null) {
                    connOpts.setUserName(this.username);
                    connOpts.setPassword(this.password.toCharArray());
                    System.out.println("MQTT authentication set for user: " + this.username);
                }
                this.mqttClient.setCallback((MqttCallback)new MqttCallbackHandler());
                this.mqttClient.connect(connOpts);
                this.mqttClient.subscribe(this.subscribeTopic, 2);
                System.out.println("Subscribed to: " + this.subscribeTopic);
                this.mqttClient.subscribe(BROADCAST_TOPIC, 2);
                this.isConnected = true;
                if (portal.portal != null) {
                    portal.portal.updateStatus();
                }
                System.out.println("MQTT Client connected successfully");
            }
            catch (Exception e) {
                System.err.println("Failed to connect MQTT client: " + e.getMessage());
                e.printStackTrace();
                this.isConnected = false;
                if (e.getMessage() == null || !e.getMessage().contains("\u672a\u7372\u6388\u6b0a") && !e.getMessage().contains("Not authorized") && !e.getMessage().contains("Authentication failed") && !(e.getCause() instanceof MqttSecurityException)) break block4;
                Platform.runLater(() -> Main.handleMqttAuthenticationError());
            }
        }
    }

    public void publish(String message) {
        try {
            if (this.isConnected && this.mqttClient != null && this.mqttClient.isConnected()) {
                System.out.println("MQTT publish: " + message);
                MqttMessage mqttMessage = new MqttMessage(message.getBytes("UTF-8"));
                mqttMessage.setQos(2);
                this.mqttClient.publish(this.publishTopic, mqttMessage);
            } else {
                System.err.println("MQTT client not connected, message will be lost");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to publish MQTT message: " + e.getMessage());
            this.isConnected = false;
        }
    }

    public void manualReconnect() {
        System.out.println("Manual reconnect requested, but relying on MQTT automatic reconnection");
    }

    public void disconnect() {
        try {
            this.isConnected = false;
            if (this.reconnectExecutor != null) {
                this.reconnectExecutor.shutdown();
            }
            if (this.mqttClient != null && this.mqttClient.isConnected()) {
                this.mqttClient.disconnect();
                this.mqttClient.close();
            }
            if (portal.portal != null) {
                portal.portal.updateStatus();
            }
            System.out.println("MQTT Client disconnected");
        }
        catch (Exception e) {
            System.err.println("Error disconnecting MQTT client: " + e.getMessage());
        }
    }

    public boolean isConnected() {
        return this.isConnected && this.mqttClient != null && this.mqttClient.isConnected();
    }

    private class MqttCallbackHandler
    implements MqttCallbackExtended {
        private MqttCallbackHandler() {
        }

        public void connectComplete(boolean reconnect, String serverURI) {
            System.out.println("MQTT connect complete. Reconnect: " + reconnect + ", Server: " + serverURI);
            if (reconnect) {
                if (MqttClient.this.isResubscribing) {
                    System.out.println("Resubscription already in progress, skipping...");
                    return;
                }
                MqttClient.this.isResubscribing = true;
                System.out.println("Reconnected to MQTT broker, resubscribing to topics...");
                MqttClient.this.reconnectExecutor.schedule(() -> {
                    try {
                        for (int i = 0; i < 3; ++i) {
                            if (MqttClient.this.mqttClient != null && MqttClient.this.mqttClient.isConnected()) {
                                try {
                                    MqttClient.this.mqttClient.subscribe(MqttClient.this.subscribeTopic, 2);
                                    System.out.println("Resubscribed to: " + MqttClient.this.subscribeTopic);
                                    MqttClient.this.mqttClient.subscribe(MqttClient.BROADCAST_TOPIC, 2);
                                    System.out.println("Resubscribed to: ceofax/broadcast");
                                    System.out.println("\u2713 MQTT reconnection and resubscription completed successfully");
                                    break;
                                }
                                catch (Exception e) {
                                    System.err.println("Resubscription attempt " + (i + 1) + " failed: " + e.getMessage());
                                    if (i >= 2) continue;
                                    Thread.sleep(1000L);
                                    continue;
                                }
                            }
                            System.out.println("Connection lost during resubscription attempt " + (i + 1));
                            Thread.sleep(1000L);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to resubscribe after reconnection: " + e.getMessage());
                    }
                    finally {
                        MqttClient.this.isResubscribing = false;
                    }
                }, 2000L, TimeUnit.MILLISECONDS);
            } else {
                System.out.println("\u2713 MQTT initial connection completed successfully");
            }
            MqttClient.this.isConnected = true;
            if (portal.portal != null) {
                portal.portal.updateStatus();
            }
        }

        public void connectionLost(Throwable cause) {
            System.err.println("MQTT connection lost: " + cause.getMessage());
            MqttClient.this.isConnected = false;
            if (portal.portal != null) {
                portal.portal.updateStatus();
            }
            System.out.println("Waiting for MQTT automatic reconnection...");
        }

        public void messageArrived(String topic, MqttMessage message) throws Exception {
            String messageContent = new String(message.getPayload(), "UTF-8");
            System.out.println("Received MQTT message: " + messageContent);
            Main.lastSpeak = System.currentTimeMillis() / 1000L;
            if (!messageContent.equals("0")) {
                Platform.runLater(() -> Main.read(messageContent));
            }
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }
    }
}

