/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.tool;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.print.PrintService;

public class PrintJpg
implements Runnable {
    private BufferedImage image;
    public static PrintService printService;
    public static final int dpi = 72;
    public static final double CM_PER_INCH = 0.393700787;
    public static final double INCH_PER_CM = 2.545;
    public static final double INCH_PER_MM = 25.45;

    public PrintJpg(String source) {
        try {
            this.image = ImageIO.read(new File(source));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (printService == null) {
            printService = PrintJpg.findPrintService("123");
        }
        PrinterJob printJob = PrinterJob.getPrinterJob();
        try {
            printJob.setPrintService(printService);
        }
        catch (PrinterException e) {
            e.printStackTrace();
        }
        printJob.setPrintable(new ImagePrintable(printJob, this.image));
        try {
            printJob.print();
        }
        catch (PrinterException prt) {
            prt.printStackTrace();
        }
    }

    public static double cmsToPixel(double cms, double dpi) {
        return PrintJpg.cmToInches(cms) * dpi;
    }

    public static double cmToInches(double cms) {
        return cms * 0.393700787;
    }

    public static double inchesToCms(double inch) {
        return inch * 2.545;
    }

    public static PrintService findPrintService(String printerName) {
        if (printerName == null || printerName.equalsIgnoreCase("\u672a\u8a2d\u5b9a")) {
            return null;
        }
        printerName = printerName.toLowerCase();
        PrintService service = null;
        PrintService[] services = PrinterJob.lookupPrintServices();
        for (int index = 0; service == null && index < services.length; ++index) {
            if (!services[index].getName().toLowerCase().equalsIgnoreCase(printerName)) continue;
            service = services[index];
        }
        return service;
    }

    public class ImagePrintable
    implements Printable {
        private double x;
        private double y;
        private double width;
        private int orientation;
        private BufferedImage image;

        public ImagePrintable(PrinterJob printJob, BufferedImage image) {
            double pw = PrintJpg.cmsToPixel(21.0, 72.0);
            double ph = PrintJpg.cmsToPixel(29.7, 72.0);
            PageFormat pageFormat = printJob.defaultPage();
            Paper paper = pageFormat.getPaper();
            paper.setSize(pw, ph);
            paper.setImageableArea(0.0, 0.0, pw, ph);
            pageFormat.setOrientation(1);
            pageFormat.setPaper(paper);
            this.x = pageFormat.getImageableX();
            this.y = pageFormat.getImageableY();
            this.width = pageFormat.getImageableWidth();
            this.orientation = pageFormat.getOrientation();
            this.image = image;
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex == 0) {
                int x = (int)PrintJpg.cmsToPixel(0.5, 72.0);
                int y = (int)PrintJpg.cmsToPixel(0.85, 72.0);
                int pWidth = (int)PrintJpg.cmsToPixel(20.0, 72.0);
                int pHeight = (int)PrintJpg.cmsToPixel(28.0, 72.0);
                g.drawImage(this.image, x, y, pWidth, pHeight, null);
                return 0;
            }
            return 1;
        }
    }
}

