/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.tool;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.print.PrintService;

public class PrintQR
implements Printable {
    public String filepath;
    public static final int dpi = 72;
    public static final double CM_PER_INCH = 0.393700787;
    public static final double INCH_PER_CM = 2.545;
    public static final double INCH_PER_MM = 25.45;

    public String getFilepath() {
        return this.filepath;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        File f = new File(this.filepath);
        if (f.exists() && pageIndex == 0) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int x = (int)PrintQR.cmsToPixel(0.5, 72.0);
            int y = (int)PrintQR.cmsToPixel(0.85, 72.0);
            int pWidth = (int)PrintQR.cmsToPixel(20.0, 72.0);
            int pHeight = (int)PrintQR.cmsToPixel(28.0, 72.0);
            g.drawImage(image, x, y, pWidth, pHeight, null);
            return 0;
        }
        return 1;
    }

    public static double cmsToPixel(double cms, double dpi) {
        return PrintQR.cmToInches(cms) * dpi;
    }

    public static double cmToInches(double cms) {
        return cms * 0.393700787;
    }

    public static double inchesToCms(double inch) {
        return inch * 2.545;
    }

    public static PrintService findPrintService(String printerName) {
        if (printerName == null || printerName.equalsIgnoreCase("\u672a\u8a2d\u5b9a")) {
            return null;
        }
        printerName = printerName.toLowerCase();
        PrintService service = null;
        PrintService[] services = PrinterJob.lookupPrintServices();
        for (int index = 0; service == null && index < services.length; ++index) {
            if (!services[index].getName().toLowerCase().equalsIgnoreCase(printerName)) continue;
            service = services[index];
        }
        return service;
    }
}

