/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.date;

import com.icafe4j.date.DateUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTime {
    private Date date;
    private TimeZone timeZone;
    private Locale locale;
    private Calendar calendar;

    public DateTime(Date date) {
        this(date, TimeZone.getDefault(), Locale.getDefault());
    }

    public DateTime(Date date, TimeZone timeZone, Locale locale) {
        this.date = date;
        this.timeZone = timeZone;
        this.locale = locale;
        this.calendar = Calendar.getInstance(timeZone, locale);
        this.calendar.setTime(date);
    }

    public DateTime(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public boolean after(DateTime dateTime) {
        return this.getUTCTimeInMillis() > dateTime.getUTCTimeInMillis();
    }

    public boolean before(DateTime dateTime) {
        return this.getUTCTimeInMillis() < dateTime.getUTCTimeInMillis();
    }

    public static DateTime currentDate() {
        TimeZone timeZone = TimeZone.getDefault();
        Locale locale = Locale.getDefault();
        return DateTime.currentDate(timeZone, locale);
    }

    public static DateTime currentDate(TimeZone timeZone) {
        Locale locale = Locale.getDefault();
        return DateTime.currentDate(timeZone, locale);
    }

    public static DateTime currentDate(TimeZone timeZone, Locale locale) {
        Date date = new Date();
        return new DateTime(date, timeZone, locale);
    }

    public static DateTime currentDateUTC() {
        return DateTime.currentDate(TimeZone.getTimeZone("UTC"));
    }

    public static DateTime currentDateUTC(Locale locale) {
        return DateTime.currentDate(TimeZone.getTimeZone("UTC"), locale);
    }

    public DateTime dateAfter(int n, int n2) {
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.add(1, n);
        calendar.add(2, n2);
        return new DateTime(calendar.getTime(), this.timeZone, this.locale);
    }

    public DateTime dateAfter(int n, int n2, int n3) {
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.add(1, n);
        calendar.add(2, n2);
        calendar.add(5, n3);
        return new DateTime(calendar.getTime(), this.timeZone, this.locale);
    }

    public DateTime dateAfter(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.add(1, n);
        calendar.add(2, n2);
        calendar.add(5, n3);
        calendar.add(10, n4);
        calendar.add(12, n5);
        calendar.add(13, n6);
        calendar.add(14, n7);
        return new DateTime(calendar.getTime(), this.timeZone, this.locale);
    }

    public DateTime daysAfter(int n) {
        return new DateTime(new Date(this.date.getTime() + 86400000L * (long)n), this.timeZone, this.locale);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateTime)) {
            return false;
        }
        return this.getUTCTimeInMillis() == ((DateTime)object).getUTCTimeInMillis();
    }

    public String format(DateFormat dateFormat) {
        return dateFormat.format(this.date);
    }

    public String format(String string) {
        return this.format(string, Locale.getDefault());
    }

    public String format(String string, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale == null ? Locale.getDefault() : locale);
        simpleDateFormat.setTimeZone(this.timeZone);
        String string2 = simpleDateFormat.format(this.date);
        return string2;
    }

    public String formatISO8601() {
        return DateUtils.formatISO8601(this.date, this.timeZone);
    }

    public Date getDate() {
        return (Date)this.date.clone();
    }

    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    public int getDayOfWeek() {
        return this.calendar.get(7);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public long getUTCTimeInMillis() {
        long l = this.date.getTime();
        int n = this.timeZone.getOffset(l);
        return l + (long)n;
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int hashCode() {
        return Long.valueOf(this.getUTCTimeInMillis()).hashCode();
    }

    public DateTime hoursAfter(int n) {
        return new DateTime(new Date(this.date.getTime() + 3600000L * (long)n), this.timeZone, this.locale);
    }

    public DateTime monthsAfter(int n) {
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.add(2, n);
        return new DateTime(calendar.getTime(), this.timeZone, this.locale);
    }

    public String toString() {
        DateFormat dateFormat = DateFormat.getInstance();
        dateFormat.setTimeZone(this.timeZone);
        return dateFormat.format(this.date) + " " + this.timeZone.getDisplayName();
    }

    public DateTime yearsAfter(int n) {
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.add(1, n);
        return new DateTime(calendar.getTime(), this.timeZone, this.locale);
    }
}

