/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.bmp;

import com.icafe4j.image.bmp.BmpCompression;
import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.image.ImageMetadata;
import com.icafe4j.io.IOUtils;
import com.icafe4j.string.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BMPTweaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(BMPTweaker.class);

    private static void readHeader(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        DataTransferObject.access$002(dataTransferObject, new byte[14]);
        DataTransferObject.access$102(dataTransferObject, new byte[40]);
        inputStream.read(dataTransferObject.fileHeader);
        inputStream.read(dataTransferObject.infoHeader);
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream inputStream) throws IOException {
        HashMap<MetadataType, Metadata> hashMap = new HashMap<MetadataType, Metadata>();
        Document document = XMLUtils.createDocumentNode();
        DataTransferObject dataTransferObject = new DataTransferObject();
        BMPTweaker.readHeader(inputStream, dataTransferObject);
        LOGGER.info("... BMP snoop starts...");
        LOGGER.info("Image signature: {}", (Object)new String(dataTransferObject.fileHeader, 0, 2));
        LOGGER.info("File size: {} bytes", (Object)IOUtils.readInt(dataTransferObject.fileHeader, 2));
        LOGGER.info("Reserved1 (2 bytes): {}", (Object)IOUtils.readShort(dataTransferObject.fileHeader, 6));
        LOGGER.info("Reserved2 (2 bytes): {}", (Object)IOUtils.readShort(dataTransferObject.fileHeader, 8));
        LOGGER.info("Data offset: {}", (Object)IOUtils.readInt(dataTransferObject.fileHeader, 10));
        Element element = XMLUtils.createElement(document, "bitmap");
        Element element2 = XMLUtils.createElement(document, "header");
        Element element3 = XMLUtils.createElement(document, "file-header");
        Element element4 = XMLUtils.createElement(document, "image-signature");
        Element element5 = XMLUtils.createElement(document, "file-size");
        Element element6 = XMLUtils.createElement(document, "reserved1");
        Element element7 = XMLUtils.createElement(document, "reserved2");
        Element element8 = XMLUtils.createElement(document, "data-offset");
        XMLUtils.addText(document, element4, new String(dataTransferObject.fileHeader, 0, 2));
        XMLUtils.addText(document, element5, IOUtils.readInt(dataTransferObject.fileHeader, 2) + " bytes");
        XMLUtils.addText(document, element6, "" + IOUtils.readShort(dataTransferObject.fileHeader, 6));
        XMLUtils.addText(document, element7, "" + IOUtils.readShort(dataTransferObject.fileHeader, 8));
        XMLUtils.addText(document, element8, "byte " + IOUtils.readInt(dataTransferObject.fileHeader, 10));
        XMLUtils.addChild(element2, element3);
        XMLUtils.addChild(element3, element4);
        XMLUtils.addChild(element3, element5);
        XMLUtils.addChild(element3, element6);
        XMLUtils.addChild(element3, element7);
        XMLUtils.addChild(element3, element8);
        LOGGER.info("Info header length: {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 0));
        LOGGER.info("Image width: {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 4));
        LOGGER.info("Image heigth: {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 8));
        String string = "";
        string = IOUtils.readInt(dataTransferObject.infoHeader, 8) > 0 ? "BOTTOM_UP" : "TOP_DOWN";
        LOGGER.info("Image alignment: {}", (Object)string);
        LOGGER.info("Number of planes: {}", (Object)IOUtils.readShort(dataTransferObject.infoHeader, 12));
        LOGGER.info("BitCount (bits per pixel): {}", (Object)IOUtils.readShort(dataTransferObject.infoHeader, 14));
        LOGGER.info("Compression: {}", (Object)BmpCompression.fromInt(IOUtils.readInt(dataTransferObject.infoHeader, 16)));
        LOGGER.info("Image size (compressed size of image): {} bytes", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 20));
        LOGGER.info("Horizontal resolution (Pixels/meter): {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 24));
        LOGGER.info("Vertical resolution (Pixels/meter): {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 28));
        LOGGER.info("Colors used (number of actually used colors): {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 32));
        LOGGER.info("Important colors (number of important colors): {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 36));
        Element element9 = XMLUtils.createElement(document, "info-header");
        Element element10 = XMLUtils.createElement(document, "info-header-length");
        Element element11 = XMLUtils.createElement(document, "image-alignment");
        Element element12 = XMLUtils.createElement(document, "number-of-planes");
        Element element13 = XMLUtils.createElement(document, "bits-per-pixel");
        Element element14 = XMLUtils.createElement(document, "compression");
        Element element15 = XMLUtils.createElement(document, "compessed-image-size");
        Element element16 = XMLUtils.createElement(document, "horizontal-resolution");
        Element element17 = XMLUtils.createElement(document, "vertical-resolution");
        Element element18 = XMLUtils.createElement(document, "colors-used");
        Element element19 = XMLUtils.createElement(document, "important-colors");
        XMLUtils.addText(document, element10, IOUtils.readInt(dataTransferObject.infoHeader, 0) + " bytes");
        XMLUtils.addText(document, element11, string);
        XMLUtils.addText(document, element12, IOUtils.readShort(dataTransferObject.infoHeader, 12) + " planes");
        XMLUtils.addText(document, element13, IOUtils.readShort(dataTransferObject.infoHeader, 14) + " bits per pixel");
        XMLUtils.addText(document, element14, BmpCompression.fromInt(IOUtils.readInt(dataTransferObject.infoHeader, 16)).toString());
        XMLUtils.addText(document, element15, IOUtils.readInt(dataTransferObject.infoHeader, 20) + " bytes");
        XMLUtils.addText(document, element16, IOUtils.readInt(dataTransferObject.infoHeader, 24) + " pixels/meter");
        XMLUtils.addText(document, element17, IOUtils.readInt(dataTransferObject.infoHeader, 28) + " pixels/meter");
        XMLUtils.addText(document, element18, IOUtils.readInt(dataTransferObject.infoHeader, 32) + " colors used");
        XMLUtils.addText(document, element19, IOUtils.readInt(dataTransferObject.infoHeader, 36) + " important colors");
        XMLUtils.addChild(element9, element10);
        XMLUtils.addChild(element9, element11);
        XMLUtils.addChild(element9, element12);
        XMLUtils.addChild(element9, element13);
        XMLUtils.addChild(element9, element14);
        XMLUtils.addChild(element9, element15);
        XMLUtils.addChild(element9, element16);
        XMLUtils.addChild(element9, element17);
        XMLUtils.addChild(element9, element18);
        XMLUtils.addChild(element9, element19);
        XMLUtils.addChild(element2, element9);
        XMLUtils.addChild(element, element2);
        XMLUtils.addChild(document, element);
        short s = IOUtils.readShort(dataTransferObject.infoHeader, 14);
        if (s <= 8) {
            BMPTweaker.readPalette(inputStream, dataTransferObject);
            LOGGER.info("Color map follows");
        }
        hashMap.put(MetadataType.IMAGE, new ImageMetadata(document));
        return hashMap;
    }

    private static void readPalette(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = IOUtils.readInt(dataTransferObject.infoHeader, 32);
        short s = IOUtils.readShort(dataTransferObject.infoHeader, 14);
        int n4 = IOUtils.readInt(dataTransferObject.fileHeader, 10);
        int n5 = n3 == 0 ? 1 << s : n3;
        byte[] byArray = new byte[n5 * 4];
        DataTransferObject.access$302(dataTransferObject, new int[n5]);
        IOUtils.readFully(inputStream, byArray);
        for (int i = 0; i < n5; ++i) {
            ((DataTransferObject)dataTransferObject).colorPalette[n++] = 0xFF000000 | byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16;
            n2 += 4;
        }
        IOUtils.skipFully(inputStream, n4 - n5 * 4 - 54);
    }

    private BMPTweaker() {
    }

    private static class DataTransferObject {
        private byte[] fileHeader;
        private byte[] infoHeader;
        private int[] colorPalette;

        private DataTransferObject() {
        }

        static /* synthetic */ byte[] access$002(DataTransferObject dataTransferObject, byte[] byArray) {
            dataTransferObject.fileHeader = byArray;
            return byArray;
        }

        static /* synthetic */ byte[] access$102(DataTransferObject dataTransferObject, byte[] byArray) {
            dataTransferObject.infoHeader = byArray;
            return byArray;
        }

        static /* synthetic */ int[] access$302(DataTransferObject dataTransferObject, int[] nArray) {
            dataTransferObject.colorPalette = nArray;
            return nArray;
        }
    }
}

