/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.ccitt;

import com.icafe4j.image.compression.ImageDecoder;
import com.icafe4j.image.compression.huffman.T4BlackCodeHuffmanTreeNode;
import com.icafe4j.image.compression.huffman.T4CodeHuffmanTreeNode;
import com.icafe4j.image.compression.huffman.T4WhiteCodeHuffmanTreeNode;

public class G31DDecoder
implements ImageDecoder {
    private int empty_bits = 8;
    private int lineOffset = 0;
    protected byte[] input;
    protected int len = 0;
    protected int scanLineWidth = 0;
    protected int byteOffset = 0;
    protected int bitOffset = 7;
    protected int destByteOffset = 0;
    protected int uncompressedBytes = 0;

    public G31DDecoder(int n) {
        this.scanLineWidth = n;
    }

    public G31DDecoder(byte[] byArray, int n) {
        this.input = byArray;
        this.scanLineWidth = n;
        this.reset(0, byArray.length, 7);
    }

    @Override
    public int decode(byte[] byArray, int n, int n2) throws Exception {
        T4CodeHuffmanTreeNode t4CodeHuffmanTreeNode;
        T4CodeHuffmanTreeNode t4CodeHuffmanTreeNode2 = T4BlackCodeHuffmanTreeNode.getInstance();
        T4CodeHuffmanTreeNode t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode = T4WhiteCodeHuffmanTreeNode.getInstance();
        byte by = this.input[this.byteOffset];
        int n3 = this.byteOffset + this.len;
        int n4 = 0;
        int n5 = this.scanLineWidth;
        boolean bl = true;
        while (true) {
            if ((by >> this.bitOffset & 1) == 0) {
                if (t4CodeHuffmanTreeNode3.left() != null) {
                    t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode3.left();
                    --this.bitOffset;
                    if (this.bitOffset >= 0) continue;
                    this.bitOffset = 7;
                    ++this.byteOffset;
                    if (this.byteOffset >= n3) break;
                    by = this.input[this.byteOffset];
                    continue;
                }
                n4 += t4CodeHuffmanTreeNode3.value();
                if (t4CodeHuffmanTreeNode3.value() <= 63) {
                    if (n4 > n5) {
                        n4 = n5;
                    }
                    n5 -= n4;
                    if (bl) {
                        this.destByteOffset = this.outputRunLen(byArray, this.destByteOffset, n4, this.scanLineWidth, 0, n2);
                        if (n5 != 0) {
                            t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode2;
                            bl = false;
                        } else {
                            t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode;
                            bl = true;
                        }
                    } else {
                        this.destByteOffset = this.outputRunLen(byArray, this.destByteOffset, n4, this.scanLineWidth, 1, n2);
                        t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode;
                        bl = true;
                    }
                    if (n5 == 0) {
                        n5 = this.scanLineWidth;
                        if (this.bitOffset != 7) {
                            ++this.byteOffset;
                            this.bitOffset = 7;
                            if (this.byteOffset >= n3) break;
                            by = this.input[this.byteOffset];
                        }
                    }
                    n4 = 0;
                    continue;
                }
                if (bl) {
                    t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode;
                    continue;
                }
                t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode2;
                continue;
            }
            if ((by >> this.bitOffset & 1) != 1) continue;
            if (t4CodeHuffmanTreeNode3.right() != null) {
                t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode3.right();
                --this.bitOffset;
                if (this.bitOffset >= 0) continue;
                this.bitOffset = 7;
                ++this.byteOffset;
                if (this.byteOffset >= n3) break;
                by = this.input[this.byteOffset];
                continue;
            }
            n4 += t4CodeHuffmanTreeNode3.value();
            if (t4CodeHuffmanTreeNode3.value() <= 63) {
                if (n4 > n5) {
                    n4 = n5;
                }
                n5 -= n4;
                if (bl) {
                    this.destByteOffset = this.outputRunLen(byArray, this.destByteOffset, n4, this.scanLineWidth, 0, n2);
                    if (n5 != 0) {
                        t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode2;
                        bl = false;
                    } else {
                        t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode;
                        bl = true;
                    }
                } else {
                    this.destByteOffset = this.outputRunLen(byArray, this.destByteOffset, n4, this.scanLineWidth, 1, n2);
                    t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode;
                    bl = true;
                }
                if (n5 == 0) {
                    n5 = this.scanLineWidth;
                    if (this.bitOffset != 7) {
                        ++this.byteOffset;
                        this.bitOffset = 7;
                        if (this.byteOffset >= n3) break;
                        by = this.input[this.byteOffset];
                    }
                }
                n4 = 0;
                continue;
            }
            if (bl) {
                t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode;
                continue;
            }
            t4CodeHuffmanTreeNode3 = t4CodeHuffmanTreeNode2;
        }
        return this.uncompressedBytes;
    }

    protected int outputRunLen(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n2; ++i) {
            if (this.empty_bits >= 1) {
                int n6 = n;
                byArray[n6] = (byte)(byArray[n6] | n4 << this.empty_bits - 1);
                --this.empty_bits;
            }
            if (++this.lineOffset % n3 != 0 && this.empty_bits != 0) continue;
            ++n;
            ++this.uncompressedBytes;
            this.empty_bits = 8;
            if (this.uncompressedBytes >= n5) break;
        }
        return n;
    }

    protected void reset(int n, int n2, int n3) {
        this.byteOffset = n;
        this.len = n2;
        this.bitOffset = n3;
        this.uncompressedBytes = 0;
    }

    @Override
    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    @Override
    public void setInput(byte[] byArray, int n, int n2) {
        this.input = byArray;
        this.reset(n, n2, 7);
    }
}

