/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.ccitt;

import com.icafe4j.image.compression.ImageEncoder;
import com.icafe4j.image.compression.ccitt.T4BlackCode;
import com.icafe4j.image.compression.ccitt.T4Code;
import com.icafe4j.image.compression.ccitt.T4WhiteCode;
import com.icafe4j.util.ArrayUtils;
import com.icafe4j.util.CollectionUtils;
import com.icafe4j.util.Updatable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class G31DEncoder
implements ImageEncoder {
    private int empty_bits;
    private byte[] bytes_buf;
    private int buf_length;
    private OutputStream os;
    private Updatable<Integer> writer;
    private boolean extraFlush;
    private int bufIndex;
    private int compressedDataLen = 0;
    private static final short[] mask = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191};
    protected int scanLineWidth;
    protected int currPos = 7;

    public G31DEncoder(OutputStream outputStream, int n, int n2, Updatable<Integer> updatable) {
        this.scanLineWidth = n;
        this.bytes_buf = new byte[n2];
        this.buf_length = n2;
        this.os = outputStream;
        this.writer = updatable;
    }

    @Override
    public void encode(byte[] byArray, int n, int n2) throws Exception {
        int n3 = n2 / this.scanLineWidth;
        for (int i = 0; i < n3; ++i) {
            n = this.encode1DLine(byArray, n);
        }
    }

    protected int encode1DLine(byte[] byArray, int n) throws Exception {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray[n] >>> this.currPos & 1;
        int n5 = n;
        while (this.currPos >= 0) {
            if ((byArray[n5] >>> this.currPos & 1) == n4) {
                ++n2;
            } else {
                arrayList.add(n2);
                arrayList2.add(n4);
                n4 = byArray[n5] >>> this.currPos & 1;
                n2 = 1;
            }
            ++n3;
            --this.currPos;
            if (this.currPos < 0) {
                this.currPos = 7;
                ++n5;
            }
            if (n3 < this.scanLineWidth) continue;
        }
        arrayList.add(n2);
        arrayList2.add(n4);
        int[] nArray = CollectionUtils.integerListToIntArray(arrayList);
        int[] nArray2 = CollectionUtils.integerListToIntArray(arrayList2);
        for (int i = 0; i < nArray2.length; ++i) {
            int n6 = nArray[i];
            if (nArray2[i] == 0) {
                this.outputRunLengthCode(n6, 0);
                continue;
            }
            if (i == 0) {
                this.send_code_to_buffer(13568, 8);
            }
            this.outputRunLengthCode(n6, 1);
        }
        this.flush_buf(this.bufIndex + 1);
        this.empty_bits = 8;
        return n5;
    }

    protected void outputRunLengthCode(int n, int n2) throws Exception {
        T4Code t4Code;
        int n3;
        if (n >= 2624) {
            n3 = 104;
            t4Code = n2 == 0 ? T4WhiteCode.fromRunLen(T4Code.runLenArray[n3]) : T4BlackCode.fromRunLen(T4Code.runLenArray[n3]);
            short s = t4Code.getCode();
            int n4 = t4Code.getCodeLen();
            int n5 = t4Code.getRunLen();
            while (n >= 2624) {
                this.send_code_to_buffer(s, n4);
                n -= n5;
            }
        }
        while (n >= 64) {
            n3 = 64 + (n >> 6);
            t4Code = n2 == 0 ? T4WhiteCode.fromRunLen(T4Code.runLenArray[n3]) : T4BlackCode.fromRunLen(T4Code.runLenArray[n3]);
            this.send_code_to_buffer(t4Code.getCode(), t4Code.getCodeLen());
            n -= t4Code.getRunLen();
        }
        t4Code = n2 == 0 ? T4WhiteCode.fromRunLen(n) : T4BlackCode.fromRunLen(n);
        this.send_code_to_buffer(t4Code.getCode(), t4Code.getCodeLen());
    }

    protected void outputRunLengthCode2(int n, int n2) throws Exception {
        int n3 = ArrayUtils.findEqualOrLess(T4Code.runLenArray, n);
        while (n3 > 0) {
            T4Code t4Code = n2 == 0 ? T4WhiteCode.fromRunLen(T4Code.runLenArray[n3]) : T4BlackCode.fromRunLen(T4Code.runLenArray[n3]);
            short s = t4Code.getCode();
            int n4 = t4Code.getCodeLen();
            int n5 = t4Code.getRunLen();
            while (n >= n5) {
                this.send_code_to_buffer(s, n4);
                n -= n5;
            }
            n3 = ArrayUtils.findEqualOrLess(T4Code.runLenArray, 0, n3, n);
        }
    }

    @Override
    public void finish() throws Exception {
        if (this.extraFlush) {
            this.flush_buf(this.bufIndex + 1);
        }
        this.writer.update(this.compressedDataLen);
    }

    private void flush_buf(int n) throws Exception {
        this.os.write(this.bytes_buf, 0, n);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, n, (byte)0);
        this.compressedDataLen += n;
    }

    @Override
    public int getCompressedDataLen() {
        return this.compressedDataLen;
    }

    @Override
    public void initialize() throws Exception {
        this.empty_bits = 8;
        this.compressedDataLen = 0;
    }

    protected void send_code_to_buffer(int n, int n2) throws Exception {
        if (this.empty_bits == 0) {
            if (++this.bufIndex >= this.buf_length) {
                this.flush_buf(this.buf_length);
            }
            this.empty_bits = 8;
        }
        if (n2 <= this.empty_bits) {
            int n3 = 16 - n2;
            int n4 = this.bufIndex;
            this.bytes_buf[n4] = (byte)(this.bytes_buf[n4] | (n >>> n3 & mask[n2]) << this.empty_bits - n2);
            this.empty_bits -= n2;
        } else {
            int n5 = this.bufIndex++;
            this.bytes_buf[n5] = (byte)(this.bytes_buf[n5] | n >>> 16 - this.empty_bits & mask[this.empty_bits]);
            int n6 = n2 - this.empty_bits;
            if (n6 > 8) {
                if (this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n7 = this.bufIndex;
                this.bytes_buf[n7] = (byte)(this.bytes_buf[n7] | n >>> 8 - n2 + n6 & mask[8]);
                n6 -= 8;
            }
            if (n6 > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n8 = this.bufIndex;
                this.bytes_buf[n8] = (byte)(this.bytes_buf[n8] | (n >>> 16 - n2 & mask[n6]) << 8 - n6);
                n6 -= 8;
            }
            this.empty_bits = -n6;
        }
    }

    protected void setExtraFlush(boolean bl) {
        this.extraFlush = bl;
    }
}

