/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.ccitt;

import com.icafe4j.image.compression.ccitt.T4Code;
import java.util.HashMap;
import java.util.Map;

public enum T4BlackCode implements T4Code
{
    CODE0(0, 10, 3520),
    CODE1(1, 3, 16384),
    CODE2(2, 2, -16384),
    CODE3(3, 2, Short.MIN_VALUE),
    CODE4(4, 3, 24576),
    CODE5(5, 4, 12288),
    CODE6(6, 4, 8192),
    CODE7(7, 5, 6144),
    CODE8(8, 6, 5120),
    CODE9(9, 6, 4096),
    CODE10(10, 7, 2048),
    CODE11(11, 7, 2560),
    CODE12(12, 7, 3584),
    CODE13(13, 8, 1024),
    CODE14(14, 8, 1792),
    CODE15(15, 9, 3072),
    CODE16(16, 10, 1472),
    CODE17(17, 10, 1536),
    CODE18(18, 10, 512),
    CODE19(19, 11, 3296),
    CODE20(20, 11, 3328),
    CODE21(21, 11, 3456),
    CODE22(22, 11, 1760),
    CODE23(23, 11, 1280),
    CODE24(24, 11, 736),
    CODE25(25, 11, 768),
    CODE26(26, 12, 3232),
    CODE27(27, 12, 3248),
    CODE28(28, 12, 3264),
    CODE29(29, 12, 3280),
    CODE30(30, 12, 1664),
    CODE31(31, 12, 1680),
    CODE32(32, 12, 1696),
    CODE33(33, 12, 1712),
    CODE34(34, 12, 3360),
    CODE35(35, 12, 3376),
    CODE36(36, 12, 3392),
    CODE37(37, 12, 3408),
    CODE38(38, 12, 3424),
    CODE39(39, 12, 3440),
    CODE40(40, 12, 1728),
    CODE41(41, 12, 1744),
    CODE42(42, 12, 3488),
    CODE43(43, 12, 3504),
    CODE44(44, 12, 1344),
    CODE45(45, 12, 1360),
    CODE46(46, 12, 1376),
    CODE47(47, 12, 1392),
    CODE48(48, 12, 1600),
    CODE49(49, 12, 1616),
    CODE50(50, 12, 1312),
    CODE51(51, 12, 1328),
    CODE52(52, 12, 576),
    CODE53(53, 12, 880),
    CODE54(54, 12, 896),
    CODE55(55, 12, 624),
    CODE56(56, 12, 640),
    CODE57(57, 12, 1408),
    CODE58(58, 12, 1424),
    CODE59(59, 12, 688),
    CODE60(60, 12, 704),
    CODE61(61, 12, 1440),
    CODE62(62, 12, 1632),
    CODE63(63, 12, 1648),
    CODE64(64, 10, 960),
    CODE128(128, 12, 3200),
    CODE192(192, 12, 3216),
    CODE256(256, 12, 1456),
    CODE320(320, 12, 816),
    CODE384(384, 12, 832),
    CODE448(448, 12, 848),
    CODE512(512, 13, 864),
    CODE576(576, 13, 872),
    CODE640(640, 13, 592),
    CODE704(704, 13, 600),
    CODE768(768, 13, 608),
    CODE832(832, 13, 616),
    CODE896(896, 13, 912),
    CODE960(960, 13, 920),
    CODE1024(1024, 13, 928),
    CODE1088(1088, 13, 936),
    CODE1152(1152, 13, 944),
    CODE1216(1216, 13, 952),
    CODE1280(1280, 13, 656),
    CODE1344(1344, 13, 664),
    CODE1408(1408, 13, 672),
    CODE1472(1472, 13, 680),
    CODE1536(1536, 13, 720),
    CODE1600(1600, 13, 728),
    CODE1664(1664, 13, 800),
    CODE1728(1728, 13, 808),
    CODE1792(1792, 11, 256),
    CODE1856(1856, 11, 384),
    CODE1920(1920, 11, 416),
    CODE1984(1984, 12, 288),
    CODE2048(2048, 12, 304),
    CODE2112(2112, 12, 320),
    CODE2176(2176, 12, 336),
    CODE2240(2240, 12, 352),
    CODE2304(2304, 12, 368),
    CODE2368(2368, 12, 448),
    CODE2432(2432, 12, 464),
    CODE2496(2496, 12, 480),
    CODE2560(2560, 12, 496),
    UNKNOWN(9999, 12, 0);

    private static final Map<Integer, T4Code> runLenMap;
    private static final Map<Short, T4Code> codeMap;
    private final int runLen;
    private final int codeLen;
    private final short code;

    private T4BlackCode(int n2, int n3, short s) {
        this.runLen = n2;
        this.codeLen = n3;
        this.code = s;
    }

    @Override
    public int getRunLen() {
        return this.runLen;
    }

    @Override
    public int getCodeLen() {
        return this.codeLen;
    }

    @Override
    public short getCode() {
        return this.code;
    }

    public static T4Code fromRunLen(int n) {
        T4Code t4Code = runLenMap.get(n);
        if (t4Code == null) {
            return UNKNOWN;
        }
        return t4Code;
    }

    public static T4Code fromCode(short s) {
        T4Code t4Code = codeMap.get(s);
        if (t4Code == null) {
            return UNKNOWN;
        }
        return t4Code;
    }

    static {
        runLenMap = new HashMap<Integer, T4Code>();
        codeMap = new HashMap<Short, T4Code>();
        for (T4BlackCode t4BlackCode : T4BlackCode.values()) {
            runLenMap.put(t4BlackCode.getRunLen(), t4BlackCode);
            codeMap.put(t4BlackCode.getCode(), t4BlackCode);
        }
    }
}

