/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.huffman;

import com.icafe4j.image.compression.huffman.HuffmanTbl;
import java.io.IOException;
import java.io.InputStream;

public class HuffmanDecoder {
    private static final int DNL = 220;
    private InputStream is;
    private int[] VALPTR;
    private int[] MINCODE;
    private int[] MAXCODE;
    private byte[] HUFFVAL;
    private int CNT = 0;
    private int[] ZZ = new int[64];

    public HuffmanDecoder(InputStream inputStream, HuffmanTbl huffmanTbl) {
        this.is = inputStream;
        this.VALPTR = huffmanTbl.getValPTRTable();
        this.MINCODE = huffmanTbl.getMinCodeTable();
        this.MAXCODE = huffmanTbl.getMaxCodeTable();
        this.HUFFVAL = huffmanTbl.getValueTable();
    }

    private int DECODE() {
        int n = 1;
        int n2 = this.NEXTBIT();
        while (n2 > this.MAXCODE[n]) {
            ++n;
            n2 = (n2 << 1) + this.NEXTBIT();
        }
        int n3 = this.VALPTR[n] + n2 - this.MINCODE[n];
        return this.HUFFVAL[n3] & 0xFF;
    }

    public void decode_AC_coefficients() {
        block2: {
            int n;
            int n2;
            int n3 = 1;
            while (true) {
                int n4 = this.DECODE();
                n2 = n4 % 16;
                n = n4 >> 4;
                if (n2 != 0) break;
                if (n == 15) {
                    n3 += 16;
                    continue;
                }
                break block2;
                break;
            }
            this.decode_ZZ(n3 += n, n2);
            if (n3 == 63) break block2;
            ++n3;
        }
    }

    private void decode_ZZ(int n, int n2) {
        this.ZZ[n] = this.RECEIVE(n2);
        this.ZZ[n] = HuffmanDecoder.EXTEND(this.ZZ[n], n2);
    }

    private static int EXTEND(int n, int n2) {
        int n3 = 1 << n2 - 1;
        if (n < n3) {
            n3 = (-1 << n2) + 1;
            n += n3;
        }
        return n;
    }

    private int NEXTBIT() {
        int n = 0;
        if (this.CNT == 0) {
            int n2;
            n = this.NEXTBYTE();
            this.CNT = 8;
            if (n != 255 || (n2 = this.NEXTBYTE()) == 0 || n2 == 220) {
                // empty if block
            }
        }
        int n3 = n >> 7;
        --this.CNT;
        n <<= 1;
        return n3;
    }

    private int NEXTBYTE() {
        int n;
        try {
            n = this.is.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error reading NEXTBYTE...");
        }
        return n;
    }

    private int RECEIVE(int n) {
        int n2 = 0;
        for (int i = 0; i != n; ++i) {
            n2 = (n2 << 1) + this.NEXTBIT();
        }
        return n2;
    }
}

