/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.huffman;

import com.icafe4j.image.compression.ImageEncoder;
import com.icafe4j.image.compression.huffman.HuffmanTbl;
import com.icafe4j.image.jpeg.JPEGConsts;
import java.io.OutputStream;
import java.util.Arrays;

public class HuffmanEncoder
implements ImageEncoder {
    private int empty_bits;
    private byte[] bytes_buf;
    private int buf_length;
    private int bufIndex;
    private int[][] DC_EHUFCO = new int[4][];
    private int[][] DC_EHUFSI = new int[4][];
    private int[][] AC_EHUFCO = new int[4][];
    private int[][] AC_EHUFSI = new int[4][];
    private int[] PREDICTION = new int[4];
    private boolean extraFlush = true;
    private boolean useCustomTables = false;
    private OutputStream os;
    private static final short[] mask = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191};
    private static final int[] ZIGZAG_TRAVERSE_ORDER = JPEGConsts.getZigzagMatrix();
    int totalBytes = 0;

    public HuffmanEncoder(OutputStream outputStream, int n) {
        this.os = outputStream;
        this.bytes_buf = new byte[n];
        this.buf_length = n;
    }

    private void createDefaultEncodingTables() {
        HuffmanTbl huffmanTbl = new HuffmanTbl();
        huffmanTbl.setBits(JPEGConsts.getDCLuminanceBits());
        huffmanTbl.setValues(JPEGConsts.getDCLuminanceValues());
        huffmanTbl.generateEncoderTables();
        this.DC_EHUFCO[0] = huffmanTbl.getEncoderCodeTable();
        this.DC_EHUFSI[0] = huffmanTbl.getEncoderSizeTable();
        huffmanTbl.setBits(JPEGConsts.getDCChrominanceBits());
        huffmanTbl.setValues(JPEGConsts.getDCChrominanceValues());
        huffmanTbl.generateEncoderTables();
        this.DC_EHUFCO[1] = huffmanTbl.getEncoderCodeTable();
        this.DC_EHUFSI[1] = huffmanTbl.getEncoderSizeTable();
        this.DC_EHUFCO[2] = huffmanTbl.getEncoderCodeTable();
        this.DC_EHUFSI[2] = huffmanTbl.getEncoderSizeTable();
        this.DC_EHUFCO[3] = huffmanTbl.getEncoderCodeTable();
        this.DC_EHUFSI[3] = huffmanTbl.getEncoderSizeTable();
        huffmanTbl.setBits(JPEGConsts.getACLuminanceBits());
        huffmanTbl.setValues(JPEGConsts.getACLuminanceValues());
        huffmanTbl.generateEncoderTables();
        this.AC_EHUFCO[0] = huffmanTbl.getEncoderCodeTable();
        this.AC_EHUFSI[0] = huffmanTbl.getEncoderSizeTable();
        huffmanTbl.setBits(JPEGConsts.getACChrominanceBits());
        huffmanTbl.setValues(JPEGConsts.getACChrominanceValues());
        huffmanTbl.generateEncoderTables();
        this.AC_EHUFCO[1] = huffmanTbl.getEncoderCodeTable();
        this.AC_EHUFSI[1] = huffmanTbl.getEncoderSizeTable();
        this.AC_EHUFCO[2] = huffmanTbl.getEncoderCodeTable();
        this.AC_EHUFSI[2] = huffmanTbl.getEncoderSizeTable();
        this.AC_EHUFCO[3] = huffmanTbl.getEncoderCodeTable();
        this.AC_EHUFSI[3] = huffmanTbl.getEncoderSizeTable();
    }

    @Override
    public void encode(byte[] byArray, int n, int n2) throws Exception {
        throw new UnsupportedOperationException("Call encode(int[] ZZ, int component_id) instead.");
    }

    public void encode(int[] nArray, int n) throws Exception {
        int n2 = 0;
        int n3 = nArray[0] - this.PREDICTION[n];
        int n4 = HuffmanEncoder.CSIZE(n3);
        if (n3 < 0) {
            --n3;
        }
        this.send_code_to_buffer(this.DC_EHUFCO[n][n4], this.DC_EHUFSI[n][n4]);
        if (n4 != 0) {
            this.send_code_to_buffer(n3, n4);
        }
        this.PREDICTION[n] = nArray[0];
        for (int i = 1; i < 64; ++i) {
            n3 = nArray[ZIGZAG_TRAVERSE_ORDER[i]];
            if (n3 == 0) {
                ++n2;
                continue;
            }
            while (n2 > 15) {
                this.send_code_to_buffer(this.AC_EHUFCO[n][240], this.AC_EHUFSI[n][240]);
                n2 -= 16;
            }
            n4 = HuffmanEncoder.CSIZE(n3);
            if (n3 < 0) {
                --n3;
            }
            int n5 = (n2 << 4) + n4;
            this.send_code_to_buffer(this.AC_EHUFCO[n][n5], this.AC_EHUFSI[n][n5]);
            this.send_code_to_buffer(n3, n4);
            n2 = 0;
        }
        if (n2 > 0) {
            this.send_code_to_buffer(this.AC_EHUFCO[n][0], this.AC_EHUFSI[n][0]);
        }
    }

    @Override
    public void finish() throws Exception {
        if (this.extraFlush) {
            this.flush_buf(this.bufIndex + 1);
        }
    }

    private void flush_buf(int n) throws Exception {
        this.os.write(this.bytes_buf, 0, n);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, n, (byte)0);
        this.totalBytes += n;
    }

    @Override
    public int getCompressedDataLen() {
        return this.totalBytes;
    }

    @Override
    public void initialize() {
        if (!this.useCustomTables) {
            this.createDefaultEncodingTables();
        }
        this.empty_bits = 8;
        this.totalBytes = 0;
    }

    private void send_code_to_buffer(int n, int n2) throws Exception {
        if (this.empty_bits == 0) {
            if (++this.bufIndex >= this.buf_length) {
                this.flush_buf(this.buf_length);
            }
            this.empty_bits = 8;
        }
        if (n2 < this.empty_bits) {
            int n3 = this.bufIndex;
            this.bytes_buf[n3] = (byte)(this.bytes_buf[n3] | (n & mask[n2]) << this.empty_bits - n2);
            this.empty_bits -= n2;
        } else {
            int n4 = this.bufIndex;
            this.bytes_buf[n4] = (byte)(this.bytes_buf[n4] | n >>> n2 - this.empty_bits & mask[this.empty_bits]);
            int n5 = n2 - this.empty_bits;
            if ((this.bytes_buf[this.bufIndex] & 0xFF) == 255) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n6 = this.bufIndex;
                this.bytes_buf[n6] = (byte)(this.bytes_buf[n6] | 0);
            }
            if (n5 >= 8) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n7 = this.bufIndex;
                this.bytes_buf[n7] = (byte)(this.bytes_buf[n7] | n >>> n5 - 8 & mask[8]);
                n5 -= 8;
                if ((this.bytes_buf[this.bufIndex] & 0xFF) == 255) {
                    if (++this.bufIndex >= this.buf_length) {
                        this.flush_buf(this.buf_length);
                    }
                    int n8 = this.bufIndex;
                    this.bytes_buf[n8] = (byte)(this.bytes_buf[n8] | 0);
                }
            }
            if (n5 > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n9 = this.bufIndex;
                this.bytes_buf[n9] = (byte)(this.bytes_buf[n9] | (n & mask[n5]) << 8 - n5);
                n5 -= 8;
            }
            this.empty_bits = -n5;
        }
    }

    public void setEncodingTables(int[][] nArray, int[][] nArray2, int[][] nArray3, int[][] nArray4) {
        this.DC_EHUFCO = nArray;
        this.DC_EHUFSI = nArray2;
        this.AC_EHUFCO = nArray3;
        this.AC_EHUFSI = nArray4;
        this.useCustomTables = true;
    }

    private static int CSIZE(int n) {
        if (n == 0) {
            return 0;
        }
        if (n >= -1 && n <= 1) {
            return 1;
        }
        if (n >= -3 && n <= 3) {
            return 2;
        }
        if (n >= -7 && n <= 7) {
            return 3;
        }
        if (n >= -15 && n <= 15) {
            return 4;
        }
        if (n >= -31 && n <= 31) {
            return 5;
        }
        if (n >= -63 && n <= 63) {
            return 6;
        }
        if (n >= -127 && n <= 127) {
            return 7;
        }
        if (n >= -255 && n <= 255) {
            return 8;
        }
        if (n >= -511 && n <= 511) {
            return 9;
        }
        if (n >= -1023 && n <= 1023) {
            return 10;
        }
        if (n >= -2047 && n <= 2047) {
            return 11;
        }
        throw new RuntimeException("Invalid ZZ_K value: " + n);
    }
}

