/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.gif;

import com.icafe4j.image.ImageIO;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.gif.FrameReader;
import com.icafe4j.image.gif.GIFFrame;
import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.gif.GifXMP;
import com.icafe4j.image.meta.image.Comments;
import com.icafe4j.image.meta.xmp.XMP;
import com.icafe4j.image.writer.GIFWriter;
import com.icafe4j.image.writer.ImageWriter;
import com.icafe4j.io.IOUtils;
import com.icafe4j.string.StringUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GIFTweaker {
    public static final byte IMAGE_SEPARATOR = 44;
    public static final byte IMAGE_TRAILER = 59;
    public static final byte EXTENSION_INTRODUCER = 33;
    public static final byte GRAPHIC_CONTROL_LABEL = -7;
    public static final byte APPLICATION_EXTENSION_LABEL = -1;
    public static final byte COMMENT_EXTENSION_LABEL = -2;
    public static final byte TEXT_EXTENSION_LABEL = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(GIFTweaker.class);

    private static boolean copyFrame(InputStream inputStream, OutputStream outputStream, DataTransferObject dataTransferObject) throws IOException {
        byte[] byArray;
        int n;
        int n2;
        outputStream.write(dataTransferObject.header);
        outputStream.write(dataTransferObject.logicalScreenDescriptor);
        if (dataTransferObject.globalPalette != null) {
            outputStream.write(dataTransferObject.globalPalette);
        }
        int n3 = 0;
        do {
            if ((n3 = inputStream.read()) == 59) {
                return false;
            }
            if (n3 == -1) {
                LOGGER.error("Unexpected end of stream!");
                return false;
            }
            if (n3 != 33) continue;
            n2 = inputStream.read();
            outputStream.write(33);
            outputStream.write(n2);
            n = 0;
            while ((n = inputStream.read()) > 0) {
                outputStream.write(n);
                byArray = new byte[n];
                inputStream.read(byArray);
                outputStream.write(byArray);
            }
            outputStream.write(0);
        } while (n3 != 44);
        GIFTweaker.readImageDescriptor(inputStream, dataTransferObject);
        outputStream.write(44);
        outputStream.write(dataTransferObject.imageDescriptor);
        if ((dataTransferObject.imageDescriptor[8] & 0x80) == 128) {
            n2 = (dataTransferObject.imageDescriptor[8] & 7) + 1;
            n = 1 << n2;
            byArray = new byte[3 * n];
            inputStream.read(byArray);
            outputStream.write(byArray);
        }
        outputStream.write(inputStream.read());
        n2 = 0;
        while ((n2 = inputStream.read()) > 0) {
            outputStream.write(n2);
            byte[] byArray2 = new byte[n2];
            inputStream.read(byArray2);
            outputStream.write(byArray2);
        }
        outputStream.write(0);
        outputStream.write(59);
        outputStream.close();
        return true;
    }

    public static void finishWrite(OutputStream outputStream) throws Exception {
        outputStream.write(59);
        outputStream.close();
    }

    public static void insertComments(InputStream inputStream, OutputStream outputStream, List<String> list) throws IOException {
        int n;
        int n2;
        DataTransferObject dataTransferObject = new DataTransferObject();
        GIFTweaker.readHeader(inputStream, dataTransferObject);
        GIFTweaker.readLSD(inputStream, dataTransferObject);
        outputStream.write(dataTransferObject.header);
        outputStream.write(dataTransferObject.logicalScreenDescriptor);
        if ((dataTransferObject.logicalScreenDescriptor[4] & 0x80) == 128) {
            n2 = (dataTransferObject.logicalScreenDescriptor[4] & 7) + 1;
            n = 1 << n2;
            GIFTweaker.readGlobalPalette(inputStream, n, dataTransferObject);
            outputStream.write(dataTransferObject.globalPalette);
        }
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            outputStream.write(33);
            outputStream.write(-2);
            byte[] byArray = list.get(n).getBytes();
            int n3 = byArray.length / 255;
            int n4 = byArray.length % 255;
            int n5 = 0;
            if (n3 > 0) {
                for (int i = 0; i < n3; ++i) {
                    outputStream.write(255);
                    outputStream.write(byArray, n5, 255);
                    n5 += 255;
                }
            }
            if (n4 > 0) {
                outputStream.write(n4);
                outputStream.write(byArray, n5, n4);
            }
            outputStream.write(0);
        }
        byte[] byArray = new byte[10240];
        int n6 = inputStream.read(byArray);
        while (n6 != -1) {
            outputStream.write(byArray, 0, n6);
            n6 = inputStream.read(byArray);
        }
    }

    public static void insertXMPApplicationBlock(InputStream inputStream, OutputStream outputStream, XMP xMP) throws IOException {
        int n;
        DataTransferObject dataTransferObject = new DataTransferObject();
        GIFTweaker.readHeader(inputStream, dataTransferObject);
        GIFTweaker.readLSD(inputStream, dataTransferObject);
        outputStream.write(dataTransferObject.header);
        outputStream.write(dataTransferObject.logicalScreenDescriptor);
        if ((dataTransferObject.logicalScreenDescriptor[4] & 0x80) == 128) {
            int n2 = (dataTransferObject.logicalScreenDescriptor[4] & 7) + 1;
            n = 1 << n2;
            GIFTweaker.readGlobalPalette(inputStream, n, dataTransferObject);
            outputStream.write(dataTransferObject.globalPalette);
        }
        xMP.write(outputStream);
        byte[] byArray = new byte[10240];
        n = inputStream.read(byArray);
        while (n != -1) {
            outputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
    }

    public static void insertXMPApplicationBlock(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        GIFTweaker.insertXMPApplicationBlock(inputStream, outputStream, new GifXMP(byArray));
    }

    public static void prepareForWrite(GIFWriter gIFWriter, OutputStream outputStream, int n, int n2) throws Exception {
        gIFWriter.prepareForWrite(outputStream, n, n2);
    }

    public static void insertXMPApplicationBlock(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        GIFTweaker.insertXMPApplicationBlock(inputStream, outputStream, new GifXMP(string));
    }

    private static boolean readFrame(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        byte[] byArray;
        int n;
        int n2;
        int n3 = -1;
        int n4 = 0;
        do {
            if ((n4 = inputStream.read()) == -1 || n4 == 59) {
                return false;
            }
            if (n4 != 33) continue;
            n2 = inputStream.read();
            int n5 = inputStream.read();
            if (n2 == 249) {
                n = inputStream.read();
                n3 = (n & 0x1C) >> 2;
                switch (n3) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                if ((n & 1) == 1) {
                    IOUtils.skipFully(inputStream, 2);
                    inputStream.read();
                    n5 = inputStream.read();
                } else {
                    IOUtils.skipFully(inputStream, 3);
                    n5 = inputStream.read();
                }
            } else if (n2 == 255) {
                byte[] byArray2 = new byte[]{88, 77, 80, 32, 68, 97, 116, 97, 88, 77, 80};
                byArray = new byte[11];
                IOUtils.readFully(inputStream, byArray);
                if (Arrays.equals(byArray2, byArray)) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    n5 = inputStream.read();
                    while (n5 != 0) {
                        byteArrayOutputStream.write(n5);
                        byArray = new byte[n5];
                        IOUtils.readFully(inputStream, byArray);
                        byteArrayOutputStream.write(byArray);
                        n5 = inputStream.read();
                    }
                    byte[] byArray3 = byteArrayOutputStream.toByteArray();
                    n5 = byArray3.length - 257;
                    if (n5 > 0) {
                        dataTransferObject.metadataMap.put(MetadataType.XMP, new GifXMP(ArrayUtils.subArray(byArray3, 0, n5)));
                    }
                    n5 = 0;
                } else {
                    n5 = inputStream.read();
                }
            } else if (n2 == 254) {
                byte[] byArray4 = new byte[n5];
                IOUtils.readFully(inputStream, byArray4);
                if (dataTransferObject.comments == null) {
                    dataTransferObject.comments = new Comments();
                }
                dataTransferObject.comments.addComment(byArray4);
                n5 = inputStream.read();
            }
            while (n5 != 0) {
                IOUtils.skipFully(inputStream, n5);
                n5 = inputStream.read();
            }
        } while (n4 != 44);
        GIFTweaker.readImageDescriptor(inputStream, dataTransferObject);
        n2 = 1 << (dataTransferObject.logicalScreenDescriptor[4] & 7) + 1;
        byte[] byArray5 = null;
        if ((dataTransferObject.imageDescriptor[8] & 0x80) == 128) {
            n = (dataTransferObject.imageDescriptor[8] & 7) + 1;
            n2 = 1 << n;
            byArray5 = new byte[3 * n2];
            inputStream.read(byArray5);
        }
        if (byArray5 == null) {
            byArray5 = dataTransferObject.globalPalette;
        }
        inputStream.read();
        n = 0;
        while ((n = inputStream.read()) > 0) {
            byArray = new byte[n];
            inputStream.read(byArray);
        }
        return true;
    }

    private static void readGlobalPalette(InputStream inputStream, int n, DataTransferObject dataTransferObject) throws IOException {
        DataTransferObject.access$202(dataTransferObject, new byte[n * 3]);
        inputStream.read(dataTransferObject.globalPalette);
    }

    private static void readHeader(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        DataTransferObject.access$002(dataTransferObject, new byte[6]);
        inputStream.read(dataTransferObject.header);
    }

    private static void readImageDescriptor(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        DataTransferObject.access$302(dataTransferObject, new byte[9]);
        inputStream.read(dataTransferObject.imageDescriptor);
    }

    private static void readLSD(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        DataTransferObject.access$102(dataTransferObject, new byte[7]);
        inputStream.read(dataTransferObject.logicalScreenDescriptor);
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream inputStream) throws IOException {
        DataTransferObject dataTransferObject = new DataTransferObject();
        dataTransferObject.metadataMap = new HashMap();
        GIFTweaker.readHeader(inputStream, dataTransferObject);
        GIFTweaker.readLSD(inputStream, dataTransferObject);
        if ((dataTransferObject.logicalScreenDescriptor[4] & 0x80) == 128) {
            int n = (dataTransferObject.logicalScreenDescriptor[4] & 7) + 1;
            int n2 = 1 << n;
            GIFTweaker.readGlobalPalette(inputStream, n2, dataTransferObject);
        }
        while (GIFTweaker.readFrame(inputStream, dataTransferObject)) {
        }
        if (dataTransferObject.comments != null) {
            dataTransferObject.metadataMap.put(MetadataType.COMMENT, dataTransferObject.comments);
        }
        return dataTransferObject.metadataMap;
    }

    public static void splitFrames(InputStream inputStream, String string) throws Exception {
        String string2;
        FileOutputStream fileOutputStream;
        int n;
        DataTransferObject dataTransferObject = new DataTransferObject();
        GIFTweaker.readHeader(inputStream, dataTransferObject);
        GIFTweaker.readLSD(inputStream, dataTransferObject);
        if ((dataTransferObject.logicalScreenDescriptor[4] & 0x80) == 128) {
            n = (dataTransferObject.logicalScreenDescriptor[4] & 7) + 1;
            int n2 = 1 << n;
            GIFTweaker.readGlobalPalette(inputStream, n2, dataTransferObject);
        }
        n = 0;
        while (GIFTweaker.copyFrame(inputStream, fileOutputStream = new FileOutputStream((string2 = StringUtils.isNullOrEmpty(string) ? "frame_" + n++ : string + "_frame_" + n++) + ".gif"), dataTransferObject)) {
        }
        fileOutputStream.close();
        new File(string2 + ".gif").delete();
    }

    @Deprecated
    public static void splitFrames2(InputStream inputStream, ImageWriter imageWriter, String string) throws Exception {
        String string2;
        FrameReader frameReader = new FrameReader();
        ImageType imageType = imageWriter.getImageType();
        GIFFrame gIFFrame = frameReader.getGIFFrame(inputStream);
        int n = frameReader.getLogicalScreenWidth();
        int n2 = frameReader.getLogicalScreenHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n3 = 0;
        String string3 = string2 = StringUtils.isNullOrEmpty(string) ? "frame_" : string + "_frame_";
        while (gIFFrame != null) {
            int n4 = gIFFrame.getLeftPosition();
            int n5 = gIFFrame.getTopPosition();
            int n6 = gIFFrame.getFrameWidth();
            int n7 = gIFFrame.getFrameHeight();
            Rectangle rectangle = new Rectangle(n4, n5, n6, n7);
            BufferedImage bufferedImage2 = new BufferedImage(n6, n7, 2);
            bufferedImage2.setData(bufferedImage.getData(rectangle));
            graphics2D.drawImage((Image)gIFFrame.getFrame(), n4, n5, null);
            String string4 = string2 + n3++;
            FileOutputStream fileOutputStream = new FileOutputStream(string4 + "." + imageType.getExtension());
            imageWriter.write(bufferedImage, fileOutputStream);
            if (gIFFrame.getDisposalMethod() != 1 && gIFFrame.getDisposalMethod() != 0) {
                Composite composite;
                if (gIFFrame.getDisposalMethod() == 2) {
                    composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.Clear);
                    graphics2D.fillRect(n4, n5, n6, n7);
                    graphics2D.setComposite(composite);
                } else if (gIFFrame.getDisposalMethod() == 3) {
                    composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.Src);
                    graphics2D.drawImage((Image)bufferedImage2, n4, n5, null);
                    graphics2D.setComposite(composite);
                } else {
                    bufferedImage = new BufferedImage(n, n2, 2);
                    graphics2D = bufferedImage.createGraphics();
                }
            }
            gIFFrame = frameReader.getGIFFrame(inputStream);
        }
    }

    public static void splitAnimatedGIF(InputStream inputStream, String string) throws Exception {
        GIFTweaker.splitAnimatedGIF(inputStream, ImageIO.getWriter(ImageType.GIF), string);
    }

    public static void splitAnimatedGIF(InputStream inputStream, ImageWriter imageWriter, String string) throws Exception {
        String string2;
        FrameReader frameReader = new FrameReader();
        ImageType imageType = imageWriter.getImageType();
        GIFFrame gIFFrame = frameReader.getGIFFrameEx(inputStream);
        int n = 0;
        String string3 = string2 = StringUtils.isNullOrEmpty(string) ? "frame_" : string + "_frame_";
        while (gIFFrame != null) {
            String string4 = string2 + n++;
            FileOutputStream fileOutputStream = new FileOutputStream(string4 + "." + imageType.getExtension());
            imageWriter.write(gIFFrame.getFrame(), fileOutputStream);
            gIFFrame = frameReader.getGIFFrameEx(inputStream);
        }
    }

    public static void writeAnimatedGIF(BufferedImage[] bufferedImageArray, int[] nArray, int n, OutputStream outputStream) throws Exception {
        GIFTweaker.writeAnimatedGIF(bufferedImageArray, nArray, n, ImageParam.getBuilder().applyDither(true).build(), outputStream);
    }

    public static void writeAnimatedGIF(BufferedImage[] bufferedImageArray, int[] nArray, int n, ImageParam imageParam, OutputStream outputStream) throws Exception {
        GIFWriter gIFWriter = new GIFWriter();
        gIFWriter.setImageParam(imageParam);
        gIFWriter.setLoopCount(n);
        gIFWriter.writeAnimatedGIF(bufferedImageArray, nArray, outputStream);
    }

    public static void writeAnimatedGIF(BufferedImage[] bufferedImageArray, int[] nArray, OutputStream outputStream) throws Exception {
        GIFTweaker.writeAnimatedGIF(bufferedImageArray, nArray, 0, outputStream);
    }

    public static void writeAnimatedGIF(GIFFrame[] gIFFrameArray, int n, OutputStream outputStream) throws Exception {
        GIFTweaker.writeAnimatedGIF(gIFFrameArray, n, ImageParam.getBuilder().applyDither(true).build(), outputStream);
    }

    public static void writeAnimatedGIF(GIFFrame[] gIFFrameArray, int n, ImageParam imageParam, OutputStream outputStream) throws Exception {
        GIFWriter gIFWriter = new GIFWriter();
        gIFWriter.setImageParam(imageParam);
        gIFWriter.setLoopCount(n);
        gIFWriter.writeAnimatedGIF(gIFFrameArray, outputStream);
    }

    public static void writeAnimatedGIF(GIFFrame[] gIFFrameArray, OutputStream outputStream) throws Exception {
        GIFTweaker.writeAnimatedGIF(gIFFrameArray, 0, outputStream);
    }

    public static void writeAnimatedGIF(List<GIFFrame> list, int n, OutputStream outputStream) throws Exception {
        GIFTweaker.writeAnimatedGIF(list.toArray(new GIFFrame[0]), n, outputStream);
    }

    public static void writeAnimatedGIF(List<GIFFrame> list, OutputStream outputStream) throws Exception {
        GIFTweaker.writeAnimatedGIF(list, 0, outputStream);
    }

    public static void writeFrame(GIFWriter gIFWriter, OutputStream outputStream, BufferedImage bufferedImage) throws Exception {
        gIFWriter.writeFrame(outputStream, bufferedImage);
    }

    public static void writeFrame(GIFWriter gIFWriter, OutputStream outputStream, BufferedImage bufferedImage, int n) throws Exception {
        gIFWriter.writeFrame(outputStream, bufferedImage, n);
    }

    public static void writeFrame(GIFWriter gIFWriter, OutputStream outputStream, GIFFrame gIFFrame) throws Exception {
        gIFWriter.writeFrame(outputStream, gIFFrame);
    }

    private GIFTweaker() {
    }

    private static class DataTransferObject {
        private byte[] header;
        private byte[] logicalScreenDescriptor;
        private byte[] globalPalette;
        private byte[] imageDescriptor;
        private Map<MetadataType, Metadata> metadataMap;
        private Comments comments;

        private DataTransferObject() {
        }

        static /* synthetic */ byte[] access$202(DataTransferObject dataTransferObject, byte[] byArray) {
            dataTransferObject.globalPalette = byArray;
            return byArray;
        }

        static /* synthetic */ byte[] access$002(DataTransferObject dataTransferObject, byte[] byArray) {
            dataTransferObject.header = byArray;
            return byArray;
        }

        static /* synthetic */ byte[] access$302(DataTransferObject dataTransferObject, byte[] byArray) {
            dataTransferObject.imageDescriptor = byArray;
            return byArray;
        }

        static /* synthetic */ byte[] access$102(DataTransferObject dataTransferObject, byte[] byArray) {
            dataTransferObject.logicalScreenDescriptor = byArray;
            return byArray;
        }
    }
}

