/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.jpeg;

import com.icafe4j.image.jpeg.Component;
import com.icafe4j.image.jpeg.Marker;
import com.icafe4j.image.jpeg.SOFReader;
import com.icafe4j.image.jpeg.Segment;
import com.icafe4j.util.Reader;
import java.io.IOException;

public class SOSReader
implements Reader {
    private Segment segment;
    private SOFReader reader;
    int Ss;
    int Se;
    int Ah_Al;
    int Ah;
    int Al;

    public SOSReader(Segment segment) throws IOException {
        if (segment.getMarker() != Marker.SOS) {
            throw new IllegalArgumentException("Not a valid SOS segment!");
        }
        this.segment = segment;
        this.read();
    }

    public SOSReader(Segment segment, SOFReader sOFReader) throws IOException {
        if (segment.getMarker() != Marker.SOS) {
            throw new IllegalArgumentException("Not a valid SOS segment!");
        }
        this.segment = segment;
        this.reader = sOFReader;
        this.read();
    }

    @Override
    public void read() throws IOException {
        byte[] byArray = this.segment.getData();
        int n = 0;
        int n2 = byArray[n++];
        Component[] componentArray = this.reader.getComponents();
        block0: for (int i = 0; i < n2; ++i) {
            byte by = byArray[n++];
            byte by2 = byArray[n++];
            for (Component component : componentArray) {
                if (component.getId() != by) continue;
                component.setACTableNumber((byte)(by2 & 0xF));
                component.setDCTableNumber((byte)(by2 >> 4 & 0xF));
                continue block0;
            }
        }
        this.Ss = byArray[n++];
        this.Se = byArray[n++];
        this.Ah_Al = byArray[n++];
        this.Ah = this.Ah_Al >> 4 & 0xF;
        this.Al = this.Ah_Al & 0xF;
    }

    public void setSOFReader(SOFReader sOFReader) {
        this.reader = sOFReader;
    }
}

