/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.adobe;

import com.icafe4j.image.meta.adobe.DataBlockType;
import com.icafe4j.io.ReadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDBEntry {
    private int type;
    private int size;
    protected byte[] data;
    protected ReadStrategy readStrategy;
    private static final Logger LOGGER = LoggerFactory.getLogger(DDBEntry.class);

    public DDBEntry(DataBlockType dataBlockType, int n, byte[] byArray, ReadStrategy readStrategy) {
        this(dataBlockType.getValue(), n, byArray, readStrategy);
    }

    public DDBEntry(int n, int n2, byte[] byArray, ReadStrategy readStrategy) {
        this.type = n;
        if (n2 < 0) {
            throw new IllegalArgumentException("Input size is negative");
        }
        this.size = n2;
        this.data = byArray;
        if (readStrategy == null) {
            throw new IllegalArgumentException("Input readStrategy is null");
        }
        this.readStrategy = readStrategy;
    }

    public void print() {
        DataBlockType dataBlockType = this.getTypeEnum();
        if (dataBlockType != DataBlockType.UNKNOWN) {
            LOGGER.info("Type: {} ({})", (Object)dataBlockType, (Object)dataBlockType.getDescription());
        } else {
            LOGGER.info("Type: Unknown (value 0x{})", (Object)Integer.toHexString(this.type));
        }
        LOGGER.info("Size: {}", (Object)this.size);
    }

    public int getType() {
        return this.type;
    }

    public DataBlockType getTypeEnum() {
        return DataBlockType.fromInt(this.type);
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }
}

