/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.exif;

import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.Tag;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.string.StringUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public enum GPSTag implements Tag
{
    GPS_VERSION_ID("GPSVersionID", 0),
    GPS_LATITUDE_REF("GPSLatitudeRef", 1),
    GPS_LATITUDE("GPSLatitude", 2){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 6) {
                throw new IllegalArgumentException("Wrong number of GPSLatitute data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray[0], nArray[1]) + '\u00b0' + StringUtils.rationalToString(decimalFormat, true, nArray[2], nArray[3]) + "'" + StringUtils.rationalToString(decimalFormat, true, nArray[4], nArray[5]) + "\"";
        }
    }
    ,
    GPS_LONGITUDE_REF("GPSLongitudeRef", 3),
    GPS_LONGITUDE("GPSLongitude", 4){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 6) {
                throw new IllegalArgumentException("Wrong number of GPSLongitude data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray[0], nArray[1]) + '\u00b0' + StringUtils.rationalToString(decimalFormat, true, nArray[2], nArray[3]) + "'" + StringUtils.rationalToString(decimalFormat, true, nArray[4], nArray[5]) + "\"";
        }
    }
    ,
    GPS_ALTITUDE_REF("GPSAltitudeRef", 5),
    GPS_ALTITUDE("GPSAltitude", 6){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of GPSAltitute data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray) + "m";
        }
    }
    ,
    GPS_TIME_STAMP("GPSTimeStamp", 7){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 6) {
                throw new IllegalArgumentException("Wrong number of GPSTimeStamp data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.##");
            return StringUtils.rationalToString(decimalFormat, true, nArray[0], nArray[1]) + ":" + StringUtils.rationalToString(decimalFormat, true, nArray[2], nArray[3]) + ":" + StringUtils.rationalToString(decimalFormat, true, nArray[4], nArray[5]);
        }
    }
    ,
    GPS_SATELLITES("GPSSatellites", 8),
    GPS_STATUS("GPSStatus", 9),
    GPS_MEASURE_MODE("GPSMeasureMode", 10),
    GPS_DOP("GPSDOP/ProcessingSoftware", 11),
    GPS_SPEED_REF("GPSSpeedRef", 12),
    GPSSpeed("GPSSpeed", 13),
    GPS_TRACK_REF("GPSTrackRef", 14),
    GPS_TRACK("GPSTrack", 15),
    GPS_IMG_DIRECTION_REF("GPSImgDirectionRef", 16),
    GPS_IMG_DIRECTION("GPSImgDirection", 17){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of GPSImgDirection data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray) + '\u00b0';
        }
    }
    ,
    GPS_MAP_DATUM("GPSMapDatum", 18),
    GPS_DEST_LATITUDE_REF("GPSDestLatitudeRef", 19),
    GPS_DEST_LATITUDE("GPSDestLatitude", 20){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 6) {
                throw new IllegalArgumentException("Wrong number of GPSDestLatitute data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray[0], nArray[1]) + '\u00b0' + StringUtils.rationalToString(decimalFormat, true, nArray[2], nArray[3]) + "'" + StringUtils.rationalToString(decimalFormat, true, nArray[4], nArray[5]) + "\"";
        }
    }
    ,
    GPS_DEST_LONGITUDE_REF("GPSDestLongitudeRef", 21),
    GPS_DEST_LONGITUDE("GPSDestLongitude", 22){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 6) {
                throw new IllegalArgumentException("Wrong number of GPSDestLongitude data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray[0], nArray[1]) + '\u00b0' + StringUtils.rationalToString(decimalFormat, true, nArray[2], nArray[3]) + "'" + StringUtils.rationalToString(decimalFormat, true, nArray[4], nArray[5]) + "\"";
        }
    }
    ,
    GPS_DEST_BEARING_REF("GPSDestBearingRef", 23),
    GPS_DEST_BEARING("GPSDestBearing", 24){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of GPSDestBearing data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray) + "m";
        }
    }
    ,
    GPS_DEST_DISTANCE_REF("GPSDestDistanceRef", 25),
    GPS_DEST_DISTANCE("GPSDestDistance", 26){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of GPSDestDistance data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray) + "m";
        }
    }
    ,
    GPS_PROCESSING_METHOD("GPSProcessingMethod", 27),
    GPS_AREA_INFORMATION("GPSAreaInformation", 28),
    GPS_DATE_STAMP("GPSDateStamp", 29),
    GPS_DIFFERENTIAL("GPSDifferential", 30),
    GPS_HPOSITIONING_ERROR("GPSHPositioningError", 31),
    UNKNOWN("Unknown", -1);

    private static final Map<Short, GPSTag> tagMap;
    private final String name;
    private final short value;

    private GPSTag(String string2, short s) {
        this.name = string2;
        this.value = s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return this.name;
        }
        return this.name + " [Value: " + StringUtils.shortToHexStringMM(this.value) + "]";
    }

    public static Tag fromShort(short s) {
        GPSTag gPSTag = tagMap.get(s);
        if (gPSTag == null) {
            return TiffTag.UNKNOWN;
        }
        return gPSTag;
    }

    @Override
    public String getFieldAsString(Object object) {
        return "";
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    @Override
    public FieldType getFieldType() {
        return FieldType.UNKNOWN;
    }

    static {
        tagMap = new HashMap<Short, GPSTag>();
        for (GPSTag gPSTag : GPSTag.values()) {
            tagMap.put(gPSTag.getValue(), gPSTag);
        }
    }
}

