/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.image;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Comments
extends Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(Comments.class);
    private Queue<byte[]> queue = new LinkedList<byte[]>();
    private List<String> comments;

    public Comments() {
        super(MetadataType.COMMENT);
        this.comments = new ArrayList<String>();
    }

    public Comments(List<String> list) {
        super(MetadataType.COMMENT);
        if (list == null) {
            throw new IllegalArgumentException("Input is null");
        }
        this.comments = list;
    }

    public List<String> getComments() {
        this.ensureDataRead();
        return Collections.unmodifiableList(this.comments);
    }

    public void addComment(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Input is null");
        }
        this.queue.offer(byArray);
    }

    public void addComment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Input is null");
        }
        this.comments.add(string);
    }

    @Override
    public void read() throws IOException {
        if (this.queue.size() > 0) {
            for (byte[] byArray : this.queue) {
                try {
                    this.comments.add(new String(byArray, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new UnsupportedEncodingException("UTF-8");
                }
            }
            this.queue.clear();
        }
    }

    @Override
    public void showMetadata() {
        this.ensureDataRead();
        LOGGER.info("Comments start =>");
        for (String string : this.comments) {
            LOGGER.info("Comment: {}", (Object)string);
        }
        LOGGER.info("Comments end <=");
    }
}

