/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.image;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.Thumbnail;
import com.icafe4j.string.XMLUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ImageMetadata
extends Metadata {
    private Document document;
    private Map<String, Thumbnail> thumbnails;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageMetadata.class);

    public ImageMetadata(Document document) {
        super(MetadataType.IMAGE);
        this.document = document;
    }

    public ImageMetadata(Document document, Map<String, Thumbnail> map) {
        super(MetadataType.IMAGE);
        this.document = document;
        this.thumbnails = map;
    }

    public boolean containsThumbnail() {
        return this.thumbnails != null && this.thumbnails.size() > 0;
    }

    public Document getDocument() {
        return this.document;
    }

    public Map<String, Thumbnail> getThumbnails() {
        return this.thumbnails;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            this.isDataRead = true;
        }
    }

    @Override
    public void showMetadata() {
        XMLUtils.showXML(this.document);
        if (this.containsThumbnail()) {
            Iterator<Map.Entry<String, Thumbnail>> iterator = this.thumbnails.entrySet().iterator();
            LOGGER.info("Total number of thumbnails: {}", (Object)this.thumbnails.size());
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry<String, Thumbnail> entry = iterator.next();
                LOGGER.info("Thumbnail #{}: {} thumbnail:", (Object)n, (Object)entry.getKey());
                Thumbnail thumbnail = entry.getValue();
                LOGGER.info("Thumbnail width: {}", thumbnail.getWidth() < 0 ? " Unavailable" : Integer.valueOf(thumbnail.getWidth()));
                LOGGER.info("Thumbnail height: {}", thumbnail.getHeight() < 0 ? " Unavailable" : Integer.valueOf(thumbnail.getHeight()));
                LOGGER.info("Thumbnail data type: {}", (Object)thumbnail.getDataTypeAsString());
                ++n;
            }
        }
    }
}

