/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.iptc;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.iptc.IPTCDataSet;
import com.icafe4j.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class IPTC
extends Metadata {
    private Map<String, List<IPTCDataSet>> datasetMap;

    public static void showIPTC(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            IPTC iPTC = new IPTC(byArray);
            try {
                iPTC.read();
                iPTC.showMetadata();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void showIPTC(InputStream inputStream) {
        try {
            IPTC.showIPTC(IOUtils.inputStreamToByteArray(inputStream));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public IPTC() {
        super(MetadataType.IPTC);
        this.datasetMap = new HashMap<String, List<IPTCDataSet>>();
        this.isDataRead = true;
    }

    public IPTC(byte[] byArray) {
        super(MetadataType.IPTC, byArray);
        this.ensureDataRead();
    }

    public void addDataSet(IPTCDataSet iPTCDataSet) {
        this.addDataSets(Arrays.asList(iPTCDataSet));
    }

    public void addDataSets(Collection<? extends IPTCDataSet> collection) {
        if (this.datasetMap != null) {
            for (IPTCDataSet iPTCDataSet : collection) {
                String string = iPTCDataSet.getName();
                if (this.datasetMap.get(string) == null) {
                    ArrayList<IPTCDataSet> arrayList = new ArrayList<IPTCDataSet>();
                    arrayList.add(iPTCDataSet);
                    this.datasetMap.put(string, arrayList);
                    continue;
                }
                if (!iPTCDataSet.allowMultiple()) continue;
                this.datasetMap.get(string).add(iPTCDataSet);
            }
        }
    }

    public String getAsString(String string) {
        List<IPTCDataSet> list = this.getDataSet(string);
        String string2 = "";
        if (list != null) {
            if (list.size() == 1) {
                string2 = list.get(0).getDataAsString();
            } else {
                for (int i = 0; i < list.size() - 1; ++i) {
                    string2 = string2 + list.get(i).getDataAsString() + ";";
                }
                string2 = string2 + list.get(list.size() - 1).getDataAsString();
            }
        }
        return string2;
    }

    public List<IPTCDataSet> getDataSet(String string) {
        return this.getDataSets().get(string);
    }

    public Map<String, List<IPTCDataSet>> getDataSets() {
        this.ensureDataRead();
        return this.datasetMap;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int n = 0;
            byte by = this.data[n];
            this.datasetMap = new HashMap<String, List<IPTCDataSet>>();
            while (by == 28) {
                int n2 = ++n;
                int n3 = this.data[n2] & 0xFF;
                int n4 = ++n;
                int n5 = this.data[n4] & 0xFF;
                int n6 = IOUtils.readUnsignedShortMM(this.data, ++n);
                n += 2;
                if (n6 > 0) {
                    IPTCDataSet iPTCDataSet = new IPTCDataSet(n3, n5, n6, this.data, n);
                    String string = iPTCDataSet.getName();
                    if (this.datasetMap.get(string) == null) {
                        ArrayList<IPTCDataSet> arrayList = new ArrayList<IPTCDataSet>();
                        arrayList.add(iPTCDataSet);
                        this.datasetMap.put(string, arrayList);
                    } else {
                        this.datasetMap.get(string).add(iPTCDataSet);
                    }
                }
                if ((n += n6) >= this.data.length) break;
                by = this.data[n];
            }
            for (Map.Entry<String, List<IPTCDataSet>> entry : this.datasetMap.entrySet()) {
                entry.setValue(new ArrayList(new LinkedHashSet(entry.getValue())));
            }
            this.isDataRead = true;
        }
    }

    @Override
    public void showMetadata() {
        this.ensureDataRead();
        if (this.datasetMap != null) {
            for (List<IPTCDataSet> list : this.datasetMap.values()) {
                for (IPTCDataSet iPTCDataSet : list) {
                    iPTCDataSet.print();
                }
            }
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        for (List<IPTCDataSet> list : this.getDataSets().values()) {
            for (IPTCDataSet iPTCDataSet : list) {
                iPTCDataSet.write(outputStream);
            }
        }
    }
}

