/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.iptc;

import com.icafe4j.image.meta.iptc.IPTCTag;
import com.icafe4j.string.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public enum IPTCObjectDataTag implements IPTCTag
{
    SUB_FILE(10, "SubFile"),
    UNKNOWN(999, "Unknown");

    private static final Map<Integer, IPTCObjectDataTag> recordMap;
    private final int tag;
    private final String name;

    private IPTCObjectDataTag(int n2, String string2) {
        this.tag = n2;
        this.name = string2;
    }

    public static IPTCObjectDataTag fromTag(int n) {
        IPTCObjectDataTag iPTCObjectDataTag = recordMap.get(n);
        if (iPTCObjectDataTag == null) {
            return UNKNOWN;
        }
        return iPTCObjectDataTag;
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public String getDataAsString(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8").trim();
            if (string.length() > 0) {
                return string;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return StringUtils.byteArrayToHexString(byArray, 0, 10);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    public String toString() {
        return this.name;
    }

    static {
        recordMap = new HashMap<Integer, IPTCObjectDataTag>();
        for (IPTCObjectDataTag iPTCObjectDataTag : IPTCObjectDataTag.values()) {
            recordMap.put(iPTCObjectDataTag.getTag(), iPTCObjectDataTag);
        }
    }
}

