/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.png;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.image.png.TIMEBuilder;
import com.icafe4j.image.png.TIMEReader;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TIMEChunk
extends Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(TIMEChunk.class);
    private static final String[] MONTH = new String[]{"", "January", "Febrary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private Chunk chunk;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;

    private static MetadataType validate(ChunkType chunkType) {
        if (chunkType == null) {
            throw new IllegalArgumentException("ChunkType is null");
        }
        if (chunkType == ChunkType.TIME) {
            return MetadataType.PNG_TIME;
        }
        throw new IllegalArgumentException("Input ChunkType is not tIME chunk!");
    }

    private static void checkDate(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
            throw new IllegalArgumentException("Year out of range: -32768 - 32767");
        }
        if (n2 > 12 || n2 < 1) {
            throw new IllegalArgumentException("Month out of range: 1-12");
        }
        if (n3 > 31 || n3 < 1) {
            throw new IllegalArgumentException("Day out of range: 1-31");
        }
        if (n4 > 23 || n4 < 0) {
            throw new IllegalArgumentException("Hour out of range: 0-23");
        }
        if (n5 > 59 || n5 < 0) {
            throw new IllegalArgumentException("Minute out of range: 0-59");
        }
        if (n6 > 60 || n6 < 0) {
            throw new IllegalArgumentException("Second out of range: 0-60");
        }
    }

    public TIMEChunk(Chunk chunk) {
        super(TIMEChunk.validate(chunk.getChunkType()), chunk.getData());
        this.chunk = chunk;
        this.ensureDataRead();
    }

    public TIMEChunk(ChunkType chunkType, int n, int n2, int n3, int n4, int n5, int n6) {
        super(TIMEChunk.validate(chunkType));
        TIMEChunk.checkDate(n, n2, n3, n4, n5, n6);
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.isDataRead = true;
    }

    public Chunk getChunk() {
        if (this.chunk == null) {
            this.chunk = new TIMEBuilder().year(this.year).month(this.month).day(this.day).hour(this.hour).minute(this.minute).second(this.second).build();
        }
        return this.chunk;
    }

    @Override
    public byte[] getData() {
        return this.getChunk().getData();
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getMonth() {
        return this.month;
    }

    public int getSecond() {
        return this.second;
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            TIMEReader tIMEReader = new TIMEReader(this.chunk);
            this.year = tIMEReader.getYear();
            this.month = tIMEReader.getMonth();
            this.day = tIMEReader.getDay();
            this.hour = tIMEReader.getHour();
            this.minute = tIMEReader.getMinute();
            this.second = tIMEReader.getSecond();
            this.isDataRead = true;
        }
    }

    @Override
    public void showMetadata() {
        LOGGER.info("PNG tIME chunk starts =>");
        LOGGER.info("{} {} {}, {}:{}:{} UTC (Time of last modification)", new Object[]{this.day, this.month > 0 && this.month <= 12 ? MONTH[this.month] : "()", this.year, this.hour, this.minute, this.second});
        LOGGER.info("PNG tIME chunk ends <=");
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.getChunk().write(outputStream);
    }
}

