/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.png;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.image.png.TextReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextualChunks
extends Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextualChunks.class);
    private Queue<Chunk> queue;
    private List<Chunk> chunks;
    private Map<String, String> keyValMap;

    public TextualChunks() {
        super(MetadataType.PNG_TEXTUAL);
        this.queue = new LinkedList<Chunk>();
        this.chunks = new ArrayList<Chunk>();
        this.keyValMap = new HashMap<String, String>();
    }

    public TextualChunks(Collection<Chunk> collection) {
        super(MetadataType.PNG_TEXTUAL);
        TextualChunks.validateChunks(collection);
        this.queue = new LinkedList<Chunk>(collection);
        this.chunks = new ArrayList<Chunk>();
        this.keyValMap = new HashMap<String, String>();
    }

    public List<Chunk> getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>(this.chunks);
        arrayList.addAll(this.queue);
        return arrayList;
    }

    public Map<String, String> getKeyValMap() {
        this.ensureDataRead();
        return Collections.unmodifiableMap(this.keyValMap);
    }

    public void addChunk(Chunk chunk) {
        TextualChunks.validateChunkType(chunk.getChunkType());
        this.queue.offer(chunk);
    }

    @Override
    public void read() throws IOException {
        if (this.queue.size() > 0) {
            TextReader textReader = new TextReader();
            for (Chunk chunk : this.queue) {
                textReader.setInput(chunk);
                String string = textReader.getKeyword();
                String string2 = textReader.getText();
                String string3 = this.keyValMap.get(string);
                this.keyValMap.put(string, string3 == null ? string2 : string3 + "; " + string2);
                this.chunks.add(chunk);
            }
            this.queue.clear();
        }
    }

    @Override
    public void showMetadata() {
        this.ensureDataRead();
        LOGGER.info("PNG textual chunk starts =>");
        for (Map.Entry<String, String> entry : this.keyValMap.entrySet()) {
            LOGGER.info("{}: {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
        LOGGER.info("PNG textual chunk ends <=");
    }

    private static void validateChunks(Collection<Chunk> collection) {
        for (Chunk chunk : collection) {
            TextualChunks.validateChunkType(chunk.getChunkType());
        }
    }

    private static void validateChunkType(ChunkType chunkType) {
        if (chunkType != ChunkType.TEXT && chunkType != ChunkType.ITXT && chunkType != ChunkType.ZTXT) {
            throw new IllegalArgumentException("Expect Textual chunk!");
        }
    }
}

