/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.xmp;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.string.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMP
extends Metadata {
    private Document xmpDocument;
    private Document extendedXmpDocument;
    private Document mergedXmpDocument;
    private boolean hasExtendedXmp;
    private byte[] extendedXmpData;
    private String xmp;

    public XMP(byte[] byArray) {
        super(MetadataType.XMP, byArray);
    }

    public XMP(String string) {
        this(string, null);
    }

    public XMP(String string, String string2) {
        super(MetadataType.XMP);
        if (string == null) {
            throw new IllegalArgumentException("Input XMP string is null");
        }
        this.xmp = string;
        if (string2 != null) {
            try {
                this.setExtendedXMPData(XMLUtils.serializeToByteArray(XMLUtils.createXML(string2)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public byte[] getData() {
        byte[] byArray = super.getData();
        if (byArray != null && !this.hasExtendedXmp) {
            return byArray;
        }
        try {
            return XMLUtils.serializeToByteArray(this.getMergedDocument());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getExtendedXmpData() {
        return this.extendedXmpData;
    }

    public Document getExtendedXmpDocument() {
        if (this.hasExtendedXmp && this.extendedXmpDocument == null) {
            this.extendedXmpDocument = XMLUtils.createXML(this.extendedXmpData);
        }
        return this.extendedXmpDocument;
    }

    public Document getMergedDocument() {
        if (this.mergedXmpDocument != null) {
            return this.mergedXmpDocument;
        }
        if (this.getExtendedXmpDocument() != null) {
            Node node;
            this.mergedXmpDocument = XMLUtils.createDocumentNode();
            Document document = this.getXmpDocument();
            NodeList nodeList = document.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = this.mergedXmpDocument.importNode(nodeList.item(i), true);
                this.mergedXmpDocument.appendChild(node);
            }
            XMLUtils.removeAttribute(this.mergedXmpDocument, "rdf:Description", "xmpNote:HasExtendedXMP");
            NodeList nodeList2 = this.extendedXmpDocument.getElementsByTagName("rdf:RDF").item(0).getChildNodes();
            node = (Element)this.mergedXmpDocument.getElementsByTagName("rdf:RDF").item(0);
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                Node node3 = this.mergedXmpDocument.importNode(node2, true);
                node.appendChild(node3);
            }
            return this.mergedXmpDocument;
        }
        return this.getXmpDocument();
    }

    public Document getXmpDocument() {
        this.ensureDataRead();
        return this.xmpDocument;
    }

    public boolean hasExtendedXmp() {
        return this.hasExtendedXmp;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            if (this.xmp != null) {
                this.xmpDocument = XMLUtils.createXML(this.xmp);
            } else if (this.data != null) {
                this.xmpDocument = XMLUtils.createXML(this.data);
            }
            this.isDataRead = true;
        }
    }

    public void setExtendedXMPData(byte[] byArray) {
        this.extendedXmpData = byArray;
        this.hasExtendedXmp = true;
    }

    @Override
    public void showMetadata() {
        this.ensureDataRead();
        XMLUtils.showXML(this.getMergedDocument());
    }

    @Override
    public abstract void write(OutputStream var1) throws IOException;
}

