/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.ChunkType;
import com.icafe4j.io.IOUtils;
import com.icafe4j.util.ArrayUtils;
import com.icafe4j.util.LangUtils;
import com.icafe4j.util.zip.CRC32;
import java.io.IOException;
import java.io.OutputStream;

public class Chunk
implements Comparable<Chunk> {
    private final long length;
    private final ChunkType chunkType;
    private final byte[] data;
    private final long crc;

    @Override
    public int compareTo(Chunk chunk) {
        return this.chunkType.getRanking() - chunk.chunkType.getRanking();
    }

    public Chunk(ChunkType chunkType, long l, byte[] byArray, long l2) {
        this.length = l;
        this.chunkType = chunkType;
        this.data = byArray;
        this.crc = l2;
    }

    public ChunkType getChunkType() {
        return this.chunkType;
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public long getCRC() {
        return this.crc;
    }

    public boolean isValidCRC() {
        return Chunk.calculateCRC(this.chunkType.getValue(), this.data) == this.crc;
    }

    public void write(OutputStream outputStream) throws IOException {
        IOUtils.writeIntMM(outputStream, (int)this.length);
        IOUtils.writeIntMM(outputStream, this.chunkType.getValue());
        IOUtils.write(outputStream, this.data);
        IOUtils.writeIntMM(outputStream, (int)this.crc);
    }

    public String toString() {
        return this.chunkType.toString();
    }

    public boolean equals(Object object) {
        long l;
        if (!(object instanceof Chunk)) {
            return false;
        }
        Chunk chunk = (Chunk)object;
        long l2 = Chunk.calculateCRC(this.getChunkType().getValue(), this.getData());
        return l2 == (l = Chunk.calculateCRC(chunk.getChunkType().getValue(), chunk.getData()));
    }

    public int hashCode() {
        return LangUtils.longToIntHashCode(Chunk.calculateCRC(this.getChunkType().getValue(), this.getData()));
    }

    public static long calculateCRC(int n, byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(ArrayUtils.toByteArrayMM(n));
        cRC32.update(byArray);
        return cRC32.getValue();
    }

    public static long calculateCRC(int n, byte[] byArray, int n2, int n3) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(ArrayUtils.toByteArrayMM(n));
        cRC32.update(byArray, n2, n3);
        return cRC32.getValue();
    }
}

