/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkBuilder;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.util.Builder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.DeflaterOutputStream;

public class ICCPBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private String profileName;
    private byte[] profileData;

    public ICCPBuilder() {
        super(ChunkType.ICCP);
    }

    public ICCPBuilder data(byte[] byArray) {
        this.profileData = byArray;
        return this;
    }

    public ICCPBuilder name(String string) {
        this.profileName = string.trim().replaceAll("\\s+", " ");
        return this;
    }

    @Override
    protected byte[] buildData() {
        StringBuilder stringBuilder = new StringBuilder(this.profileName);
        stringBuilder.append('\u0000');
        stringBuilder.append('\u0000');
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try {
            byteArrayOutputStream.write(stringBuilder.toString().getBytes("iso-8859-1"));
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(deflaterOutputStream);
            bufferedOutputStream.write(this.profileData);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

