/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.io.IOUtils;
import com.icafe4j.util.Reader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class IDATReader
implements Reader {
    private byte[] rawData;
    private ByteArrayOutputStream byteOutput = null;

    public IDATReader() {
        this(8192);
    }

    public IDATReader(int n) {
        this.byteOutput = new ByteArrayOutputStream(n);
    }

    public IDATReader addChunk(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.IDAT) {
            throw new IllegalArgumentException("Not a valid IDAT chunk.");
        }
        try {
            this.byteOutput.write(chunk.getData());
        }
        catch (IOException iOException) {
            throw new RuntimeException("IDATReader: error adding new chunk");
        }
        return this;
    }

    public byte[] getData() throws IOException {
        if (this.rawData == null) {
            this.read();
        }
        return (byte[])this.rawData.clone();
    }

    @Override
    public void read() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(this.byteOutput.toByteArray())));
        this.rawData = IOUtils.inputStreamToByteArray(bufferedInputStream);
        bufferedInputStream.close();
    }
}

