/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.util.Reader;
import java.io.IOException;

public class TIMEReader
implements Reader {
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private Chunk chunk;

    public TIMEReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.TIME) {
            throw new IllegalArgumentException("Not a valid tIME chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException("TIMEReader: error reading chunk");
        }
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getMonth() {
        return this.month;
    }

    public int getSecond() {
        return this.second;
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public void read() throws IOException {
        byte[] byArray = this.chunk.getData();
        if (byArray.length < 7) {
            throw new RuntimeException("TimeReader: input data too short");
        }
        this.year = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        this.month = byArray[2] & 0xFF;
        this.day = byArray[3] & 0xFF;
        this.hour = byArray[4] & 0xFF;
        this.minute = byArray[5] & 0xFF;
        this.second = byArray[6] & 0xFF;
    }
}

