/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.reader;

import com.icafe4j.image.color.CMYKColorSpace;
import com.icafe4j.image.color.Int32ComponentColorModel;
import com.icafe4j.image.compression.ImageDecoder;
import com.icafe4j.image.compression.ccitt.G31DDecoder;
import com.icafe4j.image.compression.deflate.DeflateDecoder;
import com.icafe4j.image.compression.lzw.LZWTreeDecoder;
import com.icafe4j.image.compression.packbits.Packbits;
import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.image.tiff.ASCIIField;
import com.icafe4j.image.tiff.ByteField;
import com.icafe4j.image.tiff.DoubleField;
import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.FloatField;
import com.icafe4j.image.tiff.IFD;
import com.icafe4j.image.tiff.LongField;
import com.icafe4j.image.tiff.RationalField;
import com.icafe4j.image.tiff.ShortField;
import com.icafe4j.image.tiff.TIFFTweaker;
import com.icafe4j.image.tiff.Tag;
import com.icafe4j.image.tiff.TiffField;
import com.icafe4j.image.tiff.TiffFieldEnum;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.image.tiff.UndefinedField;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.io.FileCacheRandomAccessInputStream;
import com.icafe4j.io.RandomAccessInputStream;
import com.icafe4j.io.ReadStrategyII;
import com.icafe4j.io.ReadStrategyMM;
import com.icafe4j.string.StringUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TIFFReader
extends ImageReader {
    private RandomAccessInputStream randIS = null;
    private List<IFD> list = new ArrayList<IFD>();
    private List<BufferedImage> frames = new ArrayList<BufferedImage>();
    private int endian = 19789;
    private static final int[] redMask;
    private static final int[] greenMask;
    private static final int[] blueMask;
    private static final int[] BLACK_WHITE_PALETTE;
    private static final int[] BLACK_WHITE_PALETTE_WHITE_IS_ZERO;
    private static final int[] FOUR_COLOR_PALETTE;
    private static final int[] FOUR_COLOR_PALETTE_WHITE_IS_ZERO;
    private static final int[] SIXTEEN_COLOR_PALETTE;
    private static final int[] SIXTEEN_COLOR_PALETTE_WHITE_IS_ZERO;
    private static final int[] EIGHT_BIT_COLOR_PALETTE;
    private static final int[] EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO;
    private static final int bufLen = 40960;
    private static final Logger LOGGER;

    @Override
    public BufferedImage read(InputStream inputStream) throws Exception {
        this.randIS = new FileCacheRandomAccessInputStream(inputStream, 40960);
        if (!this.readHeader(this.randIS)) {
            return null;
        }
        int n = this.randIS.readInt();
        int n2 = 0;
        while (n != 0) {
            try {
                n = this.readIFD(n2++, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
        }
        BufferedImage bufferedImage = null;
        for (IFD iFD : this.list) {
            try {
                bufferedImage = this.decode(iFD);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            if (bufferedImage == null) continue;
            this.frames.add(bufferedImage);
        }
        this.randIS.shallowClose();
        if (this.frames.size() > 0) {
            return this.frames.get(0);
        }
        return null;
    }

    private BufferedImage decode(IFD iFD) throws Exception {
        TiffField<?> tiffField = iFD.getField(TiffTag.TILE_WIDTH);
        TiffField<?> tiffField2 = iFD.getField(TiffTag.TILE_LENGTH);
        if (tiffField != null && tiffField2 != null) {
            return this.decodeTiledTiff(iFD);
        }
        return this.decodeStrippedTiff(iFD);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private BufferedImage decodeStrippedTiff(IFD var1_1) throws Exception {
        var2_2 = var1_1.getField(TiffTag.COMPRESSION);
        var3_3 = new short[]{1};
        if (var2_2 != null) {
            var3_3 = (short[])var2_2.getData();
        }
        var4_4 = TiffFieldEnum.Compression.fromValue(var3_3[0] & 65535);
        TIFFReader.LOGGER.info("Compression type: {}", (Object)var4_4.getDescription());
        var5_5 = var1_1.getField(TiffTag.STRIP_OFFSETS);
        var6_6 = var1_1.getField(TiffTag.STRIP_BYTE_COUNTS);
        var7_7 = var5_5.getDataAsLong();
        var8_8 = var6_6.getDataAsLong();
        var9_9 = var1_1.getField(TiffTag.IMAGE_WIDTH).getDataAsLong()[0];
        var10_10 = var1_1.getField(TiffTag.IMAGE_LENGTH).getDataAsLong()[0];
        TIFFReader.LOGGER.info("Image width: {}", (Object)var9_9);
        TIFFReader.LOGGER.info("Image height: {}", (Object)var10_10);
        var11_11 = var1_1.getField(TiffTag.ROWS_PER_STRIP);
        var12_12 = var10_10;
        if (var11_11 != null) {
            var12_12 = var11_11.getDataAsLong()[0];
        }
        TIFFReader.LOGGER.info("Rows per strip: {}", (Object)var12_12);
        var13_13 = var1_1.getField(TiffTag.PHOTOMETRIC_INTERPRETATION);
        var14_14 = var13_13.getDataAsLong()[0];
        var15_15 = TiffFieldEnum.PhotoMetric.fromValue(var14_14);
        TIFFReader.LOGGER.info("PhotoMetric: {}", (Object)var15_15);
        var16_16 = var1_1.getField(TiffTag.BITS_PER_SAMPLE);
        var17_17 = var16_16.getDataAsLong()[0];
        TIFFReader.LOGGER.info("Bits per sample: {}", (Object)var17_17);
        var18_18 = var1_1.getField(TiffTag.SAMPLES_PER_PIXEL);
        var19_19 = var18_18.getDataAsLong()[0];
        TIFFReader.LOGGER.info("Samples per pixel: {}", (Object)var19_19);
        var20_20 = var1_1.getField(TiffTag.PREDICTOR);
        var21_21 = 0;
        if (var20_20 != null) {
            var21_21 = var20_20.getDataAsLong()[0];
            TIFFReader.LOGGER.info("Predictor: {}", (Object)var21_21);
        }
        var22_22 = var1_1.getField(TiffTag.PLANAR_CONFIGURATTION);
        var23_23 = 1;
        if (var22_22 != null) {
            var23_23 = var22_22.getDataAsLong()[0];
        }
        var24_24 = TiffFieldEnum.PlanarConfiguration.fromValue(var23_23);
        TIFFReader.LOGGER.info("Planary configuration: {}", (Object)var24_24);
        var25_25 = var1_1.getField(TiffTag.SAMPLE_FORMAT);
        var26_26 = var1_1.getField(TiffTag.S_MAX_SAMPLE_VALUE);
        var27_27 = var1_1.getField(TiffTag.S_MIN_SAMPLE_VALUE);
        var28_28 = 1;
        var29_29 = var1_1.getField(TiffTag.FILL_ORDER);
        if (var29_29 != null) {
            var28_28 = var29_29.getDataAsLong()[0];
        }
        var30_30 = false;
        if (var25_25 != null && var25_25.getDataAsLong()[0] == 3) {
            var30_30 = true;
            var31_31 = var17_17 <= 32 ? 3.4028234663852886E38 : 1.7976931348623157E308;
            v0 = var33_33 = var17_17 <= 32 ? 1.401298464324817E-45 : 4.9E-324;
            if (var17_17 <= 32 && var26_26 != null) {
                var31_31 = ((float[])var26_26.getData())[0];
            } else if (var17_17 > 32 && var26_26 != null) {
                var31_31 = ((double[])var26_26.getData())[0];
            }
            if (var17_17 <= 32 && var27_27 != null) {
                var33_33 = ((float[])var27_27.getData())[0];
            } else if (var17_17 > 32 && var27_27 != null) {
                var33_33 = ((double[])var27_27.getData())[0];
            }
            TIFFReader.LOGGER.info("Sample MAX value: {}", (Object)var31_31);
            TIFFReader.LOGGER.info("Sample MIN vlaue: {}", (Object)var33_33);
        }
        var31_32 = false;
        var32_35 = false;
        var33_34 = var19_19;
        var34_36 = 1;
        var35_37 = var1_1.getField(TiffTag.EXTRA_SAMPLES);
        if (var35_37 != null) {
            var32_35 = var35_37.getDataAsLong()[0] == 1;
        }
        var36_38 = 0;
        var37_39 = null;
        var38_40 = null;
        var39_41 = TIFFTweaker.getUncompressedStripByteCounts(var1_1, var7_7.length);
        var40_42 = new int[var19_19];
        if (var23_23 == 2) {
            var41_43 = var39_41.length / var19_19;
            var42_45 = 0;
            var43_46 = var41_43;
            for (var44_47 = 0; var44_47 < var19_19; ++var44_47) {
                for (var45_48 = var42_45; var45_48 < var43_46; ++var45_48) {
                    v1 = var44_47;
                    var40_42[v1] = var40_42[v1] + var39_41[var45_48];
                }
                var42_45 += var41_43;
                var43_46 += var41_43;
            }
        }
        switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$PhotoMetric[var15_15.ordinal()]) {
            case 1: {
                var41_44 = (short[])var1_1.getField(TiffTag.COLORMAP).getData();
                this.rgbColorPalette = new int[var41_44.length / 3];
                var42_45 = 1 << var17_17;
                var43_46 = var42_45 << 1;
                var45_48 = 0;
                for (var44_47 = 0; var44_47 < var41_44.length / 3; ++var44_47) {
                    this.rgbColorPalette[var45_48++] = -16777216 | (var41_44[var44_47] & 65280) << 8 | var41_44[var44_47 + var42_45] & 65280 | (var41_44[var44_47 + var43_46] & 65280) >> 8;
                }
                var44_47 = (var9_9 * var17_17 + 7) / 8;
                var38_40 = new byte[var44_47 * var10_10];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var45_48 = 0; var45_48 < var8_8.length; ++var45_48) {
                            var46_58 = var39_41[var45_48];
                            this.randIS.seek(var7_7[var45_48]);
                            this.randIS.readFully(var38_40, var36_38, var46_58);
                            var36_38 += var46_58;
                        }
                        break;
                    }
                    case 2: {
                        var37_39 = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var37_39 = new DeflateDecoder();
                        break;
                    }
                    case 5: {
                        for (var45_48 = 0; var45_48 < var8_8.length; ++var45_48) {
                            var46_58 = var39_41[var45_48];
                            this.unpackStrip(var38_40, var36_38, var39_41[var45_48], var7_7[var45_48], var8_8[var45_48]);
                            var36_38 += var46_58;
                        }
                        break;
                    }
                }
                if (var37_39 != null) {
                    for (var45_48 = 0; var45_48 < var8_8.length; ++var45_48) {
                        var46_59 = new byte[var8_8[var45_48]];
                        this.randIS.seek(var7_7[var45_48]);
                        this.randIS.readFully(var46_59);
                        var37_39.setInput(var46_59);
                        var47_65 = var37_39.decode(var38_40, var36_38, var39_41[var45_48]);
                        var36_38 += var47_65;
                    }
                }
                var45_49 = new DataBufferByte(var38_40, var38_40.length);
                var46_60 = null;
                if (var17_17 != 8) {
                    var46_60 = Raster.createPackedRaster(var45_49, var9_9, var10_10, var17_17, null);
                } else {
                    var47_66 = new int[]{0};
                    var46_60 = Raster.createInterleavedRaster(var45_49, var9_9, var10_10, var9_9, 1, var47_66, null);
                }
                var47_67 = new IndexColorModel(var17_17, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
                return new BufferedImage(var47_67, var46_60, false, null);
            }
            case 2: {
                var44_47 = var19_19 * ((var9_9 * var17_17 + 7) / 8);
                var48_72 = var44_47 * var10_10;
                if (var23_23 == 2) {
                    var44_47 = (var9_9 * var17_17 + 7) / 8;
                }
                var38_40 = new byte[var48_72];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var49_73 = 0; var49_73 < var8_8.length; ++var49_73) {
                            var50_75 = var39_41[var49_73];
                            this.randIS.seek(var7_7[var49_73]);
                            this.randIS.readFully(var38_40, var36_38, var50_75);
                            var36_38 += var50_75;
                        }
                        break;
                    }
                    case 5: {
                        for (var49_73 = 0; var49_73 < var8_8.length; ++var49_73) {
                            var50_75 = var39_41[var49_73];
                            this.unpackStrip(var38_40, var36_38, var39_41[var49_73], var7_7[var49_73], var8_8[var49_73]);
                            var36_38 += var50_75;
                        }
                        break;
                    }
                    case 2: {
                        var37_39 = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var37_39 = new DeflateDecoder();
                        break;
                    }
                }
                if (var37_39 != null) {
                    for (var49_73 = 0; var49_73 < var8_8.length; ++var49_73) {
                        var50_75 = var39_41[var49_73];
                        var51_77 /* !! */  = new byte[var8_8[var49_73]];
                        this.randIS.seek(var7_7[var49_73]);
                        this.randIS.readFully(var51_77 /* !! */ );
                        var37_39.setInput(var51_77 /* !! */ );
                        var52_78 = var37_39.decode(var38_40, var36_38, var50_75);
                        var36_38 += var52_78;
                    }
                }
                if (var21_21 == 2 && var23_23 == 1) {
                    var38_40 = TIFFReader.applyDePredictor(var19_19, var38_40, var9_9, var10_10);
                }
                var45_50 /* !! */  = new DataBufferByte(var38_40, var38_40.length);
                var49_74 = var1_1.getField(TiffTag.ICC_PROFILE);
                var50_76 = null;
                if (var49_74 != null) {
                    var50_76 = ICC_Profile.getInstance((byte[])var49_74.getData());
                }
                var51_77 /* !! */  = (byte[])CMYKColorSpace.getInstance();
                if (var50_76 != null) {
                    var51_77 /* !! */  = (byte[])new ICC_ColorSpace(var50_76);
                }
                var52_79 = new int[]{0, 1, 2, 3};
                var53_82 = new int[]{var17_17, var17_17, var17_17, var17_17};
                if (var19_19 >= 5) {
                    var52_79 = new int[]{0, 1, 2, 3, 4};
                    var53_82 = new int[]{var17_17, var17_17, var17_17, var17_17, var17_17};
                    var34_36 = 3;
                    var31_32 = true;
                }
                if (var17_17 == 16) {
                    var54_85 = ArrayUtils.toShortArray(var38_40, this.endian == 19789);
                    var45_50 /* !! */  = new DataBufferUShort(var54_85, var54_85.length);
                    var47_68 = new ComponentColorModel((ColorSpace)var51_77 /* !! */ , var53_82, var31_32, var32_35, var34_36, 1);
                    if (var23_23 == 2) {
                        var52_79 = new int[]{0, var40_42[0] * 8 / var17_17, (var40_42[0] + var40_42[1]) * 8 / var17_17, (var40_42[0] + var40_42[1] + var40_42[2]) * 8 / var17_17};
                        var55_88 = new int[]{0, 0, 0, 0};
                        if (var19_19 >= 5) {
                            var52_79 = new int[]{0, var40_42[0], var40_42[0] + var40_42[1], var40_42[0] + var40_42[1] + var40_42[2], var40_42[0] + var40_42[1] + var40_42[2] + var40_42[3]};
                            var55_88 = new int[]{0, 0, 0, 0, 0};
                        }
                        var46_61 = Raster.createBandedRaster(var45_50 /* !! */ , var9_9, var10_10, var44_47 * 8 / var17_17, var55_88, var52_79, null);
                    } else {
                        var46_61 = Raster.createInterleavedRaster(var45_50 /* !! */ , var9_9, var10_10, var9_9 * var33_34, var33_34, var52_79, null);
                    }
                    if (var50_76 != null) {
                        var46_61 = IMGUtils.iccp2rgbRaster(var46_61, var47_68);
                        var47_68 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_82, var31_32, var32_35, var34_36, var46_61.getTransferType());
                    }
                } else {
                    var47_68 = new ComponentColorModel((ColorSpace)var51_77 /* !! */ , var53_82, var31_32, var32_35, var34_36, 0);
                    if (var23_23 == 2) {
                        var52_79 = new int[]{0, var40_42[0], var40_42[0] + var40_42[1], var40_42[0] + var40_42[1] + var40_42[2]};
                        var54_86 = new int[]{0, 0, 0, 0};
                        if (var19_19 >= 5) {
                            var52_79 = new int[]{0, var40_42[0], var40_42[0] + var40_42[1], var40_42[0] + var40_42[1] + var40_42[2], var40_42[0] + var40_42[1] + var40_42[2] + var40_42[3]};
                            var54_86 = new int[]{0, 0, 0, 0, 0};
                        }
                        var46_61 = Raster.createBandedRaster(var45_50 /* !! */ , var9_9, var10_10, var44_47, var54_86, var52_79, null);
                    } else {
                        var46_61 = Raster.createInterleavedRaster(var45_50 /* !! */ , var9_9, var10_10, var9_9 * var33_34, var33_34, var52_79, null);
                    }
                    if (var50_76 != null) {
                        var46_61 = IMGUtils.iccp2rgbRaster(var46_61, var47_68);
                        var47_68 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_82, var31_32, var32_35, var34_36, 0);
                    }
                }
                return new BufferedImage(var47_68, var46_61, false, null);
            }
            case 3: {
                var54_87 = new int[]{2, 2};
                var55_89 = var1_1.getField(TiffTag.YCbCr_SUB_SAMPLING);
                if (var55_89 != null) {
                    var54_87 = var55_89.getDataAsLong();
                }
                var56_90 = (var9_9 + var54_87[0] - 1) / var54_87[0] * var54_87[0];
                var57_91 = (var10_10 + var54_87[1] - 1) / var54_87[1] * var54_87[1];
                var58_92 = 0.0f;
                var59_93 = 255.0f;
                var60_94 = 128.0f;
                var61_95 = 255.0f;
                var62_96 = 128.0f;
                var63_97 = 255.0f;
                var64_98 = 255.0f;
                var65_99 = 127.0f;
                var66_100 = var1_1.getField(TiffTag.REFERENCE_BLACK_WHITE);
                if (var66_100 != null) {
                    var67_101 = var66_100.getDataAsLong();
                    var58_92 = 1.0f * (float)var67_101[0] / (float)var67_101[1];
                    var59_93 = 1.0f * (float)var67_101[2] / (float)var67_101[3];
                    var60_94 = 1.0f * (float)var67_101[4] / (float)var67_101[5];
                    var61_95 = 1.0f * (float)var67_101[6] / (float)var67_101[7];
                    var62_96 = 1.0f * (float)var67_101[8] / (float)var67_101[9];
                    var63_97 = 1.0f * (float)var67_101[10] / (float)var67_101[11];
                }
                var67_102 = 0.299f;
                var68_103 = 0.587f;
                var69_104 = 0.114f;
                var70_105 = var1_1.getField(TiffTag.YCbCr_COEFFICIENTS);
                if (var70_105 != null) {
                    var71_106 = var70_105.getDataAsLong();
                    var67_102 = 1.0f * (float)var71_106[0] / (float)var71_106[1];
                    var68_103 = 1.0f * (float)var71_106[2] / (float)var71_106[3];
                    var69_104 = 1.0f * (float)var71_106[4] / (float)var71_106[5];
                }
                var71_107 = 0;
                var72_108 = var56_90 * var57_91;
                var38_40 = new byte[var72_108 * 3];
                var73_109 = null;
                var74_112 = null;
                if (var23_23 != 1) ** GOTO lbl310
                var75_113 = var54_87[0] * var54_87[1];
                var76_117 = 1;
                var77_121 = 1;
                var78_132 = var75_113 + var76_117 + var77_121;
                var79_138 = var56_90 / var54_87[0];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var80_141 = 0; var80_141 < var8_8.length; ++var80_141) {
                            this.randIS.seek(var7_7[var80_141]);
                            var81_151 = var8_8[var80_141];
                            var73_109 = new byte[var81_151];
                            this.randIS.readFully(var73_109);
                            var82_162 = var81_151 / var78_132;
                            var71_107 = this.upsampling(var71_107, var82_162, var75_113, var54_87, var58_92, var59_93, var60_94, var61_95, var62_96, var63_97, var64_98, var65_99, var67_102, var68_103, var69_104, var73_109, var38_40, var56_90, var79_138);
                        }
                        ** GOTO lbl375
                    }
                    case 2: {
                        for (var80_142 = 0; var80_142 < var8_8.length; ++var80_142) {
                            this.randIS.seek(var7_7[var80_142]);
                            var81_152 = var8_8[var80_142];
                            var73_109 = new byte[var81_152];
                            this.randIS.readFully(var73_109);
                            var74_112 = new byte[var39_41[var80_142]];
                            var37_39 = new LZWTreeDecoder(8, true);
                            var37_39.setInput(var73_109);
                            var82_163 = var37_39.decode(var74_112, 0, var74_112.length);
                            var83_167 = var82_163 / var78_132;
                            var71_107 = this.upsampling(var71_107, var83_167, var75_113, var54_87, var58_92, var59_93, var60_94, var61_95, var62_96, var63_97, var64_98, var65_99, var67_102, var68_103, var69_104, var74_112, var38_40, var56_90, var79_138);
                        }
                        ** GOTO lbl375
                    }
                    case 5: {
                        for (var80_143 = 0; var80_143 < var8_8.length; ++var80_143) {
                            this.randIS.seek(var7_7[var80_143]);
                            var81_153 = var8_8[var80_143];
                            var73_109 = new byte[var81_153];
                            this.randIS.readFully(var73_109);
                            var74_112 = new byte[var39_41[var80_143]];
                            Packbits.unpackbits(var73_109, var74_112);
                            var82_164 = var39_41[var80_143];
                            var83_168 = var82_164 / var78_132;
                            var71_107 = this.upsampling(var71_107, var83_168, var75_113, var54_87, var58_92, var59_93, var60_94, var61_95, var62_96, var63_97, var64_98, var65_99, var67_102, var68_103, var69_104, var74_112, var38_40, var56_90, var79_138);
                        }
                        ** GOTO lbl375
                    }
                }
                ** GOTO lbl375
lbl310:
                // 1 sources

                var44_47 = (var56_90 * var17_17 + 7) / 8;
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        var75_114 = var8_8.length / var19_19;
                        var76_118 = new byte[var19_19][];
                        var77_122 = new ByteArrayOutputStream();
                        var79_139 = 0;
                        for (var78_133 = 0; var78_133 < var19_19; ++var78_133) {
                            var80_144 = 0;
                            while (var80_144 < var75_114) {
                                this.randIS.seek(var7_7[var79_139]);
                                var81_154 = var8_8[var79_139];
                                var73_109 = new byte[var81_154];
                                this.randIS.readFully(var73_109);
                                var77_122.write(var73_109);
                                ++var80_144;
                                ++var79_139;
                            }
                            var76_118[var78_133] = var77_122.toByteArray();
                            var77_122.reset();
                        }
                        var78_133 = 0;
                        var79_139 = 0;
                        var80_144 = 0;
                        var81_154 = 0;
                        var82_165 = var54_87[0] * var54_87[1];
                        var83_169 = 1;
                        for (var84_170 = 0; var84_170 < var57_91; ++var84_170) {
                            var85_171 = 0;
                            while (var85_171 < var56_90) {
                                var86_172 = var76_118[0][var78_133] & 255;
                                var87_173 = var76_118[1][var79_139] & 255;
                                var88_174 = var76_118[2][var80_144] & 255;
                                if (var83_169 % var82_165 == 0) {
                                    ++var79_139;
                                    ++var80_144;
                                }
                                var89_175 = ((float)var86_172 - var58_92) * var64_98 / (var59_93 - var58_92);
                                var90_176 = ((float)var87_173 - var60_94) * var65_99 / (var61_95 - var60_94);
                                var91_177 = ((float)var88_174 - var62_96) * var65_99 / (var63_97 - var62_96);
                                var92_178 = var91_177 * (2.0f - 2.0f * var67_102) + var89_175;
                                var93_179 = var90_176 * (2.0f - 2.0f * var69_104) + var89_175;
                                var94_180 = (var89_175 - var69_104 * var93_179 - var67_102 * var92_178) / var68_103;
                                if (var92_178 < 0.0f) {
                                    var92_178 = 0.0f;
                                }
                                if (var92_178 > 255.0f) {
                                    var92_178 = 255.0f;
                                }
                                if (var94_180 < 0.0f) {
                                    var94_180 = 0.0f;
                                }
                                if (var94_180 > 255.0f) {
                                    var94_180 = 255.0f;
                                }
                                if (var93_179 < 0.0f) {
                                    var93_179 = 0.0f;
                                }
                                if (var93_179 > 255.0f) {
                                    var93_179 = 255.0f;
                                }
                                var95_181 = 3 * var81_154;
                                var38_40[var95_181] = (byte)var92_178;
                                var38_40[var95_181 + 1] = (byte)var94_180;
                                var38_40[var95_181 + 2] = (byte)var93_179;
                                ++var85_171;
                                ++var78_133;
                                ++var81_154;
                                ++var83_169;
                            }
                        }
                        break;
                    }
                }
lbl375:
                // 6 sources

                var45_51 = new DataBufferByte(var38_40, var38_40.length);
                var52_80 = new int[]{0, 1, 2};
                var31_32 = false;
                var33_34 = var19_19;
                var34_36 = 1;
                var53_83 = new int[]{8, 8, 8};
                var46_62 = Raster.createInterleavedRaster(var45_51, var56_90, var57_91, var56_90 * var33_34, var33_34, var52_80, null);
                var47_69 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_83, var31_32, var32_35, var34_36, 0);
                return new BufferedImage(var47_69, var46_62, false, null).getSubimage(0, 0, var9_9, var10_10);
            }
            case 4: {
                var44_47 = var19_19 * ((var9_9 * var17_17 + 7) / 8);
                var75_115 = var10_10 * var44_47;
                if (var23_23 == 2) {
                    var44_47 = (var9_9 * var17_17 + 7) / 8;
                }
                var38_40 = new byte[var75_115];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var76_119 = 0; var76_119 < var8_8.length; ++var76_119) {
                            var77_123 = var39_41[var76_119];
                            this.randIS.seek(var7_7[var76_119]);
                            this.randIS.readFully(var38_40, var36_38, var77_123);
                            var36_38 += var77_123;
                        }
                        break;
                    }
                    case 5: {
                        for (var76_119 = 0; var76_119 < var8_8.length; ++var76_119) {
                            var77_123 = var39_41[var76_119];
                            this.unpackStrip(var38_40, var36_38, var39_41[var76_119], var7_7[var76_119], var8_8[var76_119]);
                            var36_38 += var77_123;
                        }
                        break;
                    }
                    case 2: {
                        var37_39 = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var37_39 = new DeflateDecoder();
                        break;
                    }
                }
                if (var37_39 != null) {
                    var38_40 = new byte[var7_7.length * var39_41[0]];
                    for (var76_119 = 0; var76_119 < var8_8.length; ++var76_119) {
                        var73_110 = new byte[var8_8[var76_119]];
                        this.randIS.seek(var7_7[var76_119]);
                        this.randIS.readFully(var73_110);
                        var37_39.setInput(var73_110);
                        var77_123 = var37_39.decode(var38_40, var36_38, var39_41[var76_119]);
                        var36_38 += var77_123;
                    }
                }
                if (var21_21 == 2) {
                    if (var23_23 == 1) {
                        var38_40 = TIFFReader.applyDePredictor(var19_19, var38_40, var9_9, var10_10);
                    } else {
                        var76_119 = 0;
                        for (var77_123 = 0; var77_123 < var19_19; ++var77_123) {
                            TIFFReader.applyDePredictor2(var38_40, var76_119, var9_9, var10_10);
                            var76_119 += var40_42[var77_123];
                        }
                    }
                }
                if (var28_28 == 2) {
                    ArrayUtils.reverseBits(var38_40);
                }
                var47_70 = null;
                var46_63 = null;
                var52_81 = new int[var19_19];
                var53_84 = new int[var19_19];
                var33_34 = var19_19;
                var76_120 = new int[var19_19];
                Arrays.fill(var53_84, var17_17 <= 32 ? var17_17 : 32);
                if (var23_23 == 2) {
                    for (var77_123 = 0; var77_123 < var19_19; ++var77_123) {
                        var52_81[var77_123] = 0;
                        var76_120[var77_123] = var77_123;
                    }
                } else {
                    for (var77_123 = 0; var77_123 < var19_19; ++var77_123) {
                        var52_81[var77_123] = var77_123;
                        var76_120[var77_123] = 0;
                    }
                }
                var31_32 = false;
                var34_36 = 1;
                if (var19_19 == 4) {
                    var34_36 = 3;
                    var31_32 = true;
                }
                if (var23_23 != 2) ** GOTO lbl531
                var77_124 = new byte[var19_19][];
                var78_134 = 0;
                var79_140 = 0;
                for (var80_145 = 0; var80_145 < var19_19; ++var80_145) {
                    var77_124[var80_145] = ArrayUtils.subArray(var38_40, var78_134, var40_42[var80_145]);
                    var78_134 += var40_42[var80_145];
                }
                if (var30_30) {
                    if (var17_17 == 16 || var17_17 == 32) {
                        var80_146 /* !! */  = new float[var19_19][];
                        if (var17_17 == 16) {
                            for (var81_155 = 0; var81_155 < var19_19; ++var81_155) {
                                var80_146 /* !! */ [var81_155] = ArrayUtils.to16BitFloatArray(var77_124[var81_155], this.endian == 19789);
                            }
                        } else {
                            for (var81_156 = 0; var81_156 < var19_19; ++var81_156) {
                                var80_146 /* !! */ [var81_156] = ArrayUtils.toFloatArray(var77_124[var81_156], this.endian == 19789);
                            }
                        }
                        var79_140 = 4;
                        var45_52 /* !! */  = new DataBufferFloat(var80_146 /* !! */ , var80_146 /* !! */ [0].length);
                    } else if (var17_17 == 64) {
                        var80_146 /* !! */  = (float[][])new double[var19_19][];
                        for (var81_157 = 0; var81_157 < var19_19; ++var81_157) {
                            var80_146 /* !! */ [var81_157] = (float[])ArrayUtils.toDoubleArray(var77_124[var81_157], this.endian == 19789);
                        }
                        var79_140 = 5;
                        var45_52 /* !! */  = new DataBufferDouble(var80_146 /* !! */ , var80_146 /* !! */ [0].length);
                    } else {
                        throw new UnsupportedOperationException("Unsupported floating point sample bit depth: " + var17_17);
                    }
                    var47_70 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_84, var31_32, var32_35, var34_36, var79_140);
                    var80_146 /* !! */  = (float[][])new BandedSampleModel(var79_140, var9_9, var10_10, var9_9, var76_120, var52_81);
                    var46_63 = Raster.createWritableRaster((SampleModel)var80_146 /* !! */ , var45_52 /* !! */ , null);
                } else {
                    if (var17_17 == 16) {
                        var80_147 = new short[var19_19][];
                        for (var81_158 = 0; var81_158 < var19_19; ++var81_158) {
                            var80_147[var81_158] = ArrayUtils.toShortArray(var77_124[var81_158], this.endian == 19789);
                        }
                        var45_53 /* !! */  = new DataBufferUShort(var80_147, var80_147[0].length);
                        var79_140 = 1;
                    } else if (var17_17 > 8 && var17_17 < 16) {
                        var80_148 = new short[var19_19][];
                        for (var81_159 = 0; var81_159 < var19_19; ++var81_159) {
                            var80_148[var81_159] = (short[])ArrayUtils.toNBits(var17_17, var77_124[var81_159], var9_9, true);
                        }
                        var45_53 /* !! */  = new DataBufferUShort(var80_148, var80_148[0].length);
                        var79_140 = 1;
                    } else if (var17_17 > 16) {
                        var80_149 = new int[var19_19][];
                        var81_160 = false;
                        if (var17_17 % 8 == 0) {
                            var81_160 = true;
                        }
                        for (var82_166 = 0; var82_166 < var19_19; ++var82_166) {
                            var80_149[var82_166] = (int[])ArrayUtils.toNBits(var17_17, var77_124[var82_166], var19_19 * var9_9, var81_160);
                        }
                        var45_53 /* !! */  = new DataBufferInt(var80_149, var80_149[0].length);
                        var79_140 = 3;
                    } else if (var17_17 < 8) {
                        var80_150 = new byte[var19_19][];
                        for (var81_161 = 0; var81_161 < var19_19; ++var81_161) {
                            var80_150[var81_161] = (byte[])ArrayUtils.toNBits(var17_17, var77_124[var81_161], var9_9, true);
                        }
                        var45_53 /* !! */  = new DataBufferByte(var80_150, var80_150[0].length);
                        var79_140 = 0;
                    } else {
                        var45_53 /* !! */  = new DataBufferByte(var77_124, var77_124[0].length);
                        var79_140 = 0;
                    }
                    var47_70 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_84, var31_32, var32_35, var34_36, var79_140);
                    var46_63 = Raster.createBandedRaster(var45_53 /* !! */ , var9_9, var10_10, var9_9, var76_120, var52_81, null);
                }
                ** GOTO lbl565
lbl531:
                // 1 sources

                if (!var30_30) ** GOTO lbl550
                if (var17_17 < 16 || var17_17 > 32) ** GOTO lbl542
                if (var17_17 % 8 == 0) {
                    var77_125 = null;
                    var77_125 = var17_17 == 16 ? ArrayUtils.to16BitFloatArray(var38_40, this.endian == 19789) : (var17_17 == 24 ? ArrayUtils.to24BitFloatArray(var38_40, this.endian == 19789) : ArrayUtils.toFloatArray(var38_40, this.endian == 19789));
                    var47_70 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_84, var31_32, var32_35, var34_36, 4);
                    var45_54 = new DataBufferFloat(var77_125, var77_125.length);
                    var78_135 = new PixelInterleavedSampleModel(4, var9_9, var10_10, var19_19, var9_9 * var19_19, var52_81);
                    var46_63 = Raster.createWritableRaster(var78_135, var45_54, null);
                } else {
                    throw new UnsupportedOperationException("Unsupported bit depth: " + var17_17);
lbl542:
                    // 1 sources

                    if (var17_17 == 64) {
                        var77_126 = ArrayUtils.toDoubleArray(var38_40, this.endian == 19789);
                        var47_70 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_84, var31_32, var32_35, var34_36, 5);
                        var45_55 = new DataBufferDouble(var77_126, var77_126.length);
                        var78_136 = new PixelInterleavedSampleModel(5, var9_9, var10_10, var19_19, var9_9 * var19_19, var52_81);
                        var46_63 = Raster.createWritableRaster(var78_136, var45_55, null);
                    } else {
                        throw new UnsupportedOperationException("Unsupported bit depth: " + var17_17);
lbl550:
                        // 1 sources

                        if (var17_17 < 8) {
                            var77_127 = ArrayUtils.toNBits(var17_17 * var19_19, var38_40, var9_9, true);
                            var47_70 = new DirectColorModel(var17_17 * var19_19, TIFFReader.redMask[var17_17], TIFFReader.greenMask[var17_17], TIFFReader.blueMask[var17_17]);
                            var46_63 = var47_70.createCompatibleWritableRaster(var9_9, var10_10);
                            var46_63.setDataElements(0, 0, var9_9, var10_10, var77_127);
                        } else if (var17_17 == 8) {
                            var47_70 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_84, var31_32, var32_35, var34_36, 0);
                            var45_56 = new DataBufferByte(var38_40, var38_40.length);
                            var46_63 = Raster.createInterleavedRaster(var45_56, var9_9, var10_10, var9_9 * var33_34, var33_34, var52_81, null);
                        } else {
                            var77_128 = ArrayUtils.toNBits(var17_17, var38_40, var19_19 * var9_9, var17_17 % 8 == 0 ? this.endian == 19789 : true);
                            var47_70 = var17_17 <= 16 ? new ComponentColorModel(ColorSpace.getInstance(1000), var53_84, var31_32, var32_35, var34_36, 1) : (var17_17 == 32 ? new Int32ComponentColorModel(ColorSpace.getInstance(1000), var31_32) : new ComponentColorModel(ColorSpace.getInstance(1000), var53_84, var31_32, var32_35, var34_36, 3));
                            var46_63 = var47_70.createCompatibleWritableRaster(var9_9, var10_10);
                            var46_63.setDataElements(0, 0, var9_9, var10_10, var77_128);
                        }
                    }
                }
lbl565:
                // 7 sources

                return new BufferedImage(var47_70, var46_63, false, null);
            }
            case 5: 
            case 6: {
                var44_47 = var19_19 * ((var9_9 * var17_17 + 7) / 8);
                var75_116 = var10_10 * var44_47;
                if (var23_23 == 2) {
                    var44_47 = (var9_9 * var17_17 + 7) / 8;
                }
                var38_40 = new byte[var75_116];
                switch (var17_17) {
                    case 1: {
                        this.rgbColorPalette = var15_15 == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.BLACK_WHITE_PALETTE : TIFFReader.BLACK_WHITE_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                    case 2: {
                        this.rgbColorPalette = var15_15 == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.FOUR_COLOR_PALETTE : TIFFReader.FOUR_COLOR_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                    case 4: {
                        this.rgbColorPalette = var15_15 == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.SIXTEEN_COLOR_PALETTE : TIFFReader.SIXTEEN_COLOR_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                    case 8: {
                        this.rgbColorPalette = var15_15 == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.EIGHT_BIT_COLOR_PALETTE : TIFFReader.EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                }
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var77_129 = 0; var77_129 < var8_8.length; ++var77_129) {
                            var78_137 = var39_41[var77_129];
                            this.randIS.seek(var7_7[var77_129]);
                            this.randIS.readFully(var38_40, var36_38, var78_137);
                            var36_38 += var78_137;
                        }
                        break;
                    }
                    case 6: {
                        var37_39 = new G31DDecoder(var9_9);
                        break;
                    }
                    case 2: {
                        var37_39 = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var37_39 = new DeflateDecoder();
                        break;
                    }
                    case 5: {
                        for (var77_129 = 0; var77_129 < var8_8.length; ++var77_129) {
                            var78_137 = var39_41[var77_129];
                            this.unpackStrip(var38_40, var36_38, var39_41[var77_129], var7_7[var77_129], var8_8[var77_129]);
                            var36_38 += var78_137;
                        }
                        break;
                    }
                }
                if (var37_39 != null) {
                    for (var77_129 = 0; var77_129 < var8_8.length; ++var77_129) {
                        var73_111 = new byte[var8_8[var77_129]];
                        this.randIS.seek(var7_7[var77_129]);
                        this.randIS.readFully(var73_111);
                        var37_39.setInput(var73_111);
                        var78_137 = var37_39.decode(var38_40, var36_38, var39_41[var77_129]);
                        var36_38 += var78_137;
                    }
                }
                if (var17_17 <= 8) {
                    if (var21_21 == 2 && var23_23 == 1) {
                        var38_40 = TIFFReader.applyDePredictor(var19_19, var38_40, var9_9, var10_10);
                    }
                    var45_57 = new DataBufferByte(var38_40, var38_40.length);
                    var47_71 = new IndexColorModel(var17_17, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
                    var46_64 = Raster.createPackedRaster(var45_57, var9_9, var10_10, var17_17, null);
                    if (var19_19 == 2) {
                        if (var15_15 == TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO) {
                            IMGUtils.invertBits(var38_40, 2);
                        }
                        var33_34 = var19_19;
                        var77_130 = new int[]{0, 0, 0, 1};
                        var31_32 = true;
                        var34_36 = 3;
                        var47_71 = new ComponentColorModel(ColorSpace.getInstance(1000), var31_32, var32_35, var34_36, 0);
                        var46_64 = Raster.createInterleavedRaster(var45_57, var9_9, var10_10, var9_9 * var33_34, var33_34, var77_130, null);
                    }
                } else {
                    var77_131 = (short[])ArrayUtils.toNBits(var17_17, var38_40, var19_19 * var9_9, var17_17 % 8 == 0 ? this.endian == 19789 : true);
                    if (var21_21 == 2 && var23_23 == 1) {
                        var77_131 = TIFFReader.applyDePredictor(var19_19, var77_131, var9_9, var10_10);
                    }
                    if (var15_15 == TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO) {
                        IMGUtils.invertBits(var77_131, var19_19);
                    }
                    if (var19_19 == 2) {
                        var31_32 = true;
                        var34_36 = 3;
                    }
                    var47_71 = new ComponentColorModel(ColorSpace.getInstance(1003), var31_32, var32_35, var34_36, 1);
                    var46_64 = var47_71.createCompatibleWritableRaster(var9_9, var10_10);
                    var46_64.setDataElements(0, 0, var9_9, var10_10, var77_131);
                }
                return new BufferedImage(var47_71, var46_64, false, null);
            }
        }
        return null;
    }

    private BufferedImage decodeTiledTiff(IFD iFD) throws Exception {
        TiffField<?> tiffField;
        TiffField<?> tiffField2 = iFD.getField(TiffTag.COMPRESSION);
        short[] sArray = (short[])tiffField2.getData();
        TiffFieldEnum.Compression compression = TiffFieldEnum.Compression.fromValue(sArray[0] & 0xFFFF);
        LOGGER.info("Compression type: {}", (Object)compression.getDescription());
        TiffField<?> tiffField3 = iFD.getField(TiffTag.TILE_OFFSETS);
        if (tiffField3 == null) {
            tiffField3 = iFD.getField(TiffTag.STRIP_OFFSETS);
        }
        if ((tiffField = iFD.getField(TiffTag.TILE_BYTE_COUNTS)) == null) {
            tiffField = iFD.getField(TiffTag.STRIP_BYTE_COUNTS);
        }
        int[] nArray = tiffField3.getDataAsLong();
        int[] nArray2 = tiffField.getDataAsLong();
        int n = iFD.getField(TiffTag.IMAGE_WIDTH).getDataAsLong()[0];
        int n2 = iFD.getField(TiffTag.IMAGE_LENGTH).getDataAsLong()[0];
        LOGGER.info("Image width: {}", (Object)n);
        LOGGER.info("Image height: {}", (Object)n2);
        TiffField<?> tiffField4 = iFD.getField(TiffTag.TILE_WIDTH);
        TiffField<?> tiffField5 = iFD.getField(TiffTag.TILE_LENGTH);
        int n3 = n;
        if (tiffField4 != null) {
            n3 = tiffField4.getDataAsLong()[0];
        }
        int n4 = n2;
        if (tiffField5 != null) {
            n4 = tiffField5.getDataAsLong()[0];
        }
        TiffField<?> tiffField6 = iFD.getField(TiffTag.PHOTOMETRIC_INTERPRETATION);
        int n5 = tiffField6.getDataAsLong()[0];
        TiffFieldEnum.PhotoMetric photoMetric = TiffFieldEnum.PhotoMetric.fromValue(n5);
        LOGGER.info("PhotoMetric: {}", (Object)photoMetric);
        TiffField<?> tiffField7 = iFD.getField(TiffTag.BITS_PER_SAMPLE);
        int n6 = tiffField7.getDataAsLong()[0];
        LOGGER.info("Bits per sample: {}", (Object)n6);
        TiffField<?> tiffField8 = iFD.getField(TiffTag.SAMPLES_PER_PIXEL);
        int n7 = tiffField8.getDataAsLong()[0];
        LOGGER.info("Samples per pixel: {}", (Object)n7);
        TiffField<?> tiffField9 = iFD.getField(TiffTag.PREDICTOR);
        int n8 = 0;
        if (tiffField9 != null) {
            n8 = tiffField9.getDataAsLong()[0];
            LOGGER.info("Predictor: {}", (Object)n8);
        }
        TiffField<?> tiffField10 = iFD.getField(TiffTag.PLANAR_CONFIGURATTION);
        int n9 = 1;
        if (tiffField10 != null) {
            n9 = tiffField10.getDataAsLong()[0];
        }
        TiffFieldEnum.PlanarConfiguration planarConfiguration = TiffFieldEnum.PlanarConfiguration.fromValue(n9);
        LOGGER.info("Planary configuration: {}", (Object)planarConfiguration);
        TiffField<?> tiffField11 = iFD.getField(TiffTag.SAMPLE_FORMAT);
        TiffField<?> tiffField12 = iFD.getField(TiffTag.S_MAX_SAMPLE_VALUE);
        TiffField<?> tiffField13 = iFD.getField(TiffTag.S_MIN_SAMPLE_VALUE);
        boolean bl = false;
        boolean bl2 = false;
        if (tiffField11 != null && tiffField11.getDataAsLong()[0] == 3) {
            double d;
            bl = true;
            double d2 = n6 <= 32 ? 3.4028234663852886E38 : Double.MAX_VALUE;
            double d3 = d = n6 <= 32 ? (double)1.4E-45f : Double.MIN_VALUE;
            if (n6 <= 32 && tiffField12 != null) {
                d2 = ((float[])tiffField12.getData())[0];
            } else if (n6 > 32 && tiffField12 != null) {
                d2 = ((double[])tiffField12.getData())[0];
            }
            if (n6 <= 32 && tiffField13 != null) {
                d = ((float[])tiffField13.getData())[0];
            } else if (n6 > 32 && tiffField13 != null) {
                d = ((double[])tiffField13.getData())[0];
            }
            LOGGER.info("Sample MAX value: {}", (Object)d2);
            LOGGER.info("Sample MIN vlaue: {}", (Object)d);
        }
        int n10 = (n + n3 - 1) / n3;
        int n11 = (n2 + n4 - 1) / n4;
        int n12 = n10 * n11;
        ImageDecoder imageDecoder = null;
        byte[] byArray = null;
        int n13 = (n3 * n6 + 7) / 8 * n7 * n4;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        WritableRaster writableRaster = null;
        DataBuffer dataBuffer = null;
        ColorModel colorModel = null;
        switch (photoMetric) {
            case PALETTE_COLOR: {
                Object object;
                byte[] byArray2;
                int n17;
                short[] sArray2 = (short[])iFD.getField(TiffTag.COLORMAP).getData();
                this.rgbColorPalette = new int[sArray2.length / 3];
                int n18 = 1 << n6;
                int n19 = n18 << 1;
                int n20 = 0;
                for (n17 = 0; n17 < sArray2.length / 3; ++n17) {
                    this.rgbColorPalette[n20++] = 0xFF000000 | (sArray2[n17] & 0xFF00) << 8 | sArray2[n17 + n18] & 0xFF00 | (sArray2[n17 + n19] & 0xFF00) >> 8;
                }
                n17 = n10 * (n3 * n6 + 7) / 8;
                byArray = new byte[n17 * n11 * n4];
                short[] sArray3 = null;
                dataBuffer = new DataBufferByte(byArray, byArray.length);
                colorModel = new IndexColorModel(n6, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
                if (n6 < 8) {
                    writableRaster = Raster.createPackedRaster(dataBuffer, n3 * n10, n4 * n11, n6, null);
                } else {
                    int[] nArray3 = new int[]{0};
                    if (n6 > 8) {
                        sArray3 = new short[byArray.length / 2];
                        dataBuffer = new DataBufferUShort(sArray3, sArray3.length);
                        colorModel = new IndexColorModel(n6, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 1);
                    }
                    writableRaster = Raster.createInterleavedRaster(dataBuffer, n3 * n10, n4 * n11, n3 * n10, 1, nArray3, null);
                }
                switch (compression) {
                    case NONE: {
                        for (int i = 0; i < nArray2.length; ++i) {
                            byArray2 = new byte[nArray2[i]];
                            this.randIS.seek(nArray[i]);
                            this.randIS.readFully(byArray2);
                            if (n6 == 16) {
                                writableRaster.setDataElements(n14, n15, n3, n4, ArrayUtils.toShortArray(byArray2, this.endian == 19789));
                            } else {
                                object = new DataBufferByte(byArray2, byArray2.length);
                                WritableRaster writableRaster2 = Raster.createPackedRaster((DataBuffer)object, n3, n4, n6, null);
                                writableRaster.setDataElements(n14, n15, writableRaster2);
                            }
                            n14 += n3;
                            if (++n16 < n10) continue;
                            n14 = 0;
                            n15 += n4;
                            n16 = 0;
                        }
                        break;
                    }
                    case LZW: {
                        imageDecoder = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case DEFLATE: 
                    case DEFLATE_ADOBE: {
                        imageDecoder = new DeflateDecoder();
                        break;
                    }
                }
                if (imageDecoder != null) {
                    for (int i = 0; i < nArray2.length; ++i) {
                        byArray2 = new byte[nArray2[i]];
                        object = new byte[n13];
                        this.randIS.seek(nArray[i]);
                        this.randIS.readFully(byArray2);
                        imageDecoder.setInput(byArray2);
                        imageDecoder.decode((byte[])object, 0, n13);
                        if (n6 == 16) {
                            writableRaster.setDataElements(n14, n15, n3, n4, ArrayUtils.toShortArray(object, this.endian == 19789));
                        } else {
                            writableRaster.setDataElements(n14, n15, n3, n4, object);
                        }
                        n14 += n3;
                        if (++n16 < n10) continue;
                        n14 = 0;
                        n15 += n4;
                        n16 = 0;
                    }
                }
                return new BufferedImage(colorModel, writableRaster, false, null).getSubimage(0, 0, n, n2);
            }
            case RGB: {
                Object object;
                Object object2;
                int n21;
                int n22;
                int[] nArray4 = new int[n7];
                int[] nArray5 = new int[n7];
                Arrays.fill(nArray5, n6);
                for (n22 = 0; n22 < n7; ++n22) {
                    nArray4[n22] = n22;
                }
                n22 = 0;
                int n23 = 1;
                if (n7 >= 4) {
                    n23 = 3;
                    n22 = 1;
                }
                if (bl) {
                    if (n6 == 64) {
                        colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray5, n22 != 0, false, n23, 5);
                    } else if (n6 >= 16 && n6 <= 32) {
                        colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray5, n22 != 0, false, n23, 4);
                    }
                } else {
                    colorModel = n6 < 8 ? new DirectColorModel(n6 * n7, redMask[n6], greenMask[n6], blueMask[n6]) : (n6 == 16 ? new ComponentColorModel(ColorSpace.getInstance(1000), nArray5, n22 != 0, bl2, n23, 1) : (n6 == 24 ? new ComponentColorModel(ColorSpace.getInstance(1000), nArray5, n22 != 0, bl2, n23, 3) : (n6 == 32 ? new Int32ComponentColorModel(ColorSpace.getInstance(1000), n22 != 0) : (n6 == 64 ? new Int32ComponentColorModel(ColorSpace.getInstance(1000), n22 != 0) : new ComponentColorModel(ColorSpace.getInstance(1000), nArray5, n22 != 0, bl2, n23, 0)))));
                }
                writableRaster = ((ColorModel)colorModel).createCompatibleWritableRaster(n3 * n10, n4 * n11);
                switch (compression) {
                    case NONE: {
                        if (n9 == 1) {
                            for (n21 = 0; n21 < nArray2.length; ++n21) {
                                object2 = new byte[nArray2[n21]];
                                this.randIS.seek(nArray[n21]);
                                this.randIS.readFully((byte[])object2);
                                if (bl) {
                                    object = null;
                                    if (n6 == 64) {
                                        object = ArrayUtils.toDoubleArray(object2, this.endian == 19789);
                                    } else if (n6 == 32) {
                                        object = ArrayUtils.toFloatArray(object2, this.endian == 19789);
                                    } else if (n6 == 24) {
                                        object = ArrayUtils.to24BitFloatArray(object2, this.endian == 19789);
                                    } else if (n6 == 16) {
                                        object = ArrayUtils.to16BitFloatArray(object2, this.endian == 19789);
                                    } else {
                                        throw new UnsupportedOperationException("Unsupported bit depth: " + n6);
                                    }
                                    writableRaster.setDataElements(n14, n15, n3, n4, object);
                                } else if (n6 < 8) {
                                    writableRaster.setDataElements(n14, n15, n3, n4, ArrayUtils.toNBits(n6 * n7, object2, n3, true));
                                } else if (n6 == 8) {
                                    writableRaster.setDataElements(n14, n15, n3, n4, object2);
                                } else if (n6 % 8 == 0) {
                                    object = ArrayUtils.toNBits(n6, object2, n7 * n3, this.endian == 19789);
                                    writableRaster.setDataElements(n14, n15, n3, n4, object);
                                } else {
                                    object = ArrayUtils.toNBits(n6, object2, n7 * n3, true);
                                    writableRaster.setDataElements(n14, n15, n3, n4, object);
                                }
                                n14 += n3;
                                if (++n16 < n10) continue;
                                n14 = 0;
                                n15 += n4;
                                n16 = 0;
                            }
                            break;
                        }
                        byte[][] byArrayArray = new byte[n7][];
                        object2 = null;
                        object = null;
                        int[] nArray6 = new int[]{0, 1, 2};
                        nArray4 = new int[]{0, 0, 0};
                        int n24 = 0;
                        for (int i = 0; i < n12; ++i) {
                            byArrayArray[0] = new byte[nArray2[i]];
                            this.randIS.seek(nArray[i]);
                            this.randIS.readFully(byArrayArray[0]);
                            int n25 = i + n12;
                            byArrayArray[1] = new byte[nArray2[n25]];
                            this.randIS.seek(nArray[n25]);
                            this.randIS.readFully(byArrayArray[1]);
                            int n26 = n25 + n12;
                            byArrayArray[2] = new byte[nArray2[n26]];
                            this.randIS.seek(nArray[n26]);
                            this.randIS.readFully(byArrayArray[2]);
                            if (bl) {
                                int n27;
                                Object object3;
                                if (n6 >= 16 && n6 <= 32) {
                                    object3 = new float[n7][];
                                    if (n6 == 16) {
                                        for (n27 = 0; n27 < n7; ++n27) {
                                            object3[n27] = ArrayUtils.to16BitFloatArray(byArrayArray[n27], this.endian == 19789);
                                        }
                                    } else if (n6 == 24) {
                                        for (n27 = 0; n27 < n7; ++n27) {
                                            object3[n27] = ArrayUtils.to24BitFloatArray(byArrayArray[n27], this.endian == 19789);
                                        }
                                    } else if (n6 == 32) {
                                        for (n27 = 0; n27 < n7; ++n27) {
                                            object3[n27] = ArrayUtils.toFloatArray(byArrayArray[n27], this.endian == 19789);
                                        }
                                    }
                                    object = new DataBufferFloat((float[][])object3, object3[0].length);
                                    n24 = 4;
                                } else if (n6 == 64) {
                                    object3 = new double[n7][];
                                    for (n27 = 0; n27 < n7; ++n27) {
                                        object3[n27] = (float[])ArrayUtils.toDoubleArray(byArrayArray[n27], this.endian == 19789);
                                    }
                                    object = new DataBufferDouble((double[][])object3, object3[0].length);
                                    n24 = 5;
                                } else {
                                    throw new UnsupportedOperationException("Unsupported floating point sample bit depth: " + n6);
                                }
                                object3 = new BandedSampleModel(n24, n3, n4, n3, nArray6, nArray4);
                                object2 = Raster.createWritableRaster((SampleModel)object3, (DataBuffer)object, null);
                            } else {
                                if (n6 == 16) {
                                    object = new DataBufferUShort(new short[][]{ArrayUtils.toShortArray(byArrayArray[0], this.endian == 19789), ArrayUtils.toShortArray(byArrayArray[1], this.endian == 19789), ArrayUtils.toShortArray(byArrayArray[2], this.endian == 19789)}, n3 * n4);
                                } else if (n6 > 16 && n6 <= 32) {
                                    boolean bl3 = n6 % 8 == 0 ? this.endian == 19789 : true;
                                    object = new DataBufferInt(new int[][]{(int[])ArrayUtils.toNBits(n6, byArrayArray[0], n3, bl3), (int[])ArrayUtils.toNBits(n6, byArrayArray[1], n3, bl3), (int[])ArrayUtils.toNBits(n6, byArrayArray[2], n3, bl3)}, n3 * n4);
                                } else {
                                    object = n6 == 64 ? (Object)new DataBufferInt(new int[][]{ArrayUtils.to32BitsLongArray(byArrayArray[0], this.endian == 19789), ArrayUtils.to32BitsLongArray(byArrayArray[1], this.endian == 19789), ArrayUtils.to32BitsLongArray(byArrayArray[2], this.endian == 19789)}, n3 * n4) : (Object)new DataBufferByte(byArrayArray, byArrayArray[0].length);
                                }
                                object2 = Raster.createBandedRaster((DataBuffer)object, n3, n4, n3, nArray6, nArray4, null);
                            }
                            writableRaster.setRect(n14, n15, (Raster)object2);
                            n14 += n3;
                            if (++n16 < n10) continue;
                            n14 = 0;
                            n15 += n4;
                            n16 = 0;
                        }
                        break;
                    }
                    case PACKBITS: {
                        for (int i = 0; i < nArray2.length; ++i) {
                            object2 = new byte[nArray2[i]];
                            this.randIS.seek(nArray[i]);
                            this.randIS.readFully((byte[])object2);
                            object = new byte[n13];
                            Packbits.unpackbits(object2, (byte[])object);
                            if (n6 == 16) {
                                writableRaster.setDataElements(n14, n15, n3, n4, ArrayUtils.toShortArray((byte[])object, this.endian == 19789));
                            } else {
                                writableRaster.setDataElements(n14, n15, n3, n4, object);
                            }
                            n14 += n3;
                            if (++n16 < n10) continue;
                            n14 = 0;
                            n15 += n4;
                            n16 = 0;
                        }
                        break;
                    }
                    case LZW: {
                        imageDecoder = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case DEFLATE: 
                    case DEFLATE_ADOBE: {
                        imageDecoder = new DeflateDecoder();
                        break;
                    }
                }
                if (imageDecoder != null) {
                    for (n21 = 0; n21 < nArray2.length; ++n21) {
                        object2 = new byte[nArray2[n21]];
                        object = new byte[n13];
                        this.randIS.seek(nArray[n21]);
                        this.randIS.readFully((byte[])object2);
                        imageDecoder.setInput((byte[])object2);
                        imageDecoder.decode((byte[])object, 0, n13);
                        if (n6 == 16) {
                            writableRaster.setDataElements(n14, n15, n3, n4, ArrayUtils.toShortArray((byte[])object, this.endian == 19789));
                        } else {
                            writableRaster.setDataElements(n14, n15, n3, n4, object);
                        }
                        n14 += n3;
                        if (++n16 < n10) continue;
                        n14 = 0;
                        n15 += n4;
                        n16 = 0;
                    }
                }
                if (n8 == 2 && n9 == 1 && this.bitsPerPixel == 8) {
                    byArray = TIFFReader.applyDePredictor(n7, byArray, n, n2);
                }
                return new BufferedImage(colorModel, writableRaster, false, null).getSubimage(0, 0, n, n2);
            }
        }
        return null;
    }

    @Override
    public int getFrameCount() {
        return this.frames.size();
    }

    @Override
    public List<BufferedImage> getFrames() {
        return this.frames;
    }

    private boolean readHeader(RandomAccessInputStream randomAccessInputStream) throws IOException {
        this.endian = randomAccessInputStream.readShort();
        if (this.endian == 19789) {
            LOGGER.info("Byte order: Motorola BIG_ENDIAN");
            this.randIS.setReadStrategy(ReadStrategyMM.getInstance());
        } else if (this.endian == 18761) {
            LOGGER.info("Byte order: Intel LITTLE_ENDIAN");
            this.randIS.setReadStrategy(ReadStrategyII.getInstance());
        } else {
            LOGGER.info("Warning: invalid TIFF byte order!");
            return false;
        }
        short s = randomAccessInputStream.readShort();
        if (s != 42) {
            LOGGER.error("Error: invalid tiff identifier");
            return false;
        }
        return true;
    }

    private int readIFD(int n, int n2) throws IOException {
        IFD iFD = new IFD();
        LOGGER.info("IFD {} offset: byte {}", (Object)n, (Object)n2);
        this.randIS.seek(n2);
        int n3 = this.randIS.readShort();
        LOGGER.info("Total number of fields for IFD {}: {}", (Object)n, (Object)n3);
        n2 += 2;
        block9: for (int i = 0; i < n3; ++i) {
            LOGGER.info("TiffField {} =>", (Object)i);
            this.randIS.seek(n2);
            short s = this.randIS.readShort();
            Tag tag = TiffTag.fromShort(s);
            if (tag == TiffTag.UNKNOWN) {
                LOGGER.info("TiffTag: {} [Value: 0x{}] (Unknown)", (Object)tag, (Object)Integer.toHexString(s & 0xFFFF));
            } else {
                LOGGER.info("TiffTag: {}", (Object)tag);
            }
            this.randIS.seek(n2 += 2);
            short s2 = this.randIS.readShort();
            FieldType fieldType = FieldType.fromShort(s2);
            LOGGER.info("Data type: {}", (Object)fieldType);
            this.randIS.seek(n2 += 2);
            int n4 = this.randIS.readInt();
            LOGGER.info("TiffField length: {}", (Object)n4);
            n2 += 4;
            switch (fieldType) {
                case BYTE: 
                case UNDEFINED: {
                    byte[] byArray = new byte[n4];
                    if (n4 <= 4) {
                        this.randIS.seek(n2);
                        this.randIS.readFully(byArray, 0, n4);
                    } else {
                        this.randIS.seek(n2);
                        this.randIS.seek(this.randIS.readInt());
                        this.randIS.readFully(byArray, 0, n4);
                    }
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.byteArrayToHexString(byArray, 0, 10));
                    n2 += 4;
                    iFD.addField(fieldType == FieldType.BYTE ? new ByteField(s, byArray) : new UndefinedField(s, byArray));
                    continue block9;
                }
                case ASCII: {
                    byte[] byArray = new byte[n4];
                    if (n4 <= 4) {
                        this.randIS.seek(n2);
                        this.randIS.readFully(byArray, 0, n4);
                    } else {
                        this.randIS.seek(n2);
                        this.randIS.seek(this.randIS.readInt());
                        this.randIS.readFully(byArray, 0, n4);
                    }
                    if (byArray.length > 0) {
                        LOGGER.info("TiffField value: {}", (Object)new String(byArray, 0, byArray.length - 1).trim());
                    }
                    n2 += 4;
                    iFD.addField(new ASCIIField(s, new String(byArray, 0, byArray.length)));
                    continue block9;
                }
                case SHORT: {
                    int n5;
                    short[] sArray = new short[n4];
                    if (n4 == 1) {
                        this.randIS.seek(n2);
                        sArray[0] = this.randIS.readShort();
                        n2 += 4;
                    } else if (n4 == 2) {
                        this.randIS.seek(n2);
                        sArray[0] = this.randIS.readShort();
                        this.randIS.seek(n2 += 2);
                        sArray[1] = this.randIS.readShort();
                        n2 += 2;
                    } else {
                        this.randIS.seek(n2);
                        int n6 = this.randIS.readInt();
                        n2 += 4;
                        for (n5 = 0; n5 < n4; ++n5) {
                            this.randIS.seek(n6);
                            sArray[n5] = this.randIS.readShort();
                            n6 += 2;
                        }
                    }
                    iFD.addField(new ShortField(s, sArray));
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.shortArrayToString(sArray, 0, 10, true));
                    continue block9;
                }
                case LONG: {
                    int n7;
                    int n5;
                    int[] nArray = new int[n4];
                    if (n4 == 1) {
                        this.randIS.seek(n2);
                        nArray[0] = this.randIS.readInt();
                        n2 += 4;
                    } else {
                        this.randIS.seek(n2);
                        n5 = this.randIS.readInt();
                        n2 += 4;
                        for (n7 = 0; n7 < n4; ++n7) {
                            this.randIS.seek(n5);
                            nArray[n7] = this.randIS.readInt();
                            n5 += 4;
                        }
                    }
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.longArrayToString(nArray, 0, 10, true));
                    iFD.addField(new LongField(s, nArray));
                    continue block9;
                }
                case RATIONAL: {
                    int n5 = 2 * n4;
                    int[] nArray = new int[n5];
                    this.randIS.seek(n2);
                    int n7 = this.randIS.readInt();
                    n2 += 4;
                    for (int j = 0; j < n5; j += 2) {
                        this.randIS.seek(n7);
                        nArray[j] = this.randIS.readInt();
                        this.randIS.seek(n7 += 4);
                        nArray[j + 1] = this.randIS.readInt();
                        n7 += 4;
                    }
                    iFD.addField(new RationalField(s, nArray));
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.rationalArrayToString(nArray, true));
                    continue block9;
                }
                case FLOAT: {
                    int n7;
                    float[] fArray = new float[n4];
                    if (n4 == 1) {
                        this.randIS.seek(n2);
                        fArray[0] = this.randIS.readFloat();
                        n2 += 4;
                    } else {
                        this.randIS.seek(n2);
                        n7 = this.randIS.readInt();
                        n2 += 4;
                        for (int j = 0; j < n4; ++j) {
                            this.randIS.seek(n7);
                            fArray[j] = this.randIS.readFloat();
                            n7 += 4;
                        }
                    }
                    iFD.addField(new FloatField(s, fArray));
                    LOGGER.info("TiffField value: {}", (Object)Arrays.toString(fArray));
                    continue block9;
                }
                case DOUBLE: {
                    double[] dArray = new double[n4];
                    this.randIS.seek(n2);
                    int n7 = this.randIS.readInt();
                    n2 += 4;
                    for (int j = 0; j < n4; ++j) {
                        this.randIS.seek(n7);
                        dArray[j] = this.randIS.readDouble();
                        n7 += 8;
                    }
                    iFD.addField(new DoubleField(s, dArray));
                    LOGGER.info("Field value: {}", (Object)Arrays.toString(dArray));
                    continue block9;
                }
                default: {
                    n2 += 4;
                }
            }
        }
        this.list.add(iFD);
        LOGGER.info("********************************");
        this.randIS.seek(n2);
        return this.randIS.readInt();
    }

    private static byte[] applyDePredictor(int n, byte[] byArray, int n2, int n3) {
        int n4 = n * n2;
        int n5 = n4 - n;
        int n6 = n;
        for (int i = 0; i <= n3 - 1; ++i) {
            for (int j = n6; j <= n5; j += n) {
                for (int k = 0; k < n; ++k) {
                    int n7 = j + k;
                    byArray[n7] = (byte)(byArray[n7] + byArray[j - n + k]);
                }
            }
            n5 += n4;
            n6 += n4;
        }
        return byArray;
    }

    private static short[] applyDePredictor(int n, short[] sArray, int n2, int n3) {
        int n4 = n * n2;
        int n5 = n4 - n;
        int n6 = n;
        for (int i = 0; i <= n3 - 1; ++i) {
            for (int j = n6; j <= n5; j += n) {
                for (int k = 0; k < n; ++k) {
                    int n7 = j + k;
                    sArray[n7] = (short)(sArray[n7] + sArray[j - n + k]);
                }
            }
            n5 += n4;
            n6 += n4;
        }
        return sArray;
    }

    private static byte[] applyDePredictor2(byte[] byArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n + n4 - 1;
        int n6 = n + 1;
        for (int i = n3 - 1; i >= 0; --i) {
            for (int j = n6; j < n5; ++j) {
                int n7 = j;
                byArray[n7] = (byte)(byArray[n7] + byArray[j - 1]);
            }
            n5 += n4;
            n6 += n4;
        }
        return byArray;
    }

    private void unpackStrip(byte[] byArray, int n, int n2, int n3, int n4) throws IOException {
        byte[] byArray2 = new byte[n4];
        this.randIS.seek(n3);
        this.randIS.readFully(byArray2);
        byte[] byArray3 = new byte[n2];
        Packbits.unpackbits(byArray2, byArray3);
        System.arraycopy(byArray3, 0, byArray, n, n2);
    }

    private int upsampling(int n, int n2, int n3, int[] nArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, byte[] byArray, byte[] byArray2, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        for (int i = 1; i <= n2; ++i) {
            int n8 = n6 + n3;
            int n9 = byArray[n8] & 0xFF;
            int n10 = byArray[n8 + 1] & 0xFF;
            for (int j = 0; j < nArray[1]; ++j) {
                int n11 = 0;
                while (n11 < nArray[0]) {
                    int n12 = byArray[n6++] & 0xFF;
                    float f12 = ((float)n12 - f) * f7 / (f2 - f);
                    float f13 = ((float)n9 - f3) * f8 / (f4 - f3);
                    float f14 = ((float)n10 - f5) * f8 / (f6 - f5);
                    float f15 = f14 * (2.0f - 2.0f * f9) + f12;
                    float f16 = f13 * (2.0f - 2.0f * f11) + f12;
                    float f17 = (f12 - f11 * f16 - f9 * f15) / f10;
                    if (f15 < 0.0f) {
                        f15 = 0.0f;
                    }
                    if (f15 > 255.0f) {
                        f15 = 255.0f;
                    }
                    if (f17 < 0.0f) {
                        f17 = 0.0f;
                    }
                    if (f17 > 255.0f) {
                        f17 = 255.0f;
                    }
                    if (f16 < 0.0f) {
                        f16 = 0.0f;
                    }
                    if (f16 > 255.0f) {
                        f16 = 255.0f;
                    }
                    int n13 = n7 + n * n4;
                    int n14 = 3 * n13;
                    byArray2[n14] = (byte)f15;
                    byArray2[n14 + 1] = (byte)f17;
                    byArray2[n14 + 2] = (byte)f16;
                    ++n11;
                    ++n7;
                }
                n7 -= nArray[0];
                ++n;
            }
            n -= nArray[1];
            n6 += 2;
            n7 += nArray[0];
            if (i % n5 != 0) continue;
            n += nArray[1];
            n7 = 0;
        }
        return n;
    }

    static {
        int n;
        redMask = new int[]{0, 4, 48, 448, 3840};
        greenMask = new int[]{0, 2, 12, 56, 240};
        blueMask = new int[]{0, 1, 3, 7, 15};
        BLACK_WHITE_PALETTE = new int[]{-16777216, -1};
        BLACK_WHITE_PALETTE_WHITE_IS_ZERO = new int[]{-1, -16777216};
        FOUR_COLOR_PALETTE = new int[]{-16777216, -12566464, -8355712, -1};
        FOUR_COLOR_PALETTE_WHITE_IS_ZERO = new int[]{-1, -8355712, -12566464, -16777216};
        SIXTEEN_COLOR_PALETTE = new int[]{-16777216, -15658735, -14540254, -13421773, -12303292, -11184811, -10066330, -8947849, -7829368, -6710887, -5592406, -4473925, -3355444, -2236963, -1118482, -1};
        SIXTEEN_COLOR_PALETTE_WHITE_IS_ZERO = new int[]{-1, -1118482, -2236963, -3355444, -4473925, -5592406, -6710887, -7829368, -8947849, -10066330, -11184811, -12303292, -13421773, -14540254, -15658735, -16777216};
        EIGHT_BIT_COLOR_PALETTE = new int[256];
        EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO = new int[256];
        for (n = 0; n < 256; ++n) {
            TIFFReader.EIGHT_BIT_COLOR_PALETTE[n] = 0xFF000000 | n << 16 | n << 8 | n & 0xFF;
        }
        for (n = 0; n < 256; ++n) {
            TIFFReader.EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO[255 - n] = 0xFF000000 | n << 16 | n << 8 | n & 0xFF;
        }
        LOGGER = LoggerFactory.getLogger(TIFFReader.class);
    }
}

