/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.tiff;

import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.Tag;
import com.icafe4j.image.tiff.TiffFieldEnum;
import com.icafe4j.string.StringUtils;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public enum TiffTag implements Tag
{
    NEW_SUBFILE_TYPE("NewSubfileType", 254, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Warning: unknown new subfile type value: " + object;
            switch (n) {
                case 0: {
                    string = "Default value 0";
                    break;
                }
                case 1: {
                    string = "Reduced-resolution image data";
                    break;
                }
                case 2: {
                    string = "A single page of a multi-page image";
                    break;
                }
                case 4: {
                    string = "A transparency mask for another image";
                }
            }
            return string;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    SUBFILE_TYPE("SubfileType", 255, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Unknown subfile type value: " + object;
            switch (n) {
                case 0: {
                    string = "Default value 0";
                    break;
                }
                case 1: {
                    string = "Full-resolution image data";
                    break;
                }
                case 2: {
                    string = "Reduced-resolution image data";
                    break;
                }
                case 3: {
                    string = "A single page of a multi-page image";
                }
            }
            return string;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    IMAGE_WIDTH("ImageWidth", 256, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    IMAGE_LENGTH("ImageLength", 257, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    BITS_PER_SAMPLE("BitsPerSample", 258, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    COMPRESSION("Compression", 259, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            return TiffFieldEnum.Compression.fromValue(((int[])object)[0]).getDescription();
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    PHOTOMETRIC_INTERPRETATION("PhotometricInterpretation", 262, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            return TiffFieldEnum.PhotoMetric.fromValue(((int[])object)[0]).getDescription();
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    THRESHOLDING("Thresholding", 263, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Unknown thresholding value: " + object;
            switch (n) {
                case 1: {
                    string = "No dithering or halftoning has been applied to the image data";
                    break;
                }
                case 2: {
                    string = "An ordered dither or halftone technique has been applied to the image data";
                    break;
                }
                case 3: {
                    string = "A randomized process such as error diffusion has been applied to the image data";
                }
            }
            return string;
        }
    }
    ,
    CELL_WIDTH("CellWidth", 264, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    CELL_LENGTH("CellLength", 265, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    FILL_ORDER("FillOrder", 266, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            String[] stringArray = new String[]{"Msb2Lsb", "Lsb2Msb"};
            int n = ((int[])object)[0];
            if (n != 1 && n != 2) {
                return "Warning: unknown fill order value: " + n;
            }
            return stringArray[n - 1];
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    DOCUMENT_NAME("DocumentName", 269, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    IMAGE_DESCRIPTION("ImageDescription", 270, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    MAKE("Make", 271, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    MODEL("Model", 272, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    STRIP_OFFSETS("StripOffsets", 273, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    ORIENTATION("Orientation", 274, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            String[] stringArray = new String[]{"TopLeft", "TopRight", "BottomRight", "BottomLeft", "LeftTop", "RightTop", "RightBottom", "LeftBottom"};
            int n = ((int[])object)[0];
            if (n >= 1 && n <= 8) {
                return stringArray[n - 1];
            }
            return "Warning: unknown planar configuration value: " + n;
        }
    }
    ,
    SAMPLES_PER_PIXEL("SamplesPerPixel", 277, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    ROWS_PER_STRIP("RowsPerStrip", 278, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    STRIP_BYTE_COUNTS("StripByteCounts", 279, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    MIN_SAMPLE_VALUE("MinSampleValue", 280, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    MAX_SAMPLE_VALUE("MaxSampleValue", 281, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    X_RESOLUTION("XResolution", 282, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of XResolution data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.##");
            return StringUtils.rationalToString(decimalFormat, true, nArray);
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.RATIONAL;
        }
    }
    ,
    Y_RESOLUTION("YResolution", 283, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of YResolution data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.##");
            return StringUtils.rationalToString(decimalFormat, true, nArray);
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.RATIONAL;
        }
    }
    ,
    PLANAR_CONFIGURATTION("PlanarConfiguration", 284, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            return TiffFieldEnum.PlanarConfiguration.fromValue(((int[])object)[0]).getDescription();
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    PAGE_NAME("\tPageName", 285, Attribute.EXTENDED),
    X_POSITION("XPosition", 286, Attribute.EXTENDED),
    Y_POSITION("YPosition", 287, Attribute.EXTENDED),
    FREE_OFFSETS("FreeOffsets", 288, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    FREE_BYTE_COUNTS("FreeByteCounts", 289, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    GRAY_RESPONSE_UNIT("GrayResponseUnit", 290, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            String[] stringArray = new String[]{"Number represents tenths of a unit", "Number represents hundredths of a unit", "Number represents thousandths of a unit", "Number represents ten-thousandths of a unit", "Number represents hundred-thousandths of a unit"};
            int n = ((int[])object)[0];
            if (n >= 1 && n <= 5) {
                return stringArray[n - 1];
            }
            return "Warning: unknown resolution unit value: " + n;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    GRAY_RESPONSE_CURVE("GrayResponseCurve", 291, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    T4_OPTIONS("T4Options", 292, Attribute.EXTENDED){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Warning: unknown T4 options value: " + n;
            switch (n) {
                case 0: {
                    string = "Basic 1-dimensional coding";
                    break;
                }
                case 1: {
                    string = "2-dimensional coding";
                    break;
                }
                case 2: {
                    string = "Uncompressed mode";
                    break;
                }
                case 4: {
                    string = "Fill bits have been added as necessary before EOL codes such that EOL always ends on a byte boundary";
                }
            }
            return string;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    T6_OPTIONS("T6Options", 293, Attribute.EXTENDED){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Warning: unknown T6 options value: " + n;
            switch (n) {
                case 2: {
                    string = "Uncompressed mode";
                    break;
                }
                case 0: {
                    string = "Default value 0";
                }
            }
            return string;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    RESOLUTION_UNIT("ResolutionUnit", 296, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            String[] stringArray = new String[]{"No absolute unit of measurement (Used for images that may have a non-square aspect ratio, but no meaningful absolute dimensions)", "Inch", "Centimeter"};
            int n = ((int[])object)[0];
            if (n != 1 && n != 2 && n != 3) {
                return "Warning: unknown resolution unit value: " + n;
            }
            return stringArray[n - 1];
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    PAGE_NUMBER("PageNumber", 297, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    TRANSFER_FUNCTION("TransferFunction", 301, Attribute.EXTENDED),
    SOFTWARE("Software", 305, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    DATETIME("DateTime", 306, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    ARTIST("Artist", 315, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    HOST_COMPUTER("HostComputer", 316, Attribute.BASELINE),
    PREDICTOR("Predictor", 317, Attribute.EXTENDED){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Unknown predictor value: " + n;
            switch (n) {
                case 1: {
                    string = "No prediction scheme used before coding";
                    break;
                }
                case 2: {
                    string = "Horizontal differencing";
                    break;
                }
                case 3: {
                    string = "Floating point horizontal differencing";
                }
            }
            return string;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    WHITE_POINT("WhitePoint", 318, Attribute.EXTENDED),
    PRIMARY_CHROMATICITIES("PrimaryChromaticities", 319, Attribute.EXTENDED),
    COLORMAP("ColorMap", 320, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    HALTONE_HINTS("HalftoneHints", 321, Attribute.EXTENDED),
    TILE_WIDTH("TileWidth", 322, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    TILE_LENGTH("TileLength", 323, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    TILE_OFFSETS("TileOffsets", 324, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    TILE_BYTE_COUNTS("TileByteCounts", 325, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    BAD_FAX_LINES("BadFaxLines", 326, Attribute.EXTENDED),
    CLEAN_FAX_DATA("CleanFaxData", 327, Attribute.EXTENDED),
    CONSECUTIVE_BAD_FAX_LINES("ConsecutiveBadFaxLines", 328, Attribute.EXTENDED),
    SUB_IFDS("SubIFDs", 330, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    INK_SET("InkSet", 332, Attribute.EXTENDED){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Warning: unknown InkSet value: " + n;
            switch (n) {
                case 1: {
                    string = "CMYK";
                    break;
                }
                case 2: {
                    string = "Not CMYK";
                }
            }
            return string;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    INK_NAMES("InkNames", 333, Attribute.EXTENDED),
    NUMBER_OF_INKS("NumberOfInks", 334, Attribute.EXTENDED),
    DOT_RANGE("DotRange", 336, Attribute.EXTENDED),
    TARGET_PRINTER("TargetPrinter", 337, Attribute.EXTENDED),
    EXTRA_SAMPLES("ExtraSamples", 338, Attribute.BASELINE){

        @Override
        public String getFieldAsString(Object object) {
            String[] stringArray = new String[]{"Unspecified data", "Associated alpha data (with pre-multiplied color)", "Unassociated alpha data"};
            int n = ((int[])object)[0];
            if (n >= 0 && n <= 2) {
                return stringArray[n];
            }
            return "Warning: unknown extra samples value: " + n;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    SAMPLE_FORMAT("SampleFormat", 339, Attribute.EXTENDED){

        @Override
        public String getFieldAsString(Object object) {
            String[] stringArray = new String[]{"Unsigned integer data", "Two's complement signed integer data", "IEEE floating point data", "Undefined data format", "Complex integer data", "Complex IEED floating point data"};
            int n = ((int[])object)[0];
            if (n >= 1 && n <= 6) {
                return stringArray[n - 1];
            }
            return "Warning: unknown sample format value: " + n;
        }
    }
    ,
    S_MIN_SAMPLE_VALUE("SMinSampleValue", 340, Attribute.EXTENDED),
    S_MAX_SAMPLE_VALUE("SMaxSampleValue", 341, Attribute.EXTENDED),
    TRANSFER_RANGE("TransferRange", 342, Attribute.EXTENDED),
    CLIP_PATH("ClipPath", 343, Attribute.EXTENDED),
    X_CLIP_PATH_UNITS("XClipPathUnits", 344, Attribute.EXTENDED),
    Y_CLIP_PATH_UNITS("YClipPathUnits", 345, Attribute.EXTENDED),
    INDEXED("Indexed", 346, Attribute.EXTENDED){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Warning: unknown Indexed value: " + n;
            switch (n) {
                case 0: {
                    string = "Not indexde";
                    break;
                }
                case 1: {
                    string = "Indexed";
                }
            }
            return string;
        }
    }
    ,
    JPEG_TABLES("JPEGTables - optional, for new-style JPEG compression", 347, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.UNDEFINED;
        }
    }
    ,
    OPI_PROXY("OPIProxy", 351, Attribute.EXTENDED),
    GLOBAL_PARAMETERS_IFD("GlobalParametersIFD", 400, Attribute.EXTENDED),
    PROFILE_TYPE("ProfileType", 401, Attribute.EXTENDED){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Warning: unknown profile type value: " + n;
            switch (n) {
                case 0: {
                    string = "Unspecified";
                    break;
                }
                case 1: {
                    string = "Group 3 fax";
                }
            }
            return string;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    FAX_PROFILE("FaxProfile", 402, Attribute.EXTENDED){

        @Override
        public String getFieldAsString(Object object) {
            String[] stringArray = new String[]{"Does not conform to a profile defined for TIFF for facsimile", "Minimal black & white lossless, Profile S", "Extended black & white lossless, Profile F", "Lossless JBIG black & white, Profile J", "Lossy color and grayscale, Profile C", "Lossless color and grayscale, Profile L", "Mixed Raster Content, Profile M"};
            int n = ((int[])object)[0];
            if (n >= 0 && n <= 6) {
                return stringArray[n];
            }
            return "Warning: unknown fax profile value: " + n;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    CODING_METHODS("CodingMethods", 403, Attribute.EXTENDED){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Unknown coding method value: " + n;
            switch (n) {
                case 1: {
                    string = "Unspecified compression";
                    break;
                }
                case 2: {
                    string = "1-dimensional coding, ITU-T Rec. T.4 (MH - Modified Huffman)";
                    break;
                }
                case 4: {
                    string = "2-dimensional coding, ITU-T Rec. T.4 (MR - Modified Read)";
                    break;
                }
                case 8: {
                    string = "2-dimensional coding, ITU-T Rec. T.6 (MMR - Modified MR)";
                    break;
                }
                case 16: {
                    string = "ITU-T Rec. T.82 coding, using ITU-T Rec. T.85 (JBIG)";
                    break;
                }
                case 32: {
                    string = "ITU-T Rec. T.81 (Baseline JPEG)";
                    break;
                }
                case 64: {
                    string = "ITU-T Rec. T.82 coding, using ITU-T Rec. T.43 (JBIG color)";
                }
            }
            return string;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    VERSION_YEAR("VersionYear", 404, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.BYTE;
        }
    }
    ,
    MODE_NUMBER("ModeNumber", 405, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.BYTE;
        }
    }
    ,
    DECODE("Decode", 433, Attribute.EXTENDED),
    DEFAULT_IMAGE_COLOR("DefaultImageColor", 434, Attribute.EXTENDED),
    JPEG_PROC("JPEGProc", 512, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    JPEG_INTERCHANGE_FORMAT("JPEGInterchangeFormat/JpegIFOffset", 513, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    JPEG_INTERCHANGE_FORMAT_LENGTH("JPEGInterchangeFormatLength/JpegIFByteCount", 514, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    JPEG_RESTART_INTERVAL("JPEGRestartInterval", 515, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    JPEG_LOSSLESS_PREDICTORS("JPEGLosslessPredictors", 517, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    JPEG_POINT_TRANSFORMS("JPEGPointTransforms", 518, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    JPEG_Q_TABLES("JPEGQTables", 519, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    JPEG_DC_TABLES("JPEGDCTables", 520, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    JPEG_AC_TABLES("JPEGACTables", 521, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    YCbCr_COEFFICIENTS("YCbCrCoefficients", 529, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.RATIONAL;
        }
    }
    ,
    YCbCr_SUB_SAMPLING("YCbCrSubSampling", 530, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    YCbCr_POSITIONING("YCbCrPositioning", 531, Attribute.EXTENDED){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Warning: unknown YCbCr positioning value: " + n;
            switch (n) {
                case 1: {
                    string = "Centered";
                    break;
                }
                case 2: {
                    string = "Cosited";
                }
            }
            return string;
        }

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    REFERENCE_BLACK_WHITE("ReferenceBlackWhite", 532, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.RATIONAL;
        }
    }
    ,
    STRIP_ROW_COUNTS("StripRowCounts", 559, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    XMP("XMP", 700, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.BYTE;
        }
    }
    ,
    RATING("Rating", 18246, Attribute.PRIVATE),
    RATING_PERCENT("RatingPercent", 18249, Attribute.PRIVATE),
    IMAGE_ID("ImageID", -32755, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    MATTEING("Matteing", -32541, Attribute.PRIVATE),
    COPYRIGHT("Copyright", -32104, Attribute.BASELINE){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    IPTC("RichTiffIPTC", -31813, Attribute.PRIVATE){

        @Override
        public FieldType getFieldType() {
            return FieldType.UNDEFINED;
        }
    }
    ,
    IT8_SITE("IT8Site", -31520, Attribute.PRIVATE),
    IT8_COLOR_SEQUENCE("IT8ColorSequence", -31519, Attribute.PRIVATE),
    IT8_HEADER("IT8Header", -31518, Attribute.PRIVATE),
    IT8_RASTER_PADDING("IT8RasterPadding", -31517, Attribute.PRIVATE),
    IT8_BITS_PER_RUN_LENGTH("IT8BitsPerRunLength", -31516, Attribute.PRIVATE),
    IT8_BITS_PER_EXTENDED_RUN_LENGTH("IT8BitsPerExtendedRunLength", -31515, Attribute.PRIVATE),
    IT8_COLOR_TABLE("IT8ColorTable", -31514, Attribute.PRIVATE),
    IT8_IMAGE_COLOR_INDICATOR("IT8ImageColorIndicator", -31513, Attribute.PRIVATE),
    IT8_BKG_COLOR_INDICATOR("IT8BkgColorIndicator", -31512, Attribute.PRIVATE),
    IT8_IMAGE_COLOR_VALUE("IT8ImageColorValue", -31511, Attribute.PRIVATE),
    IT8_BKG_COLOR_VALUE("IT8BkgColorValue", -31510, Attribute.PRIVATE),
    IT8_PIXEL_INTENSITY_RANGE("IT8PixelIntensityRange", -31509, Attribute.PRIVATE),
    IT8_TRANSPARENCY_INDICATOR("IT8TransparencyIndicator", -31508, Attribute.PRIVATE),
    IT8_COLOR_CHARACTERIZATION("IT8ColorCharacterization", -31507, Attribute.PRIVATE),
    IT8_HC_USAGE("IT8HCUsage", -31506, Attribute.PRIVATE),
    IPTC2("RichTiffIPTC", -31384, Attribute.PRIVATE),
    FRAME_COUNT("FrameCount", -31304, Attribute.PRIVATE),
    PHOTOSHOP("Photoshop", -31159, Attribute.PRIVATE){

        @Override
        public FieldType getFieldType() {
            return FieldType.BYTE;
        }
    }
    ,
    EXIF_SUB_IFD("ExifSubIFD", -30871, Attribute.PRIVATE){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    IMAGE_LAYER("ImageLayer", -30804, Attribute.EXTENDED){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    ICC_PROFILE("ICC Profile", -30861, Attribute.PRIVATE){

        @Override
        public FieldType getFieldType() {
            return FieldType.UNDEFINED;
        }
    }
    ,
    GPS_SUB_IFD("GPSSubIFD", -30683, Attribute.PRIVATE){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    IMAGE_SOURCE_DATA("ImageSourceData", -27812, Attribute.PRIVATE),
    WINDOWS_XP_TITLE("WindowsXPTitle", -25445, Attribute.PRIVATE){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_COMMENT("WindowsXPComment", -25444, Attribute.PRIVATE){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_AUTHOR("WindowsXPAuthor", -25443, Attribute.PRIVATE){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_KEYWORDS("WindowsXPKeywords", -25442, Attribute.PRIVATE){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_SUBJECT("WindowsXPSubject", -25441, Attribute.PRIVATE){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    UNKNOWN("Unknown", -1, Attribute.UNKNOWN);

    private static final Map<Short, TiffTag> tagMap;
    private final String name;
    private final short value;
    private final Attribute attribute;

    public static Tag fromShort(short s) {
        TiffTag tiffTag = tagMap.get(s);
        if (tiffTag == null) {
            return UNKNOWN;
        }
        return tiffTag;
    }

    private TiffTag(String string2, short s, Attribute attribute) {
        this.name = string2;
        this.value = s;
        this.attribute = attribute;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public String getFieldAsString(Object object) {
        return "";
    }

    @Override
    public FieldType getFieldType() {
        return FieldType.UNKNOWN;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return this.name;
        }
        return this.name + " [Value: " + StringUtils.shortToHexStringMM(this.value) + "] (" + (Object)((Object)this.getAttribute()) + ")";
    }

    static {
        tagMap = new HashMap<Short, TiffTag>();
        for (TiffTag tiffTag : TiffTag.values()) {
            tagMap.put(tiffTag.getValue(), tiffTag);
        }
    }

    public static enum Attribute {
        BASELINE,
        EXTENDED,
        PRIVATE,
        UNKNOWN;


        public String toString() {
            return StringUtils.capitalizeFully(this.name());
        }
    }
}

