/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.util;

public class BytePacker {
    private static final short[] mask = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private int bits;
    private int stride;
    int index;
    private byte[] packedBytes;
    int empty_bits;
    int strideCounter = 0;

    public BytePacker(int n, int n2, int n3) {
        this.reset(n, n2, n3);
    }

    public byte[] getPackedBytes() {
        return this.packedBytes;
    }

    public void packByte(int n) {
        if (this.empty_bits >= this.bits) {
            int n2 = this.index;
            this.packedBytes[n2] = (byte)(this.packedBytes[n2] | (n & mask[this.bits]) << this.empty_bits - this.bits);
            this.empty_bits -= this.bits;
        } else {
            int n3 = this.index++;
            this.packedBytes[n3] = (byte)(this.packedBytes[n3] | n >> this.bits - this.empty_bits & mask[this.empty_bits]);
            int n4 = this.index;
            this.packedBytes[n4] = (byte)(this.packedBytes[n4] | (n & mask[this.bits - this.empty_bits]) << 8 - this.bits + this.empty_bits);
            this.empty_bits += 8 - this.bits;
        }
        if (++this.strideCounter % this.stride == 0 || this.empty_bits == 0) {
            ++this.index;
            this.empty_bits = 8;
        }
    }

    public void reset(int n, int n2, int n3) {
        if (n >= 8 || n <= 0) {
            throw new IllegalArgumentException("Invalid value of bits: " + n);
        }
        this.bits = n;
        this.stride = n2;
        int n4 = n * n2;
        int n5 = n3 / n2;
        this.packedBytes = new byte[(n4 + 7 >> 3) * n5];
        this.index = 0;
        this.empty_bits = 8;
        this.strideCounter = 0;
    }
}

