/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.util;

public class DCT {
    private static final float BETA1 = 1.4142135f;
    private static final float BETA2 = 2.6131258f;
    private static final float BETA3 = 1.4142135f;
    private static final float BETA4 = 1.0823922f;
    private static final float BETA5 = 0.76536685f;
    private static final float[] AANscaleFactor = new float[]{1.0f, 1.3870399f, 1.306563f, 1.1758755f, 1.0f, 0.78569496f, 0.5411961f, 0.27589938f};
    private static final float[][] MULTIPLIER = new float[8][8];

    private DCT() {
    }

    public static float[][] forwardDCT(float[][] fArray) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        int n;
        for (n = 0; n < 8; ++n) {
            f19 = fArray[n][0] + fArray[n][7];
            f18 = fArray[n][0] - fArray[n][7];
            f17 = fArray[n][1] + fArray[n][6];
            f16 = fArray[n][1] - fArray[n][6];
            f15 = fArray[n][2] + fArray[n][5];
            f14 = fArray[n][2] - fArray[n][5];
            f13 = fArray[n][3] + fArray[n][4];
            f12 = fArray[n][3] - fArray[n][4];
            f11 = f19 + f13;
            f10 = f19 - f13;
            f9 = f17 + f15;
            f8 = f17 - f15;
            fArray[n][0] = f11 + f9;
            fArray[n][4] = f11 - f9;
            f7 = (f8 + f10) * 0.70710677f;
            fArray[n][2] = f10 + f7;
            fArray[n][6] = f10 - f7;
            f11 = f12 + f14;
            f9 = f14 + f16;
            f8 = f16 + f18;
            f6 = (f11 - f8) * 0.38268343f;
            f5 = 0.5411961f * f11 + f6;
            f4 = 1.306563f * f8 + f6;
            f3 = f9 * 0.70710677f;
            f2 = f18 + f3;
            f = f18 - f3;
            fArray[n][5] = f + f5;
            fArray[n][3] = f - f5;
            fArray[n][1] = f2 + f4;
            fArray[n][7] = f2 - f4;
        }
        for (n = 0; n < 8; ++n) {
            f19 = fArray[0][n] + fArray[7][n];
            f18 = fArray[0][n] - fArray[7][n];
            f17 = fArray[1][n] + fArray[6][n];
            f16 = fArray[1][n] - fArray[6][n];
            f15 = fArray[2][n] + fArray[5][n];
            f14 = fArray[2][n] - fArray[5][n];
            f13 = fArray[3][n] + fArray[4][n];
            f12 = fArray[3][n] - fArray[4][n];
            f11 = f19 + f13;
            f10 = f19 - f13;
            f9 = f17 + f15;
            f8 = f17 - f15;
            fArray[0][n] = (f11 + f9) * MULTIPLIER[0][n];
            fArray[4][n] = (f11 - f9) * MULTIPLIER[4][n];
            f7 = (f8 + f10) * 0.70710677f;
            fArray[2][n] = (f10 + f7) * MULTIPLIER[2][n];
            fArray[6][n] = (f10 - f7) * MULTIPLIER[6][n];
            f11 = f12 + f14;
            f9 = f14 + f16;
            f8 = f16 + f18;
            f6 = (f11 - f8) * 0.38268343f;
            f5 = 0.5411961f * f11 + f6;
            f4 = 1.306563f * f8 + f6;
            f3 = f9 * 0.70710677f;
            f2 = f18 + f3;
            f = f18 - f3;
            fArray[5][n] = (f + f5) * MULTIPLIER[5][n];
            fArray[3][n] = (f - f5) * MULTIPLIER[3][n];
            fArray[1][n] = (f2 + f4) * MULTIPLIER[1][n];
            fArray[7][n] = (f2 - f4) * MULTIPLIER[7][n];
        }
        return fArray;
    }

    public static float[][] inverseDCT(float[][] fArray) {
        int n;
        for (n = 0; n < 8; ++n) {
            DCT.inverseDCT_col(fArray, n * 8);
        }
        for (n = 0; n < 8; ++n) {
            DCT.inverseDCT_row(fArray, n++);
        }
        return fArray;
    }

    private static void inverseDCT_col(float[][] fArray, int n) {
        float f = fArray[0][n] + fArray[4][n];
        float f2 = fArray[0][n] - fArray[4][n];
        float f3 = fArray[2][n] + fArray[6][n];
        float f4 = (fArray[2][n] - fArray[6][n]) * 1.4142135f - f3;
        float f5 = fArray[5][n] - fArray[3][n];
        float f6 = fArray[1][n] + fArray[7][n];
        float f7 = fArray[1][n] - fArray[7][n];
        float f8 = fArray[5][n] + fArray[3][n];
        float f9 = f6 - f8;
        f8 = f6 + f8;
        float f10 = (f5 - f7) * 0.76536685f;
        f5 = -f5 * 2.6131258f + f10;
        f7 = f7 * 1.0823922f - f10;
        f6 = f9 * 1.4142135f;
        float f11 = f + f3;
        float f12 = f - f3;
        float f13 = f2 + f4;
        float f14 = f2 - f4;
        f5 = -(f5 + (f6 -= (f7 -= f8)));
        fArray[0][n] = f11 + f8;
        fArray[7][n] = f11 - f8;
        fArray[1][n] = f13 + f7;
        fArray[6][n] = f13 - f7;
        fArray[2][n] = f14 + f6;
        fArray[5][n] = f14 - f6;
        fArray[3][n] = f12 + f5;
        fArray[4][n] = f12 - f5;
    }

    private static void inverseDCT_row(float[][] fArray, int n) {
        float f = fArray[n][0] + fArray[n][4];
        float f2 = fArray[n][0] - fArray[n][4];
        float f3 = fArray[n][2] + fArray[n][6];
        float f4 = (fArray[n][2] - fArray[n][6]) * 1.4142135f - f3;
        float f5 = fArray[n][5] - fArray[n][3];
        float f6 = fArray[n][1] + fArray[n][7];
        float f7 = fArray[n][1] - fArray[n][7];
        float f8 = fArray[n][5] + fArray[n][3];
        float f9 = f6 - f8;
        f8 = f6 + f8;
        float f10 = (f5 - f7) * 0.76536685f;
        f5 = -f5 * 2.6131258f + f10;
        f7 = f7 * 1.0823922f - f10;
        f6 = f9 * 1.4142135f;
        float f11 = f + f3;
        float f12 = f - f3;
        float f13 = f2 + f4;
        float f14 = f2 - f4;
        f5 = -(f5 + (f6 -= (f7 -= f8)));
        fArray[n][0] = (f11 + f8) * MULTIPLIER[n][0];
        fArray[n][7] = (f11 - f8) * MULTIPLIER[n][7];
        fArray[n][1] = (f13 + f7) * MULTIPLIER[n][1];
        fArray[n][6] = (f13 - f7) * MULTIPLIER[n][6];
        fArray[n][2] = (f14 + f6) * MULTIPLIER[n][2];
        fArray[n][5] = (f14 - f6) * MULTIPLIER[n][5];
        fArray[n][3] = (f12 + f5) * MULTIPLIER[n][3];
        fArray[n][4] = (f12 - f5) * MULTIPLIER[n][4];
    }

    static {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                DCT.MULTIPLIER[i][j] = 1.0f / (AANscaleFactor[i] * AANscaleFactor[j] * 8.0f);
            }
        }
    }
}

