/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.writer;

import com.icafe4j.image.ImageColorType;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.options.ImageOptions;
import com.icafe4j.image.options.PNGOptions;
import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkBuilder;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.image.png.ColorType;
import com.icafe4j.image.png.Filter;
import com.icafe4j.image.png.IDATBuilder;
import com.icafe4j.image.png.IENDBuilder;
import com.icafe4j.image.png.IHDRBuilder;
import com.icafe4j.image.png.PLTEBuilder;
import com.icafe4j.image.png.PNGTweaker;
import com.icafe4j.image.png.TIMEBuilder;
import com.icafe4j.image.png.TRNSBuilder;
import com.icafe4j.image.png.TextBuilder;
import com.icafe4j.image.quant.DitherMethod;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.image.writer.ImageWriter;
import com.icafe4j.io.IOUtils;
import com.icafe4j.util.ArrayUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class PNGWriter
extends ImageWriter {
    boolean isApplyAdaptiveFilter = false;
    int filterType = 0;
    int compressionLevel = 4;
    ImageParam imageParam;
    private List<Chunk> chunks = new ArrayList<Chunk>(10);
    private static final long SIGNATURE = -8552249625308161526L;

    public PNGWriter() {
    }

    public PNGWriter(ImageParam imageParam) {
        super(imageParam);
    }

    private static void apply_adaptive_filter(int[] nArray, byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        int n4 = n - 1;
        int n5 = byArray.length - n3;
        while (n4 >= 0) {
            System.arraycopy(byArray, n5, byArray2, 0, n3);
            Filter.filter_sub(n2, n3, byArray, n5);
            int n6 = PNGWriter.calculateMSAD(byArray, n5, n3);
            nArray[n4] = 1;
            System.arraycopy(byArray, n5, byArray3, 0, n3);
            System.arraycopy(byArray2, 0, byArray, n5, n3);
            Filter.filter_up(n3, byArray, n5);
            int n7 = PNGWriter.calculateMSAD(byArray, n5, n3);
            if (n7 < n6) {
                n6 = n7;
                nArray[n4] = 2;
                System.arraycopy(byArray, n5, byArray3, 0, n3);
            }
            System.arraycopy(byArray2, 0, byArray, n5, n3);
            Filter.filter_average(n2, n3, byArray, n5);
            n7 = PNGWriter.calculateMSAD(byArray, n5, n3);
            if (n7 < n6) {
                n6 = n7;
                nArray[n4] = 3;
                System.arraycopy(byArray, n5, byArray3, 0, n3);
            }
            System.arraycopy(byArray2, 0, byArray, n5, n3);
            Filter.filter_paeth(n2, n3, byArray, n5);
            n7 = PNGWriter.calculateMSAD(byArray, n5, n3);
            if (n7 < n6) {
                n6 = n7;
                nArray[n4] = 4;
                System.arraycopy(byArray, n5, byArray3, 0, n3);
            }
            System.arraycopy(byArray3, 0, byArray, n5, n3);
            --n4;
            n5 -= n3;
        }
    }

    private static void apply_filter(int[] nArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = n - 1;
        int n5 = byArray.length - n3;
        while (n4 >= 0) {
            switch (nArray[n4]) {
                case 0: {
                    break;
                }
                case 1: {
                    Filter.filter_sub(n2, n3, byArray, n5);
                    break;
                }
                case 2: {
                    Filter.filter_up(n3, byArray, n5);
                    break;
                }
                case 3: {
                    Filter.filter_average(n2, n3, byArray, n5);
                    break;
                }
                case 4: {
                    Filter.filter_paeth(n2, n3, byArray, n5);
                    break;
                }
            }
            --n4;
            n5 -= n3;
        }
    }

    private static int calculateMSAD(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n + n2 - 1; i >= n; --i) {
            n3 += byArray[i] > 0 ? byArray[i] : -byArray[i];
        }
        return n3;
    }

    private static int getBytesPerScanLine(int n, int n2, boolean bl) {
        int n3 = bl ? 2 : 1;
        int n4 = n2 * n3;
        switch (n) {
            case 1: {
                n4 = (n2 >>> 3) + (n2 % 8 == 0 ? 0 : 1);
                break;
            }
            case 2: {
                n4 = (n2 >>> 2) + (n2 % 4 == 0 ? 0 : 1);
                break;
            }
            case 4: {
                n4 = (n2 >>> 1) + (n2 % 2 == 0 ? 0 : 1);
                break;
            }
        }
        return n4;
    }

    private void addTextChunks(List<Chunk> list) {
        TextBuilder textBuilder = new TextBuilder(ChunkType.TEXT);
        textBuilder.keyword("Software").text("ICAFE - https://github.com/dragon66/icafe");
        list.add(textBuilder.build());
    }

    private void addTimeChunk(List<Chunk> list) {
        TIMEBuilder tIMEBuilder = new TIMEBuilder();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        tIMEBuilder.calendar(calendar);
        list.add(tIMEBuilder.build());
    }

    @Override
    public ImageType getImageType() {
        return ImageType.PNG;
    }

    private void reset() {
        this.chunks.clear();
        this.isApplyAdaptiveFilter = false;
        this.filterType = 0;
        this.compressionLevel = 4;
    }

    @Override
    protected void write(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        boolean bl;
        IOUtils.writeLongMM(outputStream, -8552249625308161526L);
        this.reset();
        this.addTextChunks(this.chunks);
        this.addTimeChunk(this.chunks);
        this.imageParam = this.getImageParam();
        ImageOptions imageOptions = this.imageParam.getImageOptions();
        if (imageOptions instanceof PNGOptions) {
            PNGOptions pNGOptions = (PNGOptions)imageOptions;
            this.isApplyAdaptiveFilter = pNGOptions.isApplyAdaptiveFilter();
            this.filterType = pNGOptions.getFilterType();
            this.compressionLevel = pNGOptions.getCompressionLevel();
        }
        boolean bl2 = bl = !this.imageParam.hasAlpha();
        if (this.imageParam.getColorType() == ImageColorType.INDEXED) {
            this.writeIndexed(nArray, n, n2, outputStream);
        } else if (this.imageParam.getColorType() == ImageColorType.GRAY_SCALE) {
            if (bl) {
                this.writeGrayScale(IMGUtils.rgb2grayscale(nArray), n, n2, false, outputStream);
            } else {
                this.writeGrayScale(IMGUtils.rgb2grayscaleA(nArray), n, n2, true, outputStream);
            }
        } else {
            this.writeRGB(nArray, n, n2, outputStream);
        }
        new IENDBuilder().build().write(outputStream);
    }

    private void writeGrayScale(byte[] byArray, int n, int n2, boolean bl, OutputStream outputStream) throws Exception {
        byte[] byArray2;
        int n3;
        int n4;
        IHDRBuilder iHDRBuilder = new IHDRBuilder().width(n).height(n2).compressionMethod(0).filterMethod(0).interlaceMethod(0);
        if (bl) {
            iHDRBuilder.colorType(ColorType.GRAY_SCALE_WITH_ALPHA);
        } else {
            iHDRBuilder.colorType(ColorType.GRAY_SCALE);
        }
        int n5 = 8;
        if (!bl) {
            n5 = IMGUtils.getBitDepth(byArray, false);
            switch (n5) {
                case 3: {
                    n5 = 4;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n5 = 8;
                    break;
                }
            }
        }
        if (n5 != 8) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(byArray[i] << n5 >> 8);
            }
            byArray = ArrayUtils.packByteArray(byArray, n, 0, n5, n * n2);
        }
        this.chunks.add(iHDRBuilder.bitDepth(n5).build());
        if (!bl && this.imageParam.isTransparent()) {
            TRNSBuilder tRNSBuilder = new TRNSBuilder(0);
            n4 = this.imageParam.getTransparentColor();
            n3 = (byte)((double)(n4 >> 16 & 0xFF) * 0.2126 + (double)(n4 >> 8 & 0xFF) * 0.7152 + (double)(n4 & 0xFF) * 0.0722);
            byArray2 = new byte[]{0, (byte)(n3 << n5 >> 8)};
            this.chunks.add(tRNSBuilder.alpha(byArray2).build());
        }
        PNGTweaker.serializeChunks(this.chunks, outputStream);
        int[] nArray = new int[n2];
        Arrays.fill(nArray, this.filterType);
        n4 = bl ? 2 : 1;
        n3 = PNGWriter.getBytesPerScanLine(n5, n, bl);
        if (n5 == 8) {
            if (this.isApplyAdaptiveFilter) {
                PNGWriter.apply_adaptive_filter(nArray, byArray, n2, n4, n3);
            } else if (this.filterType != 0) {
                PNGWriter.apply_filter(nArray, byArray, n2, n4, n3);
            }
        }
        byArray2 = new byte[n3 + 1];
        IDATBuilder iDATBuilder = new IDATBuilder(this.compressionLevel);
        int n6 = n4 * n * n2 / 5;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n8 < n2) {
            byArray2 = new byte[n3 + 1];
            byArray2[0] = (byte)nArray[n8];
            System.arraycopy(byArray, n9, byArray2, 1, n3);
            iDATBuilder.data(byArray2);
            if ((n7 += n3) > n6) {
                Chunk chunk = iDATBuilder.build();
                if (chunk.getData().length > 0) {
                    chunk.write(outputStream);
                }
                n7 = 0;
            }
            ++n8;
            n9 += n3;
        }
        iDATBuilder.setFinish(true);
        Chunk chunk = iDATBuilder.build();
        if (chunk.getData().length > 0) {
            chunk.write(outputStream);
        }
    }

    private void writeIndexed(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        Object object;
        Object object2;
        ImageParam imageParam = this.getImageParam();
        int[] nArray2 = new int[n2];
        int n3 = n * 1;
        byte[] byArray = new byte[n2 * n3];
        int[] nArray3 = new int[256];
        int[] nArray4 = IMGUtils.checkColorDepth(nArray, byArray, nArray3);
        int n4 = nArray4[0];
        if (nArray4[0] > 8) {
            n4 = 8;
            nArray4 = imageParam.isApplyDither() ? (imageParam.getDitherMethod() == DitherMethod.FLOYD_STEINBERG ? IMGUtils.reduceColorsDiffusionDither(imageParam.getQuantMethod(), nArray, n, n2, n4, byArray, nArray3) : IMGUtils.reduceColorsOrderedDither(imageParam.getQuantMethod(), nArray, n, n2, n4, byArray, nArray3, imageParam.getDitherMatrix())) : IMGUtils.reduceColors(imageParam.getQuantMethod(), nArray, n4, byArray, nArray3);
        }
        switch (n4) {
            case 3: {
                n4 = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n4 = 8;
                break;
            }
        }
        n3 = PNGWriter.getBytesPerScanLine(n4, n, false);
        this.chunks.add(new IHDRBuilder().width(n).height(n2).bitDepth(n4).colorType(ColorType.INDEX_COLOR).compressionMethod(0).filterMethod(0).interlaceMethod(0).build());
        int n5 = 1 << n4;
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        byte[] byArray4 = new byte[n5];
        for (int i = 0; i < n5; ++i) {
            byArray2[i] = (byte)(nArray3[i] >> 16);
            byArray3[i] = (byte)(nArray3[i] >> 8);
            byArray4[i] = (byte)nArray3[i];
        }
        PLTEBuilder pLTEBuilder = new PLTEBuilder();
        pLTEBuilder.redMap(byArray2).greenMap(byArray3).blueMap(byArray4);
        this.chunks.add(pLTEBuilder.build());
        if (nArray4[1] >= 0) {
            object2 = new TRNSBuilder(3);
            object = new byte[n5];
            Arrays.fill((byte[])object, (byte)-1);
            object[nArray4[1]] = 0;
            this.chunks.add(((TRNSBuilder)object2).alpha((byte[])object).build());
        }
        PNGTweaker.serializeChunks(this.chunks, outputStream);
        Arrays.fill(nArray2, this.filterType);
        if (n4 == 8) {
            if (this.isApplyAdaptiveFilter) {
                PNGWriter.apply_adaptive_filter(nArray2, byArray, n2, 1, n3);
            } else if (this.filterType != 0) {
                PNGWriter.apply_filter(nArray2, byArray, n2, 1, n3);
            }
        }
        object2 = new byte[n3 + 1];
        object = new IDATBuilder(this.compressionLevel);
        int n6 = n * n2 / 5;
        int n7 = 0;
        if (n4 != 8) {
            byArray = ArrayUtils.packByteArray(byArray, n, 0, n4, n * n2);
        }
        int n8 = 0;
        int n9 = 0;
        while (n8 < n2) {
            object2 = new byte[n3 + 1];
            object2[0] = (byte)nArray2[n8];
            System.arraycopy(byArray, n9, object2, 1, n3);
            ((IDATBuilder)object).data((byte[])object2);
            if ((n7 += n3) > n6) {
                Chunk chunk = ((ChunkBuilder)object).build();
                if (chunk.getData().length > 0) {
                    chunk.write(outputStream);
                }
                n7 = 0;
            }
            ++n8;
            n9 += n3;
        }
        ((IDATBuilder)object).setFinish(true);
        Chunk chunk = ((ChunkBuilder)object).build();
        if (chunk.getData().length > 0) {
            chunk.write(outputStream);
        }
    }

    private void writeRGB(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        int n3;
        int n4;
        boolean bl = !this.imageParam.hasAlpha();
        IHDRBuilder iHDRBuilder = new IHDRBuilder().width(n).height(n2).bitDepth(8).compressionMethod(0).filterMethod(0).interlaceMethod(0);
        if (bl) {
            iHDRBuilder.colorType(ColorType.TRUE_COLOR);
        } else {
            iHDRBuilder.colorType(ColorType.TRUE_COLOR_WITH_ALPHA);
        }
        this.chunks.add(iHDRBuilder.build());
        int[] nArray2 = new int[n2];
        int n5 = bl ? 3 : 4;
        int n6 = n * n5;
        int n7 = n * n2;
        byte[] byArray = new byte[n2 * n6];
        if (this.filterType == 0) {
            this.filterType = 4;
        }
        Arrays.fill(nArray2, this.filterType);
        if (bl) {
            n4 = 0;
            for (n3 = 0; n3 < n7; ++n3) {
                byArray[n4++] = (byte)(nArray[n3] >> 16 & 0xFF);
                byArray[n4++] = (byte)(nArray[n3] >> 8 & 0xFF);
                byArray[n4++] = (byte)(nArray[n3] & 0xFF);
            }
        } else {
            n4 = 0;
            for (n3 = 0; n3 < n7; ++n3) {
                byArray[n4++] = (byte)(nArray[n3] >> 16 & 0xFF);
                byArray[n4++] = (byte)(nArray[n3] >> 8 & 0xFF);
                byArray[n4++] = (byte)(nArray[n3] & 0xFF);
                byArray[n4++] = (byte)(nArray[n3] >> 24 & 0xFF);
            }
        }
        if (bl && this.imageParam.isTransparent()) {
            TRNSBuilder tRNSBuilder = new TRNSBuilder(2);
            n4 = this.imageParam.getTransparentColor();
            byte[] byArray2 = new byte[]{0, (byte)(n4 >>> 16), 0, (byte)(n4 >>> 8), 0, (byte)(n4 >>> 0)};
            this.chunks.add(tRNSBuilder.alpha(byArray2).build());
        }
        PNGTweaker.serializeChunks(this.chunks, outputStream);
        if (this.isApplyAdaptiveFilter) {
            PNGWriter.apply_adaptive_filter(nArray2, byArray, n2, n5, n6);
        } else {
            PNGWriter.apply_filter(nArray2, byArray, n2, n5, n6);
        }
        byte[] byArray3 = new byte[n6 + 1];
        IDATBuilder iDATBuilder = new IDATBuilder(this.compressionLevel);
        int n8 = n5 * n * n2 / 5;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n10 < n2) {
            byArray3 = new byte[n6 + 1];
            byArray3[0] = (byte)nArray2[n10];
            System.arraycopy(byArray, n11, byArray3, 1, n6);
            iDATBuilder.data(byArray3);
            if ((n9 += n6) > n8) {
                Chunk chunk = iDATBuilder.build();
                if (chunk.getData().length > 0) {
                    chunk.write(outputStream);
                }
                n9 = 0;
            }
            ++n10;
            n11 += n6;
        }
        iDATBuilder.setFinish(true);
        Chunk chunk = iDATBuilder.build();
        if (chunk.getData().length > 0) {
            chunk.write(outputStream);
        }
    }
}

