/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.string;

import com.icafe4j.util.ArrayUtils;

public final class Base64 {
    private static final char[] base64Map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private static byte[] toUTF8ByteArray(String string) {
        byte[] byArray = new byte[3 * string.length()];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080' && c <= '\u07ff') {
                byArray[n++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n++] = (byte)(0x80 | c & 0x3F);
                n2 += 2;
                continue;
            }
            if (c >= '\u0800' && c <= '\uffff') {
                byArray[n++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n++] = (byte)(0x80 | c & 0x3F);
                n2 += 3;
                continue;
            }
            if (c >= '\u0000' && c <= '\u007f') {
                byArray[n++] = (byte)(0 | c & 0x7F);
                ++n2;
                continue;
            }
            throw new RuntimeException("Unsupported encoding character length!\n");
        }
        return ArrayUtils.subArray(byArray, 0, n2);
    }

    public static String encode(String string) {
        return Base64.encode(Base64.toUTF8ByteArray(string));
    }

    public static String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        if (byArray.length == 0) {
            return "";
        }
        switch (byArray.length % 3) {
            case 1: {
                string = string + base64Map[byArray[byArray.length - 1] >>> 2 & 0x3F];
                string = string + base64Map[byArray[byArray.length - 1] << 4 & 0x3F];
                string = string + "==";
                break;
            }
            case 2: {
                string = string + base64Map[byArray[byArray.length - 2] >>> 2 & 0x3F];
                string = string + base64Map[byArray[byArray.length - 2] << 4 & 0x3F | byArray[byArray.length - 1] >>> 4 & 0x3F];
                string = string + base64Map[byArray[byArray.length - 1] << 2 & 0x3F];
                string = string + "=";
                break;
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length - byArray.length % 3) {
            n = byArray[n3++] << 16 & 0xFF0000 | byArray[n3++] << 8 & 0xFF00 | byArray[n3++] & 0xFF;
            n2 = n >> 18 & 0x3F;
            stringBuffer.append(base64Map[n2]);
            if (stringBuffer.length() % 76 == 0) {
                stringBuffer.append('\n');
            }
            n2 = n >> 12 & 0x3F;
            stringBuffer.append(base64Map[n2]);
            if (stringBuffer.length() % 76 == 0) {
                stringBuffer.append('\n');
            }
            n2 = n >> 6 & 0x3F;
            stringBuffer.append(base64Map[n2]);
            if (stringBuffer.length() % 76 == 0) {
                stringBuffer.append('\n');
            }
            n2 = n & 0x3F;
            stringBuffer.append(base64Map[n2]);
            if (stringBuffer.length() % 76 != 0) continue;
            stringBuffer.append('\n');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String decode(String string) throws Exception {
        return new String(Base64.decodeToByteArray(string), "UTF-8");
    }

    public static byte[] decodeToByteArray(String string) throws Exception {
        if (string.length() == 0) {
            return null;
        }
        byte[] byArray = string.getBytes("iso-8859-1");
        byte[] byArray2 = new byte[byArray.length * 3 / 4];
        byte[] byArray3 = new byte[4];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 65 && byArray[i] < 91) {
                byArray3[n++] = (byte)(byArray[i] - 65);
            } else if (byArray[i] >= 97 && byArray[i] < 123) {
                byArray3[n++] = (byte)(byArray[i] - 71);
            } else if (byArray[i] >= 48 && byArray[i] < 58) {
                byArray3[n++] = (byte)(byArray[i] + 4);
            } else if (byArray[i] == 43) {
                byArray3[n++] = 62;
            } else if (byArray[i] == 47) {
                byArray3[n++] = 63;
            } else if (byArray[i] == 61) {
                byArray3[n++] = 0;
                ++n4;
            } else {
                if (byArray[i] == 10 || byArray[i] == 13 || byArray[i] == 32 || byArray[i] == 9) continue;
                throw new RuntimeException("Illegal character found in encoded string!");
            }
            if (n != 4) continue;
            int n5 = byArray3[0] << 18 | byArray3[1] << 12 | byArray3[2] << 6 | byArray3[3];
            byArray2[n2++] = (byte)(n5 >> 16);
            byArray2[n2++] = (byte)(n5 >> 8 & 0xFF);
            byArray2[n2++] = (byte)(n5 & 0xFF);
            n3 += 3;
            n = 0;
        }
        return ArrayUtils.subArray(byArray2, 0, n3 - n4);
    }
}

