/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.test;

import com.icafe4j.image.ImageColorType;
import com.icafe4j.image.ImageIO;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.options.ImageOptions;
import com.icafe4j.image.options.JPEGOptions;
import com.icafe4j.image.options.PNGOptions;
import com.icafe4j.image.options.TIFFOptions;
import com.icafe4j.image.quant.DitherMethod;
import com.icafe4j.image.quant.QuantMethod;
import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.image.tiff.TiffFieldEnum;
import com.icafe4j.io.ByteOrder;
import com.icafe4j.io.PeekHeadInputStream;
import com.icafe4j.test.TestBase;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class TestImageReader
extends TestBase {
    public static void main(String[] stringArray) throws Exception {
        new TestImageReader().test(stringArray);
    }

    @Override
    public void test(String ... stringArray) throws Exception {
        Object object;
        long l = System.currentTimeMillis();
        FileInputStream fileInputStream = new FileInputStream(new File(stringArray[0]));
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(fileInputStream, 4);
        ImageReader imageReader = ImageIO.getReader(peekHeadInputStream);
        BufferedImage bufferedImage = imageReader.read(peekHeadInputStream);
        peekHeadInputStream.close();
        if (bufferedImage == null) {
            this.logger.error("Failed reading image!");
            return;
        }
        this.logger.info("Total frames read: {}", (Object)imageReader.getFrameCount());
        this.logger.info("Color model: {}", (Object)bufferedImage.getColorModel());
        this.logger.info("Raster: {}", (Object)bufferedImage.getRaster());
        this.logger.info("Sample model: {}", (Object)bufferedImage.getSampleModel());
        long l2 = System.currentTimeMillis();
        this.logger.info("decoding time {}ms", (Object)(l2 - l));
        final JFrame jFrame = new JFrame("Image Reader");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
                System.exit(0);
            }
        });
        ImageType imageType = ImageType.TIFF;
        FileOutputStream fileOutputStream = new FileOutputStream("NEW." + imageType.getExtension());
        ImageParam.ImageParamBuilder imageParamBuilder = ImageParam.getBuilder();
        switch (imageType) {
            case TIFF: {
                object = new TIFFOptions();
                ((TIFFOptions)object).setByteOrder(ByteOrder.LITTLE_ENDIAN);
                ((TIFFOptions)object).setApplyPredictor(true);
                ((TIFFOptions)object).setTiffCompression(TiffFieldEnum.Compression.LZW);
                ((TIFFOptions)object).setJPEGQuality(60);
                ((TIFFOptions)object).setPhotoMetric(TiffFieldEnum.PhotoMetric.SEPARATED);
                ((TIFFOptions)object).setWriteICCProfile(true);
                ((TIFFOptions)object).setDeflateCompressionLevel(6);
                ((TIFFOptions)object).setXResolution(96);
                ((TIFFOptions)object).setYResolution(96);
                imageParamBuilder.imageOptions((ImageOptions)object);
                break;
            }
            case PNG: {
                PNGOptions pNGOptions = new PNGOptions();
                pNGOptions.setApplyAdaptiveFilter(false);
                pNGOptions.setCompressionLevel(6);
                pNGOptions.setFilterType(0);
                imageParamBuilder.imageOptions(pNGOptions);
                break;
            }
            case JPG: {
                JPEGOptions jPEGOptions = new JPEGOptions();
                jPEGOptions.setQuality(90);
                jPEGOptions.setColorSpace(JPEGOptions.COLOR_SPACE_YCbCr);
                jPEGOptions.setWriteICCProfile(true);
                imageParamBuilder.imageOptions(jPEGOptions);
                break;
            }
        }
        l = System.currentTimeMillis();
        ImageIO.write(bufferedImage, fileOutputStream, imageType, imageParamBuilder.quantMethod(QuantMethod.WU_QUANT).colorType(ImageColorType.INDEXED).applyDither(true).ditherMethod(DitherMethod.FLOYD_STEINBERG).hasAlpha(true).build());
        l2 = System.currentTimeMillis();
        fileOutputStream.close();
        this.logger.info("{} writer (encoding time {}ms)", (Object)imageType, (Object)(l2 - l));
        object = new JLabel(new ImageIcon(bufferedImage));
        jFrame.getContentPane().add(new JScrollPane((Component)object));
        jFrame.setSize(400, 400);
        jFrame.setVisible(true);
    }
}

