/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.test;

import com.icafe4j.image.jpeg.JPEGTweaker;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.exif.Exif;
import com.icafe4j.image.meta.exif.ExifTag;
import com.icafe4j.image.meta.icc.ICCProfile;
import com.icafe4j.image.meta.jpeg.JpegExif;
import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.test.TestBase;
import java.awt.color.ICC_Profile;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TestJPEGTweaker
extends TestBase {
    public static void main(String[] stringArray) throws Exception {
        new TestJPEGTweaker().test(stringArray);
    }

    @Override
    public void test(String ... stringArray) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        byte[] byArray = JPEGTweaker.extractICCProfile(fileInputStream);
        ICCProfile.showProfile(byArray);
        fileInputStream.close();
        fileInputStream = new FileInputStream(stringArray[1]);
        FileOutputStream fileOutputStream = new FileOutputStream("icc_profile_inserted.jpg");
        ICC_Profile iCC_Profile = IMGUtils.getICCProfile("/resources/CMYK Profiles/USWebCoatedSWOP.icc");
        JPEGTweaker.insertICCProfile((InputStream)fileInputStream, (OutputStream)fileOutputStream, iCC_Profile);
        fileInputStream.close();
        fileOutputStream.close();
        fileInputStream = new FileInputStream(stringArray[2]);
        JPEGTweaker.extractThumbnails(fileInputStream, "thumbnail");
        fileInputStream.close();
        fileInputStream = new FileInputStream(stringArray[2]);
        fileOutputStream = new FileOutputStream("metadata_removed.jpg");
        JPEGTweaker.removeMetadata(fileInputStream, fileOutputStream, MetadataType.XMP, MetadataType.EXIF, MetadataType.IPTC, MetadataType.ICC_PROFILE);
        fileInputStream.close();
        fileOutputStream.close();
        fileInputStream = new FileInputStream(stringArray[0]);
        fileOutputStream = new FileOutputStream("exif_inserted.jpg");
        JPEGTweaker.insertExif(fileInputStream, fileOutputStream, TestJPEGTweaker.populateExif(), true);
        fileInputStream.close();
        fileOutputStream.close();
    }

    private static Exif populateExif() throws Exception {
        JpegExif jpegExif = new JpegExif();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        jpegExif.addExifField(ExifTag.EXPOSURE_TIME, FieldType.RATIONAL, new int[]{10, 600});
        jpegExif.addExifField(ExifTag.FNUMBER, FieldType.RATIONAL, new int[]{49, 10});
        jpegExif.addExifField(ExifTag.ISO_SPEED_RATINGS, FieldType.SHORT, new short[]{273});
        jpegExif.addExifField(ExifTag.EXIF_VERSION, FieldType.UNDEFINED, new byte[]{48, 50, 50, 48});
        jpegExif.addExifField(ExifTag.DATE_TIME_ORIGINAL, FieldType.ASCII, simpleDateFormat.format(new Date()));
        jpegExif.addExifField(ExifTag.DATE_TIME_DIGITIZED, FieldType.ASCII, simpleDateFormat.format(new Date()));
        jpegExif.addExifField(ExifTag.FOCAL_LENGTH, FieldType.RATIONAL, new int[]{240, 10});
        jpegExif.setThumbnail(null);
        return jpegExif;
    }
}

