/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.test;

import com.icafe4j.image.jpeg.JPEGTweaker;
import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.adobe.IPTC_NAA;
import com.icafe4j.image.meta.adobe._8BIM;
import com.icafe4j.image.meta.exif.Exif;
import com.icafe4j.image.meta.exif.ExifTag;
import com.icafe4j.image.meta.image.Comments;
import com.icafe4j.image.meta.iptc.IPTC;
import com.icafe4j.image.meta.iptc.IPTCApplicationTag;
import com.icafe4j.image.meta.iptc.IPTCDataSet;
import com.icafe4j.image.meta.jpeg.JFIF;
import com.icafe4j.image.meta.jpeg.JpegExif;
import com.icafe4j.image.meta.jpeg.JpegXMP;
import com.icafe4j.image.meta.tiff.TiffExif;
import com.icafe4j.image.meta.xmp.XMP;
import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.string.XMLUtils;
import com.icafe4j.test.TestBase;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class TestMetadata
extends TestBase {
    public static void main(String[] stringArray) throws Exception {
        new TestMetadata().test(stringArray);
    }

    @Override
    public void test(String ... stringArray) throws Exception {
        Object object;
        Map<MetadataType, Metadata> map = Metadata.readMetadata(stringArray[0]);
        this.logger.info("Start of metadata information:");
        this.logger.info("Total number of metadata entries: {}", (Object)map.size());
        int n = 0;
        for (Map.Entry<MetadataType, Metadata> object22 : map.entrySet()) {
            this.logger.info("Metadata entry {} - {}", (Object)n, (Object)object22.getKey());
            object22.getValue().showMetadata();
            ++n;
            this.logger.info("-----------------------------------------");
        }
        this.logger.info("End of metadata information.");
        Object object3 = null;
        Object var5_6 = null;
        if (map.get((Object)MetadataType.XMP) != null) {
            object = (XMP)map.get((Object)MetadataType.XMP);
            object3 = new FileInputStream("images/1.jpg");
            FileOutputStream fileOutputStream = new FileOutputStream("1-xmp-inserted.jpg");
            JpegXMP jpegXMP = null;
            Document document = ((XMP)object).getMergedDocument();
            jpegXMP = new JpegXMP(XMLUtils.serializeToByteArray(document));
            Metadata.insertXMP((InputStream)object3, (OutputStream)fileOutputStream, jpegXMP);
            ((FileInputStream)object3).close();
            fileOutputStream.close();
        }
        Metadata.extractThumbnails("images/iptc-envelope.tif", "iptc-envelope");
        object3 = new FileInputStream("images/iptc-envelope.tif");
        FileOutputStream fileOutputStream = new FileOutputStream("iptc-envelope-iptc-inserted.tif");
        Metadata.insertIPTC((InputStream)object3, fileOutputStream, TestMetadata.createIPTCDataSet(), true);
        ((FileInputStream)object3).close();
        fileOutputStream.close();
        object3 = new FileInputStream("images/wizard.jpg");
        FileOutputStream fileOutputStream2 = new FileOutputStream("wizard-iptc-inserted.jpg");
        Metadata.insertIPTC((InputStream)object3, fileOutputStream2, TestMetadata.createIPTCDataSet(), true);
        ((FileInputStream)object3).close();
        fileOutputStream2.close();
        object3 = new FileInputStream("images/1.jpg");
        FileOutputStream fileOutputStream3 = new FileOutputStream("1-irbthumbnail-inserted.jpg");
        Metadata.insertIRBThumbnail((InputStream)object3, fileOutputStream3, TestMetadata.createThumbnail("images/1.jpg"));
        ((FileInputStream)object3).close();
        fileOutputStream3.close();
        object3 = new FileInputStream("images/f1.tif");
        FileOutputStream fileOutputStream4 = new FileOutputStream("f1-irbthumbnail-inserted.tif");
        Metadata.insertIRBThumbnail((InputStream)object3, fileOutputStream4, TestMetadata.createThumbnail("images/f1.tif"));
        ((FileInputStream)object3).close();
        fileOutputStream4.close();
        object3 = new FileInputStream("images/exif.tif");
        FileOutputStream fileOutputStream5 = new FileOutputStream("exif-exif-inserted.tif");
        Metadata.insertExif((InputStream)object3, fileOutputStream5, TestMetadata.populateExif(TiffExif.class), true);
        ((FileInputStream)object3).close();
        fileOutputStream5.close();
        object3 = new FileInputStream("images/exif.tif");
        FileOutputStream fileOutputStream6 = new FileOutputStream("exif-exif-iptc-comment-inserted.tif");
        object = new ArrayList();
        object.add(TestMetadata.populateExif(TiffExif.class));
        object.add(TestMetadata.createIPTC());
        object.add(new Comments(Arrays.asList("Comment1", "Comment2")));
        Metadata.insertMetadata((Collection<Metadata>)object, (InputStream)object3, fileOutputStream6);
        object3 = new FileInputStream("images/12.jpg");
        FileOutputStream fileOutputStream7 = new FileOutputStream("12-exif-inserted.jpg");
        Metadata.insertExif((InputStream)object3, fileOutputStream7, TestMetadata.populateExif(JpegExif.class), true);
        object3 = new FileInputStream("images/12.jpg");
        FileOutputStream fileOutputStream8 = new FileOutputStream("12-exif-iptc-inserted.jpg");
        object.clear();
        object.add(TestMetadata.populateExif(JpegExif.class));
        object.add(TestMetadata.createIPTC());
        object.add(new JFIF(new byte[0]));
        Metadata.insertMetadata((Collection<Metadata>)object, (InputStream)object3, fileOutputStream8);
        ((FileInputStream)object3).close();
        fileOutputStream8.close();
        object3 = new FileInputStream("images/12.jpg");
        FileOutputStream fileOutputStream9 = new FileOutputStream("12-metadata-removed.jpg");
        Metadata.removeMetadata((InputStream)object3, fileOutputStream9, MetadataType.JPG_JFIF, MetadataType.JPG_ADOBE, MetadataType.IPTC, MetadataType.ICC_PROFILE, MetadataType.XMP, MetadataType.EXIF);
        ((FileInputStream)object3).close();
        fileOutputStream9.close();
        object3 = new FileInputStream("images/12.jpg");
        FileOutputStream fileOutputStream10 = new FileOutputStream("12-photoshop-iptc-inserted.jpg");
        Metadata.insertIRB((InputStream)object3, fileOutputStream10, TestMetadata.createPhotoshopIPTC(), true);
        ((FileInputStream)object3).close();
        fileOutputStream10.close();
        object3 = new FileInputStream("images/table.jpg");
        JPEGTweaker.extractDepthMap((InputStream)object3, "table");
        ((FileInputStream)object3).close();
        object3 = new FileInputStream("images/butterfly.png");
        FileOutputStream fileOutputStream11 = new FileOutputStream("comment-inserted.png");
        Metadata.insertComments((InputStream)object3, fileOutputStream11, Arrays.asList("Comment1", "Comment2"));
        ((FileInputStream)object3).close();
        fileOutputStream11.close();
    }

    private static List<IPTCDataSet> createIPTCDataSet() {
        ArrayList<IPTCDataSet> arrayList = new ArrayList<IPTCDataSet>();
        arrayList.add(new IPTCDataSet(IPTCApplicationTag.COPYRIGHT_NOTICE, "Copyright 2014-2016, yuwen_66@yahoo.com"));
        arrayList.add(new IPTCDataSet(IPTCApplicationTag.CATEGORY, "ICAFE"));
        arrayList.add(new IPTCDataSet(IPTCApplicationTag.KEY_WORDS, "Welcome 'icafe' user!"));
        return arrayList;
    }

    private static IPTC createIPTC() {
        IPTC iPTC = new IPTC();
        iPTC.addDataSets(TestMetadata.createIPTCDataSet());
        return iPTC;
    }

    private static List<_8BIM> createPhotoshopIPTC() {
        IPTC_NAA iPTC_NAA = new IPTC_NAA();
        iPTC_NAA.addDataSet(new IPTCDataSet(IPTCApplicationTag.COPYRIGHT_NOTICE, "Copyright 2014-2016, yuwen_66@yahoo.com"));
        iPTC_NAA.addDataSet(new IPTCDataSet(IPTCApplicationTag.KEY_WORDS, "Welcome 'icafe' user!"));
        iPTC_NAA.addDataSet(new IPTCDataSet(IPTCApplicationTag.CATEGORY, "ICAFE"));
        return new ArrayList<_8BIM>(Arrays.asList(iPTC_NAA));
    }

    private static BufferedImage createThumbnail(String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        BufferedImage bufferedImage = IMGUtils.createThumbnail(fileInputStream);
        fileInputStream.close();
        return bufferedImage;
    }

    private static Exif populateExif(Class<?> clazz) throws IOException {
        Exif exif = clazz == TiffExif.class ? new TiffExif() : new JpegExif();
        exif.addImageField(TiffTag.WINDOWS_XP_AUTHOR, FieldType.WINDOWSXP, "Author");
        exif.addImageField(TiffTag.WINDOWS_XP_KEYWORDS, FieldType.WINDOWSXP, "Copyright;Author");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        exif.addExifField(ExifTag.EXPOSURE_TIME, FieldType.RATIONAL, new int[]{10, 600});
        exif.addExifField(ExifTag.FNUMBER, FieldType.RATIONAL, new int[]{49, 10});
        exif.addExifField(ExifTag.ISO_SPEED_RATINGS, FieldType.SHORT, new short[]{273});
        exif.addExifField(ExifTag.EXIF_VERSION, FieldType.UNDEFINED, "0220".getBytes());
        exif.addExifField(ExifTag.DATE_TIME_ORIGINAL, FieldType.ASCII, simpleDateFormat.format(new Date()));
        exif.addExifField(ExifTag.DATE_TIME_DIGITIZED, FieldType.ASCII, simpleDateFormat.format(new Date()));
        exif.addExifField(ExifTag.FOCAL_LENGTH, FieldType.RATIONAL, new int[]{240, 10});
        exif.setThumbnailRequired(true);
        return exif;
    }
}

