/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class ArrayUtils {
    private static final int[] MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private static final byte[] BIT_REVERSE_TABLE = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2, 1, -127, 65, -63, 33, -95, 97, -31, 17, -111, 81, -47, 49, -79, 113, -15, 9, -119, 73, -55, 41, -87, 105, -23, 25, -103, 89, -39, 57, -71, 121, -7, 5, -123, 69, -59, 37, -91, 101, -27, 21, -107, 85, -43, 53, -75, 117, -11, 13, -115, 77, -51, 45, -83, 109, -19, 29, -99, 93, -35, 61, -67, 125, -3, 3, -125, 67, -61, 35, -93, 99, -29, 19, -109, 83, -45, 51, -77, 115, -13, 11, -117, 75, -53, 43, -85, 107, -21, 27, -101, 91, -37, 59, -69, 123, -5, 7, -121, 71, -57, 39, -89, 103, -25, 23, -105, 87, -41, 55, -73, 119, -9, 15, -113, 79, -49, 47, -81, 111, -17, 31, -97, 95, -33, 63, -65, 127, -1};

    public static List<Integer> asList(final int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int n) {
                return nArray[n];
            }

            @Override
            public Integer set(int n, Integer n2) {
                int n3 = nArray[n];
                nArray[n] = n2;
                return n3;
            }

            @Override
            public int size() {
                return nArray.length;
            }
        };
    }

    public static void bubbleSort(int[] nArray) {
        int n = nArray.length;
        boolean bl = true;
        while (bl) {
            --n;
            bl = false;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] <= nArray[i + 1]) continue;
                int n2 = nArray[i];
                nArray[i] = nArray[i + 1];
                nArray[i + 1] = n2;
                bl = true;
            }
        }
    }

    public static <T extends Comparable<? super T>> void bubbleSort(T[] TArray) {
        int n = TArray.length;
        boolean bl = true;
        while (bl) {
            --n;
            bl = false;
            for (int i = 0; i < n; ++i) {
                if (TArray[i].compareTo(TArray[i + 1]) <= 0) continue;
                T t = TArray[i];
                TArray[i] = TArray[i + 1];
                TArray[i + 1] = t;
                bl = true;
            }
        }
    }

    public static <T> boolean checkDuplicate(T[] TArray) {
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : TArray) {
            if (hashSet.add(t)) continue;
            return true;
        }
        return false;
    }

    public static byte[] concat(byte[] byArray, byte[] ... byArray2) {
        if (byArray == null) {
            throw new IllegalArgumentException("Firt element is null");
        }
        if (byArray2.length == 0) {
            return byArray;
        }
        int n = byArray.length;
        for (byte[] byArray3 : byArray2) {
            n += byArray3.length;
        }
        byte[] byArray4 = new byte[n];
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray4, 0, n2);
        for (byte[] byArray5 : byArray2) {
            System.arraycopy(byArray5, 0, byArray4, n2, byArray5.length);
            n2 += byArray5.length;
        }
        return byArray4;
    }

    public static <T> T[] concat(T[] ... TArray) {
        if (TArray.length == 0) {
            throw new IllegalArgumentException("Varargs length is zero");
        }
        if (TArray.length == 1) {
            return TArray[0];
        }
        int n = 0;
        Class<?> clazz = TArray.getClass().getComponentType().getComponentType();
        for (T[] TArray2 : TArray) {
            n += TArray2.length;
        }
        T[][] TArray3 = (Object[])Array.newInstance(clazz, n);
        int n2 = 0;
        for (T[] TArray4 : TArray) {
            System.arraycopy(TArray4, 0, TArray3, n2, TArray4.length);
            n2 += TArray4.length;
        }
        return TArray3;
    }

    public static <T> T[] concat(Class<T> clazz, T[] ... TArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("Input type class is null");
        }
        if (TArray.length == 0) {
            Object[] objectArray = (Object[])Array.newInstance(clazz, 0);
            return objectArray;
        }
        if (TArray.length == 1) {
            return TArray[0];
        }
        int n = 0;
        for (T[] TArray2 : TArray) {
            n += TArray2.length;
        }
        T[][] TArray3 = (Object[])Array.newInstance(clazz, n);
        int n2 = 0;
        for (T[] TArray4 : TArray) {
            System.arraycopy(TArray4, 0, TArray3, n2, TArray4.length);
            n2 += TArray4.length;
        }
        return TArray3;
    }

    public static int findEqualOrLess(int[] nArray, int n) {
        return ArrayUtils.findEqualOrLess(nArray, 0, nArray.length, n);
    }

    public static int findEqualOrLess(int[] nArray, int n, int n2, int n3) {
        int n4 = Arrays.binarySearch(nArray, n, n2, n3);
        if (n4 < 0) {
            n4 = -n4 - 1 - 1;
        }
        return n4;
    }

    public static <T> int findEqualOrLess(T[] TArray, int n, int n2, T t, Comparator<? super T> comparator) {
        int n3 = Arrays.binarySearch(TArray, n, n2, t, comparator);
        if (n3 < 0) {
            n3 = -n3 - 1 - 1;
        }
        return n3;
    }

    public static <T> int findEqualOrLess(T[] TArray, T t, Comparator<? super T> comparator) {
        return ArrayUtils.findEqualOrLess(TArray, 0, TArray.length, t, comparator);
    }

    public static byte[] flipEndian(byte[] byArray, int n, int n2, int n3, int n4, boolean bl) {
        long l = 0L;
        int n5 = 0;
        long l2 = 0L;
        int n6 = 8;
        byte[] byArray2 = new byte[byArray.length];
        int n7 = 0;
        int n8 = n + n2;
        int n9 = 0;
        int n10 = n3;
        boolean bl2 = !bl;
        block0: while (true) {
            l = !bl ? l2 >> 8 - n5 : l2 & (long)MASK[n5];
            while (n3 > n5) {
                if (n >= n8) break block0;
                l2 = byArray[n++] & 0xFF;
                l = bl ? l << 8 | l2 : (l |= l2 << n5);
                n5 += 8;
            }
            n5 -= n3;
            if (bl) {
                l >>= n5;
            }
            if (bl2) {
                int n11 = n9;
                byArray2[n11] = (byte)((long)byArray2[n11] | l >> n10 & (long)MASK[n6]);
                for (n10 = n3 - n6; n10 > 8; n10 -= 8) {
                    int n12 = ++n9;
                    byArray2[n12] = (byte)((long)byArray2[n12] | l >> n10 - 8 & (long)MASK[8]);
                }
                if (n10 > 0) {
                    int n13 = ++n9;
                    byArray2[n13] = (byte)((long)byArray2[n13] | (l & (long)MASK[n10]) << 8 - n10);
                    n10 -= 8;
                }
            } else {
                n10 = n3;
                int n14 = n9;
                byArray2[n14] = (byte)((long)byArray2[n14] | (l & (long)MASK[n6]) << 8 - n6);
                l >>= n6;
                n10 -= n6;
                while (n10 > 8) {
                    int n15 = ++n9;
                    byArray2[n15] = (byte)((long)byArray2[n15] | l & 0xFFL);
                    l >>= 8;
                    n10 -= 8;
                }
                if (n10 > 0) {
                    int n16 = ++n9;
                    byArray2[n16] = (byte)((long)byArray2[n16] | l & (long)MASK[n10]);
                    n10 -= 8;
                }
            }
            n6 = -n10;
            if (++n7 % n4 != 0) continue;
            n6 = 0;
            n5 = 0;
        }
        return byArray2;
    }

    public static int fromFloat(float f) {
        int n = Float.floatToIntBits(f);
        int n2 = n >>> 16 & 0x8000;
        int n3 = (n & Integer.MAX_VALUE) + 4096;
        if (n3 >= 1199570944) {
            if ((n & Integer.MAX_VALUE) >= 1199570944) {
                if (n3 < 2139095040) {
                    return n2 | 0x7C00;
                }
                return n2 | 0x7C00 | (n & 0x7FFFFF) >>> 13;
            }
            return n2 | 0x7BFF;
        }
        if (n3 >= 0x38800000) {
            return n2 | n3 - 0x38000000 >>> 13;
        }
        if (n3 < 0x33000000) {
            return n2;
        }
        n3 = (n & Integer.MAX_VALUE) >>> 23;
        return n2 | (n & 0x7FFFFF | 0x800000) + (0x800000 >>> n3 - 102) >>> 126 - n3;
    }

    public static byte[] getBitReverseTable() {
        return (byte[])BIT_REVERSE_TABLE.clone();
    }

    public static void insertionsort(int[] nArray) {
        ArrayUtils.insertionsort(nArray, 0, nArray.length - 1);
    }

    public static void insertionsort(int[] nArray, int n, int n2) {
        for (int i = n + 1; i < n2 + 1; ++i) {
            int n3 = nArray[i];
            for (int j = i; j > n && n3 <= nArray[j - 1]; --j) {
                nArray[j] = nArray[j - 1];
            }
            nArray[j] = n3;
        }
    }

    public static <T extends Comparable<? super T>> void insertionsort(T[] TArray) {
        ArrayUtils.insertionsort(TArray, (int)0, (int)(TArray.length - 1));
    }

    public static <T extends Comparable<? super T>> void insertionsort(T[] TArray, int n, int n2) {
        for (int i = n + 1; i < n2 + 1; ++i) {
            T t = TArray[i];
            for (int j = i; j > n && t.compareTo(TArray[j - 1]) <= 0; --j) {
                TArray[j] = TArray[j - 1];
            }
            TArray[j] = t;
        }
    }

    public static void mergesort(int[] nArray) {
        ArrayUtils.mergesort(nArray, new int[nArray.length], 0, nArray.length - 1);
    }

    public static void mergesort(int[] nArray, int n, int n2) {
        if (n < 0 || n2 > nArray.length - 1) {
            throw new IllegalArgumentException("Array index out of bounds");
        }
        ArrayUtils.mergesort(nArray, new int[nArray.length], n, n2);
    }

    private static void mergesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n < n2) {
            int n3 = n + (n2 - n) / 2;
            ArrayUtils.mergesort(nArray, nArray2, n, n3);
            ArrayUtils.mergesort(nArray, nArray2, n3 + 1, n2);
            ArrayUtils.merge(nArray, nArray2, n, n3, n2);
        }
    }

    public static <T extends Comparable<? super T>> void mergesort(T[] TArray) {
        ArrayUtils.mergesort(TArray, (int)0, (int)(TArray.length - 1));
    }

    public static <T extends Comparable<? super T>> void mergesort(T[] TArray, int n, int n2) {
        if (n < 0 || n2 > TArray.length - 1) {
            throw new IllegalArgumentException("Array index out of bounds");
        }
        Comparable[] comparableArray = (Comparable[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length);
        ArrayUtils.mergesort(TArray, (Comparable[])comparableArray, (int)n, (int)n2);
    }

    private static <T extends Comparable<? super T>> void mergesort(T[] TArray, T[] TArray2, int n, int n2) {
        if (n < n2) {
            int n3 = n + (n2 - n) / 2;
            ArrayUtils.mergesort(TArray, TArray2, (int)n, (int)n3);
            ArrayUtils.mergesort(TArray, TArray2, (int)(n3 + 1), (int)n2);
            ArrayUtils.merge(TArray, TArray2, (int)n, (int)n3, (int)n2);
        }
    }

    private static <T extends Comparable<? super T>> void merge(T[] TArray, T[] TArray2, int n, int n2, int n3) {
        int n4;
        for (n4 = n; n4 <= n3; ++n4) {
            TArray2[n4] = TArray[n4];
        }
        n4 = n;
        int n5 = n2 + 1;
        int n6 = n;
        while (n4 <= n2 && n5 <= n3) {
            if (TArray2[n4].compareTo(TArray2[n5]) <= 0) {
                TArray[n6] = TArray2[n4];
                ++n4;
            } else {
                TArray[n6] = TArray2[n5];
                ++n5;
            }
            ++n6;
        }
        while (n4 <= n2) {
            TArray[n6] = TArray2[n4];
            ++n6;
            ++n4;
        }
    }

    private static void merge(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4;
        for (n4 = n; n4 <= n3; ++n4) {
            nArray2[n4] = nArray[n4];
        }
        n4 = n;
        int n5 = n2 + 1;
        int n6 = n;
        while (n4 <= n2 && n5 <= n3) {
            if (nArray2[n4] <= nArray2[n5]) {
                nArray[n6] = nArray2[n4];
                ++n4;
            } else {
                nArray[n6] = nArray2[n5];
                ++n5;
            }
            ++n6;
        }
        while (n4 <= n2) {
            nArray[n6] = nArray2[n4];
            ++n6;
            ++n4;
        }
    }

    public static byte[] packByteArray(byte[] byArray, int n, int n2, int n3) {
        if (n2 == 8) {
            return ArrayUtils.subArray(byArray, n, n3);
        }
        if (n2 > 8 || n2 <= 0) {
            throw new IllegalArgumentException("Invalid value of bits: " + n2);
        }
        byte[] byArray2 = new byte[n2 * n3 + 7 >> 3];
        short[] sArray = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
        int n4 = 0;
        int n5 = 8;
        int n6 = n + n3;
        for (int i = n; i < n6; ++i) {
            if (n5 >= n2) {
                int n7 = n4++;
                byArray2[n7] = (byte)(byArray2[n7] | (byArray[i] & sArray[n2]) << n5 - n2);
                if ((n5 -= n2) != 0) continue;
                n5 = 8;
                continue;
            }
            int n8 = n4++;
            byArray2[n8] = (byte)(byArray2[n8] | byArray[i] >> n2 - n5 & sArray[n5]);
            int n9 = n4;
            byArray2[n9] = (byte)(byArray2[n9] | (byArray[i] & sArray[n2 - n5]) << 8 - n2 + n5);
            n5 += 8 - n2;
        }
        return byArray2;
    }

    public static byte[] packByteArray(byte[] byArray, int n, int n2, int n3, int n4) {
        if (n3 == 8) {
            return ArrayUtils.subArray(byArray, n2, n4);
        }
        if (n3 > 8 || n3 <= 0) {
            throw new IllegalArgumentException("Invalid value of bits: " + n3);
        }
        int n5 = n3 * n;
        int n6 = n4 / n;
        byte[] byArray2 = new byte[(n5 + 7 >> 3) * n6];
        short[] sArray = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
        int n7 = 0;
        int n8 = 8;
        int n9 = n2 + n4;
        int n10 = 0;
        for (int i = n2; i < n9; ++i) {
            if (n8 >= n3) {
                int n11 = n7;
                byArray2[n11] = (byte)(byArray2[n11] | (byArray[i] & sArray[n3]) << n8 - n3);
                n8 -= n3;
            } else {
                int n12 = n7++;
                byArray2[n12] = (byte)(byArray2[n12] | byArray[i] >> n3 - n8 & sArray[n8]);
                int n13 = n7;
                byArray2[n13] = (byte)(byArray2[n13] | (byArray[i] & sArray[n3 - n8]) << 8 - n3 + n8);
                n8 += 8 - n3;
            }
            if (++n10 % n != 0 && n8 != 0) continue;
            ++n7;
            n8 = 8;
        }
        return byArray2;
    }

    public static void quicksort(int[] nArray) {
        ArrayUtils.quicksort(nArray, 0, nArray.length - 1);
    }

    public static void quicksort(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = (n + n2) / 2;
        while (true) {
            if (n3 < n5 && nArray[n3] <= nArray[n5]) {
                ++n3;
                continue;
            }
            while (n4 > n5 && nArray[n4] >= nArray[n5]) {
                --n4;
            }
            if (n3 < n5 && n4 > n5) {
                ArrayUtils.swap(nArray, n3, n4);
                ++n3;
                --n4;
            } else if (n3 < n5) {
                ArrayUtils.swap(nArray, n3, n5 - 1);
                ArrayUtils.swap(nArray, n5, n5 - 1);
                --n5;
            } else if (n4 > n5) {
                ArrayUtils.swap(nArray, n4, n5 + 1);
                ArrayUtils.swap(nArray, n5, n5 + 1);
                ++n5;
            }
            if (n3 == n4) break;
        }
        if (n5 - 1 > n) {
            ArrayUtils.quicksort(nArray, n, n5 - 1);
        }
        if (n2 > n5 + 1) {
            ArrayUtils.quicksort(nArray, n5 + 1, n2);
        }
    }

    public static <T extends Comparable<? super T>> void quicksort(T[] TArray) {
        ArrayUtils.quicksort(TArray, (int)0, (int)(TArray.length - 1));
    }

    public static <T extends Comparable<? super T>> void quicksort(T[] TArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        T t = TArray[n + (n2 - n) / 2];
        while (n3 <= n4) {
            while (TArray[n3].compareTo(t) < 0) {
                ++n3;
            }
            while (TArray[n4].compareTo(t) > 0) {
                --n4;
            }
            if (n3 > n4) continue;
            ArrayUtils.swap(TArray, n3, n4);
            ++n3;
            --n4;
        }
        if (n < n4) {
            ArrayUtils.quicksort(TArray, (int)n, (int)n4);
        }
        if (n3 < n2) {
            ArrayUtils.quicksort(TArray, (int)n3, (int)n2);
        }
    }

    public static int[] removeDuplicates(int[] nArray) {
        if (nArray.length < 2) {
            return nArray;
        }
        Arrays.sort(nArray);
        int n = 0;
        int n2 = 1;
        while (n2 < nArray.length) {
            if (nArray[n2] == nArray[n]) {
                ++n2;
                continue;
            }
            nArray[++n] = nArray[n2++];
        }
        int[] nArray2 = new int[n + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n + 1);
        return nArray2;
    }

    public static void reverseBits(byte[] byArray) {
        for (int i = byArray.length - 1; i >= 0; --i) {
            byArray[i] = BIT_REVERSE_TABLE[byArray[i] & 0xFF];
        }
    }

    public static byte[] reverse(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Input array is null");
        }
        int n = 0;
        for (int i = byArray.length - 1; n < i; ++n, --i) {
            byte by = byArray[i];
            byArray[i] = byArray[n];
            byArray[n] = by;
        }
        return byArray;
    }

    public static <T> void reverse(T[] TArray) {
        int n = 0;
        for (int i = TArray.length - 1; n < i; ++n, --i) {
            T t = TArray[n];
            TArray[n] = TArray[i];
            TArray[i] = t;
        }
    }

    public static void shellsort(int[] nArray) {
        ArrayUtils.shellsort(nArray, 0, nArray.length - 1);
    }

    public static void shellsort(int[] nArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2 || n2 > nArray.length - 1) {
            throw new IllegalArgumentException("Array index out of bounds");
        }
        int n3 = 1;
        int n4 = n2 - n + 1;
        while (n3 < n4) {
            n3 = 3 * n3 + 1;
        }
        while (n3 > 0) {
            int n5;
            for (int i = n5 = n + n3; i <= n2; ++i) {
                int n6 = nArray[i];
                for (int j = i; j >= n5 && n6 <= nArray[j - n3]; j -= n3) {
                    nArray[j] = nArray[j - n3];
                }
                nArray[j] = n6;
            }
            n3 /= 3;
        }
    }

    public static <T extends Comparable<? super T>> void shellsort(T[] TArray) {
        ArrayUtils.shellsort(TArray, (int)0, (int)(TArray.length - 1));
    }

    public static <T extends Comparable<? super T>> void shellsort(T[] TArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2 || n2 > TArray.length - 1) {
            throw new IllegalArgumentException("Array index out of bounds");
        }
        int n3 = 1;
        int n4 = n2 - n + 1;
        while (n3 < n4) {
            n3 = 3 * n3 + 1;
        }
        while (n3 > 0) {
            int n5;
            for (int i = n5 = n + n3; i <= n2; ++i) {
                T t = TArray[i];
                for (int j = i; j >= n5 && t.compareTo(TArray[j - n3]) <= 0; j -= n3) {
                    TArray[j] = TArray[j - n3];
                }
                TArray[j] = t;
            }
            n3 /= 3;
        }
    }

    public static byte[] subArray(byte[] byArray, int n, int n2) {
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        if (n < 0 || n >= byArray.length || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Copy range out of array bounds");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    private static final void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static final <T> void swap(T[] TArray, int n, int n2) {
        T t = TArray[n];
        TArray[n] = TArray[n2];
        TArray[n2] = t;
    }

    public static float[] to16BitFloatArray(byte[] byArray, boolean bl) {
        short[] sArray = (short[])ArrayUtils.toNBits(16, byArray, Integer.MAX_VALUE, bl);
        float[] fArray = new float[sArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ArrayUtils.toFloat(sArray[i]);
        }
        return fArray;
    }

    public static float[] to24BitFloatArray(byte[] byArray, boolean bl) {
        int[] nArray = (int[])ArrayUtils.toNBits(24, byArray, Integer.MAX_VALUE, bl);
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = Float.intBitsToFloat(nArray[i] << 8);
        }
        return fArray;
    }

    public static int[] to32BitsLongArray(byte[] byArray, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (bl) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        long[] lArray = new long[longBuffer.remaining()];
        longBuffer.get(lArray);
        int[] nArray = new int[lArray.length];
        int n = 0;
        for (long l : lArray) {
            nArray[n++] = (int)l;
        }
        return nArray;
    }

    public static byte[] toByteArray(int n) {
        return new byte[]{(byte)n, (byte)(n >>> 8), (byte)(n >>> 16), (byte)(n >>> 24)};
    }

    public static byte[] toByteArray(int[] nArray, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(nArray.length * 4);
        if (bl) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(nArray);
        byte[] byArray = byteBuffer.array();
        return byArray;
    }

    public static byte[] toByteArray(long[] lArray, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(lArray.length * 8);
        if (bl) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        longBuffer.put(lArray);
        byte[] byArray = byteBuffer.array();
        return byArray;
    }

    public static byte[] toByteArray(short s) {
        return new byte[]{(byte)s, (byte)(s >>> 8)};
    }

    public static byte[] toByteArray(short[] sArray, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(sArray.length * 2);
        if (bl) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        shortBuffer.put(sArray);
        byte[] byArray = byteBuffer.array();
        return byArray;
    }

    public static byte[] toByteArrayMM(int n) {
        return new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
    }

    public static byte[] toByteArrayMM(short s) {
        return new byte[]{(byte)(s >>> 8), (byte)s};
    }

    public static double[] toDoubleArray(byte[] byArray, boolean bl) {
        return ArrayUtils.toDoubleArray(byArray, 0, byArray.length, bl);
    }

    public static double[] toDoubleArray(byte[] byArray, int n, int n2, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        if (bl) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        double[] dArray = new double[doubleBuffer.remaining()];
        doubleBuffer.get(dArray);
        return dArray;
    }

    public static float toFloat(int n) {
        int n2 = n & 0x3FF;
        int n3 = n & 0x7C00;
        if (n3 == 31744) {
            n3 = 261120;
        } else if (n3 != 0) {
            if (n2 == 0 && (n3 += 114688) > 115712) {
                return Float.intBitsToFloat((n & 0x8000) << 16 | n3 << 13 | 0x3FF);
            }
        } else if (n2 != 0) {
            n3 = 115712;
            do {
                n3 -= 1024;
            } while (((n2 <<= 1) & 0x400) == 0);
            n2 &= 0x3FF;
        }
        return Float.intBitsToFloat((n & 0x8000) << 16 | (n3 | n2) << 13);
    }

    public static float[] toFloatArray(byte[] byArray, boolean bl) {
        return ArrayUtils.toFloatArray(byArray, 0, byArray.length, bl);
    }

    public static float[] toFloatArray(byte[] byArray, int n, int n2, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        if (bl) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        float[] fArray = new float[floatBuffer.remaining()];
        floatBuffer.get(fArray);
        return fArray;
    }

    public static int[] toIntArray(byte[] byArray, boolean bl) {
        return ArrayUtils.toIntArray(byArray, 0, byArray.length, bl);
    }

    public static int[] toIntArray(byte[] byArray, int n, int n2, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        if (bl) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        int[] nArray = new int[intBuffer.remaining()];
        intBuffer.get(nArray);
        return nArray;
    }

    public static long[] toLongArray(byte[] byArray, boolean bl) {
        return ArrayUtils.toLongArray(byArray, 0, byArray.length, bl);
    }

    public static long[] toLongArray(byte[] byArray, int n, int n2, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        if (bl) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        long[] lArray = new long[longBuffer.remaining()];
        longBuffer.get(lArray);
        return lArray;
    }

    public static Object toNBits(int n, byte[] byArray, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray2 = null;
        short[] sArray = null;
        int[] nArray = null;
        Object[] objectArray = null;
        int n6 = (int)(((long)byArray.length * 8L + (long)n - 1L) / (long)n);
        if (n <= 8) {
            objectArray = byArray2 = new byte[n6];
        } else if (n <= 16) {
            sArray = new short[n6];
            objectArray = sArray;
        } else if (n <= 32) {
            nArray = new int[n6];
            objectArray = nArray;
        } else {
            throw new IllegalArgumentException("nBits exceeds limit - maximum 32");
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        block0: while (true) {
            n3 = !bl ? n5 >> 8 - n4 : n5 & MASK[n4];
            while (n > n4) {
                if (n7 >= byArray.length) break block0;
                n5 = byArray[n7++] & 0xFF;
                n3 = bl ? n3 << 8 | n5 : (n3 |= n5 << n4);
                n4 += 8;
            }
            n4 -= n;
            if (bl) {
                n3 >>= n4;
            }
            n3 &= MASK[n];
            if (++n9 % n2 == 0) {
                n4 = 0;
            }
            if (n <= 8) {
                byArray2[n8++] = (byte)n3;
                continue;
            }
            if (n <= 16) {
                sArray[n8++] = (short)n3;
                continue;
            }
            nArray[n8++] = n3;
        }
        return objectArray;
    }

    public static double[] toPrimitive(Double[] doubleArray) {
        double[] dArray = new double[doubleArray.length];
        int n = 0;
        Double[] doubleArray2 = doubleArray;
        int n2 = doubleArray2.length;
        for (int i = 0; i < n2; ++i) {
            double d = doubleArray2[i];
            dArray[n++] = d;
        }
        return dArray;
    }

    public static float[] toPrimitive(Float[] floatArray) {
        float[] fArray = new float[floatArray.length];
        int n = 0;
        Float[] floatArray2 = floatArray;
        int n2 = floatArray2.length;
        for (int i = 0; i < n2; ++i) {
            float f = floatArray2[i].floatValue();
            fArray[n++] = f;
        }
        return fArray;
    }

    public static int[] toPrimitive(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        int n = 0;
        Integer[] integerArray2 = integerArray;
        int n2 = integerArray2.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = integerArray2[i];
            nArray[n++] = n3;
        }
        return nArray;
    }

    public static long[] toPrimitive(Long[] longArray) {
        long[] lArray = new long[longArray.length];
        int n = 0;
        Long[] longArray2 = longArray;
        int n2 = longArray2.length;
        for (int i = 0; i < n2; ++i) {
            long l = longArray2[i];
            lArray[n++] = l;
        }
        return lArray;
    }

    public static short[] toPrimitive(Short[] shortArray) {
        short[] sArray = new short[shortArray.length];
        int n = 0;
        Short[] shortArray2 = shortArray;
        int n2 = shortArray2.length;
        for (int i = 0; i < n2; ++i) {
            short s = shortArray2[i];
            sArray[n++] = s;
        }
        return sArray;
    }

    public static short[] toShortArray(byte[] byArray, boolean bl) {
        return ArrayUtils.toShortArray(byArray, 0, byArray.length, bl);
    }

    public static short[] toShortArray(byte[] byArray, int n, int n2, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        if (bl) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        short[] sArray = new short[shortBuffer.remaining()];
        shortBuffer.get(sArray);
        return sArray;
    }

    private ArrayUtils() {
    }
}

