/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

public class ExternalChainingHashTable<K, V> {
    private static final int DEFAULT_TABLE_SIZE = 101;
    private int currentSize = 0;
    private HashEntry<K, V>[] entries;

    public ExternalChainingHashTable() {
        this(101);
    }

    public ExternalChainingHashTable(int n) {
        this.entries = new HashEntry[ExternalChainingHashTable.nextPrime(n)];
    }

    public void put(K k, V v) {
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.entries.length;
        HashEntry<K, V> hashEntry = this.entries[n2];
        while (hashEntry != null) {
            if (hashEntry.hash == n && hashEntry.key.equals(k)) {
                return;
            }
            hashEntry = hashEntry.next;
        }
        this.entries[n2] = hashEntry = new HashEntry<K, V>(n, k, v, this.entries[n2]);
        if (++this.currentSize > this.entries.length / 2) {
            this.rehash();
        }
    }

    public void remove(K k) {
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.entries.length;
        HashEntry<K, V> hashEntry = null;
        HashEntry<K, V> hashEntry2 = this.entries[n2];
        while (hashEntry2 != null) {
            if (hashEntry2.hash == n && hashEntry2.key.equals(k)) {
                if (hashEntry != null) {
                    hashEntry.next = hashEntry2.next;
                } else {
                    this.entries[n2] = hashEntry2.next;
                }
                --this.currentSize;
            }
            hashEntry = hashEntry2;
            hashEntry2 = hashEntry2.next;
        }
    }

    public V get(K k) {
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.entries.length;
        HashEntry<K, V> hashEntry = this.entries[n2];
        while (hashEntry != null) {
            if (hashEntry.hash == n && hashEntry.key.equals(k)) {
                return hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public boolean contains(K k) {
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.entries.length;
        HashEntry<K, V> hashEntry = this.entries[n2];
        while (hashEntry != null) {
            if (hashEntry.hash == n && hashEntry.key.equals(k)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    private void rehash() {
        HashEntry<K, V>[] hashEntryArray = this.entries;
        this.entries = new HashEntry[ExternalChainingHashTable.nextPrime(2 * hashEntryArray.length)];
        for (int i = 0; i < hashEntryArray.length; ++i) {
            HashEntry<K, V> hashEntry = hashEntryArray[i];
            while (hashEntry != null) {
                HashEntry<K, V> hashEntry2 = hashEntry;
                hashEntry = hashEntry.next;
                int n = (hashEntry2.hash & Integer.MAX_VALUE) % this.entries.length;
                hashEntry2.next = this.entries[n];
                this.entries[n] = hashEntry2;
            }
        }
    }

    public static int hashString(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n2 = 37 * n2 + string.charAt(i);
        }
        if ((n2 %= n) < 0) {
            n2 += n;
        }
        return n2;
    }

    private static int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!ExternalChainingHashTable.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isPrime(int n) {
        if (n == 2 || n == 3) {
            return true;
        }
        if (n == 1 || n % 2 == 0) {
            return false;
        }
        int n2 = 3;
        while (n2 * n2 <= n) {
            if (n % n2 == 0) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        ExternalChainingHashTable<Integer, Integer> externalChainingHashTable = new ExternalChainingHashTable<Integer, Integer>();
        System.out.println("Checking... (no more output means success)");
        int n = 37;
        while (n != 0) {
            externalChainingHashTable.put(n, n);
            n = (n + 37) % 4000;
        }
        for (n = 1; n < 4000; n += 2) {
            externalChainingHashTable.remove(n);
        }
        for (n = 2; n < 4000; n += 2) {
            if ((Integer)externalChainingHashTable.get(n) == n) continue;
            System.out.println("Find fails " + n);
        }
        for (n = 1; n < 4000; n += 2) {
            if (externalChainingHashTable.get(n) == null) continue;
            System.out.println("OOPS!!! " + n);
        }
    }

    private static class HashEntry<K, V> {
        int hash;
        K key;
        V value;
        HashEntry<K, V> next;

        HashEntry(int n, K k, V v, HashEntry<K, V> hashEntry) {
            this.hash = n;
            this.key = k;
            this.value = v;
            this.next = hashEntry;
        }
    }
}

