/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javaxt.sql.Column;
import javaxt.sql.Connection;
import javaxt.sql.Database;
import javaxt.sql.Driver;
import javaxt.sql.Field;
import javaxt.sql.Function;
import javaxt.sql.Key;
import javaxt.sql.Parser;
import javaxt.sql.Table;
import javaxt.sql.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recordset {
    private ResultSet rs = null;
    private java.sql.Connection Conn = null;
    private Statement stmt = null;
    private int x;
    private boolean isReadOnly = true;
    private String sqlString = null;
    private Connection Connection = null;
    private Driver driver = null;
    private boolean autoCommit = true;
    private Value GeneratedKey;
    private static final String[] resKeywords = new String[]{"ADD", "ADMIN", "ALL", "ALTER", "AND", "ANY", "AS", "AT", "AVG", "BEGIN", "BETWEEN", "BIGINT", "BIT_LENGTH", "BLOB", "BOTH", "BY", "CASE", "CAST", "CHAR", "CHAR_LENGTH", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COLLATE", "COLUMN", "COMMIT", "CONNECT", "CONSTRAINT", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_CONNECTION", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSACTION", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "ESCAPE", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FETCH", "FILTER", "FLOAT", "FOR", "FOREIGN", "FROM", "FULL", "FUNCTION", "GDSCODE", "GLOBAL", "GRANT", "GROUP", "HAVING", "HOUR", "IN", "INDEX", "INNER", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTO", "IS", "JOIN", "LEADING", "LEFT", "LIKE", "LONG", "LOWER", "MAX", "MAXIMUM_SEGMENT", "MERGE", "MIN", "MINUTE", "MONTH", "NATIONAL", "NATURAL", "NCHAR", "NO", "NOT", "NULL", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OR", "ORDER", "OUTER", "PARAMETER", "PLAN", "POSITION", "POST_EVENT", "PRECISION", "PRIMARY", "PROCEDURE", "RDB$DB_KEY", "REAL", "RECORD_VERSION", "RECREATE", "RECURSIVE", "REFERENCES", "RELEASE", "RETURNING_VALUES", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROW_COUNT", "ROWS", "SAVEPOINT", "SECOND", "SELECT", "SENSITIVE", "SET", "SIMILAR", "SMALLINT", "SOME", "SQLCODE", "SQLSTATE", "START", "SUM", "TABLE", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRIGGER", "TRIM", "UNION", "UNIQUE", "UPDATE", "UPPER", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WHEN", "WHERE", "WHILE", "WITH", "YEAR"};
    public int State = 0;
    public boolean EOF = false;
    private Field[] Fields = null;
    public int MaxRecords = 1000000000;
    public int RecordCount;
    public long QueryResponseTime;
    public long EllapsedTime;
    public long MetadataQueryTime;
    private long startTime;
    private long endTime;
    private Integer fetchSize = null;
    private boolean InsertOnUpdate = false;
    private int numBatches = 0;
    private int batchSize = 1;
    private HashMap<String, PreparedStatement> batchedStatements;

    public boolean isOpen() {
        if (this.State != 0) {
            String[] arr = System.getProperty("java.version").split("\\.");
            if (Integer.valueOf(arr[0]) == 1 && Integer.valueOf(arr[1]) < 6) {
                return false;
            }
            try {
                return (Boolean)this.rs.getClass().getMethod("isClosed", new Class[0]).invoke((Object)this.rs, null) == false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public ResultSet open(String sql, Connection conn) throws SQLException {
        return this.open(sql, conn, true);
    }

    public ResultSet open(String sqlString, Connection Connection2, boolean ReadOnly) throws SQLException {
        block39: {
            this.rs = null;
            this.stmt = null;
            this.State = 0;
            this.EOF = true;
            this.sqlString = sqlString;
            this.Connection = Connection2;
            this.isReadOnly = ReadOnly;
            this.driver = Connection2.getDatabase().getDriver();
            if (Connection2 == null) {
                throw new SQLException("Connection is null.");
            }
            if (Connection2.isClosed()) {
                throw new SQLException("Connection is closed.");
            }
            this.startTime = System.currentTimeMillis();
            this.Conn = Connection2.getConnection();
            this.autoCommit = this.Conn.getAutoCommit();
            if (ReadOnly) {
                if (this.fetchSize != null) {
                    this.Conn.setAutoCommit(false);
                }
                if (this.driver.equals("DB2") || this.driver.equals("SQLite")) {
                    this.stmt = this.Conn.createStatement(1003, 1007);
                } else if (this.driver.equals("PostgreSQL")) {
                    this.stmt = this.fetchSize != null ? this.Conn.createStatement(1003, 1007, 1000) : this.Conn.createStatement(1004, 1007);
                } else {
                    try {
                        this.stmt = this.Conn.createStatement(1004, 1007);
                    }
                    catch (SQLException e) {
                        this.stmt = this.Conn.createStatement();
                    }
                }
                if (this.fetchSize != null) {
                    this.stmt.setFetchSize(this.fetchSize);
                }
                this.rs = this.stmt.executeQuery(sqlString);
                this.State = 1;
            }
            if (this.driver.equals("SYBASE")) {
                if (this.fetchSize != null) {
                    this.Conn.setAutoCommit(false);
                }
                this.stmt = this.Conn.createStatement(1003, 1008);
                if (this.fetchSize != null) {
                    this.stmt.setFetchSize(this.fetchSize);
                }
                this.rs = this.stmt.executeQuery(sqlString);
                this.State = 1;
                break block39;
            }
            if (this.driver.equals("SQLite")) {
                if (this.fetchSize != null) {
                    this.Conn.setAutoCommit(false);
                }
                this.stmt = this.Conn.createStatement(1003, 1007);
                if (this.fetchSize != null) {
                    this.stmt.setFetchSize(this.fetchSize);
                }
                this.rs = this.stmt.executeQuery(sqlString);
                this.State = 1;
                break block39;
            }
            if (this.driver.equals("DB2")) {
                try {
                    if (this.fetchSize != null) {
                        this.Conn.setAutoCommit(false);
                    }
                    this.stmt = this.Conn.createStatement(1005, 1008);
                    if (this.fetchSize != null) {
                        this.stmt.setFetchSize(this.fetchSize);
                    }
                    this.rs = this.stmt.executeQuery(sqlString);
                    this.State = 1;
                }
                catch (Exception e) {
                    this.rs = null;
                }
                if (this.rs == null) {
                    try {
                        if (this.fetchSize != null) {
                            this.Conn.setAutoCommit(false);
                        }
                        this.stmt = this.Conn.createStatement(1003, 1008);
                        if (this.fetchSize != null) {
                            this.stmt.setFetchSize(this.fetchSize);
                        }
                        this.rs = this.stmt.executeQuery(sqlString);
                        this.State = 1;
                    }
                    catch (Exception e) {}
                }
                break block39;
            }
            if (this.fetchSize != null) {
                this.Conn.setAutoCommit(false);
            }
            this.stmt = this.Conn.createStatement(1005, 1008);
            if (this.fetchSize != null) {
                this.stmt.setFetchSize(this.fetchSize);
            }
            this.rs = this.stmt.executeQuery(sqlString);
            this.State = 1;
        }
        this.endTime = System.currentTimeMillis();
        this.QueryResponseTime = this.endTime - this.startTime;
        try {
            int i;
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int cols = rsmd.getColumnCount();
            this.Fields = new Field[cols];
            for (i = 1; i <= cols; ++i) {
                this.Fields[i - 1] = new Field(i, rsmd);
            }
            rsmd = null;
            this.x = -1;
            if (this.rs != null) {
                if (this.rs.next()) {
                    this.EOF = false;
                    for (i = 1; i <= cols; ++i) {
                        this.Fields[i - 1].Value = new Value(this.rs.getObject(i));
                    }
                    ++this.x;
                }
                this.MetadataQueryTime = 0L;
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return this.rs;
    }

    public void close() {
        try {
            if (this.State == 1) {
                this.executeBatch();
            }
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.Conn.setAutoCommit(this.autoCommit);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.State = 0;
        this.rs = null;
        this.stmt = null;
        this.driver = null;
        this.sqlString = null;
        if (this.Fields != null) {
            for (Field f : this.Fields) {
                f.clear();
                f = null;
            }
            this.Fields = null;
        }
        this.endTime = System.currentTimeMillis();
        this.EllapsedTime = this.endTime - this.startTime;
    }

    public Database getDatabase() {
        return this.Connection.getDatabase();
    }

    public void setFetchSize(int fetchSize) {
        if (fetchSize > 0) {
            this.fetchSize = fetchSize;
        }
    }

    public Connection getConnection() {
        return this.Connection;
    }

    public void commit() {
        try {
            this.Conn.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNew() {
        if (this.State == 1) {
            this.InsertOnUpdate = true;
            for (int i = 1; i <= this.Fields.length; ++i) {
                Field Field2 = this.Fields[i - 1];
                Field2.Value = null;
                Field2.RequiresUpdate = false;
            }
        }
    }

    public void update() throws SQLException {
        Object val;
        PreparedStatement stmt;
        int i;
        if (this.isReadOnly) {
            throw new SQLException("Read only!");
        }
        if (this.State != 1) {
            throw new SQLException("Recordset is closed!");
        }
        if (!this.isDirty()) {
            return;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.Fields) {
            if (field.getName() == null || !field.RequiresUpdate) continue;
            fields.add(field);
        }
        int numUpdates = fields.size();
        String tableName = this.Fields[0].getTable();
        if (tableName == null) {
            this.updateFields();
            tableName = this.Fields[0].getTable();
        }
        if (tableName.contains(" ")) {
            tableName = "[" + tableName + "]";
        }
        StringBuffer sql = new StringBuffer();
        if (this.InsertOnUpdate) {
            int i2;
            sql.append("INSERT INTO " + tableName + " (");
            for (i2 = 0; i2 < numUpdates; ++i2) {
                String colName = this.escape(((Field)fields.get(i2)).getName());
                sql.append(colName);
                if (numUpdates <= 1 || i2 >= numUpdates - 1) continue;
                sql.append(",");
            }
            sql.append(") VALUES (");
            for (i2 = 0; i2 < numUpdates; ++i2) {
                if (i2 > 0) {
                    sql.append(",");
                }
                sql.append(this.getQ((Field)fields.get(i2)));
            }
            sql.append(")");
        } else {
            sql.append("UPDATE " + tableName + " SET ");
            for (int i3 = 0; i3 < numUpdates; ++i3) {
                String colName = this.escape(((Field)fields.get(i3)).getName());
                sql.append(colName);
                sql.append("=");
                sql.append(this.getQ((Field)fields.get(i3)));
                if (numUpdates <= 1 || i3 >= numUpdates - 1) continue;
                sql.append(", ");
            }
            ArrayList<Field> keys = new ArrayList<Field>();
            try {
                Key[] arr;
                DatabaseMetaData dbmd = this.Conn.getMetaData();
                ResultSet r2 = dbmd.getTables(null, null, this.Fields[0].getTable(), new String[]{"TABLE"});
                if (r2.next() && (arr = new Table(r2, dbmd).getPrimaryKeys()) != null) {
                    for (i = 0; i < arr.length; ++i) {
                        Key key = arr[i];
                        Field field = this.getField(key.getName());
                        if (field == null) continue;
                        keys.add(field);
                    }
                }
                r2.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!keys.isEmpty()) {
                sql.append(" WHERE ");
                for (int i4 = 0; i4 < keys.size(); ++i4) {
                    Field field = (Field)keys.get(i4);
                    fields.add(field);
                    if (i4 > 0) {
                        sql.append(" AND ");
                    }
                    String colName = this.escape(field.getName());
                    sql.append(colName);
                    sql.append("=?");
                }
            } else {
                int numRecords;
                String where = new Parser(this.sqlString).getWhereString();
                if (where != null) {
                    sql.append(" WHERE ");
                    sql.append(where);
                }
                ResultSet r2 = this.stmt.executeQuery("SELECT COUNT(*) FROM " + tableName + (where == null ? "" : " WHERE " + where));
                try {
                    numRecords = r2.getInt(1);
                }
                catch (Exception e) {
                    try {
                        r2.first();
                        numRecords = r2.getInt(1);
                    }
                    catch (Exception ex) {
                        numRecords = Integer.MAX_VALUE;
                    }
                }
                r2.close();
                if (numRecords > 1) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("WARNING: Updating " + tableName + " table without a unique key.\r\n");
                    msg.append("Multiple rows may be affected with this update.\r\n");
                    try {
                        int x = 1 / 0;
                    }
                    catch (Exception e) {
                        ByteArrayOutputStream bas = new ByteArrayOutputStream();
                        PrintStream s = new PrintStream(bas, true);
                        e.printStackTrace(s);
                        s.close();
                        boolean append = false;
                        for (String line : bas.toString().split("\n")) {
                            if (append) {
                                msg.append("\t");
                                msg.append(line.trim());
                                msg.append("\r\n");
                            }
                            if (append || !line.contains(this.getClass().getCanonicalName())) continue;
                            append = true;
                        }
                        System.err.println(msg);
                    }
                }
            }
        }
        if (this.batchSize > 1) {
            if (this.batchedStatements == null) {
                this.batchedStatements = new HashMap();
            }
            if ((stmt = this.batchedStatements.get(sql.toString())) == null) {
                stmt = this.Conn.prepareStatement(sql.toString());
                this.batchedStatements.put(sql.toString(), stmt);
                this.Conn.setAutoCommit(false);
            }
        } else {
            stmt = this.Conn.prepareStatement(sql.toString(), 1);
        }
        int id = 1;
        for (int i5 = 0; i5 < fields.size(); ++i5) {
            Value FieldValue;
            Field field = (Field)fields.get(i5);
            String FieldType = field.Class.toLowerCase();
            if (FieldType.contains(".")) {
                FieldType = FieldType.substring(FieldType.lastIndexOf(".") + 1);
            }
            if ((FieldValue = field.getValue()).toObject() instanceof Function) {
                Function function = (Function)FieldValue.toObject();
                if (!function.hasValues()) continue;
                for (Object obj : function.getValues()) {
                    stmt.setObject(id, obj);
                    ++id;
                }
                continue;
            }
            if (FieldType.indexOf("string") >= 0) {
                stmt.setString(id, FieldValue.toString());
            } else if (FieldType.indexOf("int") >= 0) {
                val = FieldValue.toInteger();
                if (val == null) {
                    stmt.setNull(id, 4);
                } else {
                    stmt.setInt(id, (Integer)val);
                }
            } else if (FieldType.indexOf("short") >= 0) {
                val = FieldValue.toShort();
                if (val == null) {
                    stmt.setNull(id, 5);
                } else {
                    stmt.setShort(id, (Short)val);
                }
            } else if (FieldType.indexOf("long") >= 0) {
                val = FieldValue.toLong();
                if (val == null) {
                    stmt.setNull(id, -5);
                } else {
                    stmt.setLong(id, (Long)val);
                }
            } else if (FieldType.indexOf("double") >= 0) {
                val = FieldValue.toDouble();
                if (val == null) {
                    stmt.setNull(id, 8);
                } else {
                    stmt.setDouble(id, (Double)val);
                }
            } else if (FieldType.indexOf("float") >= 0) {
                val = FieldValue.toFloat();
                if (val == null) {
                    stmt.setNull(id, 6);
                } else {
                    stmt.setFloat(id, ((Float)val).floatValue());
                }
            } else if (FieldType.indexOf("bool") >= 0) {
                val = FieldValue.toBoolean();
                if (val == null) {
                    stmt.setNull(id, -7);
                } else {
                    stmt.setBoolean(id, (Boolean)val);
                }
            } else if (FieldType.indexOf("decimal") >= 0) {
                stmt.setBigDecimal(id, FieldValue.toBigDecimal());
            } else if (FieldType.indexOf("timestamp") >= 0) {
                stmt.setTimestamp(id, FieldValue.toTimeStamp());
            } else if (FieldType.indexOf("date") >= 0) {
                stmt.setDate(id, new Date(FieldValue.toDate().getTime()));
            } else if (FieldType.indexOf("object") >= 0) {
                stmt.setObject(id, FieldValue.toObject());
            } else if (FieldType.indexOf("map") >= 0) {
                stmt.setObject(id, (Object)FieldValue.toString(), 1111);
            } else {
                stmt.setObject(id, FieldValue.toObject());
            }
            ++id;
        }
        if (this.batchSize == 1) {
            try {
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                StringBuffer err = new StringBuffer();
                err.append("Error executing update:\n");
                err.append(sql.toString());
                err.append("\n");
                for (i = 0; i < fields.size(); ++i) {
                    if (i > 0) {
                        err.append("\n");
                    }
                    Field field = (Field)fields.get(i);
                    err.append("  - " + field.getName() + ": ");
                    val = field.getValue().toString();
                    if (val != null && ((String)val).length() > 100) {
                        val = ((String)val).substring(0, 100) + "...";
                    }
                    err.append((String)val);
                }
                e.setNextException(new SQLException(err.toString()));
                throw e;
            }
            if (this.InsertOnUpdate) {
                ResultSet generatedKeys = stmt.getGeneratedKeys();
                if (generatedKeys.next()) {
                    this.GeneratedKey = new Value(generatedKeys.getString(1));
                }
                this.InsertOnUpdate = false;
            }
        } else {
            stmt.addBatch();
            ++this.numBatches;
            if (this.numBatches == this.batchSize) {
                this.executeBatch();
            }
        }
    }

    private String escape(String colName) {
        if (colName.contains(" ")) {
            colName = "[" + colName + "]";
        }
        if (this.driver.equals("Firebird")) {
            for (String keyWord : resKeywords) {
                if (!colName.equals(keyWord)) continue;
                colName = "\"" + colName + "\"";
                break;
            }
        }
        return colName;
    }

    private String getQ(Field field) {
        String packageName;
        if (field == null || field.getValue().isNull()) {
            return "?";
        }
        Object value = field.getValue().toObject();
        if (value instanceof Function) {
            Function function = (Function)value;
            return function.getFunction();
        }
        Package _package = value.getClass().getPackage();
        String string2 = packageName = _package == null ? "" : _package.getName();
        if (packageName.startsWith("javaxt.geospatial.geometry")) {
            String STGeomFromText = this.getSTGeomFromText(field);
            field.Value = new Value(value.toString());
            field.Class = "java.lang.String";
            return STGeomFromText + "(?,4326)";
        }
        if (packageName.startsWith("com.vividsolutions.jts.geom")) {
            String STGeomFromText = this.getSTGeomFromText(field);
            field.Value = new Value(value.toString());
            field.Class = "java.lang.String";
            int srid = 4326;
            try {
                Object obj;
                Method method = value.getClass().getMethod("getSRID", new Class[0]);
                if (method != null && (obj = method.invoke(value, null)) != null && (srid = ((Integer)obj).intValue()) == 0) {
                    srid = 4326;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return STGeomFromText + "(?," + srid + ")";
        }
        return "?";
    }

    private String getSTGeomFromText(Field field) {
        if (this.driver.equals("SQLServer")) {
            String geo = field.Class.toLowerCase();
            if (!geo.equals("geometry") && !geo.equals("geography")) {
                geo = null;
                try {
                    Recordset rs = new Recordset();
                    rs.open("SELECT DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME='" + field.getTable() + "' AND COLUMN_NAME='" + field.getName() + "'", this.Connection);
                    geo = rs.getValue(0).toString();
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                geo = geo == null ? "geometry" : geo.toLowerCase();
            }
            return geo + "::STGeomFromText";
        }
        if (this.driver.equals("DB2")) {
            return "db2GSE.ST_GeomFromText";
        }
        return "ST_GeomFromText";
    }

    public void setBatchSize(int batchSize) {
        if (batchSize > 0) {
            this.batchSize = batchSize;
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    private int executeBatch() throws SQLException {
        if (this.batchedStatements == null) {
            return 0;
        }
        int ttl = 0;
        Iterator<String> it = this.batchedStatements.keySet().iterator();
        while (it.hasNext()) {
            PreparedStatement stmt = this.batchedStatements.get(it.next());
            int[] rowsUpdated = stmt.executeBatch();
            if (rowsUpdated.length > 0) {
                ttl += rowsUpdated.length;
            }
            if (this.Conn.getAutoCommit()) continue;
            this.Conn.commit();
        }
        this.batchedStatements.clear();
        this.numBatches = 0;
        return ttl;
    }

    public Value getGeneratedKey() {
        return this.GeneratedKey;
    }

    public Field[] getFields() {
        return this.Fields;
    }

    public Field getField(String FieldName) {
        if (this.Fields == null || this.Fields.length == 0) {
            return null;
        }
        if (FieldName == null) {
            return null;
        }
        if ((FieldName = FieldName.trim()).length() == 0) {
            return null;
        }
        String[] arr = FieldName.split("\\.");
        for (Field field : this.Fields) {
            String schemaName;
            String fieldName = field.getName();
            if (fieldName == null) continue;
            String tableName = field.getTable() == null ? "" : field.getTable();
            String string2 = schemaName = field.getSchema() == null ? "" : field.getSchema();
            if (!(arr.length == 3 ? fieldName.equalsIgnoreCase(arr[2]) && tableName.equalsIgnoreCase(arr[1]) && schemaName.equalsIgnoreCase(arr[0]) : (arr.length == 2 ? fieldName.equalsIgnoreCase(arr[1]) && tableName.equalsIgnoreCase(arr[0]) : arr.length == 1 && fieldName.equalsIgnoreCase(arr[0])))) continue;
            return field;
        }
        return null;
    }

    public Field getField(int i) {
        if (this.Fields != null && i < this.Fields.length) {
            return this.Fields[i];
        }
        return null;
    }

    public Value getValue(String FieldName) {
        Field field = this.getField(FieldName);
        if (field != null) {
            return field.getValue();
        }
        return new Value(null);
    }

    public Value getValue(int i) {
        if (this.Fields != null && i < this.Fields.length) {
            return this.Fields[i].getValue();
        }
        return new Value(null);
    }

    public boolean isDirty() {
        for (Field field : this.Fields) {
            if (!field.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void setValue(String FieldName, Value FieldValue) {
        if (this.State == 1) {
            for (int i = 0; i < this.Fields.length; ++i) {
                String name = this.Fields[i].getName();
                if (name == null || !name.equalsIgnoreCase(FieldName)) continue;
                if (FieldValue == null) {
                    FieldValue = new Value(null);
                }
                if (this.Fields[i].getValue().equals(FieldValue)) break;
                this.Fields[i].Value = FieldValue;
                this.Fields[i].RequiresUpdate = true;
                break;
            }
        }
    }

    public void setValue(String FieldName, Object FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, boolean FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, long FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, int FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, double FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, short FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public boolean hasNext() {
        return !this.EOF;
    }

    public boolean moveNext() {
        if (this.EOF) {
            return false;
        }
        if (this.x >= this.MaxRecords - 1) {
            this.EOF = true;
            return false;
        }
        try {
            if (this.rs.next()) {
                for (int i = 1; i <= this.Fields.length; ++i) {
                    Field Field2 = this.Fields[i - 1];
                    Field2.Value = new Value(this.rs.getObject(i));
                    Field2.RequiresUpdate = false;
                }
                ++this.x;
                return true;
            }
            this.EOF = true;
            return false;
        }
        catch (Exception e) {
            this.EOF = true;
            return false;
        }
    }

    public void move(int numRecords) {
        block9: {
            boolean tryAgain = false;
            try {
                this.rs.absolute(numRecords);
                this.x += numRecords;
            }
            catch (Exception e) {
                tryAgain = true;
            }
            try {
                if (!tryAgain) break block9;
                int rowPosition = this.rs.getRow();
                while (this.rs.getRow() < numRecords + rowPosition) {
                    if (this.rs.next()) {
                        ++this.x;
                        continue;
                    }
                    this.EOF = true;
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            for (int i = 1; i <= this.Fields.length; ++i) {
                Field Field2 = this.Fields[i - 1];
                Field2.Value = new Value(this.rs.getObject(i));
                Field2.RequiresUpdate = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateFields() {
        if (this.Fields == null) {
            return;
        }
        boolean updateFields = false;
        for (Field field : this.Fields) {
            String fieldName = field.getName();
            if (fieldName == null) continue;
            if (field.getTable() == null) {
                updateFields = true;
                break;
            }
            if (field.getSchema() != null) continue;
            updateFields = true;
            break;
        }
        if (!updateFields) {
            return;
        }
        String[] selectedTables = new Parser(this.sqlString).getTables();
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Table table : Database.getTables(this.Connection)) {
            for (String selectedTable : selectedTables) {
                if (selectedTable.contains(".")) {
                    selectedTable = selectedTable.substring(selectedTable.indexOf("."));
                }
                if (!selectedTable.equalsIgnoreCase(table.getName())) continue;
                tables.add(table);
            }
        }
        block3: for (Field field : this.Fields) {
            Column[] columns;
            if (field.getTable() == null && (columns = this.getColumns(field, tables)) != null) {
                Column column = columns[0];
                field.setTableName(column.getTable().getName());
                field.setSchemaName(column.getTable().getSchema());
            }
            if (field.getSchema() != null) continue;
            for (Table table : tables) {
                if (!table.getName().equalsIgnoreCase(field.getTable())) continue;
                field.setSchemaName(table.getSchema());
                continue block3;
            }
        }
        tables.clear();
        tables = null;
    }

    private Column[] getColumns(Field field, ArrayList<Table> tables) {
        ArrayList<Column> matches = new ArrayList<Column>();
        for (Table table : tables) {
            for (Column column : table.getColumns()) {
                if (!column.getName().equalsIgnoreCase(field.getName())) continue;
                matches.add(column);
            }
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return new Column[]{(Column)matches.get(0)};
        }
        if (matches.size() > 1) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (Column column : matches) {
                if (!column.getType().equalsIgnoreCase(field.Type)) continue;
                columns.add(column);
            }
            if (columns.isEmpty()) {
                return null;
            }
            return columns.toArray(new Column[columns.size()]);
        }
        return null;
    }

    public int getRecordCount() {
        try {
            int currRow = this.rs.getRow();
            this.rs.last();
            int size = this.rs.getRow();
            this.rs.absolute(currRow);
            return size;
        }
        catch (Exception e) {
            Integer numRecords = null;
            String sql = new Parser(this.sqlString).setSelect("count(*)");
            Recordset rs = new Recordset();
            try {
                rs.open(sql, this.Connection);
                numRecords = rs.getValue(0).toInteger();
                rs.close();
            }
            catch (SQLException ex) {
                rs.close();
            }
            if (numRecords != null) {
                return numRecords;
            }
            return -1;
        }
    }
}

