/*
 * Decompiled with CFR 0.152.
 */
package javaxt.webservices;

import java.util.ArrayList;
import javaxt.webservices.Parameter;
import javaxt.webservices.Parameters;
import javaxt.xml.DOM;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Method {
    private String Name;
    private String Description;
    private String SoapAction;
    private String ResultsNode;
    private NodeList Parameters = null;

    protected Method(Node MethodNode) {
        NamedNodeMap attr = MethodNode.getAttributes();
        this.Name = DOM.getAttributeValue(attr, "name");
        this.SoapAction = DOM.getAttributeValue(attr, "soapAction");
        this.ResultsNode = DOM.getAttributeValue(attr, "resultsNode");
        NodeList ChildNodes = MethodNode.getChildNodes();
        for (int j = 0; j < ChildNodes.getLength(); ++j) {
            if (ChildNodes.item(j).getNodeType() != 1) continue;
            String NodeName = ChildNodes.item(j).getNodeName();
            String NodeValue = ChildNodes.item(j).getTextContent();
            if (NodeName.toLowerCase().equals("description")) {
                this.Description = NodeValue;
            }
            if (!NodeName.toLowerCase().equals("parameters")) continue;
            this.Parameters = ChildNodes.item(j).getChildNodes();
        }
    }

    public String getName() {
        return this.Name;
    }

    public String getDescription() {
        return this.Description;
    }

    public String getSoapAction() {
        return this.SoapAction;
    }

    public String getResultsNodeName() {
        return this.ResultsNode;
    }

    public Parameters getParameters() {
        Parameter[] parameters = this.getParameters(this.Parameters);
        if (parameters == null) {
            return null;
        }
        return new Parameters(parameters);
    }

    private Parameter[] getParameters(NodeList parameterNodes) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Node parameterNode : DOM.getNodes(parameterNodes)) {
            if (!parameterNode.getNodeName().equalsIgnoreCase("parameter")) continue;
            try {
                parameters.add(new Parameter(parameterNode));
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        if (parameters.isEmpty()) {
            return null;
        }
        return parameters.toArray(new Parameter[parameters.size()]);
    }

    public boolean equals(String MethodName) {
        return this.Name.equalsIgnoreCase(MethodName);
    }

    public String toString() {
        return this.Name;
    }
}

