/*
 * Decompiled with CFR 0.152.
 */
package com.dynamsoft.barcode;

import com.dynamsoft.barcode.BarcodeReaderException;
import com.dynamsoft.barcode.LocalizationResult;
import com.dynamsoft.barcode.PublicParameterSettings;
import com.dynamsoft.barcode.PublicRuntimeSettings;
import com.dynamsoft.barcode.TextResult;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;

public class BarcodeReader {
    private long m_instance = this.nativeCreateInstance();
    private String licenseKeys;
    private static String S_VERSION = "6.4.1";

    static void throwExceptionIfNeeded(BarcodeReaderException barcodeReaderException) throws BarcodeReaderException {
        switch (barcodeReaderException.errorCode) {
            case -10041: 
            case -10026: 
            case -10020: 
            case -10019: 
            case -10017: 
            case -10016: 
            case -10004: 
            case 0: {
                return;
            }
        }
        throw barcodeReaderException;
    }

    public BarcodeReader() throws BarcodeReaderException {
        if (0L == this.m_instance) {
            throw new BarcodeReaderException(-10002, "Return null when create an DBR instance");
        }
    }

    public BarcodeReader(String string) throws Exception {
        if (0L == this.m_instance) {
            throw new BarcodeReaderException(-10002, "Return null when create an DBR instance");
        }
        this.licenseKeys = null;
        BarcodeReader.throwExceptionIfNeeded(this.nativeInitLicense(this.m_instance, string));
        this.licenseKeys = string;
    }

    public void initLicense(String string) throws BarcodeReaderException {
        this.licenseKeys = null;
        BarcodeReader.throwExceptionIfNeeded(this.nativeInitLicense(this.m_instance, string));
        this.licenseKeys = string;
    }

    public TextResult[] decodeFile(String string, String string2) throws BarcodeReaderException {
        return this.decodeImage(string, string2);
    }

    public TextResult[] decodeFileInMemory(byte[] byArray, String string) throws BarcodeReaderException {
        return this.decodeImage(byArray, string);
    }

    public TextResult[] decodeFileInMemory(InputStream inputStream, String string) throws BarcodeReaderException, IOException {
        return this.decodeImage(inputStream, string);
    }

    public TextResult[] decodeBase64String(String string, String string2) throws BarcodeReaderException {
        return this.decodeBase64(string, string2);
    }

    public TextResult[] decodeBufferedImage(BufferedImage bufferedImage, String string) throws IOException, BarcodeReaderException {
        return this.decodeImage(bufferedImage, string);
    }

    public TextResult[] decodeBuffer(byte[] byArray, int n, int n2, int n3, int n4, String string) throws BarcodeReaderException {
        return this.decodeRawImage(byArray, n, n2, n3, n4, string);
    }

    public TextResult[] getAllTextResults() throws BarcodeReaderException {
        Object object = this.nativeGetAllTextResults(this.m_instance);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (TextResult[])object;
    }

    public LocalizationResult[] getAllLocalizationResults() throws BarcodeReaderException {
        Object object = this.nativeGetAllLocalizationResults(this.m_instance);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (LocalizationResult[])object;
    }

    public void updateRuntimeSettings(PublicRuntimeSettings publicRuntimeSettings) throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeUpdateRuntimeSettings(this.m_instance, publicRuntimeSettings));
    }

    public void resetRuntimeSettings() throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeResetRuntimeSettings(this.m_instance));
    }

    public PublicRuntimeSettings getRuntimeSettings() throws BarcodeReaderException {
        Object object = this.nativeGetRuntimeSettings(this.m_instance);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (PublicRuntimeSettings)object;
    }

    public void initRuntimeSettingsWithString(String string, int n) throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeInitRuntimeSettingsWithString(this.m_instance, string, n));
    }

    public void initRuntimeSettingsWithFile(String string, int n) throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeInitRuntimeSettingsWithFile(this.m_instance, string, n));
    }

    public void appendTplStringToRuntimeSettings(String string, int n) throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeAppendTplStringToRuntimeSettings(this.m_instance, string, n));
    }

    public void appendTplFileToRuntimeSettings(String string, int n) throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeAppendTplFileToRuntimeSettings(this.m_instance, string, n));
    }

    public String[] getAllParameterTemplateNames() {
        return this.nativeGetAllParameterTemplateNames(this.m_instance);
    }

    public void outputSettingsToFile(String string, String string2) throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeOutputSettingsToFile(this.m_instance, string, string2));
    }

    public String outputSettingsToString(String string) throws BarcodeReaderException {
        Object object = this.nativeOutputSettingsToString(this.m_instance, string);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (String)object;
    }

    public void initLicenseFromServer(String string, String string2) throws BarcodeReaderException {
        BarcodeReader.throwExceptionIfNeeded(this.nativeInitLicenseFromServer(this.m_instance, string, string2));
    }

    public void initLicenseFromLicenseContent(String string, String string2) throws BarcodeReaderException {
        BarcodeReader.throwExceptionIfNeeded(this.nativeInitLicenseFromLicenseContent(this.m_instance, string, string2));
    }

    public String outputLicenseToString() throws BarcodeReaderException {
        Object object = this.nativeOutputLicenseToString(this.m_instance);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (String)object;
    }

    public void setTemplateSettings(PublicParameterSettings publicParameterSettings) throws BarcodeReaderException {
        BarcodeReader.throwExceptionIfNeeded(this.nativeSetTemplateSettings(this.m_instance, publicParameterSettings));
    }

    public PublicParameterSettings getTemplateSettings(String string) throws BarcodeReaderException {
        Object object = this.nativeGetTemplateSettings(this.m_instance, string);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (PublicParameterSettings)object;
    }

    public void loadSettings(String string) throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeLoadSettings(this.m_instance, string));
    }

    public void loadSettingsFromFile(String string) throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeLoadSettingsFromFile(this.m_instance, string));
    }

    public void appendParameterTemplate(String string) throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeAppendParameterTemplate(this.m_instance, string));
    }

    public void appendParameterTemplateFromFile(String string) throws Exception {
        BarcodeReader.throwExceptionIfNeeded(this.nativeAppendParameterTemplateFromFile(this.m_instance, string));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.nativeDestroyInstance(this.m_instance);
    }

    protected TextResult[] decodeImage(String string) throws BarcodeReaderException {
        return this.decodeImage(string, "");
    }

    protected TextResult[] decodeImage(String string, String string2) throws BarcodeReaderException {
        Object object = this.nativeDecodeFile(this.m_instance, string, string2);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (TextResult[])object;
    }

    protected TextResult[] decodeImage(Path path) throws BarcodeReaderException {
        return this.decodeImage(path.toString(), "");
    }

    protected TextResult[] decodeImage(Path path, String string) throws BarcodeReaderException {
        return this.decodeImage(path.toString(), string);
    }

    protected TextResult[] decodeBase64(String string) throws BarcodeReaderException {
        return this.decodeBase64(string, "");
    }

    protected TextResult[] decodeBase64(String string, String string2) throws BarcodeReaderException {
        Object object = this.nativeDecodeBase64String(this.m_instance, string, string2);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (TextResult[])object;
    }

    protected TextResult[] decodeImage(byte[] byArray) throws BarcodeReaderException {
        return this.decodeImage(byArray, "");
    }

    protected TextResult[] decodeImage(byte[] byArray, String string) throws BarcodeReaderException {
        Object object = this.nativeDecodeFileInMemory(this.m_instance, byArray, string);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (TextResult[])object;
    }

    protected TextResult[] decodeImage(InputStream inputStream) throws IOException, BarcodeReaderException {
        return this.decodeImage(inputStream, "");
    }

    protected TextResult[] decodeImage(InputStream inputStream, String string) throws IOException, BarcodeReaderException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = -1;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        inputStream.close();
        return this.decodeImage(byteArrayOutputStream.toByteArray(), string);
    }

    protected TextResult[] decodeImage(BufferedImage bufferedImage) throws IOException, BarcodeReaderException {
        return this.decodeImage(bufferedImage, "");
    }

    protected TextResult[] decodeImage(BufferedImage bufferedImage, String string) throws IOException, BarcodeReaderException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "bmp", byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        Object object = this.nativeDecodeFileInMemory(this.m_instance, byteArrayOutputStream.toByteArray(), string);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (TextResult[])object;
    }

    protected TextResult[] decodeRawImage(byte[] byArray, int n, int n2, int n3, int n4) throws BarcodeReaderException {
        return this.decodeRawImage(byArray, n, n2, n3, n4, "");
    }

    protected TextResult[] decodeRawImage(byte[] byArray, int n, int n2, int n3, int n4, String string) throws BarcodeReaderException {
        Object object = this.nativeDecodeBuffer(this.m_instance, byArray, n, n2, n3, n4, string);
        if (object instanceof BarcodeReaderException) {
            throw (BarcodeReaderException)object;
        }
        return (TextResult[])object;
    }

    protected TextResult[] decodeRawImage(InputStream inputStream, int n, int n2, int n3, int n4) throws IOException, BarcodeReaderException {
        return this.decodeRawImage(inputStream, n, n2, n3, n4, "");
    }

    protected TextResult[] decodeRawImage(InputStream inputStream, int n, int n2, int n3, int n4, String string) throws IOException, BarcodeReaderException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n5 = -1;
        while ((n5 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n5);
        }
        byteArrayOutputStream.close();
        inputStream.close();
        return this.decodeRawImage(byteArrayOutputStream.toByteArray(), n, n2, n3, n4, string);
    }

    private static native Exception nativeBinding();

    private native long nativeCreateInstance();

    private native void nativeDestroyInstance(long var1);

    private native BarcodeReaderException nativeInitLicense(long var1, String var3);

    private native BarcodeReaderException nativeLoadSettings(long var1, String var3);

    private native BarcodeReaderException nativeLoadSettingsFromFile(long var1, String var3);

    private native BarcodeReaderException nativeAppendParameterTemplate(long var1, String var3);

    private native BarcodeReaderException nativeAppendParameterTemplateFromFile(long var1, String var3);

    private native String[] nativeGetAllParameterTemplateNames(long var1);

    private native Object nativeDecodeFile(long var1, String var3, String var4);

    private native Object nativeDecodeFileInMemory(long var1, byte[] var3, String var4);

    private native Object nativeDecodeBuffer(long var1, byte[] var3, int var4, int var5, int var6, int var7, String var8);

    private native Object nativeDecodeBase64String(long var1, String var3, String var4);

    private native Object nativeGetAllTextResults(long var1);

    private native Object nativeGetAllLocalizationResults(long var1);

    private native BarcodeReaderException nativeSetTemplateSettings(long var1, PublicParameterSettings var3);

    private native Object nativeGetTemplateSettings(long var1, String var3);

    private native BarcodeReaderException nativeUpdateRuntimeSettings(long var1, PublicRuntimeSettings var3);

    private native BarcodeReaderException nativeResetRuntimeSettings(long var1);

    private native Object nativeGetRuntimeSettings(long var1);

    private native BarcodeReaderException nativeInitRuntimeSettingsWithString(long var1, String var3, int var4);

    private native BarcodeReaderException nativeInitRuntimeSettingsWithFile(long var1, String var3, int var4);

    private native BarcodeReaderException nativeAppendTplStringToRuntimeSettings(long var1, String var3, int var4);

    private native BarcodeReaderException nativeAppendTplFileToRuntimeSettings(long var1, String var3, int var4);

    private native BarcodeReaderException nativeOutputSettingsToFile(long var1, String var3, String var4);

    private native Object nativeOutputSettingsToString(long var1, String var3);

    private native BarcodeReaderException nativeInitLicenseFromServer(long var1, String var3, String var4);

    private native BarcodeReaderException nativeInitLicenseFromLicenseContent(long var1, String var3, String var4);

    private native BarcodeReaderException nativeInitLicenseFromLicenseContentEx(long var1, String var3, String var4, String var5);

    private native Object nativeOutputLicenseToString(long var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        String string = "libDynamsoftBarcodeJNI";
        String string2 = "DynamsoftBarcodeJNI";
        String string3 = "DynamsoftBarcodeReader";
        String string4 = "";
        String[] stringArray = null;
        try {
            String string5 = System.getProperty("os.name").toLowerCase();
            String string6 = System.getProperty("os.arch").toLowerCase();
            String string7 = System.getProperty("sun.arch.data.model");
            if (string5.startsWith("win")) {
                string2 = string2 + ".dll";
                if (string7.equals("32")) {
                    string4 = "libs/win/x86";
                    string3 = string3 + "x86.dll";
                    stringArray = new String[]{string2, string3, "DynamicPdf.dll", "vcomp110.dll", "DynamsoftLicClientx86.dll"};
                } else {
                    string4 = "libs/win/x64";
                    string3 = string3 + "x64.dll";
                    stringArray = new String[]{string2, string3, "DynamicPdfx64.dll", "vcomp110.dll", "DynamsoftLicClientx64.dll"};
                }
            } else if (string5.startsWith("linux")) {
                string = string + ".so";
                string3 = "lib" + string3;
                if (string7.equals("32")) {
                    if (!string6.equals("arm")) throw new Exception("Dbr jni sample not support 32bit linux.");
                    string4 = "libs/linux/x86";
                    string3 = string3 + "Arm.so";
                    stringArray = new String[]{string, string3};
                } else {
                    string4 = "libs/linux/x64";
                    string3 = string3 + ".so";
                    stringArray = new String[]{string, string3, "libDynamicPdf.so", "libDynamLicenseClient.so"};
                }
            } else {
                if (!string5.startsWith("mac")) throw new Exception("Dbr jni sample not support unknown os.");
                string4 = "libs/mac";
                string = string + ".jnilib";
                stringArray = new String[]{string};
            }
            String string8 = BarcodeReader.class.getName();
            string4 = "/" + string8.substring(0, string8.lastIndexOf(46)).replaceAll("\\.", "/") + "/" + string4;
            Path path = Files.createTempDirectory(null, new FileAttribute[0]);
            String string9 = path.toString();
            File file = new File(string9);
            file.deleteOnExit();
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            byte[] byArray = new byte[1024];
            for (String string10 : stringArray) {
                inputStream = BarcodeReader.class.getResourceAsStream(string4 + "/" + string10);
                fileOutputStream = new FileOutputStream(string9 + "/" + string10);
                int n = -1;
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                fileOutputStream.close();
            }
            if (string5.startsWith("win")) {
                File file2;
                int n = string9.lastIndexOf("\\");
                String string11 = string9.substring(0, n);
                string11 = string11 + "\\Dynamsoft\\BarcodeReader\\" + S_VERSION + "\\";
                string11 = string7.equals("32") ? string11 + "32" : string11 + "64";
                File file3 = new File(string11);
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                if (!(file2 = new File(string11 + "/" + string3)).exists()) {
                    Files.move(Paths.get(string9, string3), Paths.get(string11, string3), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.delete(Paths.get(string9, string3));
                }
                File file4 = new File(string11 + "/" + string2);
                if (!file4.exists()) {
                    Files.move(Paths.get(string9, string2), Paths.get(string11, string2), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.delete(Paths.get(string9, string2));
                }
                File file5 = new File(string11 + "/" + "vcomp110.dll");
                if (!file5.exists()) {
                    Files.move(Paths.get(string9, "vcomp110.dll"), Paths.get(string11, "vcomp110.dll"), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.delete(Paths.get(string9, "vcomp110.dll"));
                }
                if (string7.equals("32")) {
                    File file6 = new File(string11 + "/" + "DynamsoftLicClientx86.dll");
                    if (!file6.exists()) {
                        Files.move(Paths.get(string9, "DynamsoftLicClientx86.dll"), Paths.get(string11, "DynamsoftLicClientx86.dll"), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.delete(Paths.get(string9, "DynamsoftLicClientx86.dll"));
                    }
                    File file7 = new File(string11 + "/" + "DynamicPdf.dll");
                    if (!file7.exists()) {
                        Files.move(Paths.get(string9, "DynamicPdf.dll"), Paths.get(string11, "DynamicPdf.dll"), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.delete(Paths.get(string9, "DynamicPdf.dll"));
                    }
                    System.load(string11 + "/" + "DynamsoftLicClientx86.dll");
                    System.load(string11 + "/" + "DynamicPdf.dll");
                } else {
                    File file8 = new File(string11 + "/" + "DynamsoftLicClientx64.dll");
                    if (!file8.exists()) {
                        Files.move(Paths.get(string9, "DynamsoftLicClientx64.dll"), Paths.get(string11, "DynamsoftLicClientx64.dll"), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.delete(Paths.get(string9, "DynamsoftLicClientx64.dll"));
                    }
                    File file9 = new File(string11 + "/" + "DynamicPdfx64.dll");
                    if (!file9.exists()) {
                        Files.move(Paths.get(string9, "DynamicPdfx64.dll"), Paths.get(string11, "DynamicPdfx64.dll"), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.delete(Paths.get(string9, "DynamicPdfx64.dll"));
                    }
                    System.load(string11 + "/" + "DynamsoftLicClientx64.dll");
                    System.load(string11 + "/" + "DynamicPdfx64.dll");
                }
                System.load(string11 + "/" + "vcomp110.dll");
                System.load(string11 + "/" + string3);
                System.load(string11 + "/" + string2);
                file.delete();
            } else if (string5.startsWith("linux")) {
                String string12 = "/tmp/dynamsoft/";
                File file10 = new File(string12);
                if (!file10.exists()) {
                    file10.mkdir();
                }
                if (!(file10 = new File(string12 + S_VERSION)).exists()) {
                    file10.mkdir();
                }
                Files.move(Paths.get(string9, string3), Paths.get(string12 + S_VERSION, string3), StandardCopyOption.REPLACE_EXISTING);
                if (string7.equals("32")) {
                    if (!string6.equals("arm")) throw new Exception("Dbr jni sample not support 32bit linux.");
                    Files.move(Paths.get(string9, string), Paths.get(string12 + S_VERSION, string), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.move(Paths.get(string9, "libDynamicPdf.so"), Paths.get(string12 + S_VERSION, "libDynamicPdf.so"), StandardCopyOption.REPLACE_EXISTING);
                    Files.move(Paths.get(string9, "libDynamLicenseClient.so"), Paths.get(string12 + S_VERSION, "libDynamLicenseClient.so"), StandardCopyOption.REPLACE_EXISTING);
                    Files.move(Paths.get(string9, string), Paths.get(string12 + S_VERSION, string), StandardCopyOption.REPLACE_EXISTING);
                }
                System.load(string12 + S_VERSION + "/" + string);
            } else if (string5.startsWith("mac")) {
                System.load(string9 + "/" + string);
            }
            try {
                Exception exception = BarcodeReader.nativeBinding();
                if (null == exception) return;
                throw exception;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

