/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.Http2Ping;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.WithLogId;
import io.grpc.okhttp.AsyncFrameWriter;
import io.grpc.okhttp.OkHttpClientStream;
import io.grpc.okhttp.OkHttpSettingsUtil;
import io.grpc.okhttp.OkHttpTlsUpgrader;
import io.grpc.okhttp.OutboundFlowController;
import io.grpc.okhttp.internal.ConnectionSpec;
import io.grpc.okhttp.internal.framed.ErrorCode;
import io.grpc.okhttp.internal.framed.FrameReader;
import io.grpc.okhttp.internal.framed.FrameWriter;
import io.grpc.okhttp.internal.framed.Header;
import io.grpc.okhttp.internal.framed.HeadersMode;
import io.grpc.okhttp.internal.framed.Http2;
import io.grpc.okhttp.internal.framed.Settings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.SSLSocketFactory;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

class OkHttpClientTransport
implements ConnectionClientTransport {
    private static final Map<ErrorCode, Status> ERROR_CODE_TO_STATUS = OkHttpClientTransport.buildErrorCodeToStatusMap();
    private static final Logger log = Logger.getLogger(OkHttpClientTransport.class.getName());
    private static final OkHttpClientStream[] EMPTY_STREAM_ARRAY = new OkHttpClientStream[0];
    private final InetSocketAddress address;
    private final String defaultAuthority;
    private final String userAgent;
    private final Random random = new Random();
    private final Ticker ticker;
    private ManagedClientTransport.Listener listener;
    private FrameReader testFrameReader;
    private AsyncFrameWriter frameWriter;
    private OutboundFlowController outboundFlow;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int nextStreamId;
    @GuardedBy(value="lock")
    private final Map<Integer, OkHttpClientStream> streams = new HashMap<Integer, OkHttpClientStream>();
    private final Executor executor;
    private final SerializingExecutor serializingExecutor;
    private final int maxMessageSize;
    private int connectionUnacknowledgedBytesRead;
    private ClientFrameHandler clientFrameHandler;
    @GuardedBy(value="lock")
    private Status goAwayStatus;
    @GuardedBy(value="lock")
    private boolean goAwaySent;
    @GuardedBy(value="lock")
    private Http2Ping ping;
    @GuardedBy(value="lock")
    private boolean stopped;
    @GuardedBy(value="lock")
    private boolean inUse;
    private SSLSocketFactory sslSocketFactory;
    private Socket socket;
    @GuardedBy(value="lock")
    private int maxConcurrentStreams = 0;
    @GuardedBy(value="lock")
    private LinkedList<OkHttpClientStream> pendingStreams = new LinkedList();
    private final ConnectionSpec connectionSpec;
    private FrameWriter testFrameWriter;
    Runnable connectingCallback;
    SettableFuture<Void> connectedFuture;

    private static Map<ErrorCode, Status> buildErrorCodeToStatusMap() {
        EnumMap<ErrorCode, Status> errorToStatus = new EnumMap<ErrorCode, Status>(ErrorCode.class);
        errorToStatus.put(ErrorCode.NO_ERROR, Status.INTERNAL.withDescription("No error: A GRPC status of OK should have been sent"));
        errorToStatus.put(ErrorCode.PROTOCOL_ERROR, Status.INTERNAL.withDescription("Protocol error"));
        errorToStatus.put(ErrorCode.INTERNAL_ERROR, Status.INTERNAL.withDescription("Internal error"));
        errorToStatus.put(ErrorCode.FLOW_CONTROL_ERROR, Status.INTERNAL.withDescription("Flow control error"));
        errorToStatus.put(ErrorCode.STREAM_CLOSED, Status.INTERNAL.withDescription("Stream closed"));
        errorToStatus.put(ErrorCode.FRAME_TOO_LARGE, Status.INTERNAL.withDescription("Frame too large"));
        errorToStatus.put(ErrorCode.REFUSED_STREAM, Status.UNAVAILABLE.withDescription("Refused stream"));
        errorToStatus.put(ErrorCode.CANCEL, Status.CANCELLED.withDescription("Cancelled"));
        errorToStatus.put(ErrorCode.COMPRESSION_ERROR, Status.INTERNAL.withDescription("Compression error"));
        errorToStatus.put(ErrorCode.CONNECT_ERROR, Status.INTERNAL.withDescription("Connect error"));
        errorToStatus.put(ErrorCode.ENHANCE_YOUR_CALM, Status.RESOURCE_EXHAUSTED.withDescription("Enhance your calm"));
        errorToStatus.put(ErrorCode.INADEQUATE_SECURITY, Status.PERMISSION_DENIED.withDescription("Inadequate security"));
        return Collections.unmodifiableMap(errorToStatus);
    }

    OkHttpClientTransport(InetSocketAddress address, String authority, @Nullable String userAgent, Executor executor, @Nullable SSLSocketFactory sslSocketFactory, ConnectionSpec connectionSpec, int maxMessageSize) {
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.defaultAuthority = authority;
        this.maxMessageSize = maxMessageSize;
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.serializingExecutor = new SerializingExecutor(executor);
        this.nextStreamId = 3;
        this.sslSocketFactory = sslSocketFactory;
        this.connectionSpec = (ConnectionSpec)Preconditions.checkNotNull((Object)connectionSpec, (Object)"connectionSpec");
        this.ticker = Ticker.systemTicker();
        this.userAgent = GrpcUtil.getGrpcUserAgent((String)"okhttp", (String)userAgent);
    }

    @VisibleForTesting
    OkHttpClientTransport(String userAgent, Executor executor, FrameReader frameReader, FrameWriter testFrameWriter, int nextStreamId, Socket socket, Ticker ticker, @Nullable Runnable connectingCallback, SettableFuture<Void> connectedFuture, int maxMessageSize) {
        this.address = null;
        this.maxMessageSize = maxMessageSize;
        this.defaultAuthority = "notarealauthority:80";
        this.userAgent = GrpcUtil.getGrpcUserAgent((String)"okhttp", (String)userAgent);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.serializingExecutor = new SerializingExecutor(executor);
        this.testFrameReader = (FrameReader)Preconditions.checkNotNull((Object)frameReader);
        this.testFrameWriter = (FrameWriter)Preconditions.checkNotNull((Object)testFrameWriter);
        this.socket = (Socket)Preconditions.checkNotNull((Object)socket);
        this.nextStreamId = nextStreamId;
        this.ticker = ticker;
        this.connectionSpec = null;
        this.connectingCallback = connectingCallback;
        this.connectedFuture = (SettableFuture)Preconditions.checkNotNull(connectedFuture);
    }

    private boolean isForTest() {
        return this.address == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(ClientTransport.PingCallback callback, Executor executor) {
        boolean writePing;
        Http2Ping p;
        Preconditions.checkState((this.frameWriter != null ? 1 : 0) != 0);
        long data = 0L;
        Object object = this.lock;
        synchronized (object) {
            if (this.stopped) {
                Http2Ping.notifyFailed((ClientTransport.PingCallback)callback, (Executor)executor, (Throwable)this.getPingFailure());
                return;
            }
            if (this.ping != null) {
                p = this.ping;
                writePing = false;
            } else {
                data = this.random.nextLong();
                p = this.ping = new Http2Ping(data, Stopwatch.createStarted((Ticker)this.ticker));
                writePing = true;
            }
        }
        if (writePing) {
            this.frameWriter.ping(false, (int)(data >>> 32), (int)data);
        }
        p.addCallback(callback, executor);
    }

    public OkHttpClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        return new OkHttpClientStream(method, headers, this.frameWriter, this, this.outboundFlow, this.lock, this.maxMessageSize, this.defaultAuthority, this.userAgent);
    }

    public OkHttpClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        return this.newStream(method, headers, CallOptions.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    void streamReadyToStart(OkHttpClientStream clientStream) {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus != null) {
                clientStream.transportReportStatus(this.goAwayStatus, true, new Metadata());
            } else if (this.streams.size() >= this.maxConcurrentStreams) {
                this.pendingStreams.add(clientStream);
                this.setInUse();
            } else {
                this.startStream(clientStream);
            }
        }
    }

    @GuardedBy(value="lock")
    private void startStream(OkHttpClientStream stream) {
        Preconditions.checkState((stream.id() == null ? 1 : 0) != 0, (Object)"StreamId already assigned");
        this.streams.put(this.nextStreamId, stream);
        this.setInUse();
        stream.start(this.nextStreamId);
        stream.allocated();
        if (stream.getType() != MethodDescriptor.MethodType.UNARY && stream.getType() != MethodDescriptor.MethodType.SERVER_STREAMING) {
            this.frameWriter.flush();
        }
        if (this.nextStreamId >= 0x7FFFFFFD) {
            this.nextStreamId = Integer.MAX_VALUE;
            this.startGoAway(Integer.MAX_VALUE, ErrorCode.NO_ERROR, Status.UNAVAILABLE.withDescription("Stream ids exhausted"));
        } else {
            this.nextStreamId += 2;
        }
    }

    @GuardedBy(value="lock")
    private boolean startPendingStreams() {
        boolean hasStreamStarted = false;
        while (!this.pendingStreams.isEmpty() && this.streams.size() < this.maxConcurrentStreams) {
            OkHttpClientStream stream = this.pendingStreams.poll();
            this.startStream(stream);
            hasStreamStarted = true;
        }
        return hasStreamStarted;
    }

    @GuardedBy(value="lock")
    void removePendingStream(OkHttpClientStream pendingStream) {
        this.pendingStreams.remove((Object)pendingStream);
        this.maybeClearInUse();
    }

    public void start(ManagedClientTransport.Listener listener) {
        this.listener = (ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.frameWriter = new AsyncFrameWriter(this, this.serializingExecutor);
        this.outboundFlow = new OutboundFlowController(this, this.frameWriter);
        this.serializingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedSink sink;
                Socket sock;
                if (OkHttpClientTransport.this.isForTest()) {
                    if (OkHttpClientTransport.this.connectingCallback != null) {
                        OkHttpClientTransport.this.connectingCallback.run();
                    }
                    OkHttpClientTransport.this.clientFrameHandler = new ClientFrameHandler(OkHttpClientTransport.this.testFrameReader);
                    OkHttpClientTransport.this.executor.execute(OkHttpClientTransport.this.clientFrameHandler);
                    Object object = OkHttpClientTransport.this.lock;
                    synchronized (object) {
                        OkHttpClientTransport.this.maxConcurrentStreams = Integer.MAX_VALUE;
                        OkHttpClientTransport.this.startPendingStreams();
                    }
                    OkHttpClientTransport.this.frameWriter.becomeConnected(OkHttpClientTransport.this.testFrameWriter, OkHttpClientTransport.this.socket);
                    OkHttpClientTransport.this.connectedFuture.set(null);
                    return;
                }
                BufferedSource source = Okio.buffer((Source)new Source(){

                    public long read(Buffer sink, long byteCount) {
                        return -1L;
                    }

                    public Timeout timeout() {
                        return Timeout.NONE;
                    }

                    public void close() {
                    }
                });
                Http2 variant = new Http2();
                try {
                    sock = new Socket(OkHttpClientTransport.this.address.getAddress(), OkHttpClientTransport.this.address.getPort());
                    if (OkHttpClientTransport.this.sslSocketFactory != null) {
                        sock = OkHttpTlsUpgrader.upgrade(OkHttpClientTransport.this.sslSocketFactory, sock, OkHttpClientTransport.this.getOverridenHost(), OkHttpClientTransport.this.getOverridenPort(), OkHttpClientTransport.this.connectionSpec);
                    }
                    sock.setTcpNoDelay(true);
                    source = Okio.buffer((Source)Okio.source((Socket)sock));
                    sink = Okio.buffer((Sink)Okio.sink((Socket)sock));
                }
                catch (Exception e) {
                    OkHttpClientTransport.this.onException(e);
                    return;
                }
                finally {
                    OkHttpClientTransport.this.clientFrameHandler = new ClientFrameHandler(variant.newReader(source, true));
                    OkHttpClientTransport.this.executor.execute(OkHttpClientTransport.this.clientFrameHandler);
                }
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.socket = sock;
                    OkHttpClientTransport.this.maxConcurrentStreams = Integer.MAX_VALUE;
                    OkHttpClientTransport.this.startPendingStreams();
                }
                FrameWriter rawFrameWriter = variant.newWriter(sink, true);
                OkHttpClientTransport.this.frameWriter.becomeConnected(rawFrameWriter, OkHttpClientTransport.this.socket);
                try {
                    rawFrameWriter.connectionPreface();
                    Settings settings = new Settings();
                    rawFrameWriter.settings(settings);
                }
                catch (Exception e) {
                    OkHttpClientTransport.this.onException(e);
                    return;
                }
            }
        });
    }

    public String toString() {
        return this.getLogId() + "(" + this.address + ")";
    }

    public String getLogId() {
        return GrpcUtil.getLogId((WithLogId)this);
    }

    @VisibleForTesting
    String getOverridenHost() {
        URI uri = GrpcUtil.authorityToUri((String)this.defaultAuthority);
        if (uri.getHost() != null) {
            return uri.getHost();
        }
        return this.defaultAuthority;
    }

    @VisibleForTesting
    int getOverridenPort() {
        URI uri = GrpcUtil.authorityToUri((String)this.defaultAuthority);
        if (uri.getPort() != -1) {
            return uri.getPort();
        }
        return this.address.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus != null) {
                return;
            }
            this.goAwayStatus = Status.UNAVAILABLE.withDescription("Transport stopped");
            this.listener.transportShutdown(this.goAwayStatus);
            this.stopIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow(Status reason) {
        this.shutdown();
        Object object = this.lock;
        synchronized (object) {
            Iterator<Map.Entry<Integer, OkHttpClientStream>> it = this.streams.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, OkHttpClientStream> entry = it.next();
                it.remove();
                entry.getValue().transportReportStatus(reason, false, new Metadata());
            }
            for (OkHttpClientStream stream : this.pendingStreams) {
                stream.transportReportStatus(reason, true, new Metadata());
            }
            this.pendingStreams.clear();
            this.maybeClearInUse();
            this.stopIfNecessary();
        }
    }

    public Attributes getAttrs() {
        return Attributes.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OkHttpClientStream[] getActiveStreams() {
        Object object = this.lock;
        synchronized (object) {
            return this.streams.values().toArray(EMPTY_STREAM_ARRAY);
        }
    }

    @VisibleForTesting
    ClientFrameHandler getHandler() {
        return this.clientFrameHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getPendingStreamSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams.size();
        }
    }

    void onException(Throwable failureCause) {
        Status status = Status.UNAVAILABLE.withCause(failureCause);
        if (failureCause != null) {
            status = status.augmentDescription("No provided cause");
        }
        this.startGoAway(0, ErrorCode.INTERNAL_ERROR, status);
    }

    private void onError(ErrorCode errorCode, String moreDetail) {
        this.startGoAway(0, errorCode, OkHttpClientTransport.toGrpcStatus(errorCode).augmentDescription(moreDetail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGoAway(int lastKnownStreamId, ErrorCode errorCode, Status status) {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus == null) {
                this.goAwayStatus = status;
                this.listener.transportShutdown(status);
            }
            if (errorCode != null && !this.goAwaySent) {
                this.goAwaySent = true;
                this.frameWriter.goAway(0, errorCode, new byte[0]);
            }
            Iterator<Map.Entry<Integer, OkHttpClientStream>> it = this.streams.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, OkHttpClientStream> entry = it.next();
                if (entry.getKey() <= lastKnownStreamId) continue;
                it.remove();
                entry.getValue().transportReportStatus(status, false, new Metadata());
            }
            for (OkHttpClientStream stream : this.pendingStreams) {
                stream.transportReportStatus(status, true, new Metadata());
            }
            this.pendingStreams.clear();
            this.maybeClearInUse();
            this.stopIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishStream(int streamId, @Nullable Status status, @Nullable ErrorCode errorCode) {
        Object object = this.lock;
        synchronized (object) {
            OkHttpClientStream stream = this.streams.remove(streamId);
            if (stream != null) {
                if (errorCode != null) {
                    this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                }
                if (status != null) {
                    boolean isCancelled = status.getCode() == Status.Code.CANCELLED || status.getCode() == Status.Code.DEADLINE_EXCEEDED;
                    stream.transportReportStatus(status, isCancelled, new Metadata());
                }
                if (!this.startPendingStreams()) {
                    this.stopIfNecessary();
                    this.maybeClearInUse();
                }
            }
        }
    }

    @GuardedBy(value="lock")
    void stopIfNecessary() {
        if (this.goAwayStatus == null || !this.streams.isEmpty() || !this.pendingStreams.isEmpty()) {
            return;
        }
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.ping != null) {
            this.ping.failed(this.getPingFailure());
            this.ping = null;
        }
        if (!this.goAwaySent) {
            this.goAwaySent = true;
            this.frameWriter.goAway(0, ErrorCode.NO_ERROR, new byte[0]);
        }
        this.frameWriter.close();
    }

    @GuardedBy(value="lock")
    private void maybeClearInUse() {
        if (this.inUse && this.pendingStreams.isEmpty() && this.streams.isEmpty()) {
            this.inUse = false;
            this.listener.transportInUse(false);
        }
    }

    @GuardedBy(value="lock")
    private void setInUse() {
        if (!this.inUse) {
            this.inUse = true;
            this.listener.transportInUse(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable getPingFailure() {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus != null) {
                return this.goAwayStatus.asException();
            }
            return Status.UNAVAILABLE.withDescription("Connection closed").asException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mayHaveCreatedStream(int streamId) {
        Object object = this.lock;
        synchronized (object) {
            return streamId < this.nextStreamId && (streamId & 1) == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OkHttpClientStream getStream(int streamId) {
        Object object = this.lock;
        synchronized (object) {
            return this.streams.get(streamId);
        }
    }

    @VisibleForTesting
    static Status toGrpcStatus(ErrorCode code) {
        Status status = ERROR_CODE_TO_STATUS.get((Object)code);
        return status != null ? status : Status.UNKNOWN.withDescription("Unknown http2 error code: " + code.httpCode);
    }

    @VisibleForTesting
    class ClientFrameHandler
    implements FrameReader.Handler,
    Runnable {
        FrameReader frameReader;
        boolean firstSettings = true;

        ClientFrameHandler(FrameReader frameReader) {
            this.frameReader = frameReader;
        }

        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName("OkHttpClientTransport");
            try {
                while (this.frameReader.nextFrame(this)) {
                }
                OkHttpClientTransport.this.startGoAway(0, ErrorCode.INTERNAL_ERROR, Status.UNAVAILABLE.withDescription("End of stream or IOException"));
            }
            catch (Exception t) {
                OkHttpClientTransport.this.startGoAway(0, ErrorCode.PROTOCOL_ERROR, Status.UNAVAILABLE.withCause((Throwable)t));
            }
            finally {
                try {
                    this.frameReader.close();
                }
                catch (IOException ex) {
                    log.log(Level.INFO, "Exception closing frame reader", ex);
                }
                OkHttpClientTransport.this.listener.transportTerminated();
                Thread.currentThread().setName(threadName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void data(boolean inFinished, int streamId, BufferedSource in, int length) throws IOException {
            OkHttpClientStream stream = OkHttpClientTransport.this.getStream(streamId);
            if (stream == null) {
                if (!OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received data for unknown stream: " + streamId);
                    return;
                }
                OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.INVALID_STREAM);
                in.skip((long)length);
            } else {
                in.require((long)length);
                Buffer buf = new Buffer();
                buf.write(in.buffer(), (long)length);
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    stream.transportDataReceived(buf, inFinished);
                }
            }
            OkHttpClientTransport.this.connectionUnacknowledgedBytesRead = OkHttpClientTransport.this.connectionUnacknowledgedBytesRead + length;
            if (OkHttpClientTransport.this.connectionUnacknowledgedBytesRead >= Short.MAX_VALUE) {
                OkHttpClientTransport.this.frameWriter.windowUpdate(0, OkHttpClientTransport.this.connectionUnacknowledgedBytesRead);
                OkHttpClientTransport.this.connectionUnacknowledgedBytesRead = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock, HeadersMode headersMode) {
            boolean unknownStream = false;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                OkHttpClientStream stream = (OkHttpClientStream)((Object)OkHttpClientTransport.this.streams.get(streamId));
                if (stream == null) {
                    if (OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                        OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.INVALID_STREAM);
                    } else {
                        unknownStream = true;
                    }
                } else {
                    stream.transportHeadersReceived(headerBlock, inFinished);
                }
            }
            if (unknownStream) {
                OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received header for unknown stream: " + streamId);
            }
        }

        @Override
        public void rstStream(int streamId, ErrorCode errorCode) {
            OkHttpClientTransport.this.finishStream(streamId, OkHttpClientTransport.toGrpcStatus(errorCode).augmentDescription("Rst Stream"), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean clearPrevious, Settings settings) {
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                if (OkHttpSettingsUtil.isSet(settings, 4)) {
                    int receivedMaxConcurrentStreams = OkHttpSettingsUtil.get(settings, 4);
                    OkHttpClientTransport.this.maxConcurrentStreams = receivedMaxConcurrentStreams;
                }
                if (OkHttpSettingsUtil.isSet(settings, 7)) {
                    int initialWindowSize = OkHttpSettingsUtil.get(settings, 7);
                    OkHttpClientTransport.this.outboundFlow.initialOutboundWindowSize(initialWindowSize);
                }
                if (this.firstSettings) {
                    OkHttpClientTransport.this.listener.transportReady();
                    this.firstSettings = false;
                }
                OkHttpClientTransport.this.startPendingStreams();
            }
            OkHttpClientTransport.this.frameWriter.ackSettings(settings);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ping(boolean ack, int payload1, int payload2) {
            if (!ack) {
                OkHttpClientTransport.this.frameWriter.ping(true, payload1, payload2);
            } else {
                Http2Ping p = null;
                long ackPayload = (long)payload1 << 32 | (long)payload2 & 0xFFFFFFFFL;
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    if (OkHttpClientTransport.this.ping != null) {
                        if (OkHttpClientTransport.this.ping.payload() == ackPayload) {
                            p = OkHttpClientTransport.this.ping;
                            OkHttpClientTransport.this.ping = null;
                        } else {
                            log.log(Level.WARNING, String.format("Received unexpected ping ack. Expecting %d, got %d", OkHttpClientTransport.this.ping.payload(), ackPayload));
                        }
                    } else {
                        log.warning("Received unexpected ping ack. No ping outstanding");
                    }
                }
                if (p != null) {
                    p.complete();
                }
            }
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            Status status = GrpcUtil.Http2Error.statusForCode((long)errorCode.httpCode).augmentDescription("Received Goaway");
            if (debugData != null && debugData.size() > 0) {
                status = status.augmentDescription(debugData.utf8());
            }
            OkHttpClientTransport.this.startGoAway(lastGoodStreamId, null, status);
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) throws IOException {
            OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.PROTOCOL_ERROR);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long delta) {
            if (delta == 0L) {
                String errorMsg = "Received 0 flow control window increment.";
                if (streamId == 0) {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, errorMsg);
                } else {
                    OkHttpClientTransport.this.finishStream(streamId, Status.INTERNAL.withDescription(errorMsg), ErrorCode.PROTOCOL_ERROR);
                }
                return;
            }
            boolean unknownStream = false;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                if (streamId == 0) {
                    OkHttpClientTransport.this.outboundFlow.windowUpdate(null, (int)delta);
                    return;
                }
                OkHttpClientStream stream = (OkHttpClientStream)((Object)OkHttpClientTransport.this.streams.get(streamId));
                if (stream != null) {
                    OkHttpClientTransport.this.outboundFlow.windowUpdate(stream, (int)delta);
                } else if (!OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                    unknownStream = true;
                }
            }
            if (unknownStream) {
                OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received window_update for unknown stream: " + streamId);
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
        }
    }
}

