/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.codec.ico;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.sf.image4j.codec.bmp.BMPDecoder;
import net.sf.image4j.codec.bmp.ColorEntry;
import net.sf.image4j.codec.bmp.InfoHeader;
import net.sf.image4j.codec.ico.ICOImage;
import net.sf.image4j.codec.ico.IconEntry;
import net.sf.image4j.io.CountingInputStream;
import net.sf.image4j.io.EndianUtils;
import net.sf.image4j.io.LittleEndianInputStream;

public class ICODecoder {
    private static Logger log = Logger.getLogger(ICODecoder.class.getName());
    private static final int PNG_MAGIC = -1991225785;
    private static final int PNG_MAGIC_LE = 1196314761;
    private static final int PNG_MAGIC2 = 218765834;
    private static final int PNG_MAGIC2_LE = 169478669;

    private ICODecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BufferedImage> read(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            List<BufferedImage> list = ICODecoder.read(new BufferedInputStream(fileInputStream));
            return list;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                log.log(Level.FINE, "Failed to close file input for file " + file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ICOImage> readExt(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            List<ICOImage> list = ICODecoder.readExt(new BufferedInputStream(fileInputStream));
            return list;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Failed to close file input for file " + file, iOException);
            }
        }
    }

    public static List<BufferedImage> read(InputStream inputStream) throws IOException {
        List<ICOImage> list = ICODecoder.readExt(inputStream);
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ICOImage iCOImage = list.get(i);
            BufferedImage bufferedImage = iCOImage.getImage();
            arrayList.add(bufferedImage);
        }
        return arrayList;
    }

    private static IconEntry[] sortByFileOffset(IconEntry[] iconEntryArray) {
        List<IconEntry> list = Arrays.asList(iconEntryArray);
        Collections.sort(list, new Comparator<IconEntry>(){

            @Override
            public int compare(IconEntry iconEntry, IconEntry iconEntry2) {
                return iconEntry.iFileOffset - iconEntry2.iFileOffset;
            }
        });
        return list.toArray(new IconEntry[list.size()]);
    }

    public static List<ICOImage> readExt(InputStream inputStream) throws IOException {
        int n;
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(new CountingInputStream(inputStream));
        short s = littleEndianInputStream.readShortLE();
        short s2 = littleEndianInputStream.readShortLE();
        int n2 = littleEndianInputStream.readShortLE();
        IconEntry[] iconEntryArray = new IconEntry[n2];
        for (n = 0; n < n2; n = (short)(n + 1)) {
            iconEntryArray[n] = new IconEntry(littleEndianInputStream);
        }
        n = 0;
        ArrayList<ICOImage> arrayList = new ArrayList<ICOImage>(n2);
        try {
            for (n = 0; n < n2; ++n) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                ColorEntry[] colorEntryArray;
                Object object5;
                Object object6;
                Object object7;
                int n3 = littleEndianInputStream.getCount();
                if (n3 != iconEntryArray[n].iFileOffset) {
                    throw new IOException("Cannot read image #" + n + " starting at unexpected file offset.");
                }
                int n4 = littleEndianInputStream.readIntLE();
                log.log(Level.FINE, "Image #" + n + " @ " + littleEndianInputStream.getCount() + " info = " + EndianUtils.toInfoString(n4));
                if (n4 == 40) {
                    int n5;
                    int n6;
                    int n7;
                    InfoHeader infoHeader = BMPDecoder.readInfoHeader(littleEndianInputStream, n4);
                    object7 = new InfoHeader(infoHeader);
                    ((InfoHeader)object7).iHeight = infoHeader.iHeight / 2;
                    InfoHeader infoHeader2 = new InfoHeader(infoHeader);
                    infoHeader2.iHeight = ((InfoHeader)object7).iHeight;
                    ((InfoHeader)object7).sBitCount = 1;
                    ((InfoHeader)object7).iNumColors = 2;
                    object6 = BMPDecoder.read(infoHeader2, littleEndianInputStream);
                    object5 = new BufferedImage(infoHeader2.iWidth, infoHeader2.iHeight, 2);
                    colorEntryArray = new ColorEntry[]{new ColorEntry(255, 255, 255, 255), new ColorEntry(0, 0, 0, 0)};
                    if (infoHeader.sBitCount == 32) {
                        int n8 = iconEntryArray[n].iSizeInBytes;
                        int n9 = infoHeader.iSize;
                        int n10 = infoHeader2.iWidth * infoHeader2.iHeight * 4;
                        int n11 = n8 - n9 - n10;
                        int n12 = iconEntryArray[n].iFileOffset + n8 - littleEndianInputStream.getCount();
                        if (littleEndianInputStream.skip(n11, false) < n11 && n < n2 - 1) {
                            throw new EOFException("Unexpected end of input");
                        }
                        object4 = ((BufferedImage)object6).getRaster();
                        object3 = ((BufferedImage)object6).getAlphaRaster();
                        WritableRaster writableRaster = ((BufferedImage)object5).getRaster();
                        WritableRaster writableRaster2 = ((BufferedImage)object5).getAlphaRaster();
                        for (n7 = infoHeader2.iHeight - 1; n7 >= 0; --n7) {
                            for (n6 = 0; n6 < infoHeader2.iWidth; ++n6) {
                                n5 = ((Raster)object4).getSample(n6, n7, 0);
                                int n13 = ((Raster)object4).getSample(n6, n7, 1);
                                int n14 = ((Raster)object4).getSample(n6, n7, 2);
                                int n15 = ((Raster)object3).getSample(n6, n7, 0);
                                writableRaster.setSample(n6, n7, 0, n5);
                                writableRaster.setSample(n6, n7, 1, n13);
                                writableRaster.setSample(n6, n7, 2, n14);
                                writableRaster2.setSample(n6, n7, 0, n15);
                            }
                        }
                    } else {
                        object2 = BMPDecoder.read((InfoHeader)object7, littleEndianInputStream, colorEntryArray);
                        object = ((BufferedImage)object6).getRaster();
                        WritableRaster writableRaster = ((BufferedImage)object5).getRaster();
                        WritableRaster writableRaster3 = ((BufferedImage)object5).getAlphaRaster();
                        WritableRaster writableRaster4 = ((BufferedImage)object2).getRaster();
                        for (int i = 0; i < infoHeader2.iHeight; ++i) {
                            for (int j = 0; j < infoHeader2.iWidth; ++j) {
                                n6 = ((BufferedImage)object6).getRGB(j, i);
                                int n16 = n6 >> 16 & 0xFF;
                                int n17 = n6 >> 8 & 0xFF;
                                n7 = n6 & 0xFF;
                                writableRaster.setSample(j, i, 0, n16);
                                writableRaster.setSample(j, i, 1, n17);
                                writableRaster.setSample(j, i, 2, n7);
                                n5 = ((BufferedImage)object2).getRGB(j, i);
                                writableRaster3.setSample(j, i, 0, n5);
                            }
                        }
                    }
                    object2 = iconEntryArray[n];
                    object = new ICOImage((BufferedImage)object5, infoHeader, (IconEntry)object2);
                    ((ICOImage)object).setPngCompressed(false);
                    ((ICOImage)object).setIconIndex(n);
                    arrayList.add((ICOImage)object);
                    continue;
                }
                if (n4 == 1196314761) {
                    int n18 = littleEndianInputStream.readIntLE();
                    if (n18 != 169478669) {
                        throw new IOException("Unrecognized icon format for image #" + n);
                    }
                    object7 = iconEntryArray[n];
                    int n19 = ((IconEntry)object7).iSizeInBytes - 8;
                    object6 = new byte[n19];
                    littleEndianInputStream.readFully((byte[])object6);
                    object5 = new ByteArrayOutputStream();
                    colorEntryArray = new DataOutputStream((OutputStream)object5);
                    colorEntryArray.writeInt(-1991225785);
                    colorEntryArray.writeInt(218765834);
                    colorEntryArray.write((byte[])object6);
                    object2 = ((ByteArrayOutputStream)object5).toByteArray();
                    object = new ByteArrayInputStream((byte[])object2);
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(object);
                    ImageReader imageReader = ICODecoder.getPNGImageReader();
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = imageReader.read(0);
                    object4 = iconEntryArray[n];
                    object3 = new ICOImage(bufferedImage, null, (IconEntry)object4);
                    ((ICOImage)object3).setPngCompressed(true);
                    ((ICOImage)object3).setIconIndex(n);
                    arrayList.add((ICOImage)object3);
                    continue;
                }
                throw new IOException("Unrecognized icon format for image #" + n);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to read image # " + n, iOException);
        }
        return arrayList;
    }

    private static ImageReader getPNGImageReader() {
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("png");
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        return imageReader;
    }
}

