/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.test;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.sf.image4j.codec.bmp.BMPDecoder;
import net.sf.image4j.codec.bmp.BMPEncoder;
import net.sf.image4j.codec.ico.ICODecoder;
import net.sf.image4j.codec.ico.ICOEncoder;

public class Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage:\n\tTest <inputfile> <outputfile>");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        InputStream inputStream = null;
        try {
            Object object;
            List<Object> list;
            inputStream = string.startsWith("http:") ? new URL(string).openStream() : new FileInputStream(string);
            if (!string.endsWith(".ico")) {
                list = new ArrayList<BufferedImage>(1);
                list.add(ImageIO.read(inputStream));
                System.out.println("Read image " + string + "...OK");
            } else {
                Object object2;
                System.out.println("Decoding ICO file '" + string + "'.");
                list = ICODecoder.read(inputStream);
                System.out.println("ICO decoding...OK");
                System.out.println("  image count = " + list.size());
                System.out.println("  image summary:");
                for (int i = 0; i < list.size(); ++i) {
                    BufferedImage bufferedImage = (BufferedImage)list.get(i);
                    int n = bufferedImage.getColorModel().getPixelSize();
                    int n2 = bufferedImage.getWidth();
                    int n3 = bufferedImage.getHeight();
                    System.out.println("    # " + i + ": size=" + n2 + "x" + n3 + "; colour depth=" + n + " bpp");
                }
                System.out.println("  saving separate images:");
                object = "png";
                for (int i = 0; i < list.size(); ++i) {
                    BufferedImage bufferedImage = (BufferedImage)list.get(i);
                    String string3 = string2 + "-" + i;
                    File file = new File(string3 + ".bmp");
                    object2 = new File(string3 + ".png");
                    System.out.println("    writing '" + string3 + ".bmp'");
                    BMPEncoder.write(bufferedImage, file);
                    System.out.println("    writing '" + string3 + ".png'");
                    ImageIO.write((RenderedImage)bufferedImage, (String)object, (File)object2);
                }
                System.out.println("BMP encoding...OK");
                System.out.println("  reloading BMP files:");
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    String string4 = string2 + "-" + i + ".bmp";
                    File file = new File(string4);
                    System.out.println("    reading '" + string4 + "'");
                    object2 = BMPDecoder.read(file);
                    arrayList.add(object2);
                }
                System.out.println("BMP decoding...OK");
            }
            System.out.println("Encoding ICO file '" + string2 + "'.");
            object = new File(string2);
            ICOEncoder.write(list, (File)object);
            System.out.println("ICO encoding...OK");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void usage() {
    }
}

