/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.controller;

import cc.ceofax.bean.Account;
import cc.ceofax.bean.AppAccountFriend;
import cc.ceofax.bean.AppLineFriendView;
import cc.ceofax.bean.Document;
import cc.ceofax.bean.Friend;
import cc.ceofax.bean.HistoryTime;
import cc.ceofax.bean.LineAccountFriend;
import cc.ceofax.bean.Team;
import cc.ceofax.bean.TeamOrFriend;
import cc.ceofax.controller.DocViewer;
import cc.ceofax.controller.Main;
import cc.ceofax.tool.S3Tool;
import cc.ceofax.tool.StyleChangingRowFactory;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javax.imageio.IIOException;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class portal {
    public static Map<String, Stage> stages = new HashMap<String, Stage>();
    public TableView lstFriend;
    public CheckBox chkIsVip;
    public Button btnDirectSent1;
    public static Account account;
    public static Friend editingFriend;
    public static Team editingTeam;
    public static AppAccountFriend editingAppAccountFriend;
    public static LineAccountFriend editingLineAccountFriend;
    public Label appStatus;
    public static portal portal;
    public static DataFormat dataFormat;
    public CheckMenuItem chkAccType1Print;
    public CheckMenuItem chkAccType2Print;
    public TableView lstGotHistory;
    public TableView lstSendHistory;
    public static List<Document> sendDocuments;
    public static List<Document> gotDocuments;
    public static List<Document> waitPrintDocuments;
    public static Map<String, Integer> sendIndexMaps;
    public static Map<String, Integer> gotIndexMaps;
    public static Map<String, Integer> gotHistoryIndexMaps;
    public static Map<String, Integer> sendHistoryIndexMaps;
    public static int buttonModeType;
    public static int buttonModePage;
    public static int buttonModeEditingFriendIndex;
    public static int buttonModeEditingTeamIndex;
    public static int tabIndexInSetting;
    public ComboBox lstHistoryDay;
    public ComboBox lstHistoryWho;
    public static String currentLstHistoryName;
    public TextArea txtJobDetails;
    public Button btnAddFriend;
    public VBox boxFriends;
    public Label txtScanWaiting;
    public Tab btnDeleteAll;
    public TabPane tabHistories;
    public Button btnSelectAllFriend;
    public TabPane tabFriendTeam;
    public TableView lstAppLineUsers;
    static DoubleProperty sptCenterPosition;
    public Label txtPageIndex;
    public Button btnButtonModeType0;
    public Button btnButtonModeType1;
    public TableView lstGotHistoryOld;
    public TableView lstSendHistoryOld;
    public SplitPane sptToday;
    public SplitPane sptCenter;
    public Button btnCancelScan;
    public VBox boxScanStatus;
    public CheckMenuItem chkQREnable;
    public boolean hasGetInitDataed = false;
    public static TableView viewerTable;
    public static int viewerIndex;

    public void updateStatus() {
        Platform.runLater(() -> {
            if (Main.hasLogined && !this.hasGetInitDataed) {
                Main.speak("getInitData");
            }
            if (Main.loadCompleted && stages.get("portal") != null) {
                String accountStatusStr = "\u6b61\u8fce\u4f7f\u7528" + Main.APP_TITLE + " - \u5e33\u865f:  " + account.getUserId() + "              \u4f7f\u7528\u671f\u9650:  " + new SimpleDateFormat("yyyy/MM/dd").format(account.getLimitDate()) + "              \u50b3\u771f\u9ede\u6578: " + account.getPoint();
                String printer = "\u672a\u8a2d\u5b9a";
                String scanner = "\u672a\u8a2d\u5b9a";
                if (Main.setting.getPrinter() != null) {
                    printer = Main.setting.getPrinter();
                }
                if (Main.setting.getScanner() != null) {
                    scanner = Main.setting.getScanner().trim();
                    if (!Main.canScan()) {
                        scanner = scanner + "(\u672a\u9023\u7dda)";
                    }
                }
                String scannerType = "\u81ea\u52d5";
                if (Main.setting.getScannerType() == 1) {
                    scannerType = "\u9001\u7d19\u5668";
                } else if (Main.setting.getScannerType() == 2) {
                    scannerType = "\u5e73\u53f0";
                }
                String appStatusStr = "\u5370\u8868\u6a5f:" + printer + "      \u6383\u63cf\u5668:" + scanner + "(" + scannerType + ")      ver:1.2.1      ";
                boolean isConnected = Main.mqttClient != null && Main.mqttClient.isConnected();
                appStatusStr = !isConnected ? appStatusStr + "\u672a\u9023\u4e0a\u4f3a\u670d\u5668 (MQTT)" : appStatusStr + "\u5df2\u9023\u4e0a\u4f3a\u670d\u5668 (MQTT)";
                stages.get("portal").setTitle(accountStatusStr);
                this.appStatus.setText(appStatusStr);
                if (account.getEmail() == null) {
                    this.chkAccType2Print.setDisable(true);
                }
            }
        });
    }

    public void initialize() {
        portal = this;
        sendDocuments = new ArrayList<Document>();
        gotDocuments = new ArrayList<Document>();
        waitPrintDocuments = new ArrayList<Document>();
        sendIndexMaps = new HashMap<String, Integer>();
        gotIndexMaps = new HashMap<String, Integer>();
        gotHistoryIndexMaps = new HashMap<String, Integer>();
        sendHistoryIndexMaps = new HashMap<String, Integer>();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                portal.this.updateStatus();
            }
        };
        Timer timer = new Timer();
        timer.schedule(task, 0L, 3000L);
        ((SplitPane.Divider)this.sptCenter.getDividers().get(0)).positionProperty().bindBidirectional((Property)sptCenterPosition);
        this.chkQREnable.setSelected(Main.setting.isQRDetectEnable());
        this.lstFriend.setPrefSize(200.0, 100.0);
        this.lstFriend.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.lstFriend.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        TableColumn accType = new TableColumn("\u985e\u578b");
        accType.setPrefWidth(100.0);
        accType.setMinWidth(100.0);
        accType.setMaxWidth(100.0);
        accType.setStyle("-fx-alignment: CENTER;");
        accType.setCellValueFactory((Callback)new PropertyValueFactory("accType"));
        accType.setCellFactory(col -> new IntegerEditingCell());
        TableColumn nickname = new TableColumn("\u66b1\u7a31");
        nickname.setStyle("-fx-padding: 0 0 0 25;");
        nickname.setMinWidth(100.0);
        nickname.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        Object[] cols = new TableColumn[]{accType, nickname};
        this.lstFriend.getColumns().addAll(cols);
        StyleChangingRowFactory<TeamOrFriend> rowFactory = new StyleChangingRowFactory<TeamOrFriend>("highlightedRow", new Callback<TableView<TeamOrFriend>, TableRow<TeamOrFriend>>(){

            public TableRow<TeamOrFriend> call(TableView<TeamOrFriend> tableView) {
                TableRow<TeamOrFriend> row = new TableRow<TeamOrFriend>(){

                    protected void updateItem(TeamOrFriend f, boolean b) {
                        super.updateItem((Object)f, b);
                        if (f != null) {
                            ContextMenu contextMenu = new ContextMenu();
                            String rowLabel = f.getName();
                            MenuItem editItem = new MenuItem();
                            editItem.textProperty().bind((ObservableValue)Bindings.format((String)"\u4fee\u6539 \"%s\"", (Object[])new Object[]{rowLabel}));
                            editItem.setOnAction(event -> {
                                try {
                                    if (f.getAccType() == -1) {
                                        if (stages.get("editTeam") == null) {
                                            editingTeam = f.getTeam();
                                        }
                                        cc.ceofax.controller.portal.newStage("editTeam", "\u4fee\u6539" + rowLabel, 700, 600);
                                    } else if (stages.get("editFriend") == null) {
                                        editingFriend = f.getFriend();
                                        cc.ceofax.controller.portal.newStage("editFriend", "\u4fee\u6539" + rowLabel, 700, 600);
                                    }
                                }
                                catch (IOException e) {
                                    Main.log.error((Object)"error:", (Throwable)e);
                                }
                            });
                            MenuItem deleteItem = new MenuItem();
                            deleteItem.textProperty().bind((ObservableValue)Bindings.format((String)"\u522a\u9664 \"%s\"", (Object[])new Object[]{rowLabel}));
                            deleteItem.setOnAction(event -> {
                                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                                alert.setHeaderText(null);
                                alert.setTitle("\u518d\u6b21\u78ba\u8a8d");
                                alert.setContentText("\u662f\u5426\u78ba\u5b9a\u522a\u9664" + rowLabel + "?");
                                Optional result = alert.showAndWait();
                                if (result.get() == ButtonType.OK) {
                                    if (f.getAccType() == -1) {
                                        Main.speak("deleteTeam," + f.getIdStr());
                                        portal.this.lstFriend.getItems().remove((Object)f);
                                        Main.teamOrFriends.remove(f.getIdStr());
                                        Main.teams.remove(f.getIdStr());
                                        portal.refreshButtonModeButtons();
                                    } else {
                                        Main.speak("deleteFriend," + f.getIdStr());
                                        Main.friends.remove(f.getIdStr());
                                        Main.teamOrFriends.remove(f.getIdStr());
                                    }
                                    portal.this.lstFriend.getItems().remove((Object)f);
                                    cc.ceofax.controller.portal.refreshLstFriend(true);
                                }
                            });
                            contextMenu.getItems().addAll((Object[])new MenuItem[]{editItem, deleteItem});
                            this.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.itemProperty())).then((Object)contextMenu).otherwise((Object)null));
                        }
                    }
                };
                row.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>((TableRow)row){
                    final /* synthetic */ TableRow val$row;
                    {
                        this.val$row = tableRow;
                    }

                    public void handle(MouseEvent event) {
                        int index = this.val$row.getIndex();
                        if (event.isPrimaryButtonDown() && index >= 0 && index < portal.this.lstFriend.getItems().size()) {
                            if (portal.this.lstFriend.getSelectionModel().isSelected(index)) {
                                portal.this.lstFriend.getSelectionModel().clearSelection(index);
                            } else {
                                portal.this.lstFriend.getSelectionModel().select(index);
                            }
                            event.consume();
                        }
                    }
                });
                row.setOnDragEntered((EventHandler)new EventHandler<DragEvent>((TableRow)row){
                    final /* synthetic */ TableRow val$row;
                    {
                        this.val$row = tableRow;
                    }

                    public void handle(DragEvent t) {
                        portal.this.setSelection(portal.this.lstFriend, (IndexedCell)this.val$row);
                        portal.this.lstFriendClicked(null);
                    }
                });
                row.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>((TableRow)row){
                    final /* synthetic */ TableRow val$row;
                    {
                        this.val$row = tableRow;
                    }

                    public void handle(MouseEvent t) {
                        Dragboard db = this.val$row.getTableView().startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                        ClipboardContent content = new ClipboardContent();
                        content.put((Object)dataFormat, (Object)"XData");
                        db.setContent((Map)content);
                        portal.this.setSelection(portal.this.lstFriend, (IndexedCell)this.val$row);
                        t.consume();
                    }
                });
                row.setOnMouseClicked(arg_0 -> this.lambda$call$15((TableRow)row, arg_0));
                return row;
            }

            private /* synthetic */ void lambda$call$15(TableRow row, MouseEvent event) {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    portal.this.lstFriend.getSelectionModel().clearSelection();
                    portal.this.lstFriend.getSelectionModel().select(row.getIndex());
                    portal.this.btnDirectSentAction(null);
                }
            }
        });
        this.lstFriend.setRowFactory(rowFactory);
        this.lstAppLineUsers.setPrefSize(200.0, 100.0);
        this.lstAppLineUsers.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        TableColumn appUserAcc = new TableColumn("\u5e33\u865f");
        appUserAcc.setStyle("-fx-alignment: CENTER;");
        appUserAcc.setMinWidth(100.0);
        appUserAcc.setCellValueFactory((Callback)new PropertyValueFactory("accountId"));
        TableColumn appUserNickname = new TableColumn("\u66b1\u7a31");
        appUserNickname.setStyle("-fx-alignment: CENTER;");
        appUserNickname.setStyle("-fx-padding: 0 0 0 25;");
        appUserNickname.setMinWidth(50.0);
        appUserNickname.setCellValueFactory((Callback)new PropertyValueFactory("nickname"));
        Object[] aCols = new TableColumn[]{appUserAcc, appUserNickname};
        this.lstAppLineUsers.getColumns().addAll(aCols);
        StyleChangingRowFactory<AppLineFriendView> aRowFactory = new StyleChangingRowFactory<AppLineFriendView>("highlightedRow", new Callback<TableView<AppLineFriendView>, TableRow<AppLineFriendView>>(){

            public TableRow<AppLineFriendView> call(TableView<AppLineFriendView> tableView) {
                TableRow<AppLineFriendView> row = new TableRow<AppLineFriendView>(){

                    protected void updateItem(AppLineFriendView g, boolean b) {
                        super.updateItem((Object)g, b);
                        if (g != null) {
                            ContextMenu contextMenu = new ContextMenu();
                            String rowLabel = g.getNickname();
                            MenuItem editItem = new MenuItem();
                            editItem.textProperty().bind((ObservableValue)Bindings.format((String)"\u4fee\u6539 \"%s\"", (Object[])new Object[]{rowLabel}));
                            editItem.setOnAction(event -> {
                                if (g.getAccountId().equalsIgnoreCase("Line")) {
                                    try {
                                        if (stages.get("editLineUser") == null) {
                                            editingLineAccountFriend = g.getLineAccountFriend();
                                        }
                                        cc.ceofax.controller.portal.newStage("editLineAccountFriend", "\u4fee\u6539" + rowLabel, 700, 500);
                                    }
                                    catch (IOException e) {
                                        Main.log.error((Object)"error:", (Throwable)e);
                                    }
                                } else {
                                    try {
                                        if (stages.get("editAppUser") == null) {
                                            editingAppAccountFriend = g.getAppAccountFriend();
                                        }
                                        cc.ceofax.controller.portal.newStage("editAppAccountFriend", "\u4fee\u6539" + rowLabel, 700, 500);
                                    }
                                    catch (IOException e) {
                                        Main.log.error((Object)"error:", (Throwable)e);
                                    }
                                }
                            });
                            MenuItem deleteItem = new MenuItem();
                            deleteItem.textProperty().bind((ObservableValue)Bindings.format((String)"\u522a\u9664 \"%s\"", (Object[])new Object[]{rowLabel}));
                            deleteItem.setOnAction(event -> {
                                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                                alert.setHeaderText(null);
                                alert.setTitle("\u518d\u6b21\u78ba\u8a8d");
                                alert.setContentText("\u662f\u5426\u78ba\u5b9a\u522a\u9664" + rowLabel + "?");
                                Optional result = alert.showAndWait();
                                if (result.get() == ButtonType.OK) {
                                    if (g.getAccountId().equalsIgnoreCase("Line")) {
                                        Main.speak("deleteLineFriend," + g.getIdStr());
                                        portal.this.lstAppLineUsers.getItems().remove((Object)g);
                                        Main.lineAccountFriends.remove(g.getIdStr());
                                    } else {
                                        Main.speak("deleteAppFriend," + g.getIdStr());
                                        portal.this.lstAppLineUsers.getItems().remove((Object)g);
                                        Main.appAccountFriends.remove(g.getIdStr());
                                    }
                                    portal.this.lstAppLineUsers.getItems().remove((Object)g);
                                }
                            });
                            contextMenu.getItems().addAll((Object[])new MenuItem[]{editItem, deleteItem});
                            this.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.itemProperty())).then((Object)contextMenu).otherwise((Object)null));
                        }
                    }
                };
                return row;
            }
        });
        this.lstAppLineUsers.setRowFactory(aRowFactory);
        this.createHistoryTable(this.lstGotHistory);
        this.createHistoryTable(this.lstSendHistory);
        this.createHistoryTable(this.lstGotHistoryOld);
        this.createHistoryTable(this.lstSendHistoryOld);
        ArrayList<HistoryTime> hts = new ArrayList<HistoryTime>();
        for (int i = 0; i <= 10; ++i) {
            HistoryTime t = new HistoryTime(new Date(System.currentTimeMillis() - (long)(86400000 * i)));
            hts.add(t);
        }
        this.lstHistoryDay.setItems(FXCollections.observableArrayList(hts));
        this.lstHistoryDay.getSelectionModel().select(0);
        this.btnButtonModeType0.getStyleClass().clear();
        this.btnButtonModeType1.getStyleClass().clear();
        this.btnButtonModeType0.getStyleClass().add((Object)"btnButtonModeType_chose");
        this.btnButtonModeType1.getStyleClass().add((Object)"btnButtonModeType");
    }

    private void createHistoryTable(final TableView table) {
        Object[] col;
        table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        TableColumn who = new TableColumn("\u5c0d\u8c61");
        who.setMinWidth(80.0);
        who.setCellValueFactory((Callback)new PropertyValueFactory("who"));
        TableColumn index = new TableColumn("\u9801");
        index.setStyle("-fx-alignment: CENTER-RIGHT;");
        index.setMinWidth(50.0);
        index.setMaxWidth(50.0);
        index.setCellValueFactory((Callback)new PropertyValueFactory("index"));
        TableColumn when = new TableColumn("\u6642\u9593");
        when.setStyle("-fx-alignment: CENTER;");
        when.setMinWidth(100.0);
        when.setMaxWidth(100.0);
        when.setCellValueFactory((Callback)new PropertyValueFactory("when"));
        when.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<Document, String> cell = new TableCell<Document, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString().substring(12);
                    }
                };
                return cell;
            }
        });
        when.setSortable(true);
        when.setSortType(TableColumn.SortType.DESCENDING);
        TableColumn print = new TableColumn("\u5370");
        print.setStyle("-fx-alignment: CENTER;");
        print.setMinWidth(50.0);
        print.setMaxWidth(50.0);
        print.setCellValueFactory((Callback)new PropertyValueFactory("printStatus"));
        TableColumn sent = new TableColumn("\u50b3");
        sent.setStyle("-fx-alignment: CENTER;");
        sent.setMinWidth(50.0);
        sent.setMaxWidth(50.0);
        sent.setCellValueFactory((Callback)new PropertyValueFactory("sentStatus"));
        if (table.equals(this.lstGotHistory)) {
            col = new TableColumn[]{who, index, when, print};
            who.maxWidthProperty().bind((ObservableValue)table.widthProperty().subtract(230));
        } else if (table.equals(this.lstSendHistory)) {
            col = new TableColumn[]{who, index, when, sent};
            who.maxWidthProperty().bind((ObservableValue)table.widthProperty().subtract(230));
        } else {
            col = new TableColumn[]{who, index, when};
            who.maxWidthProperty().bind((ObservableValue)table.widthProperty().subtract(150));
        }
        table.getColumns().addAll(col);
        table.getSortOrder().add((Object)when);
        StyleChangingRowFactory<Document> rowFactory = new StyleChangingRowFactory<Document>("highlightedRow", new Callback<TableView<Document>, TableRow<Document>>(){

            public TableRow<Document> call(TableView<Document> tableView) {
                TableRow<Document> row = new TableRow<Document>(){

                    protected void updateItem(Document d, boolean b) {
                        super.updateItem((Object)d, b);
                        if (d != null) {
                            // empty if block
                        }
                    }
                };
                row.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>((TableRow)row){
                    final /* synthetic */ TableRow val$row;
                    {
                        this.val$row = tableRow;
                    }

                    public void handle(MouseEvent event) {
                        int index = this.val$row.getIndex();
                        if (event.isPrimaryButtonDown() && index >= 0 && index < table.getItems().size()) {
                            if (table.getSelectionModel().isSelected(index)) {
                                table.getSelectionModel().clearSelection(index);
                            } else {
                                table.getSelectionModel().select(index);
                            }
                            event.consume();
                        }
                    }
                });
                row.setOnDragEntered((EventHandler)new EventHandler<DragEvent>((TableRow)row){
                    final /* synthetic */ TableRow val$row;
                    {
                        this.val$row = tableRow;
                    }

                    public void handle(DragEvent t) {
                        portal.this.setSelection(table, (IndexedCell)this.val$row);
                    }
                });
                row.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>((TableRow)row){
                    final /* synthetic */ TableRow val$row;
                    {
                        this.val$row = tableRow;
                    }

                    public void handle(MouseEvent t) {
                        Dragboard db = this.val$row.getTableView().startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                        ClipboardContent content = new ClipboardContent();
                        content.put((Object)dataFormat, (Object)"XData");
                        db.setContent((Map)content);
                        portal.this.setSelection(table, (IndexedCell)this.val$row);
                        t.consume();
                    }
                });
                row.setOnMouseClicked(arg_0 -> 5.lambda$call$18((TableRow)row, table, tableView, arg_0));
                return row;
            }

            private static /* synthetic */ void lambda$call$18(TableRow row, TableView table2, TableView tableView, MouseEvent event) {
                if (!(row.isEmpty() || event.isControlDown() || event.isShiftDown())) {
                    table2.getSelectionModel().clearSelection();
                    table2.getSelectionModel().select(row.getIndex());
                    Document d = (Document)tableView.getItems().get(row.getIndex());
                    if (d.getAccType() == 1 || d.getAccType() == 4) {
                        cc.ceofax.controller.portal.showDocument(d.getFilename(), d.getGotTime(), tableView, row.getIndex());
                    } else {
                        cc.ceofax.controller.portal.showDocument(d.getFilename(), null, tableView, row.getIndex());
                    }
                }
            }
        });
        table.setRowFactory(rowFactory);
    }

    private void setSelection(TableView table, IndexedCell cell) {
        table.getSelectionModel().select(cell.getIndex());
    }

    public static void refreshLstFriend(boolean syncToLstHistoryWho) {
        TableView lstFriend = (TableView)stages.get("portal").getScene().lookup("#lstFriend");
        lstFriend.getItems().clear();
        CheckBox chkIsVip = (CheckBox)stages.get("portal").getScene().lookup("#chkIsVip");
        ComboBox lstHistoryWho = (ComboBox)stages.get("portal").getScene().lookup("#lstHistoryWho");
        if (syncToLstHistoryWho) {
            lstHistoryWho.setItems(null);
        }
        ArrayList<Friend> fList = new ArrayList<Friend>();
        Friend fAll = new Friend();
        fAll.setAccType(-1);
        fAll.setAccount(String.valueOf(-1));
        fAll.setIdStr("-1");
        fAll.setNickname("\u6240\u6709");
        fList.add(fAll);
        if (Main.friends != null) {
            ObservableList list;
            ArrayList<Friend> tmpList = new ArrayList<Friend>();
            tmpList.addAll(Main.friends.values());
            tmpList.sort(Comparator.comparing(Friend::getNickname));
            fList.addAll(tmpList);
            if (syncToLstHistoryWho) {
                lstHistoryWho.setItems(FXCollections.observableArrayList(fList));
                lstHistoryWho.getSelectionModel().select(0);
            }
            if (chkIsVip.isSelected()) {
                ArrayList<TeamOrFriend> vips = new ArrayList<TeamOrFriend>();
                for (TeamOrFriend f : Main.teamOrFriends.values()) {
                    if (!f.isVip()) continue;
                    vips.add(f);
                }
                list = FXCollections.observableArrayList(vips);
            } else {
                list = FXCollections.observableArrayList(Main.teamOrFriends.values());
            }
            list.sort(Comparator.comparing(TeamOrFriend::getAccType).thenComparing(TeamOrFriend::getName));
            lstFriend.setItems(list);
        }
        Main.lstGotHistory = (TableView)stages.get("portal").getScene().lookup("#lstGotHistory");
    }

    public static void refreshlstAppLineAccountFriend() {
        TableView lstAppLineUsers = (TableView)stages.get("portal").getScene().lookup("#lstAppLineUsers");
        lstAppLineUsers.getItems().clear();
        ArrayList<AppLineFriendView> datas = new ArrayList<AppLineFriendView>();
        if (Main.appAccountFriends != null) {
            for (AppAccountFriend appAccountFriend : Main.appAccountFriends.values()) {
                datas.add(new AppLineFriendView(appAccountFriend.getIdStr(), appAccountFriend.getAppAccountId(), appAccountFriend.getNickname(), appAccountFriend, null));
            }
        }
        if (Main.lineAccountFriends != null) {
            for (LineAccountFriend lineAccountFriend : Main.lineAccountFriends.values()) {
                datas.add(new AppLineFriendView(lineAccountFriend.getIdStr(), "Line", lineAccountFriend.getNickname(), null, lineAccountFriend));
            }
        }
        ObservableList list = FXCollections.observableArrayList(datas);
        list.sort(Comparator.comparing(AppLineFriendView::getAccountId).thenComparing(AppLineFriendView::getNickname));
        lstAppLineUsers.setItems(list);
    }

    public void menuSMSAction(ActionEvent actionEvent) throws IOException {
        cc.ceofax.controller.portal.newStage("sentSms", "\u767c\u9001\u624b\u6a5f\u7c21\u8a0a", 900, 700);
    }

    public void menuRDPAction(ActionEvent actionEvent) throws IOException, URISyntaxException {
        File file64 = new File("C:\\Program Files (x86)\\TeamViewer\\TeamViewer.exe");
        File file32 = new File("C:\\Program Files\\TeamViewer\\TeamViewer.exe");
        if (file64.exists()) {
            Desktop.getDesktop().open(file64);
        } else if (file32.exists()) {
            Desktop.getDesktop().open(file32);
        } else {
            Desktop.getDesktop().browse(new URI("https://www.teamviewer.com/zhtw/download/windows/"));
        }
    }

    public void btnDirectSentAction(ActionEvent actionEvent) {
        Main.scanIndex = 1;
        if (cc.ceofax.controller.portal.account.isLock) {
            Main.showMsg("\u64cd\u4f5c\u5931\u6557", "\u60a8\u7684\u5e33\u865f\u5df2\u9396\u5b9a\uff0c\u8acb\u9023\u7e6b\u5ba2\u670d\u9032\u884c\u89e3\u9396\u3002", 2);
        } else if (!cc.ceofax.controller.portal.account.isCanSent) {
            Main.showMsg("\u64cd\u4f5c\u5931\u6557", "\u60a8\u7684\u5e33\u865f\u672a\u958b\u901a\u6383\u63cf\u529f\u80fd\uff0c\u8acb\u806f\u7e6b\u5ba2\u670d\u9032\u884c\u958b\u901a\u3002", 2);
        } else if (Main.setting.getScanner() == null) {
            Main.showMsg("\u64cd\u4f5c\u5931\u6557", "\u8acb\u8a2d\u5b9a\u4e00\u53f0\u6383\u63cf\u5668\u9032\u884c\u64cd\u4f5c\u3002", 2);
        } else if (!Main.canScan()) {
            Main.showMsg("\u64cd\u4f5c\u5931\u6557", "\u672a\u9023\u63a5\u6383\u63cf\u5668,\u6216\u8a2d\u5b9a\u53e6\u4e00\u53f0\u6383\u63cf\u5668\u9032\u884c\u64cd\u4f5c\u3002", 2);
        } else if (Main.mqttClient == null || !Main.mqttClient.isConnected()) {
            new Main.startSocketThread().start();
            Main.showNetworkerror();
        } else {
            if (this.tabFriendTeam.getSelectionModel().getSelectedIndex() != 0 && this.tabFriendTeam.getSelectionModel().getSelectedIndex() == 1) {
                Main.selectFriends = new ArrayList<Friend>();
                for (Object o : this.lstFriend.getSelectionModel().getSelectedItems()) {
                    TeamOrFriend tf = (TeamOrFriend)o;
                    if (tf.getAccType() == -1) {
                        for (String fid : tf.getTeam().getChildren()) {
                            Friend f = Main.friends.get(fid);
                            if (f == null) continue;
                            Main.selectFriends.add(f);
                        }
                        continue;
                    }
                    Main.selectFriends.add(tf.getFriend());
                }
            }
            this.scanAction();
        }
    }

    public void scanAction() {
        if (Main.selectFriends.size() > 0) {
            this.btnDirectSent1.setDisable(true);
            this.lstFriend.setDisable(true);
            this.chkIsVip.setDisable(true);
            this.btnSelectAllFriend.setDisable(true);
            this.btnAddFriend.setDisable(true);
            this.boxFriends.setVisible(false);
            this.boxScanStatus.setVisible(true);
            this.btnCancelScan.setDisable(false);
            this.boxScanStatus.requestFocus();
            Main.scan();
        }
    }

    public void chkVipAction(ActionEvent actionEvent) {
        cc.ceofax.controller.portal.refreshLstFriend(false);
    }

    public void unselect(TableView table) {
        table.getSelectionModel().clearSelection();
    }

    public void redirect(TableView table) {
        if (table.getSelectionModel().getSelectedItems().size() > 0) {
            Main.redirectType = 2;
            try {
                cc.ceofax.controller.portal.newStage("friendlist", "\u7acb\u523b\u8f49\u767c", 500, 600);
            }
            catch (IOException e) {
                Main.log.error((Object)"error:", (Throwable)e);
            }
        }
    }

    public void printInTable(TableView table) {
        if (table.getSelectionModel().getSelectedItems().size() > 0) {
            Main.showDetail(table.getSelectionModel().getSelectedItems().size() + "\u4efd\u6587\u4ef6\u958b\u59cb\u5217\u5370");
            int i = 0;
            for (Object o : table.getSelectionModel().getSelectedItems()) {
                Document d = (Document)o;
                ((Document)o).setWaitPrint(false);
                if (!new File(Main.dir + "\\\u96f2\u7aef\\" + ((Document)o).getFilename()).exists()) {
                    S3Tool.downloadRunnabler r = new S3Tool.downloadRunnabler(d.getFilename(), d.getGotTime());
                    new Thread(r).start();
                }
                String fromStr = d.getWho();
                if (d.getFriend() != null) {
                    fromStr = d.getFriend().getNickname();
                }
                Main.delayPrint(Main.dir + "\\\u96f2\u7aef\\" + ((Document)o).getFilename(), ((Document)o).getSentTime(), ((Document)o).getGotTime(), ((Document)o).getPlusEmailName(), fromStr, String.valueOf(((Document)o).getIndex()), i * 3000);
                ++i;
            }
        }
    }

    public void saveas(TableView table) {
        if (table.getSelectionModel().getSelectedItems().size() > 0) {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            if (Main.recentSaveFolder != null) {
                directoryChooser.setInitialDirectory(Main.recentSaveFolder);
            } else {
                directoryChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory());
            }
            File folder = directoryChooser.showDialog((Window)stages.get("portal"));
            if (folder != null) {
                Main.recentSaveFolder = folder;
                boolean allSaved = true;
                try {
                    for (Object o : table.getSelectionModel().getSelectedItems()) {
                        Document d = (Document)o;
                        File f = new File(Main.dir + "\\\u96f2\u7aef\\" + ((Document)o).getFilename());
                        if (f.exists()) {
                            FileUtils.copyFileToDirectory((File)f, (File)folder);
                            continue;
                        }
                        allSaved = false;
                        S3Tool.download(f.getName(), null);
                    }
                    if (allSaved) {
                        Main.showMsg("\u53e6\u5b58\u6210\u529f", "\u5716\u7247\u5df2\u5b58\u6a94\u3002", 1);
                    } else {
                        Main.showMsg("\u53e6\u5b58\u5931\u6557", "\u67d0\u4e9b\u5716\u7247\u6b63\u5728\u4e0b\u8f09\uff0c\u8acb\u518d\u8a66\u4e00\u6b21\u3002", 2);
                    }
                }
                catch (IOException e) {
                    Main.log.error((Object)"error:", (Throwable)e);
                }
            }
        }
    }

    public void unselectGot(ActionEvent actionEvent) {
        this.unselect(this.lstGotHistory);
    }

    public void redirectGot(ActionEvent actionEvent) {
        currentLstHistoryName = "lstGotHistory";
        this.redirect(this.lstGotHistory);
    }

    public void printGot(ActionEvent actionEvent) {
        this.printInTable(this.lstGotHistory);
    }

    public void saveasGot(ActionEvent actionEvent) {
        this.saveas(this.lstGotHistory);
    }

    public void unselectSent(ActionEvent actionEvent) {
        this.unselect(this.lstSendHistory);
    }

    public void redirectSent(ActionEvent actionEvent) {
        currentLstHistoryName = "lstSendHistory";
        this.redirect(this.lstSendHistory);
    }

    public void printSent(ActionEvent actionEvent) {
        this.printInTable(this.lstSendHistory);
    }

    public void saveasSent(ActionEvent actionEvent) {
        this.saveas(this.lstSendHistory);
    }

    public void unselectGotOld(ActionEvent actionEvent) {
        this.unselect(this.lstGotHistoryOld);
    }

    public void redirectGotOld(ActionEvent actionEvent) {
        currentLstHistoryName = "lstGotHistoryOld";
        this.redirect(this.lstGotHistoryOld);
    }

    public void printGotOld(ActionEvent actionEvent) {
        this.printInTable(this.lstGotHistoryOld);
    }

    public void saveasGotOld(ActionEvent actionEvent) {
        this.saveas(this.lstGotHistoryOld);
    }

    public void unselectSentOld(ActionEvent actionEvent) {
        this.unselect(this.lstSendHistoryOld);
    }

    public void redirectSentOld(ActionEvent actionEvent) {
        currentLstHistoryName = "lstSendHistoryOld";
        this.redirect(this.lstSendHistoryOld);
    }

    public void printSentOld(ActionEvent actionEvent) {
        this.printInTable(this.lstSendHistoryOld);
    }

    public void saveasSentOld(ActionEvent actionEvent) {
        this.saveas(this.lstSendHistoryOld);
    }

    public void queryHistory() {
        gotHistoryIndexMaps.clear();
        sendHistoryIndexMaps.clear();
        this.lstGotHistoryOld.setItems(null);
        this.lstSendHistoryOld.setItems(null);
        Friend f = (Friend)this.lstHistoryWho.getSelectionModel().getSelectedItem();
        if (f != null) {
            for (int i = 0; i <= 1; ++i) {
                String sql = "queryHistory,";
                if ((HistoryTime)this.lstHistoryDay.getSelectionModel().getSelectedItem() == null) continue;
                Date day = ((HistoryTime)this.lstHistoryDay.getSelectionModel().getSelectedItem()).getDay();
                sql = sql + new SimpleDateFormat("yyyy/MM/dd").format(day) + ",";
                sql = sql + i + ",";
                sql = sql + f.getAccType() + "," + f.getAccount();
                Main.speak(sql);
            }
        }
    }

    public void lstHistoryDayAction(ActionEvent actionEvent) {
        this.queryHistory();
    }

    public void lstHistoryTypeAction(ActionEvent actionEvent) {
        this.queryHistory();
    }

    public void lstHistoryWhoAction(ActionEvent actionEvent) {
        this.queryHistory();
    }

    public void tab3Action(Event event) {
        currentLstHistoryName = "lstHistory";
        this.queryHistory();
    }

    public void rootKeyPress(KeyEvent keyEvent) {
        String code = keyEvent.getText().toLowerCase();
        if (code != null && !code.equalsIgnoreCase("")) {
            Main.selectFriends = new ArrayList<Friend>();
            for (Friend f : Main.friends.values()) {
                if (!code.equalsIgnoreCase(f.getShortKey())) continue;
                Main.selectFriends.add(f);
            }
            for (Team t : Main.teams.values()) {
                if (!code.equalsIgnoreCase(t.getShortKey())) continue;
                for (String fid : t.getChildren()) {
                    Friend f = Main.friends.get(fid);
                    if (f == null) continue;
                    Main.selectFriends.add(f);
                }
            }
            if (Main.selectFriends.size() > 0) {
                this.scanAction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chkAccType1PrintAction(ActionEvent actionEvent) {
        if (this.chkAccType1Print.isSelected()) {
            if (Main.setting.getPrinter() != null && !Main.setting.getPrinter().equalsIgnoreCase("\u672a\u8a2d\u5b9a")) {
                Main.showDetail("\u81ea\u52d5\u5370\u51fa\u4f86\u81ea\u7cfb\u7d71\u7db2\u5167\u7684\u50b3\u771f\u6587\u4ef6");
                int leftPrintDocs = 0;
                for (Document d : waitPrintDocuments) {
                    if (!d.isWaitPrint() || d.getAccType() != 1 && d.getAccType() != 4) continue;
                    ++leftPrintDocs;
                }
                if (leftPrintDocs > 0) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("\u6587\u4ef6\u5f85\u5217\u5370");
                    alert.setHeaderText(null);
                    alert.setContentText("\u6aa2\u6e2c\u5230\u6709 " + leftPrintDocs + " \u4efd\u7db2\u5167\u6587\u4ef6\u7b49\u5f85\u5217\u5370\uff0c\u8acb\u554f\u662f\u5426\u8981\u5217\u5370\uff1f");
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.OK) {
                        Main.canPrintType1 = true;
                    } else {
                        Iterator<Document> it = waitPrintDocuments.iterator();
                        List<Document> list = waitPrintDocuments;
                        synchronized (list) {
                            while (it.hasNext()) {
                                Document d = it.next();
                                if (d == null || !d.isWaitPrint() || d.getAccType() != 1 && d.getAccType() != 4) continue;
                                it.remove();
                            }
                        }
                        Main.canPrintType1 = true;
                    }
                } else {
                    Main.canPrintType1 = true;
                }
            } else {
                Main.showMsg("\u555f\u52d5\u5931\u6557", "\u8acb\u5148\u8a2d\u5b9a\u4e00\u53f0\u5370\u8868\u6a5f", 2);
                this.chkAccType1Print.setSelected(false);
            }
        } else {
            Main.showDetail("\u4e0d\u5370\u51fa\u4f86\u81ea\u7cfb\u7d71\u7db2\u5167\u7684\u50b3\u771f\u6587\u4ef6");
            Main.canPrintType1 = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chkAccType2PrintAction(ActionEvent actionEvent) {
        if (this.chkAccType2Print.isSelected()) {
            if (Main.setting.getPrinter() != null && !Main.setting.getPrinter().equalsIgnoreCase("\u672a\u8a2d\u5b9a")) {
                Main.showDetail("\u81ea\u52d5\u5370\u51fa\u4f86\u81ea\u5e02\u8a71\u4ee3\u8868\u865f\u8207\u96fb\u5b50\u4fe1\u7bb1\u7684\u50b3\u771f\u6587\u4ef6");
                int leftPrintDocs = 0;
                for (Document d : gotDocuments) {
                    if (!d.isWaitPrint() || d.getAccType() != 2 && d.getAccType() != 3) continue;
                    ++leftPrintDocs;
                }
                if (leftPrintDocs > 0) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("\u6587\u4ef6\u5f85\u5217\u5370");
                    alert.setHeaderText(null);
                    alert.setContentText("\u6aa2\u6e2c\u5230\u6709 " + leftPrintDocs + " \u4efd\u5e02\u8a71\u4ee3\u8868\u865f\u8207\u96fb\u5b50\u4fe1\u7bb1\u7684\u6587\u4ef6\u7b49\u5f85\u5217\u5370\uff0c\u8acb\u554f\u662f\u5426\u8981\u5217\u5370\uff1f");
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.OK) {
                        Main.canPrintType2 = true;
                    } else {
                        Iterator<Document> it = waitPrintDocuments.iterator();
                        List<Document> list = waitPrintDocuments;
                        synchronized (list) {
                            while (it.hasNext()) {
                                Document d = it.next();
                                if (d == null || !d.isWaitPrint() || d.getAccType() != 2 && d.getAccType() != 3) continue;
                                it.remove();
                            }
                        }
                        Main.canPrintType2 = true;
                    }
                } else {
                    Main.canPrintType2 = true;
                }
            } else {
                Main.showMsg("\u555f\u52d5\u5931\u6557", "\u8acb\u5148\u8a2d\u5b9a\u4e00\u53f0\u5370\u8868\u6a5f", 2);
                this.chkAccType2Print.setSelected(false);
            }
        } else {
            Main.showDetail("\u4e0d\u5370\u51fa\u50b3\u81f3\u5e02\u8a71\u4ee3\u8868\u865f\u8207\u96fb\u5b50\u4fe1\u7bb1\u7684\u50b3\u771f\u6587\u4ef6");
            Main.canPrintType2 = false;
        }
    }

    public void btnDeleteAllAction(Event event) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("\u522a\u9664\u8cc7\u6599");
        alert.setHeaderText(null);
        alert.setContentText("\u60a8\u662f\u5426\u78ba\u5b9a\u8981\u522a\u9664\u6240\u6709\u8cc7\u6599\uff1f");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            String[] folders;
            Main.speak("deleteAllHistory");
            for (String folderName : folders = new String[]{"\\scan\\", "\\\u96f2\u7aef\\", "\\\u90f5\u4ef6\\", "\\\u5217\u5370\\", "\\\u66ab\u5b58\\"}) {
                File folder = new File(Main.dir + folderName);
                if (!folder.exists()) continue;
                List files = (List)FileUtils.listFiles((File)folder, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                for (File file : files) {
                    try {
                        FileUtils.forceDelete((File)file);
                    }
                    catch (IOException e) {
                        Main.log.error((Object)"error:", (Throwable)e);
                    }
                }
            }
            Main.setting.setAccount(null);
            Main.setting.setPassword(null);
            Main.setting.setSavePW(false);
            Main.saveSetting();
            Alert alert2 = new Alert(Alert.AlertType.WARNING);
            alert2.setTitle("\u95dc\u9589\u7cfb\u7d71");
            alert2.setHeaderText(null);
            alert2.setContentText("\u8cc7\u6599\u5df2\u5168\u6578\u522a\u9664\uff0c\u8acb\u95dc\u9589\u7cfb\u7d71\u3002");
            Optional result2 = alert2.showAndWait();
            if (result2.get() == ButtonType.OK) {
                Main.closeApp();
            }
        } else {
            this.tabHistories.getSelectionModel().select(0);
        }
    }

    public void btnAddTeamAction(ActionEvent actionEvent) throws IOException {
        editingTeam = new Team();
        editingTeam.setName("");
        cc.ceofax.controller.portal.newStage("editTeam", "\u65b0\u589e\u7fa4\u7d44", 700, 600);
    }

    public void menuQRPrinterAction(ActionEvent actionEvent) {
        try {
            cc.ceofax.controller.portal.newStage("printQRCode", "\u6a19\u7c64\u5217\u5370", 800, 380);
        }
        catch (IOException e) {
            Main.log.error((Object)"error:", (Throwable)e);
        }
    }

    public void btnFriendTabAction0(Event event) {
    }

    public void btnFriendTabAction1(Event event) {
    }

    public void btnFriendTabAction2(Event event) {
    }

    public static Friend getChooseBMFriend() {
        Friend result = null;
        for (Friend f : Main.friends.values()) {
            if ((buttonModeType != 0 || f.getAccType() != 1 && f.getAccType() != 2) && (buttonModeType != 1 || f.getAccType() != 3) || f.getPage() == null || f.getPage() != buttonModePage || f.getIndex() != buttonModeEditingFriendIndex) continue;
            result = f;
        }
        return result;
    }

    public static Team getChooseBMTeam() {
        Team result = null;
        for (Team t : Main.teams.values()) {
            if (t.getButtonModeType() == null || t.getButtonModeType() != buttonModeType || t.getPage() != buttonModePage || t.getIndex() != buttonModeEditingTeamIndex) continue;
            result = t;
        }
        return result;
    }

    public static void editButtonModeFriend() {
        Friend f = cc.ceofax.controller.portal.getChooseBMFriend();
        if (f == null) {
            try {
                cc.ceofax.controller.portal.newStage("addFriendBM", "\u65b0\u589e\u597d\u53cb", 700, 300);
            }
            catch (IOException e) {
                Main.log.error((Object)"error:", (Throwable)e);
            }
        } else {
            try {
                if (stages.get("editFriendBM") == null) {
                    editingFriend = f;
                }
                cc.ceofax.controller.portal.newStage("editFriendBM", "\u4fee\u6539" + f.getNickname(), 700, 600);
            }
            catch (IOException e) {
                Main.log.error((Object)"error:", (Throwable)e);
            }
        }
    }

    public static void delButtonModeFriend() {
        Friend f = cc.ceofax.controller.portal.getChooseBMFriend();
        if (f != null) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setHeaderText(null);
            alert.setTitle("\u518d\u6b21\u78ba\u8a8d");
            alert.setContentText("\u662f\u5426\u78ba\u5b9a\u522a\u9664" + f.getNickname() + "?");
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                Main.speak("deleteFriend," + f.getIdStr());
                TableView lstFriend = (TableView)stages.get("portal").getScene().lookup("#lstFriend");
                lstFriend.getItems().remove((Object)f);
                Main.friends.remove(f.getIdStr());
                cc.ceofax.controller.portal.refreshButtonModeButtons();
                cc.ceofax.controller.portal.refreshLstFriend(true);
            }
        }
    }

    public static void editButtonModeTeam() {
        Team t = cc.ceofax.controller.portal.getChooseBMTeam();
        if (t == null) {
            editingTeam = new Team();
            editingTeam.setName("");
            try {
                cc.ceofax.controller.portal.newStage("editTeamBM", "\u65b0\u589e\u7fa4\u7d44", 700, 600);
            }
            catch (IOException e) {
                Main.log.error((Object)"error:", (Throwable)e);
            }
        } else {
            try {
                if (stages.get("editTeamBM") == null) {
                    editingTeam = t;
                }
                cc.ceofax.controller.portal.newStage("editTeamBM", "\u4fee\u6539" + t.getName(), 700, 600);
            }
            catch (IOException e) {
                Main.log.error((Object)"error:", (Throwable)e);
            }
        }
    }

    public static void delButtonModeTeam() {
        Team t = cc.ceofax.controller.portal.getChooseBMTeam();
        if (t != null) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setHeaderText(null);
            alert.setTitle("\u518d\u6b21\u78ba\u8a8d");
            alert.setContentText("\u662f\u5426\u78ba\u5b9a\u522a\u9664" + t.getName() + "?");
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                TableView lstFriend = (TableView)stages.get("portal").getScene().lookup("#lstFriend");
                Main.speak("deleteTeam," + t.getIdStr());
                lstFriend.getItems().remove((Object)t);
                Main.teamOrFriends.remove(t.getIdStr());
                Main.teams.remove(t.getIdStr());
                portal.refreshButtonModeButtons();
            }
        }
    }

    public static void initButtonModeButtons() {
        int finalI;
        MenuItem del;
        MenuItem edit;
        ContextMenu contextMenu;
        Button btn;
        int i = 0;
        while (i < 14) {
            btn = (Button)stages.get("portal").getScene().lookup("#btnButtonModeSingle" + i);
            contextMenu = new ContextMenu();
            edit = new MenuItem("\u50b3\u9001\u5e33\u865f\u8a2d\u5b9a");
            del = new MenuItem("\u522a\u9664\u672c\u5e33\u865f");
            contextMenu.getItems().addAll((Object[])new MenuItem[]{edit, del});
            finalI = i++;
            edit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    buttonModeEditingFriendIndex = finalI;
                    cc.ceofax.controller.portal.editButtonModeFriend();
                }
            });
            del.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    buttonModeEditingFriendIndex = finalI;
                    cc.ceofax.controller.portal.delButtonModeFriend();
                }
            });
            btn.setOnContextMenuRequested(e -> contextMenu.show((Node)btn, e.getScreenX(), e.getScreenY()));
        }
        i = 0;
        while (i < 4) {
            btn = (Button)stages.get("portal").getScene().lookup("#btnButtonModeTeam" + i);
            contextMenu = new ContextMenu();
            edit = new MenuItem("\u50b3\u9001\u7fa4\u7d44\u8a2d\u5b9a");
            del = new MenuItem("\u522a\u9664\u672c\u7fa4\u7d44");
            contextMenu.getItems().addAll((Object[])new MenuItem[]{edit, del});
            finalI = i++;
            edit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    buttonModeEditingTeamIndex = finalI;
                    cc.ceofax.controller.portal.editButtonModeTeam();
                }
            });
            del.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    buttonModeEditingTeamIndex = finalI;
                    cc.ceofax.controller.portal.delButtonModeTeam();
                }
            });
            btn.setOnContextMenuRequested(e -> contextMenu.show((Node)btn, e.getScreenX(), e.getScreenY()));
        }
    }

    public void btnButtonModeSingleAction(int index) {
        buttonModeEditingFriendIndex = index;
        Friend f = cc.ceofax.controller.portal.getChooseBMFriend();
        if (f != null) {
            Main.selectFriends = new ArrayList<Friend>();
            Main.selectFriends.add(cc.ceofax.controller.portal.getChooseBMFriend());
            this.btnDirectSentAction(null);
        }
    }

    public void btnButtonModeTeamAction(int index) {
        buttonModeEditingTeamIndex = index;
        Team t = cc.ceofax.controller.portal.getChooseBMTeam();
        if (t != null) {
            Main.selectFriends = new ArrayList<Friend>();
            for (String fid : t.getChildren()) {
                Friend f = Main.friends.get(fid);
                if (f == null) continue;
                Main.selectFriends.add(f);
            }
            if (Main.selectFriends.size() > 0) {
                this.btnDirectSentAction(null);
            }
        }
    }

    public static void refreshButtonModeButtons() {
        Button btn;
        Button btn2;
        Label txtPageIndex = (Label)stages.get("portal").getScene().lookup("#txtPageIndex");
        txtPageIndex.setText(String.valueOf(buttonModePage));
        for (int i = 0; i < 14; ++i) {
            btn2 = (Button)stages.get("portal").getScene().lookup("#btnButtonModeSingle" + i);
            btn2.getStyleClass().clear();
            btn2.getStyleClass().add((Object)("btnButtonModeSingleNull" + buttonModeType));
            btn2.setText("");
        }
        for (Friend f : Main.friends.values()) {
            if ((buttonModeType != 0 || f.getAccType() != 1 && f.getAccType() != 2) && (buttonModeType != 1 || f.getAccType() != 3) || f.getPage() == null || f.getPage() != buttonModePage || f.getIndex() == null) continue;
            btn = (Button)stages.get("portal").getScene().lookup("#btnButtonModeSingle" + f.getIndex());
            btn.getStyleClass().clear();
            btn.getStyleClass().add((Object)("btnButtonModeSingle" + buttonModeType));
            if (f.getShortKey() != null && !f.getShortKey().equalsIgnoreCase("")) {
                btn.setText("<" + f.getShortKey() + ">" + f.getNickname());
                continue;
            }
            btn.setText(f.getNickname());
        }
        for (int i = 0; i < 4; ++i) {
            btn2 = (Button)stages.get("portal").getScene().lookup("#btnButtonModeTeam" + i);
            btn2.setText("");
            btn2.getStyleClass().clear();
            btn2.getStyleClass().add((Object)("btnButtonModeTeam" + buttonModeType));
        }
        for (Team t : Main.teams.values()) {
            if (t.getButtonModeType() == null || t.getButtonModeType() != buttonModeType || t.getPage() != buttonModePage || t.getIndex() == null) continue;
            btn = (Button)stages.get("portal").getScene().lookup("#btnButtonModeTeam" + t.getIndex());
            if (t.getShortKey() != null && !t.getShortKey().equalsIgnoreCase("")) {
                btn.setText("<" + t.getShortKey() + ">" + t.getName());
                continue;
            }
            btn.setText(t.getName());
        }
    }

    public void btnPageDown(ActionEvent actionEvent) {
        if (buttonModePage > 1) {
            --buttonModePage;
            cc.ceofax.controller.portal.refreshButtonModeButtons();
        }
    }

    public void btnPageUp(ActionEvent actionEvent) {
        if (buttonModePage < 5) {
            ++buttonModePage;
            cc.ceofax.controller.portal.refreshButtonModeButtons();
        }
    }

    public void btnSetButtonModePlaceAction(ActionEvent actionEvent) {
        try {
            cc.ceofax.controller.portal.newStage("setButtonMode" + buttonModeType, "\u8a2d\u5b9a\u6309\u9215\u4f4d\u7f6e", 1200, 660);
        }
        catch (IOException e) {
            Main.log.error((Object)"error:", (Throwable)e);
        }
    }

    public void btnButtonModeType0(ActionEvent actionEvent) {
        this.btnButtonModeType0.getStyleClass().clear();
        this.btnButtonModeType1.getStyleClass().clear();
        this.btnButtonModeType0.getStyleClass().add((Object)"btnButtonModeType_chose");
        this.btnButtonModeType1.getStyleClass().add((Object)"btnButtonModeType");
        buttonModeType = 0;
        cc.ceofax.controller.portal.refreshButtonModeButtons();
    }

    public void btnButtonModeType1(ActionEvent actionEvent) {
        this.btnButtonModeType0.getStyleClass().clear();
        this.btnButtonModeType1.getStyleClass().clear();
        this.btnButtonModeType0.getStyleClass().add((Object)"btnButtonModeType");
        this.btnButtonModeType1.getStyleClass().add((Object)"btnButtonModeType_chose");
        buttonModeType = 1;
        cc.ceofax.controller.portal.refreshButtonModeButtons();
    }

    public void btnButtonModeSingle0(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(0);
    }

    public void btnButtonModeSingle1(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(1);
    }

    public void btnButtonModeSingle2(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(2);
    }

    public void btnButtonModeSingle3(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(3);
    }

    public void btnButtonModeSingle4(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(4);
    }

    public void btnButtonModeSingle5(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(5);
    }

    public void btnButtonModeSingle6(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(6);
    }

    public void btnButtonModeSingle7(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(7);
    }

    public void btnButtonModeSingle8(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(8);
    }

    public void btnButtonModeSingle9(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(9);
    }

    public void btnButtonModeSingle10(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(10);
    }

    public void btnButtonModeSingle11(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(11);
    }

    public void btnButtonModeSingle12(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(12);
    }

    public void btnButtonModeSingle13(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(13);
    }

    public void btnButtonModeSingle14(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(14);
    }

    public void btnButtonModeSingle15(ActionEvent actionEvent) {
        this.btnButtonModeSingleAction(15);
    }

    public void btnButtonModeTeam0(ActionEvent actionEvent) {
        this.btnButtonModeTeamAction(0);
    }

    public void btnButtonModeTeam1(ActionEvent actionEvent) {
        this.btnButtonModeTeamAction(1);
    }

    public void btnButtonModeTeam2(ActionEvent actionEvent) {
        this.btnButtonModeTeamAction(2);
    }

    public void btnButtonModeTeam3(ActionEvent actionEvent) {
        this.btnButtonModeTeamAction(3);
    }

    public void menuPrinterAction(ActionEvent actionEvent) throws IOException {
        tabIndexInSetting = 1;
        cc.ceofax.controller.portal.newStage("setting", "\u7cfb\u7d71\u8a2d\u5b9a", 900, 500);
    }

    public void menuMultiMailAction(ActionEvent actionEvent) throws IOException {
        tabIndexInSetting = 3;
        cc.ceofax.controller.portal.newStage("setting", "\u7cfb\u7d71\u8a2d\u5b9a", 900, 500);
    }

    public void menuScannerAction(ActionEvent actionEvent) throws IOException {
        tabIndexInSetting = 2;
        cc.ceofax.controller.portal.newStage("setting", "\u7cfb\u7d71\u8a2d\u5b9a", 900, 500);
    }

    public void menuMyAccountAction(ActionEvent actionEvent) throws IOException {
        tabIndexInSetting = 0;
        cc.ceofax.controller.portal.newStage("setting", "\u7cfb\u7d71\u8a2d\u5b9a", 900, 500);
    }

    public void menuAllResentAction(ActionEvent actionEvent) throws IOException {
        tabIndexInSetting = 4;
        cc.ceofax.controller.portal.newStage("setting", "\u7cfb\u7d71\u8a2d\u5b9a", 900, 500);
    }

    public void menuFolderAction(ActionEvent actionEvent) throws IOException {
        tabIndexInSetting = 6;
        cc.ceofax.controller.portal.newStage("setting", "\u7cfb\u7d71\u8a2d\u5b9a", 900, 500);
    }

    public void menuShowDocViewerAction(ActionEvent actionEvent) throws IOException {
        cc.ceofax.controller.portal.newStage("DocViewer", "\u6aa2\u8996\u6587\u4ef6", 600, 700, -1, -1);
        Stage s = stages.get("DocViewer");
        s.setMaximized(Main.setting.isSMax());
        s.setX(Main.setting.getSx());
        s.setY(Main.setting.getSy());
        s.setWidth(Main.setting.getSw());
        s.setHeight(Main.setting.getSh());
        Stage finalS = s;
        s.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                cc.ceofax.controller.portal.closeStage("DocViewer");
            }
        });
    }

    public void menuShowNewsAction(ActionEvent actionEvent) {
        Main.speak("getNewsList,0");
    }

    public void btnCancelScanAction(ActionEvent actionEvent) {
        this.btnCancelScan.setDisable(true);
        Main.scanner.shouldCancel = true;
        Main.scanner.scanningFilenames.clear();
        Main.scanner.tw.TWAIN_DisableSource();
        Main.scanner.tw.TWAIN_CloseSource();
        Main.scanner.tw.TWAIN_BreakModalLoop();
    }

    public void chkQREnableAction(ActionEvent actionEvent) {
        Main.setting.setQRDetectEnable(this.chkQREnable.isSelected());
        Main.saveSetting();
    }

    public void menuNoteStampsAction(ActionEvent actionEvent) throws IOException {
        tabIndexInSetting = 5;
        cc.ceofax.controller.portal.newStage("setting", "\u7cfb\u7d71\u8a2d\u5b9a", 900, 500);
    }

    public static void newStage(String name, String title, int minW, int minH) throws IOException {
        cc.ceofax.controller.portal.newStage(name, title, minW, minH, minW, minH + 100);
    }

    public static void newStage(final String name, String title, int minW, int minH, int maxW, int maxH) throws IOException {
        Stage exist = stages.get(name);
        if (exist == null) {
            FXMLLoader fxmlLoader = new FXMLLoader(Main.class.getResource(Main.UI_PATH + name + ".fxml"));
            Parent root = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.setTitle(title);
            stage.getIcons().add((Object)new Image(Main.class.getResourceAsStream(Main.UI_PATH + "imgs/printer.png")));
            Scene scene = new Scene(root, (double)minW, (double)minH);
            stage.setScene(scene);
            stage.setMinWidth((double)minW);
            stage.setMinHeight((double)minH);
            if (maxW > 0) {
                stage.setMaxWidth((double)maxW);
            }
            if (maxH > 0) {
                stage.setMaxHeight((double)maxH);
            }
            stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                    stages.remove(name);
                }
            });
            stage.show();
            stages.put(name, stage);
        } else {
            exist.show();
            exist.toFront();
        }
    }

    public static void closeStage(final String name) {
        Stage s;
        if (name.equalsIgnoreCase("DocViewer") && (s = stages.get(name)) != null) {
            Main.setting.setSx(s.getX());
            Main.setting.setSy(s.getY());
            Main.setting.setSw(s.getWidth());
            Main.setting.setSh(s.getHeight());
            Main.setting.setSMax(s.isMaximized());
            Main.saveSetting();
            DocViewer.editImgSteps = 0;
            if (DocViewer.autoRefreshTimer != null) {
                DocViewer.autoRefreshTimer.cancel();
                DocViewer.autoRefreshTimer = null;
            }
            System.gc();
        }
        if (name.equalsIgnoreCase("DailyReport") && (s = stages.get(name)) != null) {
            Main.setting.setQx(s.getX());
            Main.setting.setQy(s.getY());
            Main.setting.setQw(s.getWidth());
            Main.setting.setQh(s.getHeight());
            Main.setting.setQMax(s.isMaximized());
            Main.saveSetting();
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (stages.get(name) != null) {
                    stages.get(name).close();
                    stages.remove(name);
                }
            }
        });
    }

    public void btnSettingAction(ActionEvent actionEvent) throws IOException {
        cc.ceofax.controller.portal.newStage("setting", "\u7cfb\u7d71\u8a2d\u5b9a", 900, 500);
    }

    public void btnAddFriendAction(ActionEvent actionEvent) throws IOException {
        cc.ceofax.controller.portal.newStage("addFriend", "\u65b0\u589e\u597d\u53cb", 700, 300);
    }

    public void menuDailyReportAction(ActionEvent actionEvent) {
        try {
            cc.ceofax.controller.portal.newStage("DailyReport", "\u672c\u65e5\u7d71\u8a08", 600, 700, -1, -1);
            Stage s = stages.get("DailyReport");
            s.setMaximized(Main.setting.isQMax());
            s.setX(Main.setting.getQx());
            s.setY(Main.setting.getQy());
            s.setWidth(Main.setting.getQw());
            s.setHeight(Main.setting.getQh());
            Stage finalS = s;
            s.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                    cc.ceofax.controller.portal.closeStage("DailyReport");
                }
            });
        }
        catch (IOException e) {
            Main.log.error((Object)"error:", (Throwable)e);
        }
    }

    public void lstFriendClicked(MouseEvent mouseEvent) {
        if (this.lstFriend.getSelectionModel().getSelectedItems().size() > 0) {
            this.btnSelectAllFriend.setText("\u6e05\u9078");
        } else {
            this.btnSelectAllFriend.setText("\u5168\u9078");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDocumentAction(final String filename, final Date gotTime) {
        Stage s = stages.get("DocViewer");
        ImageView imgViewer = (ImageView)s.getScene().lookup("#imgViewer");
        if (imgViewer != null) {
            imgViewer.setImage(null);
        }
        if (filename != null) {
            File f = new File(Main.dir + "\\\u96f2\u7aef\\" + filename);
            if (f.exists()) {
                Main.viewFilename = f.getPath();
                try {
                    DocViewer.loadImage(f);
                }
                catch (IIOException e) {
                    Main.log.error((Object)"error:", (Throwable)e);
                }
                catch (OutOfMemoryError E) {
                    System.gc();
                }
                catch (IOException e) {
                    Main.log.error((Object)"error:", (Throwable)e);
                    S3Tool.download(filename, gotTime);
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            showDocumentThread r = new showDocumentThread(filename, gotTime);
                            new Thread(r).start();
                        }
                    }, 500L);
                }
                catch (Exception e) {}
            } else {
                Main.viewFilename = null;
                File downloadingTmp = new File(Main.dir + "\\\u96f2\u7aef\\" + filename + "_");
                if (S3Tool.isExist(filename)) {
                    if (!downloadingTmp.exists()) {
                        S3Tool.download(filename, gotTime);
                    }
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (Main.willViewingFilename.equalsIgnoreCase(filename)) {
                                showDocumentThread r = new showDocumentThread(filename, gotTime);
                                new Thread(r).start();
                            }
                        }
                    }, 200L);
                }
            }
        }
    }

    public static void showDocument(String filename, Date gotTime, TableView table, int index) {
        System.out.println(filename);
        viewerTable = table;
        viewerIndex = index;
        Main.willViewingFilename = filename;
        if (stages.get("DocViewer") != null) {
            ImageView imgViewer = (ImageView)stages.get("DocViewer").getScene().lookup("#imgViewer");
            imgViewer.setImage(null);
        }
        try {
            Stage s = stages.get("DocViewer");
            if (s != null) {
                s.toFront();
            } else {
                cc.ceofax.controller.portal.newStage("DocViewer", "\u6aa2\u8996\u6587\u4ef6", 600, 700, -1, -1);
                s = stages.get("DocViewer");
                s.setMaximized(Main.setting.isSMax());
                if (Main.setting.getSx() + Main.setting.getSw() < 0.0 || Main.setting.getSx() > (double)Main.sw) {
                    s.setX((double)(Main.sw / 2));
                } else {
                    s.setX(Main.setting.getSx());
                }
                if (Main.setting.getSy() + Main.setting.getSh() < 0.0 || Main.setting.getSy() > (double)Main.sh) {
                    s.setY((double)(Main.sh / 2));
                } else {
                    s.setY(Main.setting.getSy());
                }
                s.setWidth(Main.setting.getSw());
                s.setHeight(Main.setting.getSh());
                Stage finalS = s;
                s.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent we) {
                        cc.ceofax.controller.portal.closeStage("DocViewer");
                    }
                });
            }
        }
        catch (IOException e) {
            Main.log.error((Object)"error:", (Throwable)e);
        }
        Document d = (Document)table.getItems().get(index);
        Stage stg = stages.get("DocViewer");
        stg.setTitle("\u6aa2\u8996\u6587\u4ef6 - " + d.getWho() + " / " + d.getIndex() + " / " + d.getWhen());
        stg.setIconified(false);
        DocViewer.docLabel = d.getWho() + " -P" + d.getIndex();
        cc.ceofax.controller.portal.showDocumentAction(filename, gotTime);
    }

    public static void btnNextAction() {
        try {
            Document d = (Document)viewerTable.getItems().get(viewerIndex + 1);
            if (d != null) {
                viewerTable.getSelectionModel().clearSelection();
                viewerTable.getSelectionModel().select(viewerIndex + 1);
                cc.ceofax.controller.portal.showDocument(d.getFilename(), d.getGotTime(), viewerTable, viewerIndex + 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void btnPrevAction() {
        try {
            Document d = (Document)viewerTable.getItems().get(viewerIndex - 1);
            if (d != null) {
                viewerTable.getSelectionModel().clearSelection();
                viewerTable.getSelectionModel().select(viewerIndex - 1);
                cc.ceofax.controller.portal.showDocument(d.getFilename(), d.getGotTime(), viewerTable, viewerIndex - 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void btnSelectAllFriendAction(ActionEvent actionEvent) {
        if (this.lstFriend.getSelectionModel().getSelectedItems().size() > 0) {
            this.lstFriend.getSelectionModel().clearSelection();
            this.btnSelectAllFriend.setText("\u5168\u9078");
        } else {
            this.lstFriend.getSelectionModel().selectAll();
            this.btnSelectAllFriend.setText("\u6e05\u9078");
        }
    }

    public static List unusedShortKey() {
        int i;
        ArrayList<String> keys = new ArrayList<String>(Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "G", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"));
        for (Friend f : Main.friends.values()) {
            for (i = 0; i < keys.size(); ++i) {
                if (!((String)keys.get(i)).equalsIgnoreCase(f.getShortKey())) continue;
                keys.remove(i);
            }
        }
        for (Team t : Main.teams.values()) {
            for (i = 0; i < keys.size(); ++i) {
                if (!((String)keys.get(i)).equalsIgnoreCase(t.getShortKey())) continue;
                keys.remove(i);
            }
        }
        keys.add(0, "");
        return keys;
    }

    static {
        dataFormat = new DataFormat(new String[]{"mydata"});
        buttonModeType = 0;
        buttonModePage = 1;
        buttonModeEditingFriendIndex = 1;
        buttonModeEditingTeamIndex = 1;
        tabIndexInSetting = 0;
        currentLstHistoryName = "lstGotHistory";
        sptCenterPosition = new SimpleDoubleProperty(0.4);
        viewerIndex = 0;
    }

    public static class showDocumentThread
    implements Runnable {
        String filename;
        Date gotTime;

        public showDocumentThread(String _filename, Date _gotTime) {
            this.filename = _filename;
            this.gotTime = _gotTime;
        }

        @Override
        public void run() {
            cc.ceofax.controller.portal.showDocumentAction(this.filename, this.gotTime);
        }
    }

    public static class IntegerEditingCell
    extends TableCell<Friend, Number> {
        private final TextField textField = new TextField();
        private final Pattern intPattern = Pattern.compile("-?\\d+");

        public IntegerEditingCell() {
            this.textField.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
                if (!isNowFocused.booleanValue()) {
                    this.processEdit();
                }
            });
            this.textField.setOnAction(event -> this.processEdit());
        }

        private void processEdit() {
            String text = this.textField.getText();
            if (this.intPattern.matcher(text).matches()) {
                this.commitEdit(Integer.parseInt(text));
            } else {
                this.cancelEdit();
            }
        }

        public void updateItem(Number value, boolean empty) {
            super.updateItem((Object)value, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                this.setText(null);
                this.textField.setText(value.toString());
                this.setGraphic((Node)this.textField);
            } else {
                if ((Integer)value == -1) {
                    this.setText("\u7fa4\u7d44");
                } else if ((Integer)value == 1) {
                    this.setText("\u7db2\u5167");
                } else if ((Integer)value == 2) {
                    this.setText("\u90f5\u4ef6");
                } else if ((Integer)value == 3) {
                    this.setText("\u5e02\u8a71");
                } else if ((Integer)value == 4) {
                    this.setText("App");
                }
                this.setGraphic(null);
            }
        }

        public void startEdit() {
            super.startEdit();
            Number value = (Number)this.getItem();
            if (value != null) {
                this.textField.setText(value.toString());
                this.setGraphic((Node)this.textField);
                this.setText(null);
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText(((Number)this.getItem()).toString());
            this.setGraphic(null);
        }

        public void commitEdit(Number value) {
            super.commitEdit((Object)value);
            ((Friend)this.getTableRow().getItem()).setAccType(value.intValue());
        }
    }

    class BooleanCell
    extends TableCell<Friend, Boolean> {
        private CheckBox checkBox = new CheckBox();

        public BooleanCell() {
            this.checkBox.setDisable(true);
            this.checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (BooleanCell.this.isEditing()) {
                        BooleanCell.this.commitEdit(newValue == null ? false : newValue);
                    }
                }
            });
            this.setGraphic((Node)this.checkBox);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.setEditable(true);
        }

        public void startEdit() {
            super.startEdit();
            if (this.isEmpty()) {
                return;
            }
            this.checkBox.setDisable(false);
            this.checkBox.requestFocus();
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.checkBox.setDisable(true);
        }

        public void commitEdit(Boolean value) {
            super.commitEdit((Object)value);
            this.checkBox.setDisable(true);
        }

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!this.isEmpty() && item != null) {
                this.checkBox.setSelected(item.booleanValue());
            }
        }
    }
}

