/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.tool;

import cc.ceofax.bean.PlusEmailPrinter;
import cc.ceofax.controller.Main;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;

public class LiveComboBoxTableCell<S, T>
extends TableCell<S, T> {
    private final ComboBox<T> comboBox;

    public LiveComboBoxTableCell(ObservableList<T> items) {
        this.comboBox = new ComboBox(items);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.comboBox.valueProperty().addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> obs, T oldValue, T newValue) {
                ObservableValue property = LiveComboBoxTableCell.this.getTableColumn().getCellObservableValue(LiveComboBoxTableCell.this.getIndex());
                if (property instanceof WritableValue) {
                    ((WritableValue)property).setValue(newValue);
                    PlusEmailPrinter p = (PlusEmailPrinter)LiveComboBoxTableCell.this.getTableView().getItems().get(LiveComboBoxTableCell.this.getIndex());
                    p.setPrinterName(newValue.toString());
                    Main.plusEmailPrinters.put(p.getEmailName().replaceAll("@ceowin99.net", ""), p.getPrinterName());
                    Main.setting.setPlusEmailPrinters(Main.plusEmailPrinters);
                    Main.saveSetting();
                }
            }
        });
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.comboBox.setValue(item);
            this.setGraphic((Node)this.comboBox);
        }
    }
}

