/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.tool;

import cc.ceofax.controller.Main;
import com.google.cloud.AuthCredentials;
import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;

public class S3Tool {
    static Storage storage = null;
    static String bucketName = "file.ceowin.net";

    public static void init() {
        if (Main.gfilename != null) {
            storage = (Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.builder().authCredentials((AuthCredentials)AuthCredentials.createFor((String)Main.gfilename))).projectId("vipfax-422002")).build().service();
        }
    }

    public static boolean isExist(String filename) {
        boolean hasFile = false;
        try {
            BlobId blobId = BlobId.of((String)bucketName, (String)filename);
            Blob blob = storage.get(blobId);
            hasFile = blob != null;
        }
        catch (Exception e) {
            Main.log.error((Object)"error", (Throwable)e);
        }
        return hasFile;
    }

    public static boolean upload(String path) {
        return S3Tool.upload(new File(path));
    }

    public static boolean upload(File f) {
        boolean hasUploaded = false;
        if (!S3Tool.isExist(f.getName())) {
            String contentType = "image/tiff";
            if (f.getName().toLowerCase().endsWith("jpg") || f.getName().toLowerCase().endsWith("jpeg")) {
                contentType = "image/jpeg";
            }
            BlobId blobId = BlobId.of((String)bucketName, (String)f.getName());
            BlobInfo blobInfo = BlobInfo.builder((BlobId)blobId).contentType(contentType).build();
            Path path = Paths.get(f.getPath(), new String[0]);
            try {
                Blob blob = storage.create(blobInfo, Files.readAllBytes(path), new Storage.BlobTargetOption[0]);
                hasUploaded = true;
            }
            catch (IOException ei) {
                Main.log.error((Object)"error", (Throwable)ei);
                hasUploaded = false;
            }
            catch (StorageException ex) {
                hasUploaded = false;
                Main.log.error((Object)"error", (Throwable)ex);
            }
            catch (Exception e) {
                hasUploaded = false;
                Main.log.error((Object)"error", (Throwable)e);
            }
        } else {
            hasUploaded = true;
        }
        return hasUploaded;
    }

    public static void download(String filename, Date gotTime, String folder) {
        try {
            boolean isSuccess = false;
            BlobId blobId = BlobId.of((String)bucketName, (String)filename);
            Path downloadTo = Paths.get(folder + filename, new String[0]);
            Blob blob = storage.get(blobId);
            if (blob == null) {
                System.out.println("No such object");
                return;
            }
            PrintStream writeTo = System.out;
            if (downloadTo != null) {
                try {
                    writeTo = new PrintStream(new FileOutputStream(downloadTo.toFile()));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    Main.log.error((Object)"error", (Throwable)e);
                }
            }
            if (blob.size() < 1000000L) {
                byte[] content = blob.content(new Blob.BlobSourceOption[0]);
                try {
                    writeTo.write(content);
                    isSuccess = true;
                }
                catch (IOException e) {
                    isSuccess = false;
                    e.printStackTrace();
                    Main.log.error((Object)"error", (Throwable)e);
                }
            } else {
                try (ReadChannel reader = blob.reader(new Blob.BlobSourceOption[0]);){
                    WritableByteChannel channel = Channels.newChannel(writeTo);
                    ByteBuffer bytes = ByteBuffer.allocate(65536);
                    while (reader.read(bytes) > 0) {
                        bytes.flip();
                        channel.write(bytes);
                        bytes.clear();
                    }
                    isSuccess = true;
                }
                catch (IOException e) {
                    isSuccess = false;
                    e.printStackTrace();
                    Main.log.error((Object)"error", (Throwable)e);
                }
            }
            if (downloadTo == null) {
                writeTo.println();
            } else {
                writeTo.close();
            }
            if (isSuccess) {
                Main.downloadedFiles.add(filename);
            }
        }
        catch (StorageException se) {
            Main.log.error((Object)"error", (Throwable)se);
        }
        catch (Exception ex) {
            Main.log.error((Object)"error", (Throwable)ex);
        }
    }

    public static void download(String filename, Date gotTime) {
        S3Tool.download(filename, gotTime, Main.dir + "\\\u96f2\u7aef\\");
    }

    public static class downloadRunnabler
    implements Runnable {
        String filename;
        Date gotTime;

        public downloadRunnabler(String filename, Date gotTime) {
            this.filename = filename;
            this.gotTime = gotTime;
        }

        @Override
        public void run() {
            S3Tool.download(this.filename, this.gotTime);
        }
    }
}

