/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.tool;

import cc.ceofax.tool.GlobPattern;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class UnzipUtility {
    private static final int BUFFER_SIZE = 4096;

    UnzipUtility() {
    }

    private static boolean matches(String str, Pattern[] patterns) {
        for (Pattern p : patterns) {
            if (!p.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    public void unzip(String zipFilePath, String destDirectory, String[] includes, String[] excludes, boolean emptyDirs) throws IOException {
        File destDir;
        Pattern[] includePatterns = null;
        if (includes != null) {
            includePatterns = new Pattern[includes.length];
            int i = 0;
            for (String pattern : includes) {
                GlobPattern p = new GlobPattern(pattern);
                includePatterns[i++] = p.compiled();
            }
        }
        Pattern[] excludePatterns = null;
        if (excludes != null) {
            excludePatterns = new Pattern[excludes.length];
            int i = 0;
            for (String pattern : excludes) {
                GlobPattern p = new GlobPattern(pattern);
                excludePatterns[i++] = p.compiled();
            }
        }
        if (!(destDir = new File(destDirectory)).exists()) {
            throw new IOException("Destination directory does not exist");
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            boolean includeEntry = true;
            if (excludePatterns != null && UnzipUtility.matches(entry.getName(), excludePatterns)) {
                includeEntry = false;
            }
            if (includePatterns != null && UnzipUtility.matches(entry.getName(), includePatterns)) {
                includeEntry = true;
            }
            if (includeEntry) {
                String filePath = destDirectory + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    this.extractFile(zipIn, filePath);
                } else if (emptyDirs) {
                    File dir = new File(filePath);
                    dir.mkdir();
                }
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        File f = new File(filePath);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }
}

